package Pcore::DBD::DDL;

use Pcore qw[-role];
use Pcore::DBD::DDL::ChangeSet;

requires qw[schema_info_sql];

has dbh => ( is => 'ro', isa => ConsumerOf ['Pcore::DBD'], required => 1 );

has _schema_info_table => ( is => 'lazy', isa => Str, default => '_schema_info', init_arg => undef );
has _changesets => ( is => 'lazy', isa => HashRef, default => sub { {} }, init_arg => undef );

no Pcore;

# TODO
# revert all changes if one changeset failed
# upgrade db to specified version, including downgrade - need to specify revert sql code

sub add_changeset ( $self, %args ) {
    my $cset = Pcore::DBD::DDL::ChangeSet->new( \%args );

    my $id = $cset->component . $cset->id;

    die q[DDL changeset id "] . $cset->id . q[" for component "] . $cset->component . q[" already exists] if exists $self->_changesets->{$id};

    $self->_changesets->{$id} = $cset;

    return $cset;
}

sub upgrade ($self) {
    $self->_create_schema_info;

    my $info = $self->dbh->query( 'SELECT * FROM', [ $self->_schema_info_table ] )->selectall_hashref( key_cols => 'component' ) // {};

    for my $cset ( sort { $a->id <=> $b->id } values $self->_changesets ) {
        $self->dbh->query( 'INSERT INTO', [ $self->_schema_info_table ], VALUES => { component => $cset->component } )->do if !exists $info->{ $cset->component };

        if ( !exists $info->{ $cset->component } || !defined $info->{ $cset->component }->{changeset} || $info->{ $cset->component }->{changeset} < $cset->id ) {
            $self->dbh->begin_work if $cset->transaction;

            my $error = try {
                if ( ref $cset->sql eq 'CODE' ) {
                    die q[Changeset "] . $cset->id . q[" for component "] . $cset->component . q[" did not return true value] if !$cset->sql->( $cset, $self->dbh );
                }
                else {
                    $self->_get_changeset_query($cset)->do( nocache => 1 );
                }

                $self->dbh->commit if $cset->transaction;

                return 0;
            }
            catch {
                my $e = shift;

                $e->send_log;

                $self->dbh->rollback if $cset->transaction;

                return 1;
            };

            die q[Failed to apply changeset "] . $cset->id . q[" for component "] . $cset->component . q["] if $error;

            # update schema info
            $self->dbh->query( UPDATE => [ $self->_schema_info_table ], SET => { changeset => $cset->id }, 'WHERE component =', \$cset->component )->do;

            $info->{ $cset->component }->{changeset} = $cset->id;
        }
    }

    return;
}

sub _create_schema_info ($self) {
    return $self->dbh->query( $self->schema_info_sql->$* )->do;
}

sub _get_changeset_query ( $self, $cset ) {
    return $self->dbh->query( $self->_get_cset_sql($cset) );
}

sub _get_cset_sql ( $self, $cset ) {
    return $cset->sql;
}

1;
__END__
=pod

=encoding utf8

=head1 NAME

Pcore::DBD::DDL - database schema versioning subsystem

=head1 SYNOPSIS

    my $ddl = $dbh->ddl;

    $ddl->add_changeset(
        id        => 1,
        component => undef,
        sql       => q[CREATE TABLE ...],
    );

    ...

    $ddl->upgrade;

=head1 DESCRIPTION

=cut
