package Dist::Zilla::App::Command::cleanall;

use strict;
use warnings;
use utf8;
use Dist::Zilla::App qw[-command];

sub abstract {
    my ($self) = @_;

    return 'clean all garbage from dist (Pcore)';
}

sub opt_spec {
    my ( $self, $app ) = @_;

    return;
}

sub validate_args {
    my ( $self, $opt, $args ) = @_;

    # NOTE args is just raw array or params, that not described as options

    die 'no args expected' if @{$args};

    return;
}

sub execute {
    my ( $self, $opt, $args ) = @_;

    if ( !$INC{'Pcore.pm'} ) {
        print qq[Pcore is required to run this command\n];

        return;
    }

    my $dirs = [

        # general build
        'blib',

        # Module::Build
        '_build',
    ];

    my $files = [

        # general build
        qw[META.yml MYMETA.json MYMETA.yml],

        # Module::Build
        qw[_build_params Build Build.bat],

        # MakeMaker
        qw[Makefile pm_to_blib],
    ];

    for my $dir ( @{$dirs} ) {
        Pcore->file->rmtree($dir);
    }

    for my $file ( @{$files} ) {
        unlink $file or die qq[Can't unlink "$file"] if -f $file;
    }

    $self->zilla->clean;

    return;
}

1;
## -----SOURCE FILTER LOG BEGIN-----
##
## PerlCritic profile "common" policy violations:
## ┌──────┬──────────────────────┬────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐
## │ Sev. │ Lines                │ Policy                                                                                                         │
## ╞══════╪══════════════════════╪════════════════════════════════════════════════════════════════════════════════════════════════════════════════╡
## │    3 │ 8                    │ NamingConventions::ProhibitAmbiguousNames - Ambiguously named subroutine "abstract"                            │
## ├──────┼──────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
## │    3 │ 25, 65               │ ErrorHandling::RequireCarping - "die" used instead of "croak"                                                  │
## ├──────┼──────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
## │    2 │ 1                    │ Modules::RequireVersionVar - No package-scoped "$VERSION" variable found                                       │
## ├──────┼──────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
## │    1 │ 1                    │ NamingConventions::Capitalization - Package "Dist::Zilla::App::Command::cleanall" does not start with a upper  │
## │      │                      │ case letter                                                                                                    │
## ├──────┼──────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
## │    1 │ 34                   │ InputOutput::RequireCheckedSyscalls - Return value of flagged function ignored - print                         │
## └──────┴──────────────────────┴────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘
##
## -----SOURCE FILTER LOG END-----
__END__
=pod

=encoding utf8

=cut
