package Dist::Pcore::App;

use Pcore;
use parent qw[Dist::Zilla::App];

sub _default_command_base {
    return 'Dist::Zilla::App::Command';
}

sub prepare_command {
    my $self = shift;

    my ( $cmd, $opt, @args ) = $self->SUPER::prepare_command(@_);

    if ( $cmd->isa('Dist::Zilla::App::Command::install') ) {
        $opt->{install_command} ||= 'cpanm .';
    }
    elsif ( $cmd->isa('Dist::Zilla::App::Command::release') ) {
        $ENV{DZIL_CONFIRMRELEASE_DEFAULT} = 1 unless defined $ENV{DZIL_CONFIRMRELEASE_DEFAULT};    ## no critic qw(Variables::RequireLocalizedPunctuationVars)
    }
    elsif ( $cmd->isa('Dist::Zilla::App::Command::new') ) {
        $opt->{provider} = 'Pcore';
    }

    return $cmd, $opt, @args;
}

1;
## -----SOURCE FILTER LOG BEGIN-----
##
## PerlCritic profile "pcore-script" policy violations:
## ┌──────┬──────────────────────┬────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐
## │ Sev. │ Lines                │ Policy                                                                                                         │
## ╞══════╪══════════════════════╪════════════════════════════════════════════════════════════════════════════════════════════════════════════════╡
## │    3 │ 6                    │ Subroutines::ProhibitUnusedPrivateSubroutines - Private subroutine/method '_default_command_base' declared but │
## │      │                      │ not used                                                                                                       │
## └──────┴──────────────────────┴────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘
##
## -----SOURCE FILTER LOG END-----
__END__
=pod

=encoding utf8

=head1 NAME

Dist::Pcore::App

=head1 SYNOPSIS

=head1 DESCRIPTION

=cut
