#!/usr/bin/env perl

BEGIN {
  unless ($ENV{RELEASE_TESTING}) {
    require Test::More;
    Test::More::plan(skip_all => 'these tests are for release candidate testing');
  }
}


package main v0.1.0;

use P;
use Test::More;

our $TESTS = 6;

plan tests => $TESTS;

# COMPILING
require_ok('P::Util::UA::Response');

# CONSTRUCTOR
new_ok( 'P::Util::UA::Response' => [ {} ] );

# STATUS
ok( response()->set_status(300)->status == 300, 'response_status_1' );

# HEADERS
is_deeply( response()->add_headers( aa => 1, bb => 2 )->headers, { AA => 1, BB => 2 }, 'response_headers_1' );
is_deeply( response()->add_headers( aa => 1, bb => 2 )->add_headers( aa => 1, aa => [ 4, 5 ] )->headers, { AA => [ 1, 1, 4, 5 ], BB => 2 }, 'response_headers_2' );
is_deeply( response()->add_headers( aa => 1, bb => 2 )->replace_headers( aa => [ 4, 5 ] )->headers, { AA => [ 4, 5 ], BB => 2 }, 'response_headers_3' );

sub response {
    return P::Util::UA::Response->new_response(@_);
}

done_testing $TESTS;

1;
__END__
=pod

=encoding utf8

=cut
