package Dist::Zilla::MVP::Reader::Pcore;

use Moose;
use P;

extends qw[Config::MVP::Reader];

with qw[Config::MVP::Reader::Findable::ByExtension];

no P;
no Moose;

sub refined_location {
    if ( $_[1] =~ /profile\z/sm ) {

        # return $_[1] . '.perl';
    }
    elsif ( $_[1] =~ /dist\z/sm ) {
        return './share/dist.perl' if -f './share/dist.perl';
    }

    return;
}

sub default_extension {
    return 'perl';
}

sub read_into_assembler ( $self, $location, $asm ) {
    my $cfg = P->cfg->load($location);

    $cfg = $cfg->{dist} if exists $cfg->{dist};

    for my $key ( grep { !ref $cfg->{$_} } keys $cfg ) {
        $asm->add_value( $key, $cfg->{$key} );
    }

    $asm->end_section if $asm->current_section;

    if ( $location =~ /dist.perl\z/sm ) {

        # add @Pcore section
        $asm->begin_section( '@Pcore', '@Pcore' );

        # remove undef plugins
        # 'Plugin[::Name]' => undef
        for my $plugin ( grep { m/[[:upper:]]/sm && !defined $cfg->{$_} } keys $cfg ) {
            $asm->add_value( '-remove', $plugin );
        }

        # close @Pcore section
        $asm->end_section if $asm->current_section;
    }

    # add plugins sections
    for my $section ( grep { m/[[:upper:]]/sm && ref $cfg->{$_} } keys $cfg ) {
        $asm->begin_section( $section, $section );

        for my $key ( keys $cfg->{$section} ) {
            my $values = ref $cfg->{$section}->{$key} eq 'ARRAY' ? $cfg->{$section}->{$key} : [ $cfg->{$section}->{$key} ];

            for ( $values->@* ) {
                $asm->add_value( $key, $_ );
            }
        }

        $asm->end_section if $asm->current_section;
    }

    return $asm->sequence;
}

__PACKAGE__->meta->make_immutable;

1;
## -----SOURCE FILTER LOG BEGIN-----
##
## PerlCritic profile "pcore-script" policy violations:
## ┌──────┬──────────────────────┬────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐
## │ Sev. │ Lines                │ Policy                                                                                                         │
## ╞══════╪══════════════════════╪════════════════════════════════════════════════════════════════════════════════════════════════════════════════╡
## │    1 │ 43                   │ ValuesAndExpressions::RequireInterpolationOfMetachars - String *may* require interpolation                     │
## └──────┴──────────────────────┴────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘
##
## -----SOURCE FILTER LOG END-----
__END__
