package Dist::Zilla::App::Command::par;

use P;
use Dist::Zilla::App qw[-command];

sub abstract ($self) {
    return 'build PAR executable';
}

sub opt_spec ( $self, $app ) {
    return
      [ release => 'build release binary' ],
      [ crypt   => 'crypt non-core perl sources with Filter::Crypto' ],
      [ noupx   => 'do not compress shared objects with upx' ],
      [ clean   => 'clean temp dir on exit' ];
}

sub validate_args ( $self, $opt, $args ) {

    # NOTE args is just raw array or params, that not described as options

    die 'no args expected' if $args->@*;

    return;
}

sub execute ( $self, $opt, $args ) {
    $self->zilla->plugin_named('PAR')->build_par(
        release => $opt->release,
        crypt   => $opt->crypt,
        noupx   => $opt->noupx,
        clean   => $opt->clean,
    );

    return;
}

1;
## -----SOURCE FILTER LOG BEGIN-----
##
## PerlCritic profile "pcore-script" policy violations:
## ┌──────┬──────────────────────┬────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐
## │ Sev. │ Lines                │ Policy                                                                                                         │
## ╞══════╪══════════════════════╪════════════════════════════════════════════════════════════════════════════════════════════════════════════════╡
## │    3 │ 6                    │ NamingConventions::ProhibitAmbiguousNames - Ambiguously named subroutine "abstract"                            │
## ├──────┼──────────────────────┼────────────────────────────────────────────────────────────────────────────────────────────────────────────────┤
## │    1 │ 1                    │ NamingConventions::Capitalization - Package "Dist::Zilla::App::Command::par" does not start with a upper case  │
## │      │                      │ letter                                                                                                         │
## └──────┴──────────────────────┴────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘
##
## -----SOURCE FILTER LOG END-----
__END__
=pod

=encoding utf8

=cut
