#!/usr/bin/env perl

package main v0.1.0;

use P;
use Const::Fast();
use Benchmark();

Const::Fast::const our $COUNT => 100_000;

print 'update db ... ';

P->geoip->update;

say 'done';

my $res;

$res->{'Geo::IP'} = Benchmark::timeit( $COUNT, sub { my $a = P->geoip->country_code_by_addr('192.37.51.100') } );

{
    no warnings qw(once);    ## no critic qw(TestingAndDebugging::ProhibitNoWarnings)

    local $P::Util::GeoIP::GEOIP_PURE_PERL = 1;

    P->geoip->reconnect;

    $res->{'Geo::IP::PP'} = Benchmark::timeit( $COUNT, sub { my $a = P->geoip->country_code_by_addr('192.37.51.100') } );
}

Benchmark::cmpthese($res);

1;
__END__
=pod

=encoding utf8

=head1 REQUIRED ARGUMENTS

=over

=back

=head1 OPTIONS

=over

=back

=cut
