package P::HTTP::Message::Headers;

use P qw[-class];
extends qw[P::Util::Hash::Multivalue];

no P;

sub to_psgi ($self) {
    my $hash = $self->get_hash;

    my $headers = [];

    for ( keys $hash ) {
        my $header = ( ucfirst lc ) =~ s/_([[:alpha:]])/q[-] . uc $1/smger;

        push $headers, map { ( $header, $_ ) } $hash->{$_}->@*;
    }

    return $headers;
}

sub to_string ($self) {
    my $hash = $self->get_hash;

    my $headers = q[];

    for ( keys $hash ) {
        my $header = ( ucfirst lc ) =~ s/_([[:alpha:]])/q[-] . uc $1/smger;

        for ( $hash->{$_}->@* ) {
            $headers .= $header . q[: ] . $_ . $CRLF;
        }
    }

    return $headers;
}

1;
__END__
=pod

=encoding utf8

=head1 NAME

P::HTTP::Message::Headers

=head1 SYNOPSIS

=head1 DESCRIPTION

=cut
