package Pcore::Whois::Data;

use Pcore -const, -export => {    #
    CONST => [qw[$WHOIS_STATUS_OK $WHOIS_STATUS_NO_SERVER $WHOIS_STATUS_NETWORK $WHOIS_STATUS_BANNED $WHOIS_STATUS_NO_CONTENT]],
};
use Net::Whois::Raw::Data;

const our $WHOIS_STATUS_OK         => 200;
const our $WHOIS_STATUS_NO_SERVER  => 404;
const our $WHOIS_STATUS_NETWORK    => 500;
const our $WHOIS_STATUS_BANNED     => 501;
const our $WHOIS_STATUS_NO_CONTENT => 502;

const our $NOT_AVAIL_DOMAIN => 'cwxtwtqcuduvo78hr0dbrfxpuhv8gmtm';

# "undef" means, that TLD has no WHOIS server or currently is not supported by this software
our $TLD = {
    do       => undef,
    es       => undef,
    io       => undef,
    mg       => undef,
    sh       => undef,
    tm       => undef,
    tp       => undef,
    za       => undef,
    'web.za' => 'web-whois.registry.net.za',
    'org.za' => 'org-whois.registry.net.za',
    'net.za' => 'net-whois.registry.net.za',
    'co.za'  => 'whois.registry.net.za',
};

# adding domains with known whois server
for my $domain ( keys %Net::Whois::Raw::Data::servers ) {
    $TLD->{ lc $domain } = $Net::Whois::Raw::Data::servers{$domain} if !exists $TLD->{ lc $domain };
}

# adding known domains, that has no WHOIS server
for my $domain (@Net::Whois::Raw::Data::www_whois) {
    $TLD->{ lc $domain } = undef if !exists $TLD->{ lc $domain };
}

our $SERVER = {
    'whois.arin.org'         => { req_format  => 'n + <: QUERY :>' . $CRLF },
    'whois.denic.de'         => { req_format  => '-C UTF-8 -T dn,ace <: QUERY :>' . $CRLF },
    'whois.dk-hostmaster.dk' => { req_format  => '--show-handles <: QUERY :>' . $CRLF },
    'whois.jprs.jp'          => { req_format  => '<: QUERY :>/e' . $CRLF },
    'whois.nic.name'         => { req_format  => 'domain = <: QUERY :>' . $CRLF },
    'whois.nic.org.mt'       => { req_format  => '<: QUERY :>' . $LF },
    'whois.verisign-grs.com' => { is_verisign => 1 },
};

# adding known requests format for servers
for my $domain ( keys %Net::Whois::Raw::Data::query_prefix ) {
    next if exists $SERVER->{$domain} && exists $SERVER->{$domain}->{req_format};

    $SERVER->{$domain}->{req_format} = $Net::Whois::Raw::Data::query_prefix{$domain} . '<: QUERY :>' . $CRLF;
}

# adding known rate limit regexp
for my $domain ( keys %Net::Whois::Raw::Data::exceed ) {
    next if exists $SERVER->{$domain} && exists $SERVER->{$domain}->{rate_limit_re};

    $SERVER->{$domain}->{rate_limit_re} = qr/$Net::Whois::Raw::Data::exceed{$domain}/smi;
}

our $VERISIGN_RE = [    #
    qr/To single out one record, look it up with/smi,
    qr/look them up with .+? to receive a full display/smi,
];

our $RATE_LIMIT_RE = [    #
    qr/Your request is being rate limited/smi,
    qr/Too many requests/smi,
    qr/Number of allowed queries exceeded/smi,
    qr/You exceeded the maximum allowable number of whois lookups/smi,
    qr/the WHOIS query quota for (.+?) has been exceeded/smi,
];

1;
__END__
=pod

=encoding utf8

=head1 NAME

Pcore::Whois::Data

=head1 SYNOPSIS

=head1 DESCRIPTION

=cut
