package Pcore::Whois::Data;

use Pcore;

our $TLD = {    #
    'web.za' => 'web-whois.registry.net.za',
    'org.za' => 'org-whois.registry.net.za',
    'net.za' => 'net-whois.registry.net.za',
    'co.za'  => 'whois.registry.net.za',
};

our $SERVER = {
    'whois.arin.org'         => { req_format  => 'n + <: QUERY :>' . $CRLF },
    'whois.denic.de'         => { req_format  => '-C UTF-8 -T dn,ace <: QUERY :>' . $CRLF },
    'whois.dk-hostmaster.dk' => { req_format  => '--show-handles <: QUERY :>' . $CRLF },
    'whois.jprs.jp'          => { req_format  => '<: QUERY :>/e' . $CRLF },
    'whois.nic.name'         => { req_format  => 'domain = <: QUERY :>' . $CRLF },
    'whois.nic.org.mt'       => { req_format  => '<: QUERY :>' . $LF },
    'whois.verisign-grs.com' => { is_verisign => 1 },
};

our $VERISIGN_RE = [    #
    qr/To single out one record, look it up with/sm,
    qr/look them up with .+? to receive a full display/sm,
];

our $RATE_LIMIT_RE = [    #
    qr/Your request is being rate limited/sm,
    qr/Too many requests/sm,
    qr/Number of allowed queries exceeded/sm,
    qr/You exceeded the maximum allowable number of whois lookups/sm,
    qr/the WHOIS query quota for (.+?) has been exceeded/sm,
];

1;
__END__
=pod

=encoding utf8

=head1 NAME

Pcore::Whois::Data

=head1 SYNOPSIS

=head1 DESCRIPTION

=cut
