package Pcore::Whois::Server::Response;

use Pcore qw[-class];

# status:
# 200 - ok
# 500 - general error
# 501 - ip banned

has query  => ( is => 'ro', isa => Str, required => 1 );
has status => ( is => 'ro', isa => Int, required => 1 );
has reason => ( is => 'ro', isa => Str, required => 1 );
has server => ( is => 'ro' );
has raw => ( is => 'ro', isa => ScalarRef );

has is_success  => ( is => 'lazy', isa => Bool, init_arg => undef );
has is_verisign => ( is => 'lazy', isa => Bool, init_arg => undef );    # true, if invalid request to the verisign server
has md5         => ( is => 'lazy', isa => Str,  init_arg => undef );
has is_found    => ( is => 'lazy', isa => Bool, init_arg => undef );    # whois response is valid, and domain was found (nto available for registration)

no Pcore;

sub _build_is_success ($self) {
    return 0 if $self->status != 200;

    return 0 if !length $self->raw->$*;

    # check for ban
    for my $re ( $Pcore::Whois::Data::RATE_LIMIT_RE->@* ) {
        if ( $self->raw->$* =~ $re ) {
            $self->{status} = 501;

            $self->{reason} = 'IP is banned';

            return 0;
        }
    }

    return 1;
}

sub _build_is_verisign ($self) {
    if ( $self->is_success ) {
        for my $re ( $Pcore::Whois::Data::VERISIGN_RE->@* ) {
            return 1 if $self->raw->$* =~ $re;
        }
    }

    return 0;
}

sub _build_md5 ($self) {
    return q[] if !$self->is_success;

    my $content = $self->raw->$*;

    # remove comments (lines, started with '#' or '%')
    $content =~ s/^[%#].*?$//smg;

    # remove query
    my $query = $self->query;

    $content =~ s/$query//smgi;

    $content =~ s/[^[:alpha:]]+//smgi;

    return P->digest->md5_hex($content);
}

sub _build_is_found ($self) {
    return 0 if !$self->server || !$self->server->not_found_md5;

    return $self->md5 eq $self->server->not_found_md5 ? 0 : 1;
}

1;
__END__
=pod

=encoding utf8

=head1 NAME

Pcore::Whois::Server::Response

=head1 SYNOPSIS

=head1 DESCRIPTION

=cut
