#!/usr/bin/env perl

package main v0.1.0;

use Pcore;
use Pcore::Whois;

my $whois = Pcore::Whois->new;

if ( -f $ARGV{domain} ) {
    my $domains = P->file->read_lines( $ARGV{domain} );

    for my $domain ( $domains->@* ) {
        P->cv->begin;

        $whois->whois(
            $domain,
            sub ($res) {
                P->cv->end;

                print $domain . q[     ];

                if ( $res->is_success ) {
                    say $res->is_found ? 'REGISTERED' : 'AVAILABLE';
                }
                else {
                    say $res->message;
                }

                return;
            },
            threads => $ARGV{threads},
        );
    }
}
else {
    $whois->whois(
        $ARGV{domain},
        sub ($res) {
            if ( $res->is_success ) {
                say $res->content;

                say q[-] x 50;

                say 'STATUS REPORT:';

                say 'WHOIS SERVER: ' . $res->server->host;

                say 'IS REGISTERED: ' . ( $res->is_found ? 'YES' : 'NO' );
            }
            else {
                say $res->message;
            }

            P->cv->send;

            return;
        }
    );
}

P->cv->recv;

1;
__END__
=pod

=encoding utf8

=head1 REQUIRED ARGUMENTS

=over

=item <domain>

Domain to search or path to the file with domains to serach (one domain perl line).

=back

=head1 OPTIONS

=over

=item -t [=] <threads> | --threads [=] <threads>

Max. threads num. Default value - 10.

=for Euclid:
    threads.type: integer
    threads.default: 10

=back

=cut
