package Pcore::Core::Event::Listener::Pipe::smtp;

use Pcore -class, -ansi;
use Pcore::SMTP;
use Pcore::Util::Text qw[remove_ansi];

with qw[Pcore::Core::Event::Listener::Pipe];

has header => ( is => 'ro', isa => Str, default => '[<: $date.strftime("%Y-%m-%d %H:%M:%S.%4N") :>][<: $channel :>][<: $level :>]' );

has tmpl => ( is => 'ro', isa => InstanceOf ['Pcore::Util::Template'], init_arg => undef );
has smtp => ( is => 'ro', isa => InstanceOf ['Pcore::SMTP'],           init_arg => undef );

has _init => ( is => 'ro', isa => Bool, init_arg => undef );

sub sendlog ( $self, $ev, $data ) {

    # init
    if ( !$self->{_init} ) {
        $self->{_init} = 1;

        # init template
        $self->{tmpl} = P->tmpl;

        my $template = qq[$self->{header} <: \$title | raw :>];

        $self->{tmpl}->cache_string_tmpl( header => \$template );

        $self->{smtp} = Pcore::SMTP->new(
            {   host     => $self->{uri}->query_params->{smtp_host},
                port     => $self->{uri}->query_params->{smtp_port},
                username => $self->{uri}->username . '@' . $self->{uri}->host,
                password => $self->{uri}->password,
                tls      => $self->{uri}->query_params->{smtp_tls},
            }
        );
    }

    # sendlog
    {
        local $data->{date} = P->date->from_epoch( $data->{timestamp} );

        my $body = remove_ansi $data->{body} // q[];

        $self->{smtp}->sendmail(
            from     => $self->{uri}->username . '@' . $self->{uri}->host,
            reply_to => $self->{uri}->username . '@' . $self->{uri}->host,
            to       => $self->{uri}->query_params->{to},
            bcc      => undef,
            subject  => $self->{tmpl}->render( 'header', $data )->$*,
            body     => $body,
            sub ($res) {return}
        );
    }

    return;
}

1;
## -----SOURCE FILTER LOG BEGIN-----
##
## PerlCritic profile "pcore-script" policy violations:
## +------+----------------------+----------------------------------------------------------------------------------------------------------------+
## | Sev. | Lines                | Policy                                                                                                         |
## |======+======================+================================================================================================================|
## |    2 | 41                   | Variables::ProhibitLocalVars - Variable declared as "local"                                                    |
## |------+----------------------+----------------------------------------------------------------------------------------------------------------|
## |    1 | 9                    | ValuesAndExpressions::RequireInterpolationOfMetachars - String *may* require interpolation                     |
## +------+----------------------+----------------------------------------------------------------------------------------------------------------+
##
## -----SOURCE FILTER LOG END-----
__END__
=pod

=encoding utf8

=head1 NAME

Pcore::Core::Event::Listener::Pipe::smtp

=head1 SYNOPSIS

    P->listen_events( 'LOG.TEST.*', 'smtp://username:password@google.com?smtp_tls=1&smtp_host=smtp.gmail.com&smtp_port=465&&to=username@domain.net' );

=head1 DESCRIPTION

=head1 ATTRIBUTES

=head1 METHODS

=head1 SEE ALSO

=cut
