package Pcore::Handle::Redis;

use Pcore qw[-class];
use RedisDB;

with qw[Pcore::Core::H::Role::Wrapper];

has '+h_disconnect_on' => ( isa => Enum [ 'PID_CHANGE', 'BEFORE_FORK', 'REQ_FINISH' ], default => 'PID_CHANGE' );
has addr     => ( is => 'ro', isa => Str, required => 1 );     # //host:port, unix://path
has password => ( is => 'ro', isa => Str, default  => q[] );
has database => ( is => 'ro', isa => Int, default  => 1 );

# H
sub h_connect {
    my $self = shift;

    my %params = (
        password            => $self->password,
        database            => $self->database,
        raise_error         => 1,
        timeout             => 3,
        utf8                => 1,
        connection_name     => q[],
        lazy                => 1,
        reconnect_attempts  => 3,
        reconnect_delay_max => 10,
        on_connect_error    => sub { },
    );

    my $addr = P->uri( $self->addr );

    if ( $addr->scheme eq 'unix' ) {
        $params{path} = $addr->path;
    }
    else {
        $params{host} = $addr->host;

        $params{port} = $addr->port;
    }

    my $h = RedisDB->new(%params);

    return $h;
}

sub h_disconnect {
    my $self = shift;

    $self->h->reset_connection;

    return;
}

1;
__END__
=pod

=encoding utf8

=head1 NAME

Pcore::Handle::Redis

=head1 SYNOPSIS

=head1 DESCRIPTION

=cut
