package Pcore::Proxy::Source::Banditim;

use Pcore qw[-class];

with qw[Pcore::Proxy::Source];

has type => ( is => 'ro', isa => Enum [qw[ANY FASTEST TOP10]], default => 'FASTEST' );    # TOP10 - top 10% of all proxies

has '+max_threads' => ( isa => Enum [ 50, 100, 200 ], default => 50 );
has '+is_multiproxy' => ( default => 1 );

no Pcore;

sub load ( $self, $cb ) {
    my $proxies;

    if ( $self->type eq 'ANY' ) {
        push $proxies->@*, '//37.58.52.41:2020?http&connect&socks';
    }
    elsif ( $self->type eq 'FASTEST' ) {
        push $proxies->@*, '//37.58.52.41:3030?http&connect&socks';
    }
    elsif ( $self->type eq 'TOP10' ) {
        push $proxies->@*, '//37.58.52.41:4040?http&connect&socks';
    }

    $cb->($proxies);

    return;
}

1;
__END__
=pod

=encoding utf8

=head1 NAME

Pcore::Proxy::Source::Banditim

=head1 SYNOPSIS

=head1 DESCRIPTION

=cut
