package Pcore::Handle::pg;    ## no critic qw[NamingConventions::Capitalization]

use Pcore -class;
use DBD::Pg qw[:async];
use Pcore::DBH::Pg;

with qw[Pcore::DBH];

has _dbh_pool => ( is => 'ro', isa => ArrayRef, default => sub { [] }, init_arg => undef );

sub BUILD ( $self, $args ) {
    my $attr = P->hash->merge(
        $self->default_dbi_attr,
        {   pg_server_prepare => 1,
            pg_enable_utf8    => 1,
        }
    );

    my $params = {
        host => $self->uri->path eq q[/] ? $self->uri->host : $self->uri->path,
        port => $self->uri->port || 5432,
        database => $self->uri->query_params->{db},
        options  => '--client-min-messages=warning',
    };

    die q[Host is required] if !$params->{host};

    die q[Database is required] if !$params->{database};

    $self->{_dbh} = DBI->connect( 'DBI:Pg:' . join( q[;], map {qq[$_=$params->{$_}]} sort keys $params->%* ), $self->uri->username, $self->uri->password, $attr );

    $self->{_dbh}->disconnect;

    return;
}

sub dbh ($self) {
    my $dbh = shift $self->{_dbh_pool}->@*;

    if ( !$dbh ) {
        $dbh = Pcore::DBH::Pg->new(
            {   _dbh        => $self->{_dbh}->clone,
                _parent_dbh => $self,
            }
        );
    }

    return $dbh;
}

1;
## -----SOURCE FILTER LOG BEGIN-----
##
## PerlCritic profile "pcore-script" policy violations:
## +------+----------------------+----------------------------------------------------------------------------------------------------------------+
## | Sev. | Lines                | Policy                                                                                                         |
## |======+======================+================================================================================================================|
## |    3 | 30                   | References::ProhibitDoubleSigils - Double-sigil dereference                                                    |
## +------+----------------------+----------------------------------------------------------------------------------------------------------------+
##
## -----SOURCE FILTER LOG END-----
__END__
=pod

=encoding utf8

=head1 NAME

Pcore::Handle::pg

=head1 SYNOPSIS

=head1 DESCRIPTION

=head1 ATTRIBUTES

=head1 METHODS

=head1 SEE ALSO

=cut
