package Pcore::DBD::DDL::MySQL;

use Pcore -class;

with qw[Pcore::DBD::DDL];

has mysql_mode => ( is => 'ro', isa => ArrayRef [ Enum [qw[TRADITIONAL ALLOW_INVALID_DATES NO_AUTO_VALUE_ON_ZERO]] ], predicate => 1 );

sub schema_info_sql ($self) {
    return;
}

sub _get_cset_sql ( $self, $cset ) {
    my @sql;

    push @sql, q[SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0;];
    push @sql, q[SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;];
    push @sql, q[SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='] . join( q[,], $cset->mysql_mode->@* ) . q[';] if $cset->has_mysql_mode;

    push @sql, $cset->sql;

    push @sql, q[SET SQL_MODE=@OLD_SQL_MODE;] if $cset->has_mysql_mode;
    push @sql, q[SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;];
    push @sql, q[SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS;];

    return \join $LF, @sql;
}

1;
## -----SOURCE FILTER LOG BEGIN-----
##
## PerlCritic profile "pcore-script" policy violations:
## +------+----------------------+----------------------------------------------------------------------------------------------------------------+
## | Sev. | Lines                | Policy                                                                                                         |
## |======+======================+================================================================================================================|
## |    3 | 13                   | Subroutines::ProhibitUnusedPrivateSubroutines - Private subroutine/method '_get_cset_sql' declared but not     |
## |      |                      | used                                                                                                           |
## |------+----------------------+----------------------------------------------------------------------------------------------------------------|
## |    1 | 16, 17, 18, 22, 23,  | ValuesAndExpressions::RequireInterpolationOfMetachars - String *may* require interpolation                     |
## |      | 24                   |                                                                                                                |
## +------+----------------------+----------------------------------------------------------------------------------------------------------------+
##
## -----SOURCE FILTER LOG END-----
__END__
=pod

=encoding utf8

=head1 NAME

Pcore::DBD::DDL::MySQL

=head1 SYNOPSIS

=head1 DESCRIPTION

=cut
