Ext.define("Pcore.form.field.Recaptcha", {
    "extend": "Ext.form.field.Base",
    "alias": "widget.recaptchafield",

    "requires": [
        "Ext.form.field.Base"
    ],

    "allowBlank": false,
    "hideLabel": true,

    "config": {
        "reCaptchaSiteKey": null,
        "reCaptchaBadge": "inline",
        "reCaptchaHl": "en",
        "reCaptchaInvisible": true,
        "reCaptchaSize": "normal",
        "reCaptchaTabIndex": 0,
        "reCaptchaTheme": "light",
        "reCaptchaType": "image",

        "reCaptchaExecuteCb": null,
        "reCaptchaWidgetId": null
    },

    "_renderReCaptcha": function () {
        var me = this;

        var args = {
            'sitekey': this.reCaptchaSiteKey,
            'badge': this.reCaptchaBadge,
            'type': this.reCaptchaType,
            'tabindex': this.reCaptchaTabIndex,
            'theme': this.reCaptchaTheme,
            'callback': function (reCaptchaResponse) {
                me.setValue(reCaptchaResponse);

                if (me.reCaptchaExecuteCb) {
                    var cb = me.reCaptchaExecuteCb;

                    me.reCaptchaExecuteCb = null;

                    cb();
                }
            },
            'expired-callback': function () {
                me.setValue('');
            }
        };

        if (this.reCaptchaInvisible) {
            args.size = 'invisible';
        } else {
            args.size = this.reCaptchaSize;
        }

        this.reCaptchaWidgetId = grecaptcha.render(this.getReCaptchaId(), args);

    },

    "afterRender": function () {
        this.callParent(arguments);

        // do nothing, if reCaptchaSiteKey is not set
        if (!this.reCaptchaSiteKey) {
            return;
        }

        if (typeof grecaptcha === 'undefined') {

            // install global onReCaptchaLoad callback
            if (typeof onReCaptchaLoad === 'undefined') {
                reCaptchaLoadCbQueue = [];

                onReCaptchaLoad = function () {
                    var i;

                    while ((i = reCaptchaLoadCbQueue.shift()) !== undefined) {
                        i._renderReCaptcha();
                    }
                };
            }

            reCaptchaLoadCbQueue.push(this);

            if (typeof reCaptchaScriptLoad === 'undefined') {
                reCaptchaScriptLoad = true;

                var script = document.createElement('script');
                script.src = 'https://www.google.com/recaptcha/api.js?render=explicit&onload=onReCaptchaLoad&hl=' + this.reCaptchaHl;
                document.head.appendChild(script);
            }
        } else {
            this._renderReCaptcha();
        }

    },

    "fieldSubTpl": [
      "<div id=\"{reCaptchaId}\"></div>",
      "<input id=\"{id}\" data-ref=\"inputEl\" type=\"hidden\" name=\"{name}\" />",
        {
            "disableFormats": true
      }
   ],

    "getErrors": function (value) {
        var errors = [];

        // do nothing, if reCaptchaSiteKey is not set
        if (!this.reCaptchaSiteKey) {
            return errors;
        }

        // in invisible mode field is always valid
        if (this.reCaptchaInvisible) {
            return errors;
        }

        // in visible mode chack, that reCaptcha is solved
        if (!value) {
            errors.push('reCaptcha is not solved');
        }

        return errors;

    },

    "getReCaptchaId": function () {
        return this.reCaptchaId || (this.reCaptchaId = this.id + '-reCaptchaEl');

    },

    "getSubTplData": function (fieldData) {
        var data = this.callParent(arguments);

        data.reCaptchaId = this.getReCaptchaId();

        return data;

    },

    "reCaptchaExecute": function (cb) {

        // do nothing, if reCaptchaSiteKey is not set
        if (!this.reCaptchaSiteKey) {
            cb();
        }

        // not solved
        else if (!this.getValue()) {
            this.reCaptchaExecuteCb = cb;

            grecaptcha.execute(this.reCaptchaWidgetId);
        }

        // already solved
        else {
            cb();
        }

    },

    "reCaptchaReset": function () {

        // do nothing, if reCaptchaSiteKey is not set
        if (!this.reCaptchaSiteKey) {
            return;
        }

        this.setValue('');

        grecaptcha.reset(this.reCaptchaWidgetId);

    }
});
