package Pcore::DBH v0.1.2;

use Pcore -dist, -role;
use DBI;
use Pcore::Util::Text qw[escape_scalar];

with qw[Pcore::Handle Pcore::DBH::DBI];

has _query_class => ( is => 'lazy', isa => Str, init_arg => undef );
has _ddl_class   => ( is => 'lazy', isa => Str, init_arg => undef );

sub default_dbi_attr($self) {
    state $attr = {
        Warn        => 1,
        PrintWarn   => 1,
        PrintError  => 0,
        RaiseError  => 1,
        HandleError => sub {
            my $msg = shift;

            escape_scalar $msg;

            die $msg;
        },
        ShowErrorStatement => 1,
        AutoCommit         => 1,
        Callbacks          => {
            connected => sub {
                P->log->sendlog( 'Pcore-DBH', 'Connected to: ' . $_[1] );

                return;
            },
            prepare => sub {
                return;
            },
            do => sub {
                P->log->sendlog( 'Pcore-DBH', 'Do: ' . $_[1] );

                return;
            },
            ChildCallbacks => {
                execute => sub {
                    P->log->sendlog( 'Pcore-DBH', 'Execute: ' . $_[0]->{Statement} );

                    return;
                }
            }
        }
    };

    return $attr;
}

sub _build__query_class ($self) {
    return P->class->load( $self->uri->scheme, ns => 'Pcore::DBH::Query' );
}

sub _build__ddl_class ($self) {
    return P->class->load( $self->uri->scheme, ns => 'Pcore::DBH::DDL' );
}

# SQL QUERY BUILDER
sub query ( $self, @args ) {
    my $class = $self->_query_class;

    my $query = $class->new( { dbh => $self } );

    $query->_build_query(@args);

    return $query;
}

# DDL
sub ddl ( $self) {
    my $class = $self->_ddl_class;

    return $class->new( { dbh => $self } );
}

1;
__END__
=pod

=encoding utf8

=head1 NAME

Pcore::DBH

=head1 SYNOPSIS

=head1 DESCRIPTION

=head1 ATTRIBUTES

=head1 METHODS

=head1 SEE ALSO

=cut
