package Pcore::API::Antigate;

use Pcore -class, -const;
use Pcore::Captcha;

has api_key => ( is => 'ro', isa => Str, required => 1 );
has soft_id => ( is => 'ro', isa => Maybe [Str] );    # AppCenter Application ID used for comission earnings

has _pool => ( is => 'lazy', isa => HashRef, default => sub { {} }, init_arg => undef );
has _timer => ( is => 'ro', isa => InstanceOf ['EV::Timer'], init_arg => undef );

const our $STATUS => {
    ERROR_NO_SLOT_AVAILABLE => 280,
    CAPCHA_NOT_READY        => 281,

    ERROR_WRONG_USER_KEY           => 580,
    ERROR_KEY_DOES_NOT_EXIST       => 581,
    ERROR_ZERO_BALANCE             => 582,
    ERROR_ZERO_CAPTCHA_FILESIZE    => 583,
    ERROR_IMAGE_TYPE_NOT_SUPPORTED => 584,
    ERROR_IP_NOT_ALLOWED           => 585,

    ERROR_WRONG_ID_FORMAT    => 586,
    ERROR_NO_SUCH_CAPCHA_ID  => 587,
    ERROR_CAPTCHA_UNSOLVABLE => 588,
};

our $RESOLVER_TIMEOUT = 1;

sub resolve ( $self, @ ) {
    my $cb = pop;

    my $captcha = Pcore::Captcha->new( { splice @_, 1 } );

    my $params = {};

    for my $param (qw[phrase regsense numeric calc min_len max_len is_russian type comment]) {
        $params->{$param} = $captcha->$param if defined $captcha->$param;
    }

    $params->{key}     = $self->api_key;
    $params->{soft_id} = $self->soft_id if $self->soft_id;
    $params->{method}  = 'base64';
    $params->{body}    = P->data->to_b64( $captcha->captcha->$*, q[] );

    my $body = P->data->to_uri($params);

    $self->_resolve( $captcha, $body, $cb );

    return;
}

sub _resolve ( $self, $captcha, $body, $cb ) {
    P->http->post(
        'http://antigate.com/in.php',
        body      => $body,
        headers   => { CONTENT_TYPE => 'application/x-www-form-urlencoded', },
        on_finish => sub ($res) {
            if ( $res->status != 200 ) {
                $captcha->set_status( $res->status, $res->reason );

                $cb->($captcha);
            }
            else {
                if ( $res->body->$* =~ /\AOK[|](\d+)\z/sm ) {
                    $self->_pool->{$1} = [ $captcha, $cb ];

                    $captcha->{id} = $1;

                    $self->_run_resolver;
                }
                else {
                    if ( $res->body->$* eq 'ERROR_NO_SLOT_AVAILABLE' ) {
                        $self->_resolve( $captcha, $body, $cb );
                    }
                    else {
                        $captcha->set_status( $STATUS->{ $res->body->$* }, $res->body->$* );

                        $cb->($captcha);
                    }
                }
            }

            return;
        }
    );

    return;
}

sub report_failure ( $self, $captcha ) {
    return if !$captcha->id;

    P->http->get( 'http://antigate.com/res.php?key=' . $self->api_key . '&action=reportbad&id=' . $captcha->id );

    return;
}

sub get_balance ($self) {

    # http://antigate.com/res.php?key=ddcda6f268cfd3445a5afc302689ccd2&action=getbalance

    return;
}

sub get_xml_stats ($self) {

    # http://antigate.com/res.php?key=ddcda6f268cfd3445a5afc302689ccd2&action=getstats&date=2015-02-15

    return;
}

sub get_realtime_stats ($self) {

    # http://antigate.com/load.php
    # waiting: количество работников ожидающих капчу. Максимально показываемое число - 50.
    # load: процент загрузки работников
    # minbid: минимальная ставка необходимая для прохождения вашей капчи
    # averageRecognitionTime: среднее время (в секундах) за которое в данный момент разгадываются капчи

    return;
}

sub _run_resolver ($self) {
    return if $self->_timer;

    return if !$self->_pool->%*;

    $self->{_timer} = AE::timer $RESOLVER_TIMEOUT, 0, sub {
        undef $self->{_timer};

        my @ids = keys $self->_pool->%*;

        P->http->get(
            'http://antigate.com/res.php?key=' . $self->api_key . '&action=get&ids=' . join( q[,], keys $self->_pool->%* ),
            on_finish => sub ($res) {
                if ( $res->status == 200 ) {
                    my @content = split /[|]/sm, $res->body->$*;

                    for my $id (@ids) {
                        my $status = shift @content;

                        if ( $status eq 'CAPCHA_NOT_READY' ) {
                            next;
                        }
                        else {
                            my $data = delete $self->_pool->{$id};

                            if ( $status =~ /\AERROR_/sm ) {
                                $data->[0]->set_status( $STATUS->{$status}, $status );

                                $data->[1]->( $data->[0] );
                            }
                            else {
                                $data->[0]->set_status(200);

                                $data->[0]->{result} = $status;

                                $data->[1]->( $data->[0] );
                            }
                        }
                    }
                }

                $self->_run_resolver;

                return;
            },
        );

        return;
    };

    return;
}

1;
## -----SOURCE FILTER LOG BEGIN-----
##
## PerlCritic profile "pcore-script" policy violations:
## +------+----------------------+----------------------------------------------------------------------------------------------------------------+
## | Sev. | Lines                | Policy                                                                                                         |
## |======+======================+================================================================================================================|
## |    3 | 127, 132, 135        | References::ProhibitDoubleSigils - Double-sigil dereference                                                    |
## +------+----------------------+----------------------------------------------------------------------------------------------------------------+
##
## -----SOURCE FILTER LOG END-----
__END__
=pod

=encoding utf8

=head1 NAME

Pcore::API::Antigate

=head1 SYNOPSIS

=head1 DESCRIPTION

=head1 ATTRIBUTES

=head1 METHODS

=head1 SEE ALSO

=cut
