package Pcore::Captcha v0.1.4;

use Pcore -class;

has cb         => ( is => 'ro', isa => CodeRef,           required => 1 );
has captcha    => ( is => 'ro', isa => ScalarRef,         required => 1 );
has phrase     => ( is => 'ro', isa => Bool,              default  => 0 );
has regsense   => ( is => 'ro', isa => Bool,              default  => 0 );
has numeric    => ( is => 'ro', isa => Bool,              default  => 0 );
has calc       => ( is => 'ro', isa => Bool,              default  => 0 );
has min_len    => ( is => 'ro', isa => PositiveOrZeroInt, default  => 0 );
has max_len    => ( is => 'ro', isa => PositiveOrZeroInt, default  => 0 );
has is_russian => ( is => 'ro', isa => Bool,              default  => 0 );
has soft_id => ( is => 'ro', isa => Maybe [Str], default => undef );
has header_acao => ( is => 'ro', isa => Bool, default => 0 );

has id     => ( is => 'rwp', isa => PositiveInt, predicate => 1, clearer => 1, init_arg => undef );
has error  => ( is => 'rwp', isa => Str,         predicate => 1, clearer => 1, init_arg => undef );
has result => ( is => 'rwp', isa => Str,         predicate => 1, clearer => 1, init_arg => undef );

sub clear {
    my $self = shift;

    $self->clear_id;

    $self->clear_error;

    $self->clear_result;

    return;
}

1;
__END__
=pod

=encoding utf8

=cut
