use Test::More qw(no_plan);
use Tie::IxHash::FromText;

#use Data::Dumper;
#$Data::Dumper::Indent=1;
{local$/;
$s = <DATA>;
}
#print Dumper ixhash_parse($s);
$h = ixhash_parse($s);

ok(exists $h->{'1'});
ok(exists $h->{'1'}->{'1-1'});
ok(exists $h->{'1'}->{'1-2'});
ok(exists $h->{'1'}->{'1-2'}->{'1-2-1'});
ok(exists $h->{'2'});
ok(exists $h->{'2'}->{'2-1'});
ok(exists $h->{'3'});
ok(exists $h->{'3'}->{'3-1'});
ok(exists $h->{'3'}->{'3-2'});
ok(exists $h->{'3'}->{'3-2'}->{'3-2-1'});
ok(exists $h->{'3'}->{'3-2'}->{'3-2-1'}->{'3-2-1-1'});
ok(exists $h->{'3'}->{'3-2'}->{'3-2-1'}->{'3-2-1-1'}->{'3-2-1-1-1'});
ok(exists $h->{'3'}->{'3-2'}->{'3-2-1'}->{'3-2-1-1'}->{'3-2-1-1-2'});
ok(exists $h->{'3'}->{'3-2'}->{'3-2-1'}->{'3-2-1-1'}->{'3-2-1-1-2'}->{'3-2-1-1-2-1'});
ok(exists $h->{'4'});


__END__
* 1
** 1-1
** 1-2
*** 1-2-1

* 2
** 2-1

* 3
** 3-1
** 3-2
*** 3-2-1
**** 3-2-1-1
***** 3-2-1-1-1
***** 3-2-1-1-2
****** 3-2-1-1-2-1

* 4