/*
 * Copyright 2000 by Vizdom Software, Inc. All Rights Reserved.
 */
package com.vizdom.test;

import java.lang.reflect.Constructor;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

/**
 * An agent for jUnit's TestRunner classes. This class helps run tests
 * using jUnit.
 */
public abstract class TestAgent
{
    /**
     * Runs the named tests from the given class. If no arguments were
     * given, runs all of the tests. This method is used to implement the
     * main method in TestCase subclasses.
     *
     * @param aClass a TestCase subclass
     * @param args command line arguments
     */
    public static void mainForClass(Class aClass, String[] args)
        throws Exception
    {
        TestSuite suite;
        if (args.length == 0)
            suite = new TestSuite(aClass);
        else
        {
            suite = new TestSuite();
            Constructor init =
                aClass.getConstructor(new Class[] { String.class });
            for (int i = 0; i < args.length; ++i)
            {
                Test test = (Test) init.newInstance(new String[] { args[i] });
                suite.addTest(test);
            }
        }
        TestRunner.run(suite);
    }

    /**
     * Runs the tests in all the named classes. This is essentially just
     * what TestRunner does, except that this works around the extdirs bug
     * (4311459) and it handles multiple classes. It does, however, tie us
     * to the textui TestRunner at the moment.
     *
     * @param args command line arguments
     */
    public static void main(String[] args) throws Exception
    {
        TestSuite suite = new TestSuite();
        for (int i = 0; i < args.length; ++i)
        {
            Test test = new TestSuite(Class.forName(args[i]));
            suite.addTest(test);
        }
        TestRunner.run(suite);
    }
}
