use strict;
use warnings;

package Software::License::GPL_3::or_later;

our $VERSION = '0.002'; # VERSION
# ABSTRACT: Add-on for Software::License module providing "or any later" clause to GPL_3

use parent 'Software::License::GPL_3';

sub name { $_[ 0 ]->SUPER::name() . ', or any later' };
sub version { '3+'; };
    #   Cannot call `SUPER::version` here because it returns "or.later".

1;

=pod

=encoding UTF-8

=head1 NAME

Software::License::GPL_3::or_later - Add-on for Software::License module providing "or any later" clause to GPL_3

=head1 VERSION

version 0.002

=head1 SYNOPSIS

In C<dist.ini>:

    name             = Foo-Bar
    version          = 0.001
    author           = John Doe <john.doe@example.com>
    license          = GPL_3::or_later ; <<== Note this <<==
    copyright_holder = John Doe
    copyright_year   = 2015
    …

Direct usage:

    use Software::License::GPL_3::or_later;
    my $license =
        Software::License::GPL_3::or_later->new( {
            holder => 'John Doe', …
        } );

=head1 DESCRIPTION

C<Software::License::GPL_3::or_later> is a subclass of C<Software::License::GPL_3>. It overrides
license name — appends ", or any later", changes version to "3+", and notice to standard GNU
3-paragraph notice.

See documentation on C<Software::License> for description of methods.

=head1 PURPOSE

C<Dist::Zilla>/C<dzil>, a popular framework/tool for building packages for CPAN, allows you to
specify software license in C<dist.ini> file, e. g.:

    license = NAME

where I<NAME> is a short license name, like C<Perl_5> or C<BSD>. When building your package,
C<dzil> will add "COPYRIGHT AND LICENSE" section to the documentation, add appropriate C<LICENSE>
file to your package, etc. C<Dist::Zilla> uses licenses provided by C<Software::License> package.
The latter is bundled with a set of popular software licenses, including GNU General Public License
(GNU GPL) versions 1, 2, and 3, denoted by names C<GPL_1>, C<GPL_2>, and C<GPL_3> respectively.

L<Free Software Foundation|https://fsf.org/>, a developer of GNU GPL, recommends do not stick to a
specific version of the GNU license, but allow "upgrading" it by using phrase "version I<N> or any
later version". See L<rationale|https://www.gnu.org/licenses/gpl-faq.html#VersionThreeOrLater>.

However, C<Software::License> package does not include any "upgradable" license. This module
partially fulfills the lack by providing license C<GPL_3::or_later>.

=head1 CAVEATS

C<CPAN::Meta::Spec> hardcodes the list of "valid" licenses. In version 2.150001 of the module there
are no "upgradable" GNU licenses, so in CPAN the GPLv3+ will look as ordinal GPLv3.

=head1 SEE ALSO

=over 4

=item L<Dist::Zilla>

=item L<Software::License>

=item L<Why should programs say “Version 3 of the GPL or any later version”?|https://www.gnu.org/licenses/gpl-faq.html#VersionThreeOrLater>

=back

=head1 AUTHOR

Van de Bugger <van.de.bugger@liamg.moc>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2015 Van de Bugger

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.

=cut

__DATA__
__NOTICE__
Copyright (C) {{$self->year}} {{$self->holder}}

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
__END__

# end of file #
