#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#
#   file: t/TemplatesTester.pm
#
#   Copyright © 2015 Van de Bugger
#
#   This file is part of perl-Dist-Zilla-Plugin-Templates.
#
#   perl-Dist-Zilla-Plugin-Templates is free software: you can redistribute it and/or modify it
#   under the terms of the GNU General Public License as published by the Free Software Foundation,
#   either version 3 of the License, or (at your option) any later version.
#
#   perl-Dist-Zilla-Plugin-Templates is distributed in the hope that it will be useful, but WITHOUT
#   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#   PURPOSE. See the GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License along with
#   perl-Dist-Zilla-Plugin-Templates. If not, see <http://www.gnu.org/licenses/>.
#
#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

package TemplatesTester;

#   The test is written using `Moose`-based `Test::Routine`. It is not big deal, because we are
#   testing plugin for `Dist::Zilla`, and `Dist-Zilla` is also `Moose`-based.

use autodie ':all';
use namespace::autoclean;

use Test::Routine;
with 'PluginTester';

use Test::More;
use Test::Deep qw{ cmp_deeply };

sub build_plugin { 'Templates' };

has exp_files => (
    is          => 'ro',
    isa         => 'HashRef',
    default     => sub { {} },
);

test 'check_files' => sub {
    my ( $self ) = @_;
    if ( $self->exception ) {
        plan skip_all => 'exception occurred';
    };
    plan tests => keys( %{ $self->exp_files } ) + 0;
    for my $name ( sort( keys( %{ $self->exp_files } ) ) ) {
        my $expected = $self->exp_files->{ $name };
        my @actual   = $self->tzil->built_in->file( $name )->slurp( chomp => 1 );
        cmp_deeply( \@actual, $expected, $name );
    };
    done_testing;
};

1;

# end of file #
