#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#
#   file: t/MetaResourcesTemplateTester.pm
#
#   Copyright © 2015 Van de Bugger
#
#   This file is part of perl-Dist-Zilla-Plugin-MetaResources-Template.
#
#   perl-Dist-Zilla-Plugin-MetaResources-Template is free software: you can redistribute it and/or
#   modify it under the terms of the GNU General Public License as published by the Free Software
#   Foundation, either version 3 of the License, or (at your option) any later version.
#
#   perl-Dist-Zilla-Plugin-MetaResources-Template is distributed in the hope that it will be
#   useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
#   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License along with
#   perl-Dist-Zilla-Plugin-MetaResources-Template. If not, see <http://www.gnu.org/licenses/>.
#
#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

package MetaResourcesTemplateTester;

#   The test is written using `Moose`-based `Test::Routine`. It is not big deal, because we are
#   testing plugin for `Dist::Zilla`, and `Dist-Zilla` is also `Moose`-based.

use autodie ':all';
use namespace::autoclean;

use Test::Routine;
with 'Test::Dist::Zilla::Build';

use Test::More;
use Test::Deep qw{ cmp_deeply };

#   `MetaResources::Template` plugin options, in form acceptable by `Builder->from_config`.
has resources => (
    is          => 'ro',
    isa         => 'HashRef',
    required    => 1,
);

sub _build_message_filter {
    return sub {
        map(
            { ( my $r = $_ ) =~ s{^\[[^\[\]]*\] }{}; $r; }
            grep( { $_ =~ m{^\[MetaResources::Template\] } } @_ )
        );
    };
};

sub _build_plugins {
    my ( $self ) = @_;
    return [
        'GatherDir',
        'Manifest',
        'MetaYAML',
        [ 'MetaResources::Template', $self->resources ],
    ];
};

test 'Resources' => sub {

    my ( $self ) = @_;
    my $expected = $self->expected;

    if ( $self->exception ) {
        plan skip_all => 'exception occurred';
    };
    if ( not exists ( $expected->{ resources } ) ) {
        plan skip_all => 'no expected resources';
    };

    plan tests => 1;

    my $resources = $self->tzil->distmeta->{ resources };
    cmp_deeply( $resources, $expected->{ resources }, 'resources' );

};

1;

# end of file #
