#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#
#   file: lib/Dist/Zilla/Plugin/Hook/BeforeMint.pm
#
#   This file is part of perl-Dist-Zilla-Plugin-Hook.
#   This file was generated with =tools::GenerateHooks.
#
#   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

#pod =head1 DESCRIPTION
#pod
#pod This is C<Hook::BeforeMint> plugin implementation. Nothing interesting, just using few roles.
#pod
#pod If you want to write C<Dist::Zilla> plugin directly in F<dist.ini>, read the L<manual|Dist::Zilla::Plugin::Hook::Manual>. General topics like
#pod getting source, building, installing, bug reporting and some others are covered in the
#pod L<readme|Dist::Zilla::Plugin::Hook::ReadMe>.
#pod
#pod =head1 SEE ALSO
#pod
#pod =for :list
#pod = L<Dist::Zilla::Plugin::Hook>
#pod = L<Dist::Zilla::Plugin::Hook:Manual>
#pod = L<Dist::Zilla::Plugin::Hook:ReadMe>
#pod = L<Dist::Zilla>
#pod = L<Dist::Zilla::Role::BeforeMint>
#pod
#pod =cut

package Dist::Zilla::Plugin::Hook::BeforeMint;

use Moose;

# ABSTRACT: C<Hook::BeforeMint> plugin implementation
our $VERSION = '0.006'; # VERSION

with 'Dist::Zilla::Role::Plugin';
with 'Dist::Zilla::Role::Hooker' => {
    -alias => { hook => 'before_mint' },
};
with 'Dist::Zilla::Role::BeforeMint';

__PACKAGE__->meta->make_immutable();

1;

# end of file #

__END__

=pod

=encoding UTF-8

=head1 NAME

Dist::Zilla::Plugin::Hook::BeforeMint - C<Hook::BeforeMint> plugin implementation

=head1 VERSION

Version 0.006, released on 2015-08-11 20:12 UTC.

=head1 DESCRIPTION

This is C<Hook::BeforeMint> plugin implementation. Nothing interesting, just using few roles.

If you want to write C<Dist::Zilla> plugin directly in F<dist.ini>, read the L<manual|Dist::Zilla::Plugin::Hook::Manual>. General topics like
getting source, building, installing, bug reporting and some others are covered in the
L<readme|Dist::Zilla::Plugin::Hook::ReadMe>.

=head1 SEE ALSO

=over 4

=item L<Dist::Zilla::Plugin::Hook>

=item L<Dist::Zilla::Plugin::Hook:Manual>

=item L<Dist::Zilla::Plugin::Hook:ReadMe>

=item L<Dist::Zilla>

=item L<Dist::Zilla::Role::BeforeMint>

=back

=head1 AUTHOR

Van de Bugger <van.de.bugger@gmail.com>

=cut
