### sub fold

```perl6
sub fold(
    Str:D $string,
    Int:D :$width where { ... } = 80,
    Int:D :$indent where { ... } = 0
) returns Str
```

Fold a string to contain no lines longer than the given width.

class Str:D $string
-------------------

The string to fold.

class Int:D :$width where { ... } = 80
--------------------------------------

The maximum width of lines in the text.

class Int:D :$indent where { ... } = 0
--------------------------------------

The number of spaces used to indent the text.

### sub new-line-length

```perl6
sub new-line-length(
    Str:D @words,
    Str:D $new-word,
    Int:D $indent-width
) returns Int
```

Calculate the total line length of a would-be line.

NAME
====

String::Fold

AUTHOR
======

Patrick Spek <p.spek@tyil.work>

VERSION
=======

0.1.1

SYNOPSIS
========

fold(Str:D $, Int:D :$width, Int:D :$indent);

DESCRIPTION
===========

Fold a `Str` to a given width. Accepts a `:$width`Defaults to `80` and a `:$indent`Defaults to `0`.

EXAMPLES
========

Basic usage
-----------

input
=====

use String::Fold;

my Str $folded = fold(slurp("some-text-file"));

This will yield a folded string in `$folded`. The input file will have all its lines folded to a maximum width of 80 characters.

Folding at a custom width
-------------------------

input
=====

use String::Fold;

my Str $folded = slurp("some-text-file").&fold(:width(40));

This will yield a string folded at 40 characters, instead of the default of 80 characters. Any number higher that `0` is accepted.

Indented block
--------------

input
=====

use String::Fold;

my Str $indented = slurp("some-text-file").&fold(:indent(8));

This will yield a string folded at 80 characters (the default), and indented by 8 spaces.

