#! /usr/bin/env false

use v6.c;

use Config;
use IRC::Client;

#| The IRC::Client::Plugin to deal with NickServ interaction.
unit class IRC::Client::Plugin::NickServ does IRC::Client::Plugin;

#| A Config instance to hold all configuration.
has Config $.config;

#| Identify with NickServ. This is done on IRC code 376 (end of MOTD),
#| since this is what most servers accept as the earliest time to start
#| interacting with the server.
method irc-n376 (
	$event,
) {
	# Extract the config parameters
	my $user = $!config.get('irc.plugins.nickserv.account');
	my $pass = $!config.get('irc.plugins.nickserv.password');

	# Nothing to do if we don't have a username and a password
	if (!$user || !$pass) {
		.critical('Missing username or password for NickServ auth') with $*LOG;
		return;
	}

	# Send the identify command
	$event.irc.send-cmd: "NS identify $user $pass";
}

multi method irc-notice (
	$event where *.text.contains('you are now identified', :i),
) {
	# Nothing to do if we already have our preferred nickname
	return if $event.server.current-nick eq $event.server.nick.first;

	# Ghost our nick
	$event.irc.send-cmd: "NS GHOST {$event.server.nick.first}";
}

multi method irc-notice (
	$event where *.text.contains('has been ghosted', :i),
) {
	# Use our nick
	$event.irc.nick: $event.server.nick.first;
}

# vim: ft=perl6 noet
