/* -*- buffer-read-only: t -*-
 *
 *    opnames.h
 *
 *    Copyright (C) 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
 *    2007 by Larry Wall and others
 *
 *    You may distribute under the terms of either the GNU General Public
 *    License or the Artistic License, as specified in the README file.
 *
 *
 * !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
 *  This file is built by opcode.pl from its data.  Any changes made here
 *  will be lost!
 */

typedef enum opcode {
	OP_NULL		 = 0,
	OP_STUB		 = 1,
	OP_SCALAR	 = 2,
	OP_PUSHMARK	 = 3,
	OP_WANTARRAY	 = 4,
	OP_CONST	 = 5,
	OP_GVSV		 = 6,
	OP_GV		 = 7,
	OP_GELEM	 = 8,
	OP_PADSV	 = 9,
	OP_PADANY	 = 10,
	OP_PUSHRE	 = 11,
	OP_RV2GV	 = 12,
	OP_RV2SV	 = 13,
	OP_RV2CV	 = 14,
	OP_ANONCODE	 = 15,
	OP_PROTOTYPE	 = 16,
	OP_SREFGEN	 = 17,
	OP_REF		 = 18,
	OP_BLESS	 = 19,
	OP_ANONSCALAR	 = 20,
	OP_BACKTICK	 = 21,
	OP_GLOB		 = 22,
	OP_READLINE	 = 23,
	OP_RCATLINE	 = 24,
	OP_REGCMAYBE	 = 25,
	OP_REGCRESET	 = 26,
	OP_REGCOMP	 = 27,
	OP_MATCH	 = 28,
	OP_QR		 = 29,
	OP_SUBST	 = 30,
	OP_SUBSTCONT	 = 31,
	OP_SASSIGN	 = 32,
	OP_AASSIGN	 = 33,
	OP_CHOP		 = 34,
	OP_SCHOP	 = 35,
	OP_CHOMP	 = 36,
	OP_SCHOMP	 = 37,
	OP_DEFINED	 = 38,
	OP_UNDEF	 = 39,
	OP_STUDY	 = 40,
	OP_POS		 = 41,
	OP_PREINC	 = 42,
	OP_I_PREINC	 = 43,
	OP_PREDEC	 = 44,
	OP_I_PREDEC	 = 45,
	OP_POSTINC	 = 46,
	OP_I_POSTINC	 = 47,
	OP_POSTDEC	 = 48,
	OP_I_POSTDEC	 = 49,
	OP_POW		 = 50,
	OP_MULTIPLY	 = 51,
	OP_I_MULTIPLY	 = 52,
	OP_DIVIDE	 = 53,
	OP_I_DIVIDE	 = 54,
	OP_MODULO	 = 55,
	OP_I_MODULO	 = 56,
	OP_REPEAT	 = 57,
	OP_ADD		 = 58,
	OP_I_ADD	 = 59,
	OP_SUBTRACT	 = 60,
	OP_I_SUBTRACT	 = 61,
	OP_CONCAT	 = 62,
	OP_STRINGIFY	 = 63,
	OP_LEFT_SHIFT	 = 64,
	OP_RIGHT_SHIFT	 = 65,
	OP_LT		 = 66,
	OP_I_LT		 = 67,
	OP_GT		 = 68,
	OP_I_GT		 = 69,
	OP_LE		 = 70,
	OP_I_LE		 = 71,
	OP_GE		 = 72,
	OP_I_GE		 = 73,
	OP_EQ		 = 74,
	OP_I_EQ		 = 75,
	OP_NE		 = 76,
	OP_I_NE		 = 77,
	OP_NCMP		 = 78,
	OP_I_NCMP	 = 79,
	OP_REF_EQ	 = 80,
	OP_REF_NE	 = 81,
	OP_SEQ		 = 82,
	OP_SNE		 = 83,
	OP_SCMP		 = 84,
	OP_BIT_AND	 = 85,
	OP_BIT_XOR	 = 86,
	OP_BIT_OR	 = 87,
	OP_NEGATE	 = 88,
	OP_I_NEGATE	 = 89,
	OP_NOT		 = 90,
	OP_COMPLEMENT	 = 91,
	OP_SMARTMATCH	 = 92,
	OP_ATAN2	 = 93,
	OP_SIN		 = 94,
	OP_COS		 = 95,
	OP_RAND		 = 96,
	OP_SRAND	 = 97,
	OP_EXP		 = 98,
	OP_LOG		 = 99,
	OP_SQRT		 = 100,
	OP_INT		 = 101,
	OP_HEX		 = 102,
	OP_OCT		 = 103,
	OP_ABS		 = 104,
	OP_LENGTH	 = 105,
	OP_SUBSTR	 = 106,
	OP_VEC		 = 107,
	OP_INDEX	 = 108,
	OP_RINDEX	 = 109,
	OP_SPRINTF	 = 110,
	OP_ORD		 = 111,
	OP_CHR		 = 112,
	OP_CRYPT	 = 113,
	OP_UCFIRST	 = 114,
	OP_LCFIRST	 = 115,
	OP_UC		 = 116,
	OP_LC		 = 117,
	OP_QUOTEMETA	 = 118,
	OP_RV2AV	 = 119,
	OP_AELEMFAST	 = 120,
	OP_AELEM	 = 121,
	OP_ASLICE	 = 122,
	OP_EACH		 = 123,
	OP_VALUES	 = 124,
	OP_KEYS		 = 125,
	OP_NKEYS	 = 126,
	OP_DELETE	 = 127,
	OP_EXISTS	 = 128,
	OP_RV2HV	 = 129,
	OP_HELEM	 = 130,
	OP_HSLICE	 = 131,
	OP_UNPACK	 = 132,
	OP_PACK		 = 133,
	OP_SPLIT	 = 134,
	OP_JOIN		 = 135,
	OP_LIST		 = 136,
	OP_LSLICE	 = 137,
	OP_ANONLIST	 = 138,
	OP_ANONHASH	 = 139,
	OP_LISTLAST	 = 140,
	OP_EXPAND	 = 141,
	OP_NELEMS	 = 142,
	OP_SPLICE	 = 143,
	OP_PUSH		 = 144,
	OP_POP		 = 145,
	OP_SHIFT	 = 146,
	OP_UNSHIFT	 = 147,
	OP_SORT		 = 148,
	OP_REVERSE	 = 149,
	OP_GREPSTART	 = 150,
	OP_GREPWHILE	 = 151,
	OP_MAPSTART	 = 152,
	OP_MAPWHILE	 = 153,
	OP_RANGE	 = 154,
	OP_FLIP		 = 155,
	OP_FLOP		 = 156,
	OP_AND		 = 157,
	OP_OR		 = 158,
	OP_XOR		 = 159,
	OP_DOR		 = 160,
	OP_COND_EXPR	 = 161,
	OP_ANDASSIGN	 = 162,
	OP_ORASSIGN	 = 163,
	OP_DORASSIGN	 = 164,
	OP_METHOD	 = 165,
	OP_ENTERSUB	 = 166,
	OP_LEAVESUB	 = 167,
	OP_CALLER	 = 168,
	OP_WARN		 = 169,
	OP_DIE		 = 170,
	OP_LINESEQ	 = 171,
	OP_NEXTSTATE	 = 172,
	OP_DBSTATE	 = 173,
	OP_UNSTACK	 = 174,
	OP_ENTER	 = 175,
	OP_LEAVE	 = 176,
	OP_SCOPE	 = 177,
	OP_ENTERITER	 = 178,
	OP_ITER		 = 179,
	OP_ENTERLOOP	 = 180,
	OP_LEAVELOOP	 = 181,
	OP_RETURN	 = 182,
	OP_LAST		 = 183,
	OP_NEXT		 = 184,
	OP_REDO		 = 185,
	OP_DUMP		 = 186,
	OP_GOTO		 = 187,
	OP_EXIT		 = 188,
	OP_METHOD_NAMED	 = 189,
	OP_OPEN		 = 190,
	OP_CLOSE	 = 191,
	OP_PIPE_OP	 = 192,
	OP_FILENO	 = 193,
	OP_UMASK	 = 194,
	OP_BINMODE	 = 195,
	OP_TIE		 = 196,
	OP_UNTIE	 = 197,
	OP_TIED		 = 198,
	OP_SSELECT	 = 199,
	OP_SELECT	 = 200,
	OP_GETC		 = 201,
	OP_READ		 = 202,
	OP_PRTF		 = 203,
	OP_PRINT	 = 204,
	OP_SYSOPEN	 = 205,
	OP_SYSSEEK	 = 206,
	OP_SYSREAD	 = 207,
	OP_SYSWRITE	 = 208,
	OP_EOF		 = 209,
	OP_TELL		 = 210,
	OP_SEEK		 = 211,
	OP_TRUNCATE	 = 212,
	OP_FCNTL	 = 213,
	OP_IOCTL	 = 214,
	OP_FLOCK	 = 215,
	OP_SEND		 = 216,
	OP_RECV		 = 217,
	OP_SOCKET	 = 218,
	OP_SOCKPAIR	 = 219,
	OP_BIND		 = 220,
	OP_CONNECT	 = 221,
	OP_LISTEN	 = 222,
	OP_ACCEPT	 = 223,
	OP_SHUTDOWN	 = 224,
	OP_GSOCKOPT	 = 225,
	OP_SSOCKOPT	 = 226,
	OP_GETSOCKNAME	 = 227,
	OP_GETPEERNAME	 = 228,
	OP_LSTAT	 = 229,
	OP_STAT		 = 230,
	OP_FTRREAD	 = 231,
	OP_FTRWRITE	 = 232,
	OP_FTREXEC	 = 233,
	OP_FTEREAD	 = 234,
	OP_FTEWRITE	 = 235,
	OP_FTEEXEC	 = 236,
	OP_FTIS		 = 237,
	OP_FTSIZE	 = 238,
	OP_FTMTIME	 = 239,
	OP_FTATIME	 = 240,
	OP_FTCTIME	 = 241,
	OP_FTROWNED	 = 242,
	OP_FTEOWNED	 = 243,
	OP_FTZERO	 = 244,
	OP_FTSOCK	 = 245,
	OP_FTCHR	 = 246,
	OP_FTBLK	 = 247,
	OP_FTFILE	 = 248,
	OP_FTDIR	 = 249,
	OP_FTPIPE	 = 250,
	OP_FTSUID	 = 251,
	OP_FTSGID	 = 252,
	OP_FTSVTX	 = 253,
	OP_FTLINK	 = 254,
	OP_FTTTY	 = 255,
	OP_FTTEXT	 = 256,
	OP_FTBINARY	 = 257,
	OP_CHDIR	 = 258,
	OP_CHOWN	 = 259,
	OP_CHROOT	 = 260,
	OP_UNLINK	 = 261,
	OP_CHMOD	 = 262,
	OP_UTIME	 = 263,
	OP_RENAME	 = 264,
	OP_LINK		 = 265,
	OP_SYMLINK	 = 266,
	OP_READLINK	 = 267,
	OP_MKDIR	 = 268,
	OP_RMDIR	 = 269,
	OP_OPEN_DIR	 = 270,
	OP_READDIR	 = 271,
	OP_TELLDIR	 = 272,
	OP_SEEKDIR	 = 273,
	OP_REWINDDIR	 = 274,
	OP_CLOSEDIR	 = 275,
	OP_FORK		 = 276,
	OP_WAIT		 = 277,
	OP_WAITPID	 = 278,
	OP_SYSTEM	 = 279,
	OP_EXEC		 = 280,
	OP_KILL		 = 281,
	OP_GETPPID	 = 282,
	OP_GETPGRP	 = 283,
	OP_SETPGRP	 = 284,
	OP_GETPRIORITY	 = 285,
	OP_SETPRIORITY	 = 286,
	OP_TIME		 = 287,
	OP_TMS		 = 288,
	OP_LOCALTIME	 = 289,
	OP_GMTIME	 = 290,
	OP_ALARM	 = 291,
	OP_SLEEP	 = 292,
	OP_SHMGET	 = 293,
	OP_SHMCTL	 = 294,
	OP_SHMREAD	 = 295,
	OP_SHMWRITE	 = 296,
	OP_MSGGET	 = 297,
	OP_MSGCTL	 = 298,
	OP_MSGSND	 = 299,
	OP_MSGRCV	 = 300,
	OP_SEMOP	 = 301,
	OP_SEMGET	 = 302,
	OP_SEMCTL	 = 303,
	OP_REQUIRE	 = 304,
	OP_DOFILE	 = 305,
	OP_HINTSEVAL	 = 306,
	OP_ENTEREVAL	 = 307,
	OP_LEAVEEVAL	 = 308,
	OP_ENTERTRY	 = 309,
	OP_LEAVETRY	 = 310,
	OP_GHBYNAME	 = 311,
	OP_GHBYADDR	 = 312,
	OP_GHOSTENT	 = 313,
	OP_GNBYNAME	 = 314,
	OP_GNBYADDR	 = 315,
	OP_GNETENT	 = 316,
	OP_GPBYNAME	 = 317,
	OP_GPBYNUMBER	 = 318,
	OP_GPROTOENT	 = 319,
	OP_GSBYNAME	 = 320,
	OP_GSBYPORT	 = 321,
	OP_GSERVENT	 = 322,
	OP_SHOSTENT	 = 323,
	OP_SNETENT	 = 324,
	OP_SPROTOENT	 = 325,
	OP_SSERVENT	 = 326,
	OP_EHOSTENT	 = 327,
	OP_ENETENT	 = 328,
	OP_EPROTOENT	 = 329,
	OP_ESERVENT	 = 330,
	OP_GPWNAM	 = 331,
	OP_GPWUID	 = 332,
	OP_GPWENT	 = 333,
	OP_SPWENT	 = 334,
	OP_EPWENT	 = 335,
	OP_GGRNAM	 = 336,
	OP_GGRGID	 = 337,
	OP_GGRENT	 = 338,
	OP_SGRENT	 = 339,
	OP_EGRENT	 = 340,
	OP_GETLOGIN	 = 341,
	OP_SYSCALL	 = 342,
	OP_LOCK		 = 343,
	OP_COMPSUB	 = 344,
	OP_CUSTOM	 = 345,
	OP_max		
} opcode;

#define MAXO 346
#define OP_phoney_INPUT_ONLY -1
#define OP_phoney_OUTPUT_ONLY -2


/* the OP_IS_(SOCKET|FILETEST) macros are optimized to a simple range
    check because all the member OPs are contiguous in opcode.pl
    <DATA> table.  opcode.pl verifies the range contiguity.  */

#define OP_IS_SOCKET(op)	\
	((op) >= OP_SEND && (op) <= OP_GETPEERNAME)

#define OP_IS_FILETEST(op)	\
	((op) >= OP_FTRREAD && (op) <= OP_FTBINARY)

#define OP_IS_FILETEST_ACCESS(op)	\
	((op) >= OP_FTRREAD && (op) <= OP_FTEEXEC)

/* ex: set ro: */
