/* -*- buffer-read-only: t -*-
 *
 *    opnames.h
 *
 *    Copyright (C) 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
 *    2007 by Larry Wall and others
 *
 *    You may distribute under the terms of either the GNU General Public
 *    License or the Artistic License, as specified in the README file.
 *
 *
 * !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
 *  This file is built by opcode.pl from its data.  Any changes made here
 *  will be lost!
 */

typedef enum opcode {
	OP_NULL		 = 0,
	OP_STUB		 = 1,
	OP_SCALAR	 = 2,
	OP_PUSHMARK	 = 3,
	OP_WANTARRAY	 = 4,
	OP_CONST	 = 5,
	OP_GVSV		 = 6,
	OP_GV		 = 7,
	OP_GELEM	 = 8,
	OP_PADSV	 = 9,
	OP_PADAV	 = 10,
	OP_PADHV	 = 11,
	OP_PADANY	 = 12,
	OP_PUSHRE	 = 13,
	OP_RV2GV	 = 14,
	OP_RV2SV	 = 15,
	OP_RV2CV	 = 16,
	OP_ANONCODE	 = 17,
	OP_PROTOTYPE	 = 18,
	OP_REFGEN	 = 19,
	OP_SREFGEN	 = 20,
	OP_REF		 = 21,
	OP_BLESS	 = 22,
	OP_BACKTICK	 = 23,
	OP_GLOB		 = 24,
	OP_READLINE	 = 25,
	OP_RCATLINE	 = 26,
	OP_REGCMAYBE	 = 27,
	OP_REGCRESET	 = 28,
	OP_REGCOMP	 = 29,
	OP_MATCH	 = 30,
	OP_QR		 = 31,
	OP_SUBST	 = 32,
	OP_SUBSTCONT	 = 33,
	OP_TRANS	 = 34,
	OP_SASSIGN	 = 35,
	OP_AASSIGN	 = 36,
	OP_CHOP		 = 37,
	OP_SCHOP	 = 38,
	OP_CHOMP	 = 39,
	OP_SCHOMP	 = 40,
	OP_DEFINED	 = 41,
	OP_UNDEF	 = 42,
	OP_STUDY	 = 43,
	OP_POS		 = 44,
	OP_PREINC	 = 45,
	OP_I_PREINC	 = 46,
	OP_PREDEC	 = 47,
	OP_I_PREDEC	 = 48,
	OP_POSTINC	 = 49,
	OP_I_POSTINC	 = 50,
	OP_POSTDEC	 = 51,
	OP_I_POSTDEC	 = 52,
	OP_POW		 = 53,
	OP_MULTIPLY	 = 54,
	OP_I_MULTIPLY	 = 55,
	OP_DIVIDE	 = 56,
	OP_I_DIVIDE	 = 57,
	OP_MODULO	 = 58,
	OP_I_MODULO	 = 59,
	OP_REPEAT	 = 60,
	OP_ADD		 = 61,
	OP_I_ADD	 = 62,
	OP_SUBTRACT	 = 63,
	OP_I_SUBTRACT	 = 64,
	OP_CONCAT	 = 65,
	OP_STRINGIFY	 = 66,
	OP_LEFT_SHIFT	 = 67,
	OP_RIGHT_SHIFT	 = 68,
	OP_LT		 = 69,
	OP_I_LT		 = 70,
	OP_GT		 = 71,
	OP_I_GT		 = 72,
	OP_LE		 = 73,
	OP_I_LE		 = 74,
	OP_GE		 = 75,
	OP_I_GE		 = 76,
	OP_EQ		 = 77,
	OP_I_EQ		 = 78,
	OP_NE		 = 79,
	OP_I_NE		 = 80,
	OP_NCMP		 = 81,
	OP_I_NCMP	 = 82,
	OP_REF_EQ	 = 83,
	OP_REF_NE	 = 84,
	OP_SEQ		 = 85,
	OP_SNE		 = 86,
	OP_SCMP		 = 87,
	OP_BIT_AND	 = 88,
	OP_BIT_XOR	 = 89,
	OP_BIT_OR	 = 90,
	OP_NEGATE	 = 91,
	OP_I_NEGATE	 = 92,
	OP_NOT		 = 93,
	OP_COMPLEMENT	 = 94,
	OP_SMARTMATCH	 = 95,
	OP_ATAN2	 = 96,
	OP_SIN		 = 97,
	OP_COS		 = 98,
	OP_RAND		 = 99,
	OP_SRAND	 = 100,
	OP_EXP		 = 101,
	OP_LOG		 = 102,
	OP_SQRT		 = 103,
	OP_INT		 = 104,
	OP_HEX		 = 105,
	OP_OCT		 = 106,
	OP_ABS		 = 107,
	OP_LENGTH	 = 108,
	OP_SUBSTR	 = 109,
	OP_VEC		 = 110,
	OP_INDEX	 = 111,
	OP_RINDEX	 = 112,
	OP_SPRINTF	 = 113,
	OP_ORD		 = 114,
	OP_CHR		 = 115,
	OP_CRYPT	 = 116,
	OP_UCFIRST	 = 117,
	OP_LCFIRST	 = 118,
	OP_UC		 = 119,
	OP_LC		 = 120,
	OP_QUOTEMETA	 = 121,
	OP_RV2AV	 = 122,
	OP_AELEMFAST	 = 123,
	OP_AELEM	 = 124,
	OP_ASLICE	 = 125,
	OP_EACH		 = 126,
	OP_VALUES	 = 127,
	OP_KEYS		 = 128,
	OP_DELETE	 = 129,
	OP_EXISTS	 = 130,
	OP_RV2HV	 = 131,
	OP_HELEM	 = 132,
	OP_HSLICE	 = 133,
	OP_UNPACK	 = 134,
	OP_PACK		 = 135,
	OP_SPLIT	 = 136,
	OP_JOIN		 = 137,
	OP_LIST		 = 138,
	OP_LSLICE	 = 139,
	OP_ANONLIST	 = 140,
	OP_ANONHASH	 = 141,
	OP_SPLICE	 = 142,
	OP_PUSH		 = 143,
	OP_POP		 = 144,
	OP_SHIFT	 = 145,
	OP_UNSHIFT	 = 146,
	OP_SORT		 = 147,
	OP_REVERSE	 = 148,
	OP_GREPSTART	 = 149,
	OP_GREPWHILE	 = 150,
	OP_MAPSTART	 = 151,
	OP_MAPWHILE	 = 152,
	OP_RANGE	 = 153,
	OP_FLIP		 = 154,
	OP_FLOP		 = 155,
	OP_AND		 = 156,
	OP_OR		 = 157,
	OP_XOR		 = 158,
	OP_DOR		 = 159,
	OP_COND_EXPR	 = 160,
	OP_ANDASSIGN	 = 161,
	OP_ORASSIGN	 = 162,
	OP_DORASSIGN	 = 163,
	OP_METHOD	 = 164,
	OP_ENTERSUB	 = 165,
	OP_LEAVESUB	 = 166,
	OP_LEAVESUBLV	 = 167,
	OP_CALLER	 = 168,
	OP_WARN		 = 169,
	OP_DIE		 = 170,
	OP_LINESEQ	 = 171,
	OP_NEXTSTATE	 = 172,
	OP_DBSTATE	 = 173,
	OP_UNSTACK	 = 174,
	OP_ENTER	 = 175,
	OP_LEAVE	 = 176,
	OP_SCOPE	 = 177,
	OP_ENTERITER	 = 178,
	OP_ITER		 = 179,
	OP_ENTERLOOP	 = 180,
	OP_LEAVELOOP	 = 181,
	OP_RETURN	 = 182,
	OP_LAST		 = 183,
	OP_NEXT		 = 184,
	OP_REDO		 = 185,
	OP_DUMP		 = 186,
	OP_GOTO		 = 187,
	OP_EXIT		 = 188,
	OP_METHOD_NAMED	 = 189,
	OP_ENTERGIVEN	 = 190,
	OP_LEAVEGIVEN	 = 191,
	OP_ENTERWHEN	 = 192,
	OP_LEAVEWHEN	 = 193,
	OP_BREAK	 = 194,
	OP_CONTINUE	 = 195,
	OP_OPEN		 = 196,
	OP_CLOSE	 = 197,
	OP_PIPE_OP	 = 198,
	OP_FILENO	 = 199,
	OP_UMASK	 = 200,
	OP_BINMODE	 = 201,
	OP_TIE		 = 202,
	OP_UNTIE	 = 203,
	OP_TIED		 = 204,
	OP_SSELECT	 = 205,
	OP_SELECT	 = 206,
	OP_GETC		 = 207,
	OP_READ		 = 208,
	OP_PRTF		 = 209,
	OP_PRINT	 = 210,
	OP_SYSOPEN	 = 211,
	OP_SYSSEEK	 = 212,
	OP_SYSREAD	 = 213,
	OP_SYSWRITE	 = 214,
	OP_EOF		 = 215,
	OP_TELL		 = 216,
	OP_SEEK		 = 217,
	OP_TRUNCATE	 = 218,
	OP_FCNTL	 = 219,
	OP_IOCTL	 = 220,
	OP_FLOCK	 = 221,
	OP_SEND		 = 222,
	OP_RECV		 = 223,
	OP_SOCKET	 = 224,
	OP_SOCKPAIR	 = 225,
	OP_BIND		 = 226,
	OP_CONNECT	 = 227,
	OP_LISTEN	 = 228,
	OP_ACCEPT	 = 229,
	OP_SHUTDOWN	 = 230,
	OP_GSOCKOPT	 = 231,
	OP_SSOCKOPT	 = 232,
	OP_GETSOCKNAME	 = 233,
	OP_GETPEERNAME	 = 234,
	OP_LSTAT	 = 235,
	OP_STAT		 = 236,
	OP_FTRREAD	 = 237,
	OP_FTRWRITE	 = 238,
	OP_FTREXEC	 = 239,
	OP_FTEREAD	 = 240,
	OP_FTEWRITE	 = 241,
	OP_FTEEXEC	 = 242,
	OP_FTIS		 = 243,
	OP_FTSIZE	 = 244,
	OP_FTMTIME	 = 245,
	OP_FTATIME	 = 246,
	OP_FTCTIME	 = 247,
	OP_FTROWNED	 = 248,
	OP_FTEOWNED	 = 249,
	OP_FTZERO	 = 250,
	OP_FTSOCK	 = 251,
	OP_FTCHR	 = 252,
	OP_FTBLK	 = 253,
	OP_FTFILE	 = 254,
	OP_FTDIR	 = 255,
	OP_FTPIPE	 = 256,
	OP_FTSUID	 = 257,
	OP_FTSGID	 = 258,
	OP_FTSVTX	 = 259,
	OP_FTLINK	 = 260,
	OP_FTTTY	 = 261,
	OP_FTTEXT	 = 262,
	OP_FTBINARY	 = 263,
	OP_CHDIR	 = 264,
	OP_CHOWN	 = 265,
	OP_CHROOT	 = 266,
	OP_UNLINK	 = 267,
	OP_CHMOD	 = 268,
	OP_UTIME	 = 269,
	OP_RENAME	 = 270,
	OP_LINK		 = 271,
	OP_SYMLINK	 = 272,
	OP_READLINK	 = 273,
	OP_MKDIR	 = 274,
	OP_RMDIR	 = 275,
	OP_OPEN_DIR	 = 276,
	OP_READDIR	 = 277,
	OP_TELLDIR	 = 278,
	OP_SEEKDIR	 = 279,
	OP_REWINDDIR	 = 280,
	OP_CLOSEDIR	 = 281,
	OP_FORK		 = 282,
	OP_WAIT		 = 283,
	OP_WAITPID	 = 284,
	OP_SYSTEM	 = 285,
	OP_EXEC		 = 286,
	OP_KILL		 = 287,
	OP_GETPPID	 = 288,
	OP_GETPGRP	 = 289,
	OP_SETPGRP	 = 290,
	OP_GETPRIORITY	 = 291,
	OP_SETPRIORITY	 = 292,
	OP_TIME		 = 293,
	OP_TMS		 = 294,
	OP_LOCALTIME	 = 295,
	OP_GMTIME	 = 296,
	OP_ALARM	 = 297,
	OP_SLEEP	 = 298,
	OP_SHMGET	 = 299,
	OP_SHMCTL	 = 300,
	OP_SHMREAD	 = 301,
	OP_SHMWRITE	 = 302,
	OP_MSGGET	 = 303,
	OP_MSGCTL	 = 304,
	OP_MSGSND	 = 305,
	OP_MSGRCV	 = 306,
	OP_SEMOP	 = 307,
	OP_SEMGET	 = 308,
	OP_SEMCTL	 = 309,
	OP_REQUIRE	 = 310,
	OP_DOFILE	 = 311,
	OP_HINTSEVAL	 = 312,
	OP_ENTEREVAL	 = 313,
	OP_LEAVEEVAL	 = 314,
	OP_ENTERTRY	 = 315,
	OP_LEAVETRY	 = 316,
	OP_GHBYNAME	 = 317,
	OP_GHBYADDR	 = 318,
	OP_GHOSTENT	 = 319,
	OP_GNBYNAME	 = 320,
	OP_GNBYADDR	 = 321,
	OP_GNETENT	 = 322,
	OP_GPBYNAME	 = 323,
	OP_GPBYNUMBER	 = 324,
	OP_GPROTOENT	 = 325,
	OP_GSBYNAME	 = 326,
	OP_GSBYPORT	 = 327,
	OP_GSERVENT	 = 328,
	OP_SHOSTENT	 = 329,
	OP_SNETENT	 = 330,
	OP_SPROTOENT	 = 331,
	OP_SSERVENT	 = 332,
	OP_EHOSTENT	 = 333,
	OP_ENETENT	 = 334,
	OP_EPROTOENT	 = 335,
	OP_ESERVENT	 = 336,
	OP_GPWNAM	 = 337,
	OP_GPWUID	 = 338,
	OP_GPWENT	 = 339,
	OP_SPWENT	 = 340,
	OP_EPWENT	 = 341,
	OP_GGRNAM	 = 342,
	OP_GGRGID	 = 343,
	OP_GGRENT	 = 344,
	OP_SGRENT	 = 345,
	OP_EGRENT	 = 346,
	OP_GETLOGIN	 = 347,
	OP_SYSCALL	 = 348,
	OP_LOCK		 = 349,
	OP_COMPSUB	 = 350,
	OP_CUSTOM	 = 351,
	OP_max		
} opcode;

#define MAXO 352
#define OP_phoney_INPUT_ONLY -1
#define OP_phoney_OUTPUT_ONLY -2


/* the OP_IS_(SOCKET|FILETEST) macros are optimized to a simple range
    check because all the member OPs are contiguous in opcode.pl
    <DATA> table.  opcode.pl verifies the range contiguity.  */

#define OP_IS_SOCKET(op)	\
	((op) >= OP_SEND && (op) <= OP_GETPEERNAME)

#define OP_IS_FILETEST(op)	\
	((op) >= OP_FTRREAD && (op) <= OP_FTBINARY)

#define OP_IS_FILETEST_ACCESS(op)	\
	((op) >= OP_FTRREAD && (op) <= OP_FTEEXEC)

/* ex: set ro: */
