#!/usr/bin/perl

package eBay::API::XML::DataType::StoreThemeArrayType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. StoreThemeArrayType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::StoreThemeArrayType

=head1 DESCRIPTION

Set of Store themes.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::StoreThemeArrayType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::StoreColorSchemeArrayType;
use eBay::API::XML::DataType::StoreThemeType;


my @gaProperties = ( [ 'GenericColorSchemeArray', 'ns:StoreColorSchemeArrayType', ''
	     ,'eBay::API::XML::DataType::StoreColorSchemeArrayType', '1' ]
	, [ 'Theme', 'ns:StoreThemeType', '1'
	     ,'eBay::API::XML::DataType::StoreThemeType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setGenericColorSchemeArray()

Set of color schemes. This set is for use with those themes that do
not explicitly list a color scheme in the theme definition (these
themes are also known as advanced themes).

#    Argument: 'ns:StoreColorSchemeArrayType'

=cut

sub setGenericColorSchemeArray {
  my $self = shift;
  $self->{'GenericColorSchemeArray'} = shift
}

=head2 getGenericColorSchemeArray()

  Calls: GetStoreOptions
  Returned: Always
  Context: AdvancedThemeArray

#    Returns: 'ns:StoreColorSchemeArrayType'

=cut

sub getGenericColorSchemeArray {
  my $self = shift;
  return $self->_getDataTypeInstance( 'GenericColorSchemeArray'
		,'eBay::API::XML::DataType::StoreColorSchemeArrayType');
}


=head2 setTheme()

A Store theme.

#    Argument: reference to an array  
                      of 'ns:StoreThemeType'

=cut

sub setTheme {
  my $self = shift;
  $self->{'Theme'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getTheme()

  Calls: GetStoreOptions
  Returned: Always

#    Returns: reference to an array  
                      of 'ns:StoreThemeType'

=cut

sub getTheme {
  my $self = shift;
  return $self->_getDataTypeArray('Theme');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
