/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.parser.history.action;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.parser.history.GuideHistory;
import org.maltparser.parser.history.History;
import org.maltparser.parser.history.HistoryException;
import org.maltparser.parser.history.action.SingleDecision;
import org.maltparser.parser.history.container.TableContainer;
import org.maltparser.parser.history.kbest.KBestList;

public class SimpleDecisionAction
implements SingleDecision {
    protected History history;
    protected int decision;
    protected KBestList kBestList;
    protected TableContainer tableContainer;

    public SimpleDecisionAction(History history, TableContainer tableContainer) throws MaltChainedException {
        this.setHistory(history);
        this.setTableContainer(tableContainer);
        this.createKBestList();
        this.clear();
    }

    public void clear() {
        this.decision = -1;
        if (this.kBestList != null) {
            this.kBestList.reset();
        }
    }

    public int numberOfDecisions() {
        return 1;
    }

    public void addDecision(int code) throws MaltChainedException {
        if (code == -1 || !this.tableContainer.containCode(code)) {
            this.decision = -1;
        }
        this.decision = code;
    }

    public void addDecision(String symbol) throws MaltChainedException {
        this.decision = this.tableContainer.getCode(symbol);
    }

    public int getDecisionCode() throws MaltChainedException {
        return this.decision;
    }

    public int getDecisionCode(String symbol) throws MaltChainedException {
        return this.tableContainer.getCode(symbol);
    }

    public String getDecisionSymbol() throws MaltChainedException {
        return this.tableContainer.getSymbol(this.decision);
    }

    public boolean updateFromKBestList() throws MaltChainedException {
        if (this.kBestList == null) {
            return false;
        }
        return this.kBestList.updateActionWithNextKBest();
    }

    public boolean continueWithNextDecision() throws MaltChainedException {
        return this.tableContainer.continueWithNextDecision(this.decision);
    }

    public GuideHistory getGuideHistory() {
        return this.history;
    }

    public History getActionHistory() {
        return this.history;
    }

    protected void setHistory(History history) {
        this.history = history;
    }

    public TableContainer getTableContainer() {
        return this.tableContainer;
    }

    public KBestList getKBestList() throws MaltChainedException {
        return this.kBestList;
    }

    public TableContainer.RelationToNextDecision getRelationToNextDecision() {
        return this.tableContainer.getRelationToNextDecision();
    }

    protected void setTableContainer(TableContainer tableContainer) {
        this.tableContainer = tableContainer;
    }

    private void createKBestList() throws MaltChainedException {
        Class<? extends KBestList> kBestListClass = this.history.getKBestListClass();
        if (kBestListClass == null) {
            return;
        }
        Class[] argTypes = new Class[]{Integer.class, SingleDecision.class};
        Object[] arguments = new Object[]{this.history.getKBestSize(), this};
        try {
            Constructor<? extends KBestList> constructor = kBestListClass.getConstructor(argTypes);
            this.kBestList = constructor.newInstance(arguments);
        }
        catch (NoSuchMethodException e) {
            throw new HistoryException("The kBestlist '" + kBestListClass.getName() + "' cannot be initialized. ", e);
        }
        catch (InstantiationException e) {
            throw new HistoryException("The kBestlist '" + kBestListClass.getName() + "' cannot be initialized. ", e);
        }
        catch (IllegalAccessException e) {
            throw new HistoryException("The kBestlist '" + kBestListClass.getName() + "' cannot be initialized. ", e);
        }
        catch (InvocationTargetException e) {
            throw new HistoryException("The kBestlist '" + kBestListClass.getName() + "' cannot be initialized. ", e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.decision);
        return sb.toString();
    }
}

