package Number::ZipCode::JP::Table::Area;

use strict;
use warnings;

our $VERSION = '0.20170831';

# Table last modified: 2017-08-31
our %ZIP_TABLE = (
    '001' => '(?:0(?:9(?:0[1-9]|2[1-8]|3[0-5]|1[0-25])|0(?:00|[1-3]\d|4[05])))',
    '002' => '(?:(?:80(?:91|6[1-8]|3[0-8]|[02][1-9]|8[129]|1[0-2]|[457][1-5])|08(?:5[1-9]|6[015])))',
    '003' => '(?:0(?:8(?:3\d|1[1-4]|[02][1-9]|[56][1-59]|4[09]|7[1-6])|0(?:30|1[1-3]|0[0-6]|2[1-9])))',
    '004' => '(?:0(?:8(?:21|59|7[1-9]|6[1-7]|4\d|8[0-29]|1[1-5]|0[1-59]|3[1-69])|0(?:3[1-39]|[24][12]|6[1-589]|7[1-6]|[15][1-5]|0[0-7])))',
    '005' => '(?:0(?:8(?:4[0-49]|1[0-8]|2[1-7]|0[1-9]|5[0-6]|3[0-2]|6[1-5])|0(?:3\d|1[1-8]|2[12]|0[0-8]|4[01])))',
    '006' => '(?:0(?:8(?:0[1-7]|[13][1-9]|5[1-39]|6[01]|2[0-39]|4[0-2])|0(?:50|[12][1-69]|3[1-59]|0[0-69]|4[1-39])))',
    '007' => '(?:0(?:8(?:[06][1-9]|9[0-5]|7[0-4]|1[0-59]|[24]\d|3[4-9]|5[0-2]|8[0-6])|0(?:11|3[0-4]|0[1-6])))',
    '010' => '(?:(?:0(?:9(?:[023][1-5]|5[1-6]|[67][1-7]|[14][1-8])|0(?:0[0-6]|6[1-6]|3[1-8]|[14][1-4]|[25][1-9])|8(?:2[1-6]|[46][1-5]|0[2-4]|[35][1-4]|[17][1-7])|1(?:01|3[1-8]|[124][1-6])|4(?:31|[12][1-3]|4[1-5]|0[01]|5[1-6])|6(?:8[1-8]|6[1-5]|7[1-6])|5(?:11|2[1-3]|3[1-5]|0[0-3])|3(?:5[1-5]|4[1-7])|20[12])|1(?:6(?:4[1-5]|2[1-3]|5[1-4]|[013][1-8])|4(?:0[1-8]|[12][1-9]|3[1-7])|2(?:2[1-5]|[03][1-3]|1[12])|3(?:5[12]|4[1-4])|10[1-6]|50[1-6])))',
    '011' => '(?:09(?:51|1[1-7]|[034][1-9]|2[1-8]))',
    '012' => '(?:(?:0(?:8(?:[14][1-5]|[25][1-7]|0[1-4]|6[1-9]|3[1-8])|0(?:0[0-8]|6[12]|[135][1-7]|4[1-5]|2[1-6])|1(?:83|0[4-7]))|1(?:1(?:3[1-7]|[12][1-6]|0[0-6])|24[1-3]|35[1-3])))',
    '013' => '(?:0(?:4(?:[468][1-8]|7[1-7]|[1-35][1-9]|0[24-9])|3(?:[68][1-5]|[013-57][1-9]|2[1-7])|0(?:6[0-689]|[57][1-6]|[2-4][1-8]|0[0-8]|1[1-9])|5(?:1[1-9]|[56][12]|[2-4][1-6]|0[1-3])|2(?:[01][1-8])|8(?:2[1-6]|1[1-4])|10[1-7]))',
    '014' => '(?:(?:0(?:3(?:[34][1-7]|0[0-3]|[5-7][1-9]|1[1-35-8]|2[1-8])|0(?:0[0-6]|7[1-3]|[46][1-8]|[125][1-7]|3[1-4])|1(?:[01][1-4])|20[1-7]|51[1-6]|80[1-5]|71[1-4]|60[12])|1(?:11[1-6]|20[1-5]|41[1-3])))',
    '015' => '(?:0(?:8(?:9[0-2]|0[1-47-9]|[57][1-8]|[12][1-7]|4[0-3]|[368][1-9])|0(?:00|[19][1-4]|[6-8][1-9]|4[1-7]|[235][1-5])|3(?:41|[35][1-3]|[0-26][1-4])|2(?:[12]1|4[1-3]|[03][12])|4(?:0[1-4]|1[1-8])|5(?:1[1-6]|0[1-5])|72[12]))',
    '016' => '(?:0(?:8(?:[37][1-9]|8[1-4]|[159][1-7]|0[1-8]|4[1-6]|[26][1-5])|1(?:2[1-3]|1[1-6]|8[1-8]|0[1-4]|[3467][1-9]|5[1-7])|0(?:1[1-7]|0[0-5])))',
    '017' => '(?:0(?:8(?:0[1-6]|3[1-9]|[149][1-7]|[26-8][1-8]|5[1-57])|0(?:[35][1-7]|0[0-5]|[24][1-6]|1[1245])|20[0-5]))',
    '018' => '(?:(?:0(?:1(?:[458][1-8]|6[1-7]|[0-2][1-9]|[37][1-6])|4(?:0[0-4]|2[12]|1[1-4]|3[1-6])|7(?:11|3[1-4]|2[1-6])|8(?:[45][1-5])|3(?:11|[02][12])|90[1-7]|60[1-4])|1(?:7(?:4[1-7]|1[1-4]|0[0-6]|[23][1-5])|6(?:0[0-6]|3[1-5]|1[1-8]|2[1-9])|5(?:2[1-8]|0[0-4]|1[1-6])|2(?:2[1-6]|1[1-8])|4(?:0[0-3]|1[1-6])|85[1-7]|30[1-5])|2(?:6(?:5[1-6]|[2-47][1-8]|6[1-7]|[01][1-9])|8(?:0[1-6]|1[1-5])|5(?:1[12]|0\d)|40[0-7]|30[1-5]|10[1-4])|3(?:1(?:[12][1-9]|[05][1-7]|4[1-8]|3[1-5])|3(?:0[0-2]|[34][1-3]|2[1-5]|1[1-6])|20[0-5]|50[1-6]|45[1-4])|4(?:2(?:[1-5]1|[067][1-3]|8[12])|4(?:[12][1-3]|0[01]|3[12])|6(?:1[1-3]|[02][1-4])|7(?:4[1-6]|3[1-5])|51[1-6]|30[1-3])|5(?:7(?:01|4[1-5]|5[1-6]|[1-3][12])|(?:14|85|5[01])1|33[1-7]|60[1-6]|20[0-2]|42[12])))',
    '019' => '(?:(?:1(?:8(?:6[1-68]|3[1245]|2[24-7]|5[1-35-8]|1[1-7]|4[1-36-8]|[078][1-8])|9(?:6[1-3]|[02-4][1-9]|[15][1-8])|5(?:3[1-3]|[0-24][12])|6(?:1[1-6]|0[1-5])|10[1-9]|23[1-7]|40[0-4]|30[12]|70[12])|0(?:5(?:3[1-3]|1[1-8]|0[1-35-9]|2[1-9])|7(?:[01][1-5])|4(?:81|0[1-4])|20[1-5]|80[0-3]|11[1-3]|321)|2(?:6(?:01|2[1-5]|3[12]|1[1-4])|4(?:31|[14][1-3]|0[12])|1(?:03|1[12]|2[1-3])|33[1-5]|20[1245]|74[12]|521)))',
    '020' => '(?:0(?:8(?:91|[46][1-6]|[27][1-8]|[0158][1-7]|3[1-9])|6(?:[15][1-9]|2[1-7]|0\d|[36-8][1-8]|4[1-6])|7(?:[067][1-9]|1\d|[235][1-8]|4[1-6])|5(?:1[1-57]|3\d|5[1-9]|7[1-4]|4[1-7]|2[0-57-9]|0[0-7]|8[1-5])|0(?:0[0-5]|3[1-4]|[45][1-5]|[126][1-6])|1(?:[1-3][1-7]|[04][1-8])|20[1-4]|40[1-4]|31[1-3]))',
    '021' => '(?:0(?:8(?:2[12]|[067][1-7]|[459][1-4]|[18][1-5]|3[1-6])|0(?:41|2[1-7]|[16][1-4]|0[0-8]|[35][1-6])|10[12]|90[12]|221))',
    '022' => '(?:0(?:00[0-7]|10[12]|211))',
    '023' => '(?:(?:0(?:0(?:9[1-6]|[2-46-8][1-7]|0[0-3]|1[1-9]|5[1-8])|8(?:3[1-3]|[019][1-8]|4[12]|[5-7][1-7]|[28][1-9])|1(?:32|71|0[1-8])|40[1-3])|1(?:1(?:[02][1-5]|3[1-4]|1[1-8])|(?:34|55)1|76[12])))',
    '024' => '(?:0(?:0(?:[168][1-4]|5[1-8]|0[0-4]|7[1-6]|[2-49][1-5])|3(?:41|2[1-6]|3[1-5])|10[1-5]|211))',
    '025' => '(?:0(?:0(?:0[0-8]|[569][1-8]|[378][1-9]|[124][1-6])|3(?:2[1-4]|[01][1-5])|2(?:44|5[1-3])|13[1-7]))',
    '026' => '(?:0(?:0(?:61|[24][1-6]|[135][1-5]|0[0-4])|30[1-4]|41[12]|121))',
    '027' => '(?:0(?:0(?:5[1-68]|0\d|[47][1-8]|[238][1-9]|[69][1-7])|3(?:2[1-5]|[13][1-3]|[046][1-7]|[57][1-9]|8[1-8])|50[0-8]|42[1-4]|20[1-3]|11[12]|611))',
    '028' => '(?:(?:6(?:9(?:8[1-5]|[1-467][1-9]|[05][1-8])|8(?:[36][1-8]|[147][1-9]|5[1-7]|2[1-6]|8[1-5])|10[0-8]|50[0-7]|30[0-4]|72[1-4]|22[1-3]|41[1-3]|61[12])|7(?:6(?:4[1-5]|[03][1-8]|5[1-7]|6[1-4]|[127][1-9])|5(?:[2356][1-7]|[01][1-6]|4[1-5])|9(?:0[0-6]|1[1-8])|1(?:00|1[1-3])|30[1-6]|40[1-6]|801)|0(?:0(?:[479]1|2[1-4]|8[1-3]|[13][1-5]|0[01]|[56][1-6])|1(?:0[1-7]|4[1-4]|[135][1-6]|2[1-3])|5(?:0[0-3]|3[1-4]|[12][1-7]|[45][1-5])|77[1-6]|30[1-5]|66[1-4]|481)|3(?:1(?:11|[0247][12]|8[1-5]|[356][1-3])|6(?:0[0-8]|[12][1-7])|3(?:1[0-8]|0\d|2[1-6])|4(?:5[1-3]|4[1-8])|53[1-6]|20[1-4])|8(?:3(?:3[1-6]|4[1-5]|[125][1-3]|0[0-3]|6[1-8])|40[0-7]|(?:11|52)1|60[1-5]|80[1-5]|20[0-2]|71[1-3])|5(?:3(?:0[0-6]|1[1-6])|1(?:02|3[1-4])|2(?:33|2[1-4])|6(?:33|4[1-3])|7(?:02|1[1-3])|40[0-3])|1(?:3(?:[1267]1|[34][1-3]|5[12]|0[0-3])|1(?:0[0-5]|2[12]|1[1-7]|3[1-3]))|2(?:5(?:04|1[1-3])|4(?:02|2[12])|10[1-5]|30[1-4]|23[1-3]|63[1-3]|711)|4(?:1(?:3[1-6]|2[1-5])|30[0-7]|42[1-6]|211)))',
    '029' => '(?:(?:4(?:4(?:[67][1-5]|[45][1-6]|[29][1-7]|[13][1-9]|[08][1-8])|3(?:[56][1-5]|1[1-7]|3[1-4]|[28][1-9]|[47][1-8]|0[3-8])|2(?:11|0[1-9])|50[0-5]|10[0-2])|0(?:2(?:11|0[12])|(?:43|71)1|80[1-4]|30[1-3]|52[1-3]|60[1-3]|13[12])|5(?:5(?:1[1-4]|0[0-7]|2[1-3])|6(?:21|1[1-9])|70[1-3])|3(?:40[1-6]|10[1-5]|20[5-7]|52[12]|311)|2(?:20[0-8]|3(?:00|11)|50[12])|1(?:2(?:11|0[12])|111)))',
    '030' => '(?:(?:0(?:9(?:6[1-6]|2[1-5]|[45][1-8]|0[1-4]|1[1-9]|3[1-7])|8(?:5[1-6]|[0-2][1-3]|4[1-7]|6[12])|1(?:3[1-7]|[245][1-5]|1[1-3]))|1(?:7(?:01|2\d|1[1-9]|3[1-7])|2(?:6[12]|0[0-3]|1[1-4]|7[1-3])|5(?:1[1-5]|0[0-5])|4(?:1[1-356]|0[02-5])|3(?:11|0[1-9]))))',
    '031' => '(?:0(?:0(?:[12][1-3]|5[1-8]|0[0-47]|[38][1-9]|[47][1-7])|8(?:1[1-6]|[02-4][1-4])|11[1-5]|20[12]))',
    '033' => '(?:0(?:0(?:3[1-7]|[27][1-4]|1[12]|4[1-5]|0[01]|[56][1-3])|1(?:23|6[1-7]|3[1-4]|[05][1-5]|[14][1-3])))',
    '034' => '(?:0(?:0(?:[467]1|1[1-7]|8[1-9]|2[1-4]|0[0-5]|3[1-8]|5[12]|9[1-5])|10[1-7]|21[1-3]|30[1-3]))',
    '035' => '(?:0(?:0(?:[3489][1-6]|5[1-5]|6[1-8]|[12][12]|0[0-5]|7[1-9])|1(?:1[1-3]|0[34])))',
    '036' => '(?:(?:8(?:0(?:[589][1-7]|1[1-8]|[02-467][1-6])|1(?:[89][1-8]|[0346][1-4]|2[1-7]|[157][1-5])|3(?:0[1-3]|[78][1-5]|[34][1-6]|6[1-8]|2[13-6]|5[1-7]|1[1-9])|2(?:[014][1-7]|3[1-4]|7[1-9]|2[1-8]|5[1-5]|6[1-6]))|0(?:3(?:2[1-6]|4[1-5]|[38][1-9]|5[1-7]|[167][1-8]|0[0-8])|1(?:[156][1-5]|4[1-6]|7[1-3]|0[0-4]|[23][12])|5(?:3[1-9]|2[1-4]|[01][1-7]|4[12])|2(?:[0-4][1-3])|4(?:[01][1-5])|000)|1(?:3(?:61|[24][1-5]|[013][1-4])|4(?:00|2[1-4]|[45][1-3]|[13][1-5])|5(?:[01][1-6])|20[1-6])))',
    '037' => '(?:0(?:0(?:[68][1-9]|[19][1-7]|5[1-8]|[47][1-6]|2[1-5]|3[2-6]|0[0-6])|5(?:4[1-3]|2[1-5]|3[1-8]|1[1-4])|6(?:[034][12]|1[1-4]|2[1-3])|3(?:1[1-8]|0\d)|10[1-9]|20[1-8]|40[1-5]))',
    '038' => '(?:(?:3(?:1(?:2[1-8]|6[1-7]|[35][1-9]|0[0-7]|1[1-5]|4[1-6])|6(?:00|51|3[1-6]|[1248][1-5]|7[1-3]|6[12])|5(?:3[12]|0[0-3]|4[1-3]|[12][1-5])|8(?:21|74|0[0-6]|3[1-7]|1[1-4])|2(?:[78][1-8])|30[1-6])|2(?:7(?:61|[1-3][1-5]|5[1-4]|4[1-7]|0[0-5])|8(?:1[1-8]|0[13-8])|3(?:00|2[1-7])|20[1-8]|50[1-5]|41[1-3])|1(?:3(?:0[1-6]|[24][1-5]|[13][1-3])|1(?:[12][1-3]|4[1-5]|0[0-4]|3[1-4])|2(?:1[1-6]|0[1-7]))|0(?:0(?:2[1-4]|5[1-9]|3[12]|0[0-46]|1[1-5]|4[1-6])|2(?:[2-4][1-3]|0[0-4]|1[12])|10[1-3])))',
    '039' => '(?:(?:2(?:5(?:[3-8][1-9]|2[1-7]|1[1-8]|0[0-8])|6(?:[46-8][1-8]|[125][1-7]|0[0-7]|3[1-6])|8(?:[146][1-6]|[03][1-5]|[57][1-7]|2[1-8])|1(?:02|7[1-3]|6[1-5]|3[1-6]|8\d|[15][1-8]|4[1-7]|2[1-9])|7(?:4[1-8]|7[1-9]|[15][1-7]|[36][1-3]|[28][1-6])|2(?:[23][1-6]|5[1-5]|0[0-6]|1[1-7]|4[1-356])|3(?:7[12]|0[02]|1[1-5])|40[1-7])|3(?:1(?:31|[257][1-9]|[146][1-8]|0\d)|3(?:21|6[1-4]|0[0-3]|8[12]|1[1-5]|[3-57][1-3])|5(?:24|0[1-7])|2(?:00|1[1-5]))|1(?:5(?:[1-356][1-9]|4[1-8]|0[0-8])|1(?:21|0[1-9]|1[1-4]|6\d)|2(?:0[0-8]|1[12])|70[1-3]|80[0-2])|0(?:1(?:2[12]|4[1-4]|1[1-3]|0[0-6]|3[1-5])|8(?:[01][1-5])|6(?:06|1[1-4])|31[1-7]|50[1-7]|20[0-2]|45[1-3])|4(?:1(?:3[1-8]|2[1-4]|[15][1-7]|0[0-6]|4[1-5])|7(?:0[01]|1[12])|22[1-4]|50[0-3]|60[0-2]|40[12]|301)|5(?:3(?:04|[23][1-7]|4[1-6])|20[1-4])))',
    '040' => '(?:00(?:[35][1-7]|8[1-4]|0[0-5]|7[1-8]|[126][1-5]|4[1-6]))',
    '041' => '(?:(?:0(?:8(?:0[1-8]|3[1-7]|2[1-4]|[15][1-3]|4[134])|3(?:0[1-6]|1[1-3])|6(?:1[1-3]|0[1-6])|2(?:6[1-5]|5[1-3])|40[1-8]|52[1-6])|1(?:2(?:[035]1|2[1-6]|1[1-5]|4[1-4])|1(?:0[0-5]|[12][12]|3[1-6])|6(?:[01][1-3]|2[1-4])|40[0-5]|35[1-5])))',
    '042' => '(?:09(?:3[1-5]|[24][1-4]|[015][1-8]))',
    '043' => '(?:(?:0(?:0(?:00|[15][1-7]|[2-46][1-6])|4(?:21|1[5-9]|0[1-5])|1(?:1[1-7]|0[0-4])|5(?:[01][1-5])|33[1-5]|23[1-4])|1(?:1(?:0[0-4]|1[1-8])|3(?:51|6[1-8])|23[1-8]|40[0-6]|52[1-5])))',
    '044' => '(?:0(?:0(?:5[1-7]|[67][1-8]|[13][1-6]|[248][1-5]|0[0-7])|1(?:2[1-5]|0[01]|1[1-3]|3[12])|2(?:0[01]|[12][1-5])|4(?:6[1-3]|[45][1-4])))',
    '045' => '(?:0(?:0(?:0[0-3]|3[12]|2[1-6]|1[1-3])|20[0-5]|30[0-3]|12[1-3]))',
    '046' => '(?:0(?:5(?:[267]1|[13-5][12]|0[01])|0(?:3[1-3]|[12][1-5]|0[0-4])|1(?:21|0[0-4]|[13][1-3])|32[1-8]|20[0-2]))',
    '047' => '(?:0(?:0(?:3[1-9]|1[1-7]|[24][1-8]|0[0-8])|15[1-7]|26[1-6]))',
    '048' => '(?:(?:1(?:5(?:31|6[1-3]|0[0-2]|[45][1-4]|[12][12])|3(?:41|2[1-7]|0[0-7]|1[1-6])|6(?:31|0[0-5]|2[1-4]|1[1-5])|7(?:[34]1|00|2[1-4]|[15][12])|2(?:5[1-4]|6[1-5]))|0(?:1(?:[1-3][1-7]|4[1-5]|0[01])|6(?:2[1-3]|0[0-4]|[13][1-4])|4(?:1[1-5]|0[0-6])|351)|2(?:4(?:1[1-3]|0[0-6])|33[1-5]|14[1-3]|20[0-2]|67[1-3]|56[12])))',
    '049' => '(?:(?:0(?:1(?:[17]1|4[1-3]|0[01]|3[1-6]|5[1-8]|[26][12])|4(?:[34]1|5[1-5]|[12][12]|0[0-8])|6(?:1[1-3]|2[1-7]|0[0-8])|28[1-6]|56[1-4]|74[1-4])|4(?:3(?:[23][1-7]|0[0-8]|1[1-8])|8(?:2[1-8]|1[1-6]|0[1-5])|5(?:1[1-8]|0[01])|15[1-7]|75[1-5]|43[1-4])|1(?:5(?:2[1-4]|1[1-7]|0[0-7])|3(?:[13][12]|0[0-2]|2[1-5])|7(?:71|[68][1-4])|10[0-7]|45[1-6]|64[1-5]|221)|5(?:8(?:1[1-4]|[02][12]|3[1-3])|4(?:0[0-8]|1[1-6])|6(?:0[0-5]|1[1-6])|7(?:31|2[1-4])|33[1-3]|141)|3(?:1(?:[12][1-8]|0[0-7])|5(?:21|0[0-4]|1[1-9])|46[1-5]|34[12])|2(?:3(?:2[1-7]|0[0-8]|1[1-3])|56[1-6]|46[1-5]|67[1-5]|22[1-3]|14[12])))',
    '050' => '(?:00(?:00|[6-8][1-7]|5[1-5]))',
    '051' => '(?:00(?:2[1-8]|[013][1-6]))',
    '052' => '(?:0(?:0(?:[13][1-6]|0[0-8]|2[1-7])|1(?:0[0-7]|1[1-6])|3(?:0[1-3]|1[1-7])))',
    '053' => '(?:0(?:0(?:1[1-8]|[24][1-7]|0[0-7]|3[1-5]|5[1-6])|8(?:[23][1-3]|[45][1-5]|1[1-6]|0[1-7])))',
    '054' => '(?:0(?:0(?:6[1-4]|0[0-5]|[3-5][12]|1[1-6]|2[1-3])|2(?:11|0[1-4])|14[1-4]|36[1-4]))',
    '055' => '(?:(?:0(?:00[0-8]|10[0-7]|32[1-5]|41[1-5])|23(?:1[1-6]|0[1-9])))',
    '056' => '(?:0(?:0(?:1[13-9]|2[1-8]|0[0-7])|14[1-6]))',
    '057' => '(?:0(?:0(?:0[0-7]|3[1-6]|1[1-5]|2[1-7])|17[1-4]))',
    '058' => '(?:0(?:0(?:41|1[1-5]|3[1-3]|2[1-7]|0[0-4])|20[0-7]|34[1-3]|42[12]))',
    '059' => '(?:(?:1(?:3(?:6[1-6]|7[1-5]|0[1-7])|6(?:2[1-5]|1[1-6]|0[0-6])|9(?:[1-35-7]1|4[12]|8[2-7])|7(?:4[1-9]|5[1-4])|2(?:6[1-5]|7[1-6])|5(?:1[1-3]|0[0-6])|43[1-4])|0(?:0(?:3[1-6]|2[1-8]|0[0-5]|1[1-7])|9(?:0[0-8]|1[1-6]|2[1-3])|15[1-7]|46[1-6]|27[1-5]|55[1-3]|64[12])|2(?:4(?:0[0-4]|1[1-8]|2[1-7])|2(?:4[1-5]|5[1-3])|3(?:3[12]|4[1-4])|5(?:71|6[1-6])|12[1-7])|3(?:1(?:0[1-8]|1[12])|4(?:6[1-3]|5[134])|35[1-5]|23[1-3])))',
    '060' => '(?:0(?:0(?:3[1-5]|6[1-3]|2[0-2]|5[1-7]|4[12]|1[0-8]|0\d)|8(?:20|0[6-9]|1\d)|90[5-9]))',
    '061' => '(?:(?:1(?:1(?:[23][1-7]|5[1-4]|4[1-8]|1[1-5]|0[0-6])|4(?:4[1-9]|[12][1-7]|0[0-79]|3[1-5])|3(?:[5-7][1-6])|2(?:81|7\d|6[14-9]))|3(?:2(?:71|2[0-3]|8[1-4]|5[13-9]|[01]\d|6[12]|3[0-2]|4[1-58])|3(?:6[1-35-8]|7[1-8]|3[12])|1(?:51|0[1-9]|1[1-3])|4(?:41|8[0-4])|77[1-9]|60[1-356]|52[1-3])|0(?:2(?:3[1-5]|5[1-4]|[12][1-8]|0[0-8])|5(?:2[1-9]|0[0-8]|1[1-8])|6(?:2[1-3]|1[1-8]|0[0-3]))|2(?:2(?:[6-8][1-6])|30[1-3])))',
    '062' => '(?:0(?:0(?:0\d|2[0-5]|5[1-5]|1[0-2]|3[1-59]|4[1-35])|9(?:3[1-8]|[12][12]|0[1-9])))',
    '063' => '(?:0(?:8(?:[57]0|3[0-7]|[01][1-4]|[246][1-9])|0(?:3[1-9]|2[1-39]|5[1-49]|[16][12]|0[0-79]|4[0-49])))',
    '064' => '(?:0(?:9(?:2\d|1[2-9]|5[1-489]|3[01]|4[1-6])|8(?:1[01]|2[0-6]|0[1-9])))',
    '065' => '(?:00(?:1\d|2[0-8]|3[0-3]|4[1-3]|0[04-9]))',
    '066' => '(?:0(?:0(?:[45][1-7]|[1-36][1-9]|8[1-4]|0\d|7[1-8])|2(?:71|8[1-7])))',
    '067' => '(?:00(?:7[1-5]|6[1-6]|0[0-5]|[12][1-8]|4[12]|3[1-4]|5[1-9]))',
    '068' => '(?:(?:0(?:0(?:61|2[1-9]|3[0-5]|[45][1-8]|0\d|1[0-6])|8(?:5[1-5]|3[0-7]|0[1-9]|4[1-7]|1[0-8]|2\d)|1(?:2[1-7]|1[1-5]|[03][1-6])|4(?:2[1-6]|1[1-4]|0\d)|3(?:5[1-8]|6[1-3])|6(?:[67][1-5])|5(?:3[1-6]|4\d)|75[1-6])|1(?:1(?:61|[14][1-6]|5[1-3]|2[1-7]|3[1-8]|0[0-5])|2(?:31|[01][1-5]))|21(?:81|0[0-8]|[124-6][1-8]|3[1-7])|31(?:6[1-5]|8[0-35-8]|[57][1-9])))',
    '069' => '(?:(?:1(?:3(?:3[1-6]|2[0-29]|1[0-8]|0\d|4[1-7])|4(?:[57][1-9]|6[0-4]|8[0-5])|5(?:0[0-8]|2[1-6]|1[1-3])|1(?:3[1-6]|[48][1-4])|2(?:1[1-9]|0[0-8]))|0(?:8(?:[146][1-7]|[023][1-6]|5[1-5])|2(?:1\d|3[1-9]|0[07-9]|2[01])|3(?:51|[67][1-6]|8[1-4]))))',
    '070' => '(?:(?:0(?:0(?:7[23]|[68][1-3]|[14][0-4]|3\d|0[0-3]|2[1-9]|5[2-9])|8(?:3[12]|7[1-7]|4[1-3]|6[4-7]|1[0-7]|2[1-5])|9(?:7[1-3]|0[12]))|80(?:61|2[1-8]|0[1-7]|[37][1-4]|[14][1-9]|5[1-3])))',
    '071' => '(?:(?:0(?:5(?:83|6[1-6]|5[1-5]|1[0-7]|[47][1-9]|3[0-4]|[02]\d)|7(?:26|42|1[14]|5[1-5]|8[01]|7\d|6[12]|0[04-7]|3[1-7])|2(?:[56]1|[04]\d|[1-3][1-9])|4(?:6[12]|7[1-9])|1(?:7[1-4]|8[4-6])|35[1-35])|1(?:4(?:0[02-9]|7[1-4]|[35][1-9]|6[0-7]|[14][0-2]|2[2-6])|5(?:[12][1-5]|5[0-7]|7[0-57]|3[3-9]|8[12]|[06][0-5]|4\d)|2(?:11|5\d|6[0-7]|4[7-9]|0[0-2]|[23][1-5])|17[1-7])|81(?:71|3[1-8]|5[1-9]|[01][1-4]|6[0-6]|2[1-3]|4[1-5])))',
    '072' => '(?:0(?:8(?:3[1-5]|[02][1-8]|5[1-7]|4[1-4]|1[1-9])|0(?:[14][1-7]|5[1-9]|[23][1-8]|0\d)))',
    '073' => '(?:(?:0(?:1(?:81|0[0-8]|[13467][1-8]|2[1-7]|5[1-9])|0(?:85|2[1-7]|1[1-8]|[34][1-6]|0[0-6])|2(?:2[12]|1[1-3]|0[0-6])|40[0-7])|1(?:10[0-7]|32[1-3])))',
    '074' => '(?:(?:0(?:4(?:0[0-5]|2[1-7]|1[1-5])|0(?:31|0\d|2[1-8]|1[1-6])|14[1-7]|74[1-7])|1(?:1(?:6[1-4]|8[12])|27[1-6])))',
    '075' => '(?:0(?:0(?:[24]1|1[1-9]|3[1-6]|0[0-7])|16[1-7]|25[1-4]))',
    '076' => '(?:0(?:0(?:81|3[1-9]|5\d|[124][1-8]|0[0-8])|1(?:8[1-4]|6[1-5]|7[1-6])|20[1-4]))',
    '077' => '(?:0(?:0(?:0[0-7]|1[1-6]|[2-4][1-8])|2(?:2[1-5]|0\d|1[1-8])|3(?:51|4[145])|46[1-6]|13[1-4]))',
    '078' => '(?:(?:8(?:3(?:6[0-8]|9[12]|[3-5]\d|1[1-9]|0[1-58]|[78][1-3]|2[0-7])|2(?:4[0-6]|5[1-3]|7[1-5]|2[01]|6[12]|0[1-8]|[13][1-9])|8(?:[0-2][1-5]))|1(?:7(?:[356][1-3]|0[01]|7[1-5]|[12][12]|4[1-4])|3(?:24|41|1[3-6]|3[1-57]|0[03-6])|4(?:1[1-5]|0[0-5])|27[1-4]|65[1-4])|3(?:7(?:1[1-7]|0[0-2])|4(?:5[1-7]|4[12])|6(?:21|3[1-8])|3(?:1[1-3]|0\d)|16[1-8]|(?:54|87)1|95[1-5])|2(?:2(?:2[1-5]|0[0-6]|1[1-4])|6(?:00|51|4[12]|3[1-9])|5(?:31|0[0-3]|1[1-6])|1(?:2[1-4]|0\d|1[12]))|4(?:1(?:4[0-5]|0[0-8]|3[0-4]|1\d|2[0-3])|4(?:00|3[1-3]|[12][12]))|0(?:3(?:00|1[01]|3[0-5]|[24][1-9])|1(?:5[1-4]|8[56]))))',
    '079' => '(?:(?:1(?:1(?:81|[124][1-4]|[35][1-6]|0[0-2])|2(?:7[1-4]|8[1-7]|6[1-8])|5(?:8[12]|6[2-6]|7[1-3])|37[12])|0(?:1(?:8[1-3]|6[124-7]|7[1-7])|3(?:1[1-7]|0[0-6])|2(?:6[1-7]|7[1-4])|5(?:1[01]|0\d)|46[1-3])|84(?:31|0[1-3]|2[0-4]|1[1-9]|[45][1-4])|2(?:4(?:0[0-4]|1[12])|20[0-7]|13[1-3]|55[12])))',
    '080' => '(?:(?:0(?:8(?:5[67]|[34][1-8]|[67][12]|2[1-4]|0[1-9]|1[0-7])|3(?:51|4[1-5]|6[1-3]|0[1-9]|2[1-7]|1[1-8]|3[0-5])|1(?:51|1[12]|3[1-9]|[26][1-3]|0[0-6]|4[1-6])|0(?:00|[1-3]\d|[45][0-8])|5(?:[67][1-8])|2(?:7[12]|6[1-3]))|1(?:2(?:[478][1-8]|0[0-4]|[1256][1-7]|3[1-6])|40[0-8]|189)|2(?:1(?:0[1-6]|2[1-4]|1[1-7])|4(?:59|6[0-59]|7[0-6])|33[1-7])))',
    '081' => '(?:0(?:0(?:3[1-9]|1[1-5]|2[1-3]|0[0-35-8])|2(?:[12][1-8]|0[0-5])|1(?:5[1-6]|6[1-4])|34[1-6]))',
    '082' => '(?:0(?:0(?:[013]\d|[46][0-4]|5[1-467]|8[1-7]|7[1-9]|2[0-2])|8(?:[01][1-3])|38[1-5]))',
    '083' => '(?:00(?:9[0-2]|4[1-7]|3[1-4]|2[0-3]|0[0-4]))',
    '084' => '(?:09(?:1[0-8]|[02][1-9]))',
    '085' => '(?:(?:0(?:0(?:6[1-5]|2[1-7]|0[0-8]|[13-5][1-8])|2(?:[13][1-8]|5[12]|2[0-5]|0[1-6]|4[1-5])|8(?:[034][1-7]|[12][1-6])|46[78])|1(?:2(?:6[12]|1[1-3]|0[0-7])|1(?:3[1-4]|4[1-7]))|227[1-3]))',
    '086' => '(?:(?:1(?:1(?:6[03-6]|1[0-2]|2[1-9]|5[0-3679]|0\d|4[1-8]|3[0-79])|0(?:[1-35-7]\d|[04][1-9]|8[0-3])|8(?:[13][1-6]|0[0-6]|2[1-3]|4[1-4])|6(?:0[0-2]|4[1-5]|3\d|5[1-8]|2[1-356])|7(?:5[12]|3[1-3])|27[1-3]|451)|0(?:0(?:81|6[1-5]|7[1-6])|2(?:0[0-5]|1[1-6])|65[1-7]|34[1-6]|52[1-3]|131)))',
    '087' => '(?:0(?:0(?:1[0-24-9]|5[1-5]|0\d|2[1-8]|4[1-9]|3[1-7])|16[1-7]))',
    '088' => '(?:(?:0(?:1(?:81|1[1-8]|0[1-9]|3[1-5]|2[1-6])|3(?:1[12]|0[0-5]|[24][1-4]|[35][1-3])|5(?:7[1-4]|8[1-7]|6[1-8])|6(?:0\d|[12][1-8])|8(?:3[1-5]|7[1-8])|771)|1(?:1(?:51|1[1-9]|0[0-8]|[34]\d|2[04-689])|5(?:[67]1|00|3[124-8]|2[24-8]|[15][1-4])|4(?:12|8[5-7]|0[1-9])|3(?:89|6\d|0[1-46]|7[01])|64[13-9]|78[1-5])|2(?:3(?:8[0-289]|[12][1-4]|3[1-9]|0[0-5])|1(?:5[1-7]|4[0-8])|5(?:7[1-8]|6[1-6])|2(?:7[1-5]|6[1-6])|6(?:0[12]|8[1-6])|46[1-5]|72[1-5])|3(?:2(?:71|2[1-8]|0[0-4]|1[1-5])|1(?:5[1-7]|4[1-9])|3(?:[45]1|3[12])|46[1-5])))',
    '089' => '(?:(?:1(?:3(?:00|3[0-2]|5[1-6]|[24][1-5]|6[1-8]|1[0-3]|7[1-4])|5(?:[23][12]|[14-8][1-3]|0[0-2])|7(?:31|2[14-9]|1[14-7]|0[13579])|2(?:4[1-7]|5[12])|8(?:71|8[12])|18[1-4])|0(?:5(?:6[1-7]|5[1-4]|[37][1-8]|4[1-6])|1(?:0[0-7]|[13][1-8]|2[1-7])|6(?:0[0-5]|2[1-8]|1[1-6])|3(?:5[1-7]|7[1-8]|6[1-3])|78[1-8]|24[1-3])|3(?:7(?:0[0-8]|1[1-8]|[23][1-7])|3(?:[13][1-4]|2[1-7]|0[0-8])|6(?:6[1-6]|7[1-7])|5(?:7[1-8]|8[5-7])|15[1-6]|96[1-6]|87[1-5]|28[1-4]|44[23])|2(?:1(?:5[1-6]|4[0-35-8]|0[0-7]|[12][1-7]|3[1-8])|6(?:1[1-6]|0[0-5]|[23][1-8])|2(?:[67][1-3])|4(?:55|4[5-8])|77[1-6]|56[1-4])|5(?:6(?:2[12]|1[1-57]|3[1-8]|0[0-8])|5(?:[45][1-8])|2(?:3[1-5]|4[1-7])|3(?:1[1-5]|0\d)|46[1-6]|86[5-9])|4(?:3(?:[124][1-6]|[35][1-7]|0[0-8])|2(?:[56][12])|14[1-4])))',
    '090' => '(?:0(?:0(?:70|1[1-9]|6[13-9]|2\d|[04][0-8]|5[1-8]|3[0-7])|8(?:2[1-7]|1[0-8]|[03][1-8])))',
    '091' => '(?:0(?:0(?:3[1-3]|1[16-8]|2[1-9]|0[1-478])|1(?:70|5[13-7]|6[1-3])|55[1-8]|47[1-3]))',
    '092' => '(?:0(?:0(?:1[1-8]|4[1-4]|6[1-9]|[35][0-3]|2[1-7]|0[0-7])|2(?:3[1-6]|0[0135-7]|2[1-5]|1[1-8])|3(?:6[12]|5[1-8])|1(?:8[134]|7[13-6])))',
    '093' => '(?:0(?:0(?:90|[018]\d|2[0-4]|[57][1-9]|6[0-2]|3[1-5]|4[1-6])|5(?:32|0[0-8])|2(?:02|41|1[03-6])|13[1-6]|33[1-6]|73[1-5]|42[1-4]|65[12]))',
    '094' => '(?:00(?:31|1[1-5]|0[0-7]|2[1-7]))',
    '095' => '(?:0(?:0(?:6[1-4]|1[1-9]|4[1-8]|0[0-8]|5[1-6]|[23][1-59])|40[1-6]|18[1-3]|371))',
    '096' => '(?:00(?:[56][1-6]|4[0-3]|[013]\d|2[0-5]|7[1-8]))',
    '097' => '(?:(?:0(?:0(?:[12][1-7]|0[0-7]|3[5-7])|10[01]|40[01]|[23]11)|1(?:20[0-2]|111)))',
    '098' => '(?:(?:5(?:7(?:1[1-47]|[4-6][1-5]|2[1-35]|3[489]|0[0-5])|8(?:1[4-6]|2[1-7]|0[0-8])|2(?:21|1[1-3]|0[1-7])|5(?:00|[56][1-5])|1(?:[01][1-3])|44[1-5]|95[1-5])|3(?:5(?:[24][1-3]|3[1-4]|0[0-4]|1[12])|2(?:2[1-8]|1[1-7]|0[0-7])|3(?:61|1[1-6]|0[0-6])|1(?:51|4[1-4]|3[1-5]))|2(?:2(?:[03][0-8]|1[1-4]|2[0-7]|[45][1-3])|9(?:51|4[1-3])|36[1-8]|80[0-6]|62[1-6]|50[0-2]|181)|1(?:6(?:1[1-6]|0[0-7]|2[1-4])|2(?:0[0-7]|1[1-6])|70[0-8]|50[0-6]|42[1-4]|94[1-4]|33[12]|821)|0(?:1(?:[13][1-5]|2[1-6]|0[0-4])|5(?:0[1-9]|1[1-6])|3(?:00|4[12]|3[1-9])|63[12]|475)|6(?:2(?:00|2[2568]|3[1-4])|5(?:7[1-6]|6[1-5])|3(?:41|8[45])|10[1-6]|75[14-8]|64[2-5])|4(?:1(?:3[1-9]|[01][0-7]|4[01]|2[1-6])|4(?:5[15-7]|6[1-8])|58[12])))',
    '099' => '(?:(?:0(?:4(?:2[1-8]|[01][0-8])|2(?:0[1-7]|1[1-6])|1(?:11|0[12]|2[1-7])|87[1-9]|34[1-7]|70[1-5]|62[1-4])|1(?:4(?:0[0-7]|1[1-8]|[23][1-7])|1(?:1[2-8]|3[1-8]|2[1-4]|0[0-6])|36[1-7]|58[1-7]|25[1-4])|3(?:6(?:1[1-6]|3[1-7]|2[1-8]|0[0-5])|2(?:2[1-5]|4[34]|0[12]|[13][1-4])|11[1-9]|45[1-4]|50[1-4])|2(?:3(?:[78][1-3]|1[0-2]|0[0-6]|5[14-6]|2[1-7]|6[12])|1(?:0[1-7]|1[12])|42[1-4]|231)|4(?:1(?:00|3[1-5]|[24][1-7]|1[1-8])|40[0-7]|35[1-7]|52[1-6])|5(?:6(?:0[0-6]|1[1-4])|3(?:[56][1-5])|5(?:5[1-3]|4[1-4])|17[1-5])|6(?:4(?:0[0-4]|1[1-5])|2(?:[47][12])|32[1-35-9]|50[13-9]|13[1-3])))',
    '100' => '(?:(?:6(?:1(?:90|[1-3]\d|4[0-4]|0[1-9])|5(?:90|0[1-9]|3[0-8]|[12]\d)|3(?:90|0[1-9]|[12]\d|3[0-7])|7(?:90|[1-3]\d|0[1-9]|4[0-3])|8(?:90|[12]\d|0[1-9]|3[0-7])|0(?:90|3[0-6]|0[1-9]|[12]\d)|6(?:90|4[0-2]|0[1-9]|[1-3]\d)|9(?:90|0[1-9]|3[0-4]|[12]\d)|4(?:90|3[0-3]|0[1-9]|[12]\d)|2(?:90|3[01]|0[1-9]|[12]\d))|0(?:0(?:0[0-6]|1[1-4])|(?:[36]0|51)1|10[0-4]|40[0-2]|21[12])|1(?:(?:[37]0|51)1|10[0-3]|21[1-3]|62[1-3]|40[01])|70(?:90|3[0-8]|[12]\d|0[1-9])|2(?:10[01]|211)))',
    '101' => '(?:00(?:03|6[1-5]|[34][1-8]|5[1-4]|2[1-9]))',
    '102' => '(?:00(?:7[1-6]|8[1-5]|9[1-4]))',
    '103' => '(?:(?:00(?:2[1-8]|0[0-8]|1[1-6])|60(?:90|0[1-9]|[12]\d|3[0-5])))',
    '104' => '(?:(?:6(?:0(?:90|4[0-4]|[1-3]\d|0[1-9])|2(?:90|[12]\d|0[1-9]|3[0-3])|1(?:90|0[1-9]|[1-3]\d))|00(?:28|61|3[1-3]|4[1-6]|5[1-5])))',
    '105' => '(?:(?:7(?:0(?:90|4[0-7]|0[1-9]|[1-3]\d)|1(?:90|0[1-9]|4[0-3]|[1-3]\d)|3(?:90|0[1-9]|[12]\d|3[0-7])|2(?:90|[12]\d|3[0-4]|0[1-9])|4(?:90|3[0-2]|0[1-9]|[12]\d))|6(?:0(?:90|3[0-7]|[12]\d|0[1-9])|2(?:90|0[1-9]|[1-3]\d|4[0-2])|3(?:90|0[1-9]|[12]\d|3[0-6])|1(?:[49]0|0[1-9]|[1-3]\d))|00(?:0[0-4]|1[1-4]|2[1-3])))',
    '106' => '(?:(?:6(?:1(?:90|[1-4]\d|5[0-4]|0[1-9])|0(?:90|4[0-5]|[1-3]\d|0[1-9])|2(?:[49]0|[1-3]\d|0[1-9]))|00(?:3[12]|4[1-7])))',
    '107' => '(?:(?:6(?:2(?:90|0[1-9]|4[0-5]|[1-3]\d)|0(?:90|3[0-7]|[12]\d|0[1-9])|3(?:90|0[1-9]|[1-3]\d)|1(?:[39]0|[12]\d|0[1-9]))|00(?:[56][12])))',
    '108' => '(?:(?:6(?:0(?:90|[12]\d|0[1-9]|3[0-2])|1(?:90|0[1-9]|[12]\d|3[01])|2(?:90|3[01]|[12]\d|0[1-9])|3(?:[39]0|[12]\d|0[1-9]))|00(?:14|2[23]|7[1-5])))',
    '110' => '(?:00(?:0[0-8]|1[1-6]))',
    '111' => '(?:00(?:2[1-5]|[35][1-6]|4[1-3]))',
    '112' => '(?:00(?:0[0-6]|1[1-5]))',
    '113' => '(?:00(?:01|[23][1-4]))',
    '114' => '(?:00(?:1[1-6]|0[0-5]|[23][1-4]))',
    '115' => '(?:00(?:5[1-6]|4[1-5]))',
    '116' => '(?:00(?:1[1-4]|0[0-3]))',
    '120' => '(?:00(?:2[1-6]|1[1-5]|0[0-6]|4[1-7]|3[1-8]))',
    '121' => '(?:0(?:0(?:7[1-6]|5[1-7]|6[1-4]|1[12])|8(?:2[2-5]|3[1-7]|0[17]|1[2-6])))',
    '123' => '(?:08(?:[46][1-5]|5[1-7]|7[1-4]))',
    '124' => '(?:00(?:2[1-5]|0[0-6]|1[1-4]))',
    '125' => '(?:00(?:02|[46][1-3]|3[1-5]|5[1-4]))',
    '130' => '(?:00(?:0[0-5]|2[1-6]|1[1-5]))',
    '131' => '(?:00(?:4[1-6]|3[1-4]))',
    '132' => '(?:00(?:[23][1-5]|1[13-5]|0[0-3]))',
    '133' => '(?:00(?:02|5[1-7]|4[1-4]|7[1-3]|6[1-5]))',
    '134' => '(?:00(?:03|9[1-3]|1[35]|8[1-8]))',
    '135' => '(?:(?:00(?:[23][1-4]|4[1-8]|9[12]|1[1-6]|6[1-5]|0[0-7]|5[1-3])|60(?:90|3[0-7]|0[1-9]|[12]\d)))',
    '136' => '(?:00(?:8[1-3]|7[1-6]))',
    '140' => '(?:00(?:0[0-5]|1[1-5]))',
    '141' => '(?:(?:60(?:[39]0|[12]\d|0[1-9])|00(?:01|3[1-3]|2[12])))',
    '142' => '(?:00(?:[56][1-4]|4[1-3]))',
    '143' => '(?:00(?:[02][1-7]|1[1-6]))',
    '144' => '(?:00(?:00|4[1-7]|5[1-6]|3[1-5]))',
    '145' => '(?:00(?:7[1-6]|6[1-7]))',
    '146' => '(?:00(?:[89][1-5]))',
    '150' => '(?:(?:00(?:4[1-7]|2[12]|3[1-6]|1[1-3]|0[0-2])|60(?:90|0[1-9]|[1-3]\d)))',
    '151' => '(?:00(?:[57][1-3]|6[1-6]))',
    '152' => '(?:00(?:0[0-4]|[12][1-3]|3[1-5]))',
    '153' => '(?:00(?:6[1-5]|5[1-3]|4[1-4]))',
    '154' => '(?:00(?:2[1-4]|1[1-7]|0[0-5]))',
    '155' => '(?:003[1-3])',
    '156' => '(?:00(?:4[1-5]|5[1-7]))',
    '157' => '(?:00(?:7[1-7]|6[1-8]))',
    '158' => '(?:00(?:9[1-8]|8[1-7]))',
    '160' => '(?:(?:00(?:1[1-8]|0[0-8]|2[1-3])|61(?:90|[1-3]\d|0[1-9])))',
    '161' => '(?:003[1-5])',
    '162' => '(?:0(?:8(?:5[1-7]|[0-4][1-8])|0(?:5[1-6]|4[1-5]|6[1-7])))',
    '163' => '(?:(?:0(?:4(?:90|[1-4]\d|5[0-5]|0[1-9])|6(?:90|0[1-9]|5[0-4]|[1-4]\d)|2(?:90|5[0-2]|[1-4]\d|0[1-9])|5(?:[59]0|0[1-9]|[1-4]\d)|7(?:90|2[0-6]|1\d|0[1-9])|8(?:[39]0|0[1-9]|[12]\d)|9(?:[39]0|0[1-9]|[12]\d))|1(?:4(?:90|5[0-4]|[1-4]\d|0[1-9])|0(?:90|[1-4]\d|0[1-9]|5[0-2])|3(?:90|0[1-9]|[1-3]\d|4[0-4])|5(?:90|[12]\d|0[1-9]|3[01])|1(?:[39]0|0[1-9]|[12]\d))|60(?:90|3[0-8]|[12]\d|0[1-9])))',
    '164' => '(?:00(?:1[1-4]|0[0-3]))',
    '165' => '(?:00(?:2[1-7]|3[1-5]))',
    '166' => '(?:00(?:1[1-6]|0[0-4]))',
    '167' => '(?:00(?:5[1-4]|3[1-5]|[24][1-3]))',
    '168' => '(?:00(?:8[12]|7[1-4]|6[1-5]))',
    '169' => '(?:00(?:7[1-5]|5[12]))',
    '170' => '(?:(?:60(?:[69]0|0[1-9]|[1-5]\d)|00(?:1[1-4]|0[0-5])))',
    '171' => '(?:00(?:14|[25][12]|4[1-4]|3[1-3]))',
    '173' => '(?:00(?:0[1-5]|1[1-6]|[23][1-7]))',
    '174' => '(?:00(?:00|[457][1-6]|6[1-5]))',
    '175' => '(?:00(?:45|8[1-5]|9[1-4]))',
    '176' => '(?:00(?:0[0-6]|2[1-5]|1[1-4]))',
    '177' => '(?:00(?:[34][1-5]|5[1-4]))',
    '178' => '(?:006[1-6])',
    '179' => '(?:00(?:8[1-5]|7[1-6]))',
    '180' => '(?:00(?:0[0-6]|2[1-3]|1[1-4]))',
    '181' => '(?:00(?:0[0-5]|1[1-6]))',
    '182' => '(?:00(?:1[1-7]|[23][1-6]|0[0-7]))',
    '183' => '(?:00(?:[25][1-7]|[134][1-6]|0[0-6]))',
    '184' => '(?:00(?:1[1-5]|0[0-5]))',
    '185' => '(?:00(?:[12][1-4]|0[0-5]|3[1-6]))',
    '186' => '(?:00(?:0[0-5]|1[1-5]))',
    '187' => '(?:00(?:0[0-4]|1[1-3]|[2-4][1-5]))',
    '188' => '(?:00(?:[01][1-4]))',
    '189' => '(?:00(?:2[1-6]|0[0-3]|1[1-4]))',
    '190' => '(?:(?:0(?:1(?:00|5[1-5]|6[1-6]|[47][1-4]|8[12])|0(?:0[0-4]|3[1-4]|2[1-3]|1[1-5])|2(?:2[1-3]|1[1-4]|0[0-5]))|12(?:[1-3][1-4]|0[0-4])))',
    '191' => '(?:00(?:[23][1-4]|0[0-3]|4[1-3]|1[1-6]|[56][1-5]))',
    '192' => '(?:0(?:0(?:0[0-5]|3[1-4]|[14-6][1-6]|[278][1-5])|3(?:6[1-4]|[57][1-5])|9(?:0[2-467]|1[1-9])|15[1-6]))',
    '193' => '(?:0(?:8(?:[1-4][1-6]|0[1-4])|9(?:3[1-5]|4[1-4])))',
    '194' => '(?:0(?:0(?:3[1-8]|0[0-5]|2[1-3]|4[1-6]|1[1-5])|2(?:1[1-5]|0[1-4])))',
    '195' => '(?:00(?:6[1-4]|5[1-7]|7[1-5]))',
    '196' => '(?:00(?:0[0-4]|[1-3][1-5]))',
    '197' => '(?:0(?:8(?:[03][1-4]|2[1-8]|1[1-6])|0(?:0[0-5]|[12][1-4])))',
    '198' => '(?:0(?:0(?:6[1-4]|8[1-9]|0[0-5]|4[1-46]|[12][1-5]|3[126]|5[1-3])|1(?:7[1-5]|0[1-7])|2(?:2[1-5]|1[1-3])))',
    '201' => '(?:00(?:0[0-5]|1[1-6]))',
    '202' => '(?:00(?:0[0-6]|2[1-3]|1[1-5]))',
    '203' => '(?:00(?:2[1-3]|0[0-4]|[13-5][1-4]))',
    '204' => '(?:00(?:1[1-3]|0[0-4]|2[1-4]))',
    '205' => '(?:00(?:1[1-7]|2[1-4]|0[0-3]))',
    '206' => '(?:0(?:0(?:[12][1-5]|3[1-6]|4[12]|0[0-4])|8(?:1[12]|[02][1-4])))',
    '207' => '(?:00(?:1[1-6]|[23][1-3]|0[0-5]))',
    '208' => '(?:00(?:0[0-4]|3[1-5]|[12][1-3]))',
    '210' => '(?:0(?:8(?:[0-5][1-8]|6[1-9])|0(?:1[1-5]|2[1-6]|0[0-7])))',
    '211' => '(?:00(?:6[1-8]|3[1-7]|5[1-3]|0[0-7]|1[1-6]|[24][1-5]))',
    '212' => '(?:00(?:5[1-8]|2[1-7]|3[1-3]|0[0-7]|1[1-6]))',
    '213' => '(?:00(?:2[1-7]|[13][1-5]|0[0-6]))',
    '214' => '(?:00(?:2[1-3]|0[0-8]|1[1-4]|3[1-9]))',
    '215' => '(?:00(?:2[1-7]|1[1-8]|3[1-6]|0[0-7]))',
    '216' => '(?:00(?:2[1-6]|[13][1-5]|0[0-7]))',
    '220' => '(?:(?:6(?:0(?:90|0[1-9]|[12]\d|3[0-5])|1(?:90|0[1-9]|1\d|2[0-8])|2(?:90|0[1-9]|1\d|2[01]))|00(?:4[1-6]|[35][1-5]|[16][1-3]|0[0-6]|[27][1-4])|81(?:[79]0|[1-6]\d|0[1-9])))',
    '221' => '(?:0(?:0(?:[34][1-6]|[16][1-5]|2[1-4]|[57][1-7]|0[0-5])|8(?:[014][1-4]|[23][1-5]|6[2-6]|5[1-6])))',
    '222' => '(?:00(?:2[1-6]|1[1-3]|3[2-7]|0[0-4]))',
    '223' => '(?:00(?:6[1-6]|5[1-9]))',
    '224' => '(?:00(?:2[13-9]|[35][1-7]|0[01346-8]|[146][1-6]))',
    '225' => '(?:00(?:[12][1-6]|0[1-5]))',
    '226' => '(?:00(?:2[1-9]|1[1-8]|0[0-6]))',
    '227' => '(?:00(?:00|5[1-5]|6[1-7]|[34][1-8]))',
    '230' => '(?:00(?:6[1-3]|5[1-5]|[1347][1-8]|0[0-4]|2[1-7]))',
    '231' => '(?:0(?:8(?:[01][1-6]|6[1-8]|[3-5][1-9]|2[1-7])|0(?:1[1-7]|[2-5][1-8]|6[1-6]|0[0-7])))',
    '232' => '(?:00(?:1[1-8]|0[0-8]|[2356][1-7]|7[1-6]|4[1-5]))',
    '233' => '(?:00(?:0[0-8]|1[1-6]))',
    '234' => '(?:005[1-6])',
    '235' => '(?:00(?:4[1-5]|3[1-6]|0[0-8]|2[1-4]|1[1-9]))',
    '236' => '(?:00(?:[235][1-8]|1[1-7]|0[0-7]|4[1-6]))',
    '237' => '(?:00(?:6[1-8]|7[1-9]))',
    '238' => '(?:0(?:0(?:1[1-9]|4[1-8]|0[0-8]|[235][1-6])|2(?:00|3[1-7]|4[1-6]|2[1-5])|1(?:[01][1-5])|31[1-7]))',
    '239' => '(?:08(?:1[1-5]|[34][1-7]|0[1-8]|2\d))',
    '240' => '(?:0(?:0(?:[16][1-7]|5[1-3]|0[0-7]|[2-4][1-6])|1(?:1[1-6]|0[0-8])))',
    '241' => '(?:0(?:8(?:1[1-7]|[023][1-6])|0(?:3[1-4]|0[0-5]|[12][1-5])))',
    '242' => '(?:00(?:1[1-8]|0[0-8]|2[1-9]))',
    '243' => '(?:0(?:0(?:41|0[0-7]|3[1-9]|[12][1-8])|4(?:1\d|3[1-8]|2[1-7]|0[0-6])|2(?:0[1-8]|1[1-7])|8(?:[01][1-7])|1(?:00|2[1-6]|1[12])|30[0-8]))',
    '244' => '(?:0(?:8(?:0[1-6]|4[1-5]|1[1-7])|00[0-4]))',
    '245' => '(?:00(?:6[1-7]|2[1-4]|0\d|1[1-8]|5[1-3]))',
    '246' => '(?:00(?:1[1-5]|2[1-356]|0[0-8]|3[124-8]))',
    '247' => '(?:00(?:0\d|2[1-8]|[137][1-5]|[56][1-6]))',
    '248' => '(?:00(?:[12][1-7]|0[0-7]|3[1-6]))',
    '249' => '(?:000[0-8])',
    '250' => '(?:0(?:0(?:[45][1-6]|[23][1-5]|1[1-4]|0[0-5])|1(?:[12][1-7]|3[1-6]|0[0-7])|8(?:6[1-6]|[57][1-8])|2(?:[01][1-8])|5(?:00|2[1-3])|40[1-8]|31[1-5]|631))',
    '251' => '(?:0(?:0(?:[23][1-8]|0[0-4]|[145][1-7])|8(?:6[12]|7[1-7])))',
    '252' => '(?:(?:0(?:1(?:24|6[12]|8[1-8]|4[1-46]|3[124-7]|5[1-9]|1[1-7]|0[0-6]|7[1-6])|2(?:4[1-6]|5[134]|0[0-35-8]|[23][1-9]|1[1-7])|3(?:44|3[1-6]|0[0-7]|2[1-9]|1[1-8])|0(?:1[1-6]|2[1-7]|0[0-5])|8(?:[12][1-6]|0[1-7]))|11(?:1[1-6]|0[0-8]|[23][1-7])))',
    '253' => '(?:0(?:0(?:5[1-6]|[46][1-5]|[128][1-8]|0[0-8]|7[1-4]|3[1-7])|1(?:0[0-6]|1[1-4])))',
    '254' => '(?:0(?:0(?:8[1-8]|0[0-5]|[247][1-7]|3[1-6]|[56][1-5]|1[1-689])|8(?:0[1-7]|1[1-5]|2[1-6])|9(?:0[1-6]|1[1-5])))',
    '255' => '(?:000[0-5])',
    '256' => '(?:08(?:0[1-8]|1[1-7]))',
    '257' => '(?:00(?:61|0[0-7]|[35][1-7]|[124][1-8]))',
    '258' => '(?:0(?:0(?:0[0-4]|[12][1-9])|1(?:00|2[1-6]|1[1-5])|20[1-4]))',
    '259' => '(?:(?:1(?:1(?:0[0-7]|4[1-7]|[1-3][1-8])|3(?:[01][1-7]|3[1-5]|2[1-6])|2(?:20|0[1-7]|1[1-9]))|0(?:1(?:4[1-8]|0[0-5]|[13][1-4]|5[1-7]|2[1-5])|3(?:1[1-46-8]|0[0-5])|20[0-2])))',
    '260' => '(?:0(?:8(?:3[1-5]|[12][1-6]|0[1-8]|5[1-7]|4[1-4])|0(?:3[1-4]|[12][1-8]|4[1245]|0[0-7])))',
    '261' => '(?:(?:71(?:90|0[1-9]|3[0-5]|[12]\d)|00(?:2[1-6]|1[1-4]|0[0-5])))',
    '262' => '(?:00(?:1[1-9]|4[1-8]|2[1-6]|3[1-3]|0[0-7]))',
    '263' => '(?:00(?:1[1-6]|[23][1-5]|0[0-5]|[45][1-4]))',
    '264' => '(?:00(?:0[0-7]|[13][1-7]|2[013-9]))',
    '265' => '(?:00(?:[67][1-7]|5[1-3]|4[1-6]))',
    '266' => '(?:00(?:3[1-4]|1[14-6]|2[1-6]|0[0-7]))',
    '267' => '(?:00(?:[56][1-7]))',
    '270' => '(?:(?:1(?:1(?:1[1-9]|4[1-7]|[235-7][1-8]|0[0-8])|4(?:71|0[0-8]|[45][1-7]|3[1-9]|[126][1-6])|5(?:[12][1-7]|[34][1-6]|0[0-6])|3(?:00|1[3568]|3[1-9]|2[1-8]|[4-6]\d)|6(?:0[1-9]|1[1-8]))|0(?:1(?:1[1-8]|6[1-4]|[235][1-7]|0[0-35-8]|[47][1-6])|2(?:0[1-6]|1[1-7]|[23][1-9])|0(?:0[0-7]|3[1-6]|[12][1-8]))|2(?:2(?:6[1-7]|1[1-8]|3[12]|[025][1-5]|4[1-3])|3(?:31|[12][1-9]|0[1-8]))))',
    '271' => '(?:00(?:[468][1-8]|[79][1-7]|5[1-4]))',
    '272' => '(?:0(?:1(?:[02][1-7]|3[1-8]|1[1-5]|4[1-6])|8(?:[23][1-7]|0[1-5]|1[1-6])|0(?:0[0-4]|[13][1-5]|2[1-6])))',
    '273' => '(?:0(?:0(?:3[1-9]|0[0-5]|[124][1-8])|1(?:3[1-7]|1[1-9]|2[1-8]|0[0-7])|8(?:6[1-7]|5[1-5])))',
    '274' => '(?:0(?:8(?:2[1-6]|1[1-8]|0[1-7])|0(?:7[1-7]|6\d|8[12]|5[1-6])))',
    '275' => '(?:00(?:0[0-6]|2[1-8]|1[1-7]))',
    '276' => '(?:00(?:[13][1-7]|4[1-9]|2\d|0[0-8]))',
    '277' => '(?:0(?:0(?:[457][1-5]|6[1-6]|1[1-7]|3[1-4]|0[0-8]|[28][1-8])|8(?:1[1-4]|[23][1-7]|5[1-8]|[048][1-6]|[67][1-3])|9(?:3[12]|2[1-4]|[01][1-3]|4[1-5])))',
    '278' => '(?:00(?:[34][1-8]|2[1-9]|[15][1-7]|0[0-7]))',
    '279' => '(?:00(?:0[0-4]|3[12]|1[1-4]|4[1-3]|2[1-6]))',
    '282' => '(?:00(?:1[0-2]|2[17]|3[1-5]|0[1-79]))',
    '283' => '(?:0(?:0(?:1[1-6]|0[0-6]|5[1-7]|[2-46][1-8])|8(?:[12][1-6]|[03][1-5])|1(?:1[1-7]|0[0-7])))',
    '284' => '(?:00(?:1[1-6]|4[1-5]|0\d|[23][1-7]))',
    '285' => '(?:0(?:0(?:[246][1-6]|[15][1-7]|3[1-9]|7[1-8]|0\d)|8(?:[36][1-7]|1[1-9]|0[1-8]|5\d|2[1-5]|4[1-6])|9(?:1[1-4]|2[1-8]|0[0-7])))',
    '286' => '(?:0(?:0(?:0[0-7]|2[1-9]|3[1-7]|[14][1-8])|8(?:4[1-6]|1[1-9]|[23][1-7]|0[1-8])|1(?:[01][1-8]|[23][1-7])|2(?:1[1-6]|2[1-5]|0[0-5])))',
    '287' => '(?:0(?:0(?:5[1-6]|0[0-6]|[26][1-7]|[134][1-8])|2(?:0[1-6]|2[12457]|4[1-4]|1[1-7]|3[2-7])|8(?:[0-2][1-6])|10[1-7]))',
    '288' => '(?:0(?:0(?:[27][1-7]|[346][1-8]|[15][1-6]|0[0-7])|8(?:[02][1-5]|4[1-6]|[137][1-7]|[56][1-8])))',
    '289' => '(?:(?:1(?:7(?:[34][1-9]|[125][1-7]|0[0-8])|1(?:[12][1-6]|4[1-5]|3[1-8]|0[0-8])|3(?:[34][1-5]|0[0-6]|[12][1-8])|5(?:[0-3][1-7])|6(?:1[1-9]|0[0-8]|2[1-6])|2(?:1[1-8]|[02][1-6])|80[1-6])|2(?:1(?:[467][1-9]|5[1-7]|0[0-8]|3[1-6]|[12][1-5])|5(?:[23][1-5]|1[1-6]|0[0-5])|2(?:00|3[1-6]|[45][1-7])|3(?:1[1-7]|2[1-5]|0[1-6])|6(?:0[1-7]|1[1-6])|7(?:1[1-5]|0[1-8]))|0(?:3(?:1[1-4]|[24][1-9]|[03][1-8])|6(?:1[1-9]|[23][1-7]|0[0-2])|2(?:1[1-7]|0[1-5]|2[1-6])|4(?:2[1-6]|1[1-4]|0[1-8])|1(?:2[1-6]|0\d|1[1-7])|5(?:0[1-7]|1[1-8]))|318[1-6]))',
    '290' => '(?:0(?:0(?:81|[12][1-6]|7[1-5]|3[1-8]|0[0-8]|5\d|6[1-9]|4[1-7])|2(?:3[1-6]|[0256][1-9]|4[1-4]|1[1-7])|5(?:[02-5][1-9]|1[1-8])|1(?:4[1-3]|5[1-7]|6[1-8]|7\d)))',
    '292' => '(?:(?:0(?:0(?:71|1[1-6]|4[1-5]|0\d|3[1-8]|[256][1-7])|4(?:0[1-4]|[3-5][1-5]|1[1-6]|2[1-3])|8(?:[13][1-9]|[02][1-7])|5(?:0[1-3]|1[1-6]|[23][1-7])|2(?:[01][1-7]))|11(?:7[1-9]|[56][1-8]|4\d)))',
    '293' => '(?:00(?:2[1-4]|5[1-8]|[34][1-6]|0[0-6]|1[1-3]))',
    '294' => '(?:0(?:0(?:0\d|[13-5][1-8]|2[1-9])|8(?:1[1-7]|[02][1-6])|3(?:1[1-6]|0[1-8])|2(?:3[1-5]|2[1-6])))',
    '295' => '(?:0(?:0(?:2[1-7]|1[1-4]|0[1-6])|10[1-4]))',
    '296' => '(?:0(?:0(?:0[0-4]|[2-4][1-5]|1[1-6])|1(?:[02][1-6]|1[1-5])|23[1-7]))',
    '297' => '(?:0(?:0(?:4[1-5]|6[1-7]|[1-3][1-9]|[57][1-8]|0\d)|1(?:0[0-5]|3[1-8]|[1245][1-5])|2(?:1[1-8]|3[1-5]|2[1-6]|0[0-7])))',
    '298' => '(?:0(?:2(?:[45][1-6]|0[0-7]|[16][1-7]|7[1-9]|[23][1-8])|1(?:1[1-7]|[02][1-6]|3[1-5])|0(?:1[1-8]|0[0-5]|2[1-9])))',
    '299' => '(?:(?:4(?:3(?:4[1-7]|[23][1-8]|1[1-6]|0[0-6])|1(?:0[1-6]|[12][1-8])|4(?:0[0-6]|[12][1-5])|2(?:1[1-8]|0[0-6])|6(?:2[1-5]|1[1-6])|50[1-8])|2(?:8(?:[46][1-7]|5[1-8])|5(?:2[1-6]|0[1-8]|1[1-7])|7(?:2[1-8]|0[1-5]|1[1-6])|2(?:[0-2][1-6])|4(?:1[1-8]|0[0-4])|1(?:00|1[1-8]))|1(?:1(?:[67][1-6]|5[1-4]|[124][1-7]|3[1-8]|0[0-8])|7(?:[34][1-7]|5[1-9])|6(?:0[1-9]|1[1-8]|2[12])|90[1-9]|861)|5(?:2(?:6[1-7]|1[1-9]|7[1-4]|2[1-8]|3[1-5]|[45][1-6]|0[0-6])|1(?:1[1-4]|0[0-7])|50[1-6])|0(?:2(?:71|2[1-6]|0[0-5]|6[1-8]|[13-5][1-7])|1(?:2[1-8]|1\d|0[1-9]))|32(?:6[1-8]|[14][1-9]|0[0-3]|3[1-7]|2[1-3]|5[1-6])))',
    '300' => '(?:(?:0(?:0(?:[15][1-6]|[46][1-9]|[23][1-8]|0\d)|8(?:50|[34][1-9]|7[1-7]|1\d|2[1-6]|0[1-5])|6(?:3[1-8]|[01][1-7]|4[1-3]|2[1-6])|3(?:41|2[1-6]|1[1-5]|0[0-6]|3[1-7])|7(?:[23][1-7]|4[1-9])|4(?:2[0-8]|[01]\d|3[1-7])|5(?:1[1-5]|2[1-9]|0\d)|1(?:3[1-6]|2[1-7])|2(?:0[1-5]|1[1-4]))|2(?:6(?:2[1-4]|[356][1-9]|1[1-7]|4[1-8])|3(?:4[1-8]|0[0-8]|5[1-9]|[23][1-7]|1[1-5])|4(?:[2-5][1-6]|[01][1-7])|7(?:[0-2][1-7]|4[1-8]|3[1-6])|5(?:0[1-7]|1[1-3]|2[1-6]))|1(?:2(?:[78][1-8]|[46]\d|[13][1-7]|5[1-9]|0[0-7]|2[1-5])|5(?:3[1-9]|0[1-8]|2[1-5]|[14][1-6])|6(?:0[0-6]|[1-3][1-6])|3(?:00|[23][1-7]|1[1-6])|4(?:[12][1-7]|0[1-6])|1(?:61|5[1-9]))|4(?:2(?:51|1[1-8]|4[1-9]|2[1-4]|0[1-5]|3[1-6])|5(?:4[1-6]|2[1-5]|[01][1-7]|3[1-8])|4(?:0[1-8]|1[1-7]|2[1-9])|1(?:[01][1-8])|35[1-4])|3(?:5(?:2[1-7]|[13][1-9]|7[12]|[46][1-5]|5[1-6]|0[0-6])|2(?:[56][1-7]))))',
    '301' => '(?:0(?:8(?:[02][1-6]|3[1-9]|[145][1-7])|0(?:[14][1-8]|0[0-7]|2[1-6]|3[1-5])|90[12]))',
    '302' => '(?:0(?:0(?:3[1-9]|[12][1-7]|0[0-7])|1(?:0\d|3[12]|2[1-8]|1[0-25-9])))',
    '303' => '(?:00(?:1[1-8]|3[1-4]|0[0-6]|[24][1-6]))',
    '304' => '(?:0(?:0(?:[05][0-7]|3[1-5]|7[1-6]|[12][1-8]|[46][1-9])|8(?:0[1-6]|1[1-9]|2[1-4])))',
    '305' => '(?:0(?:0(?:[12][1-9]|[47][1-7]|6[1-8]|0[0-8]|[35][1-6])|8(?:3[1-6]|0[1-5]|[16][1-8]|[28][1-4]|[457][1-7])|90[1-3]))',
    '306' => '(?:0(?:6(?:5[1-8]|0[0-8]|[13][1-7]|2[1-6]|4[1-5])|0(?:[125][1-6]|0[0-7]|4[1-7]|3[1-8])|4(?:0[0-7]|3[1-5]|[12][1-7])|2(?:[0-3][1-6])|1(?:2[1-8]|0[13-9]|1[0-6])|3(?:0[0-7]|1[1-7])|5(?:[01][1-5])))',
    '307' => '(?:00(?:4[1-6]|5[1-5]|2[1-9]|1[1-7]|3[1-8]|0[0-8]))',
    '308' => '(?:0(?:8(?:1[1-6]|[34][1-8]|[0256][1-7])|0(?:[23]1|[167][1-7]|4[12]|5[1-6]|0[0-7])|1(?:1[1-7]|2[1-9]|0[1-8])))',
    '309' => '(?:1(?:2(?:[12][1-7]|3[1-4]|0[0-5]|4[1-6])|6(?:3[1-7]|[12][1-6]|0[0-7])|7(?:[02][1-6]|1[1-7]|3[1-8])|1(?:0[1-8]|[12][1-7])|3(?:[34][1-7])|4(?:6[1-6]|5[1-8])))',
    '310' => '(?:0(?:0(?:0[0-5]|6[1-8]|1[1-5]|[2-5][1-6])|8(?:3[1-6]|0[1-5]|5[1-3]|[24][1-7]|1[1-8])|9(?:0[1-5]|1[1-4])))',
    '311' => '(?:(?:1(?:2(?:2[1-9]|0[1-7]|[1346][1-8]|5[1-5])|5(?:0[0-6]|3[1-7]|[12][1-8])|4(?:[01][1-6]|2[1-7])|1(?:3[1-6]|[12][1-5])|7(?:1[1-6]|0[1-5]|2[1-4])|3(?:0[0-7]|1[1-3]))|3(?:1(?:2[1-5]|[145][1-7]|0[0-8]|3[1-8])|8(?:[12][1-7]|0[0-7]|3[1-6])|4(?:[13][1-7]|[02][1-6])|5(?:[01][1-8]))|4(?:3(?:[23][1-5]|0[0-6]|1[1-7]|4[1-4])|1(?:4[1-6]|[56][1-5])|4(?:11|0[1-7])|20[1-8]|61[1-8]|50[1-3])|2(?:4(?:1[025-9]|[04]\d|3[1-7]|2[1-6])|2(?:1[1-5]|2[1-4]|0[1-7])|1(?:1[1-8]|0[1-5]))|0(?:1(?:1[0-8]|0\d|[23][1-6])|3(?:01|2[1-5]|1[1-4])|50[1-9]|40[1-4])))',
    '312' => '(?:00(?:2[1-7]|[145][1-8]|3[1-6]|0[0-7]|6[1-3]))',
    '313' => '(?:0(?:0(?:4[1-9]|6[1-4]|2[1-7]|3[1-8]|0[0-8]|[15][1-6])|1(?:[02][1-6]|3[1-5]|1[1-7])|2(?:[12][1-5])|35[1-3]))',
    '314' => '(?:0(?:0(?:1[1-7]|5[12]|[24][1-8]|3\d|0[0-7])|1(?:[24][1-8]|0[0-3]|3[1-5]|1[1-6])|25[2-8]|34[1-7]|40[78]))',
    '315' => '(?:0(?:0(?:[01]\d|3[0-8]|[457][1-8]|[26][1-9])|1(?:[02][1-5]|[56][1-7]|[134][1-8])))',
    '316' => '(?:00(?:0[1-7]|1[1-5]|[23][1-6]))',
    '317' => '(?:00(?:00|7[1-7]|[56][1-6]))',
    '318' => '(?:0(?:0(?:2[1-5]|[13][1-4]|0[0-5])|10[1-6]))',
    '319' => '(?:(?:1(?:5(?:00|3[1-8]|4[1-7]|5[1-9])|7(?:1[1-5]|0[1-4]|2[1-7])|2(?:[23][1-5])|1(?:0\d|1[1-9])|30[1-8]|41[1-8])|2(?:2(?:1[1-4]|2[1-7]|0[0-5]|[56][1-6])|1(?:4[1-5]|3[1-6]|0[2-7])|4(?:1[1-8]|0[1-5])|51[1-3]|60[1-3])|0(?:1(?:[12][1-6]|0[0-8]|3[1-7])|3(?:2[1-5]|[01][1-7])|2(?:11|0[1-9]))|3(?:5(?:00|3[1-8]|4[1-4]|[25][1-6]|1[1-5])|1(?:[01][1-7])|36[1-6]|70[1-5])))',
    '320' => '(?:0(?:0(?:[07][1-5]|6[1-6]|[12][1-7]|4[1-9]|[35][1-8])|8(?:[56][1-7]|[0-4][1-8])))',
    '321' => '(?:(?:0(?:9(?:1[1-8]|7[1-7]|5[1-4]|6[1-9]|[2-48][1-5]|0[1-6])|1(?:[24][1-7]|[36][1-9]|[015][1-8])|2(?:0[0-7]|1[1-9]|[23][1-8])|6(?:3[1-6]|1[1-8]|0[0-5]|2[1-9])|5(?:2[1-8]|1[1-7]|[03][1-5])|4(?:[01][1-7])|34[1-7]|000)|4(?:3(?:[45][1-7]|6[1-9]|0\d|3[1-8]|[12][1-6])|5(?:51|2[1-3]|0[1-8]|3[1-9]|[14][1-7])|2(?:00|2[1-7]|1[1-8])|4(?:[01][1-6])|10[1-7])|3(?:5(?:00|[45][1-7]|[36][1-6])|3(?:0[0-7]|1[1-6]|2[1-5])|4(?:1[1-5]|2[1-6]|0[0-6])|2(?:2[1-6]|3[1-7])|62[1-8]|70[1-7])|1(?:4(?:0[1-7]|4[1-9]|1[1-5]|[23][1-6])|5(?:0[1-8]|2[1-4]|1[1-5])|2(?:00|7[1-7]|6[1-6])|1(?:11|0[1-8])|35[1-6]|66[12])|2(?:3(?:4[1-5]|[35][1-6])|4(?:0[1-5]|2[1-7]|1[1-4])|1(?:1[1-8]|0[1-5])|6(?:1[1-6]|0[1-4])|5(?:01|2[1-6])|71[1-8]|80[1-6])))',
    '322' => '(?:0(?:0(?:[2-467][1-9]|0\d|[15][1-8])|5(?:2[1-8]|3[1-6])|3(?:4[1-6]|0[1-7])|25[1-6]|60[1-6]|10[1-3]|42[1-3]))',
    '323' => '(?:(?:0(?:0(?:1[1-7]|[26][1-9]|3[1-4]|0\d|5[1-8]|4[1-6])|1(?:1[1-6]|5[1-8]|0[1-7])|8(?:31|2\d|0[1-8]|1[1-9]))|110[1-8]))',
    '324' => '(?:0(?:0(?:0[0-6]|6[1-6]|[1-35][1-8]|4[1-7])|2(?:[34][1-6]|1[1-5]|2[1-4]|0[1-8])|6(?:0[0-8]|1[1-8])|5(?:[01][1-6])|4(?:[01][1-5])))',
    '325' => '(?:0(?:0(?:0[0-3]|3[1-9]|[126][1-7]|[45][1-8]|7[1-6])|1(?:[01][1-8])|30[1-4]))',
    '326' => '(?:0(?:0(?:1[1-6]|0[0-7]|[23][1-7]|[4-6][1-8])|8(?:[24][1-6]|0[1-8]|[13][1-7])|3(?:[23][1-8])|1(?:0[1-3]|4[1-4])))',
    '327' => '(?:0(?:8(?:[02-4][1-7]|1[1-8])|0(?:2[1-8]|1[1-7]|0[0-7]|4[1-6]|3[1-5])|3(?:1[1-8]|0[1-7]|2[1-5])|5(?:0[1-57-9]|2[3-5]|1[1-7])|10[1-4]|231))',
    '328' => '(?:0(?:0(?:0[0-7]|[47][1-5]|6[1-8]|5[1-4]|[1-3][1-7])|1(?:1[1-4]|0[1-7]|[23][1-5])|2(?:21|0[1-6]|1[12])))',
    '329' => '(?:(?:2(?:7(?:1[1-3]|3[1-5]|5[1-6]|[24][1-8]|0[1-7]|6[1-4])|1(?:00|[35][1-6]|[46][1-5]|2[1-4])|2(?:00|[12][1-6])|8(?:1[1-6]|0[1-7])|5(?:1[1-4]|0[1-6])|33[1-9]|92[1-4]|44[12])|0(?:5(?:30|0[1-7]|[12][1-9])|4(?:1[1-578]|0[0-3]|3[1-4]|2[1-5])|2(?:[01][1-7]|2[1-9])|6(?:1[1-8]|0[0-8])|1(?:0[0-5]|1[1-5])|31[1-9])|1(?:2(?:3[1-5]|2[1-6]|0[0-7]|1[1-7])|3(?:2[1-7]|3[1-4]|0[0-6]|1[1-6])|1(?:0[1-8]|1[1-7])|4(?:1[1-7]|0[1-6])|57[1-9])|3(?:1(?:3[1-6]|[245][1-7])|4(?:[34][1-7])|2(?:00|[12][1-5]))|4(?:4(?:[12][1-5]|0[1-7])|3(?:0[1-9]|1[1-6])|21[1-7])))',
    '330' => '(?:(?:0(?:0(?:00|81|[67][1-5]|[45][1-6])|8(?:[45][1-6]|0[0-5]|3[4-6]))|60(?:90|0[1-9]|[12]\d|3[0-5])))',
    '331' => '(?:0(?:0(?:00|7[1-7]|5[2-9]|4[5-9]|6\d)|8(?:0[0-5]|[12][1-5])))',
    '332' => '(?:00(?:2[1-9]|1[1-7]|0[0-7]|3[1-5]))',
    '333' => '(?:08(?:0[1-8]|[15][1-7]|[46][1-9]|[23][1-6]))',
    '334' => '(?:00(?:[01][1-5]|7[1-6]|6[1-8]|5[1-9]))',
    '335' => '(?:00(?:0[0-5]|[23][1-7]|1[1-6]))',
    '336' => '(?:0(?:9(?:2[1-6]|0[035-7]|[67][1-7]|3[1246]|1[1-8])|0(?:00|2[1-7]|4[1-3]|3[1-68]|1[5-8])))',
    '337' => '(?:00(?:4[1-5]|3[1-6]|[12][1-7]|5[1-4]|0[0-8]))',
    '338' => '(?:0(?:8(?:00|[13][1-7]|2[1-6])|0(?:0[1-7]|1[1-4])))',
    '339' => '(?:00(?:[34][1-7]|6[1-9]|8[12]|[1257][1-8]|0\d))',
    '340' => '(?:0(?:1(?:0[0-5]|6[1-4]|[1-5][1-6])|0(?:1[1-7]|[24][1-8]|[35][1-6]|0[0-7])|8(?:0[0-8]|[12][1-6]|3[1-5])|2(?:1[1-8]|0[1-6])))',
    '341' => '(?:00(?:4[1-6]|[1-3][1-8]|[05]\d))',
    '342' => '(?:00(?:[124][1-7]|5\d|3[1-8]|0[0-8]))',
    '343' => '(?:0(?:8(?:5[1-7]|[0-3][1-8]|4[1-6])|0(?:0[0-8]|[2-4][1-7]|1[1-5])|1(?:0[0-6]|1[1-7])))',
    '344' => '(?:0(?:0(?:[12][1-6]|0[0-7]|5[1-9]|6[1-7]|[34][1-8])|1(?:3[1-6]|[0-2][1-7])))',
    '345' => '(?:0(?:0(?:[12][1-5]|0[0-5]|[34][1-7])|8(?:[12][1-7]|0[1-4]|3[1-6])))',
    '346' => '(?:0(?:0(?:0[0-7]|1[1-6]|3[1-8]|2[1-9])|1(?:0[1-6]|1[1-5])))',
    '347' => '(?:0(?:0(?:4[1-7]|3[1-4]|[01]\d|[256][1-8])|1(?:2[1-6]|1[1-7]|0[1-8])))',
    '348' => '(?:00(?:71|6[1-5]|0[0-6]|1[1-7]|3[1-9]|[245][1-8]))',
    '349' => '(?:(?:1(?:1(?:[23][1-5]|0[1-6]|[45][1-8]|1[1-7])|2(?:21|1[1-6]|0[1-5]))|0(?:1(?:0[0-5]|2[1-8]|3[1-7]|[14][1-5])|2(?:0[0-5]|1[1-9]|2[1-6]))))',
    '350' => '(?:(?:0(?:2(?:[457][1-8]|0\d|[1-36][1-9])|1(?:[14][1-7]|[2356][1-8]|0[0-7])|4(?:[16][1-7]|3[1-9]|0[0-7]|2[1-5]|[45][1-6])|0(?:[34][1-6]|1[1-8]|0[1-4]|[256][1-7])|8(?:[34][1-8]|0[1-9]|[125][1-7])|3(?:0[0-7]|[12][1-4]))|1(?:2(?:4[1-9]|[23][1-7]|5[1-57]|1[1-5]|0[0-6])|1(?:2[1-689]|4[1-7]|[015-7]\d|3[1-8])|3(?:[02][0-8]|1[1-79]|3[1-6]))|22(?:1[1-9]|2[1-7]|0[0-6])))',
    '351' => '(?:0(?:0(?:2[1-5]|[13][1-6]|0[0-7])|1(?:0[0-6]|1[1-6])))',
    '352' => '(?:00(?:[23][1-5]|0[0-6]|1[1-7]))',
    '353' => '(?:000[0-8])',
    '354' => '(?:00(?:0[0-8]|1[1-8]|[2-4][1-6]))',
    '355' => '(?:0(?:0(?:5[1-5]|[367][1-7]|1[1-9]|0[0-8]|[24][1-8])|3(?:0[0-6]|[37][1-7]|5[1-9]|4[1-4]|6[13-6]|[12][1-8])|1(?:[2356][1-7]|1\d|0[0-6])|2(?:2[1-7]|0[0-6]|1[1-6])|8(?:0[0-8]|1[1-5])))',
    '356' => '(?:00(?:4[1-5]|1[1-9]|[25]\d|[03][0-8]))',
    '357' => '(?:0(?:0(?:2[1-5]|[15][1-6]|0[0-6]|[46][1-9]|3[1-8])|2(?:1[1-8]|0[1-6])|1(?:2[1-8]|1[12])))',
    '358' => '(?:00(?:4[1-8]|0[0-8]|[12][1-7]|3[1-6]|5[1-5]))',
    '359' => '(?:(?:11(?:6[1-7]|[124][1-8]|[05][1-6]|3[1-3])|00(?:[24][1-7]|3[1-8]|1[1-6]|0[0-7])))',
    '360' => '(?:0(?:8(?:[02][1-6]|[13-5][1-7])|0(?:0[0-6]|1[1-8]|[2-4][1-7])|2(?:[24][1-5]|0[1-4]|[13][1-8])|1(?:3[1-6]|2[1-5]|6[1-4]|[01][1-7])))',
    '361' => '(?:00(?:[37][1-8]|8[1-4]|[14-6][1-7]|0[0-7]|2[1-6]))',
    '362' => '(?:0(?:0(?:[27][1-6]|4[1-8]|0[0-8]|5[1-9]|[136][1-7])|8(?:1[1-3]|0[0-8])))',
    '363' => '(?:00(?:0\d|2[1-8]|1[1-7]))',
    '364' => '(?:00(?:2[1-8]|1[1-4]|0[0-7]|3[1-5]))',
    '365' => '(?:00(?:0[0-5]|[267][1-8]|4[1-7]|[35][1-9]|1[1-4]))',
    '366' => '(?:0(?:0(?:5[1-4]|2[1-9]|[46][12]|[01]\d|3[1-5])|8(?:0[12]|1\d|[23][1-9])))',
    '367' => '(?:0(?:0(?:0[0-7]|5[1-6]|7[1-5]|3\d|[14][1-8]|6[1-4]|2[1-7])|2(?:[134][1-8]|5[1-4]|0[0-7]|2[1-6])|1(?:1[1-9]|0[0-8])|3(?:01|1[1-3])))',
    '368' => '(?:0(?:0(?:[1245][1-6]|3[1-5]|7[12]|0[0-5]|6[1-7])|1(?:0[0-5]|1[1-5])|20[12]))',
    '369' => '(?:(?:1(?:2(?:[14][1-7]|0[0-5]|2[1-5]|3[1-6])|3(?:1[1-3]|0[0-5])|1(?:11|0[1-9])|8(?:[07][1-4])|6(?:01|2[1-6])|9(?:1[12]|0[1-3])|4(?:00|1[1-3])|50[1-6])|0(?:1(?:1[1-6]|0[1-8]|3[1-7]|2[1-4])|2(?:1[1-7]|2[1-5]|0[1-3])|3(?:0[0-8]|1[1-8]))))',
    '370' => '(?:(?:0(?:0(?:2[1-7]|[56][1-9]|0[0-8]|[1478][1-8]|3[1-6])|8(?:8[1-6]|7[1-5]|6[1-8]|[1-4][1-9]|[05][1-7])|3(?:21|[05][1-6]|4[1-7]|[13][1-4])|5(?:0[0-7]|2[1-5]|3[1-6]|1[1-8])|1(?:[03][1-5]|2[1-8]|1[1-7])|7(?:1[1-8]|0[0-8]|2[1-7])|4(?:1[1-8]|2[1-7]|0[1-6])|6(?:1[1-6]|0[0-6]))|2(?:3(?:[34][1-5]|0[0-7]|1[1-7]|2[1-4])|1(?:3[1-9]|0[1-7]|2[1-8]|1[1-6])|6(?:2[1-7]|0[0-6]|1[1-6])|4(?:5[1-6]|1[1-3]|6[1-7])|2(?:0[0-6]|1[1-7])|8(?:0[0-6]|1[1-6]))|3(?:5(?:0[0-5]|[37][1-4]|1[1-9]|2[1-5])|3(?:11|[34][1-8]|2[12])|1(?:[01][1-7])|60[0-8]|40[1-5])|1(?:1(?:3[1-5]|0[0-5]|2[1-8]|1[1-7])|2(?:0[1-8]|1[1-4])|6(?:1[1-7]|0[0-4])|5(?:1[1-5]|0[1-6])|40[1-6]|301)))',
    '371' => '(?:0(?:0(?:0[0-7]|[14][1-8]|[235][1-7])|8(?:2[1-6]|0[1-5]|[134][1-7]|5[1-8])|2(?:1[1-8]|2[1-4]|[04][1-7]|3[1-5])|1(?:3[1-4]|[01][1-7]|2[1-5])))',
    '372' => '(?:0(?:0(?:3[1-46-9]|0[0-7]|[12][1-6]|[45][1-8])|8(?:1[1-8]|2[1-7]|[034][1-4]|5[1-5])))',
    '373' => '(?:0(?:0(?:0[0-46-8]|3[1-8]|5[1-7]|2[1-9]|6[1-3]|1[1-689]|[47][1-5])|8(?:[35][1-3]|[0-2][1-9]|4[1-7]|6[12])))',
    '374' => '(?:0(?:0(?:0\d|[1-367][1-9]|[45][1-7])|1(?:0[0-7]|[12][1-3]|3[1-5])))',
    '375' => '(?:00(?:0[0-6]|[13-5][1-7]|2[1-4]))',
    '376' => '(?:0(?:0(?:1[1-4]|2[1-7]|3[1-8]|[45][1-6]|0[0-7])|1(?:1[1-6]|[24][1-5]|3[1-7]|0[0-4])|30[1-8]|601))',
    '377' => '(?:(?:0(?:0(?:31|0[02-8]|2[4-7]|[56][1-5])|4(?:00|1[1-7]|3[1-4]|2[1-5])|8(?:0[0-7]|1[1-6])|3(?:0[1-5]|1[12])|20[1-6]|93[1-5]|54[1-4]|10[1-3]|70[0-2]|601)|1(?:5(?:00|12|2[1-8])|4(?:1[12]|0[1-5])|7(?:1[12]|0[0-4])|3(?:1[0-2]|0\d)|61[1-7])))',
    '378' => '(?:0(?:0(?:[1467][1-8]|0[0-5]|[25][1-6]|3[1-5])|3(?:[01][1-7]|2[1-6])|1(?:0[0-5]|2[1-7]|1[1-5])|4(?:1[1-5]|0\d)))',
    '379' => '(?:(?:2(?:1(?:5[1-4]|[14][1-7]|0[1-8]|[36][1-6]|2[1-3])|2(?:[03][1-6]|2[1245]|1[1-7])|3(?:0[1-6]|1[1-4]))|1(?:1(?:2[1-7]|0[1-5]|1[1-6])|3(?:0[0-8]|1[1-5])|4(?:1[1-8]|0[1-49])|6(?:01|1[1-9])|20[0-7]|72[1-8])|0(?:1(?:[13][1-6]|0\d|2[1-9])|2(?:0[1-9]|1[1-7]|2[1-6])|30[1-7])))',
    '380' => '(?:0(?:8(?:[12][1-6]|[358][1-8]|[0467][1-7])|9(?:61|0[1-7]|3[4-6]|5[2-8]|[14][1-8]|2[178])))',
    '381' => '(?:(?:0(?:0(?:[267][1-6]|4[1-5]|8[1-9]|[15][1-7]|3[1-8]|0[0-8])|2(?:0\d|1[12])|40[0-5]|10[1-4])|2(?:2(?:3[1-5]|[0-24][1-7])|4(?:0[1-7]|2[1-4]|1[1-6])|3(?:4[1-7]|5[1-9])|70[1-5])|3(?:16[1-6]|20[1-5]|30[0-4])|12(?:2[1-6]|[13][1-5])|4(?:10[1-4]|30[1-3])))',
    '382' => '(?:0(?:0(?:[1578][1-7]|3[1-467]|[24][1-8]|6[1-6]|9[1247-9]|0[0-6])|8(?:0[0-6]|[23][1-7]|1[13-7])))',
    '383' => '(?:00(?:[46][1-6]|[12][1-5]|0[0-8]|[35][1-7]))',
    '384' => '(?:(?:0(?:0(?:5[1-6]|[68][1-5]|9[1-7]|7[124-8]|[1-4][1-8]|0[0-8])|6(?:00|1[1-4]|2[12])|80[1-9]|30[1-7]|41[1-4]|70[1-4]|50[1-3])|1(?:40[0-8]|30[0-6]|10[0-5]|2[01]1)|2(?:2(?:11|0[1-6])|10[1-7]|30\d)))',
    '385' => '(?:00(?:0[0-79]|4[1-7]|2[1-9]|6[1-3]|3[1-5]|[15][1-6]))',
    '386' => '(?:(?:0(?:0(?:2[2-7]|3[1-4]|1[1-8]|0[0-6]|4[1-3])|4(?:1[1-3]|0[1-8])|50[1-8]|15[1-356]|60[0-3]|32[1-3]|701)|1(?:10[1-8]|60[0-7]|32[1-7]|43[1-7]|54[1-6]|21[1-4])|22(?:11|0[1-4])))',
    '387' => '(?:00(?:2[1-4]|1[1-8]|0[0-7]))',
    '388' => '(?:80(?:20|0[1-8]|1[1-9]))',
    '389' => '(?:(?:0(?:8(?:1[1-3]|2[1-4]|0[1-7])|5(?:0[0-6]|1[1-9])|1(?:21|0[0-4]|1[1-5])|20[0-8]|40[1-7]|60[0-6])|2(?:2(?:00|61|3[1-5]|5[1-8]|4[1-4])|3(?:71|0[0-3]|2[12])|6(?:0[12]|1[1-4])|41[1-8]|10[1-4]|50[0-3]|70[0-3])|1(?:2(?:0[0-6]|1[1-5]|2[1-7])|3(?:0[0-6]|1[1-6])|10[1-7])))',
    '390' => '(?:(?:0(?:8(?:[24][1-8]|5[12]|[01367][1-7])|3(?:0[1-6]|1[1-7])|22[12])|1(?:5(?:20|1[1-6]|0[1-467])|1(?:0[0-4]|3[12])|(?:[34]0|61)1|24[1-3]|70[1-3])))',
    '391' => '(?:0(?:0(?:21|1[1-3]|0[0-5])|1(?:0\d|1[1-6])|21[1-6]|3[02]1))',
    '392' => '(?:0(?:0(?:0\d|2[1-7]|1[0-7])|131))',
    '393' => '(?:00(?:0[0-8]|[67][1-8]|[458][1-7]|1[1-9]|9[1-3]|3[1-5]|2[1-6]))',
    '394' => '(?:00(?:[19]1|3[1-5]|5[1-6]|0[0-5]|4[1-8]|[28][1-9]))',
    '395' => '(?:(?:0(?:0(?:2[1-9]|[37][1-7]|[16][1-8]|0[0-4]|[58][1-6]|4[1-68])|8(?:2[1-6]|0[1-8]|1[1-7])|15[1-7]|30[0-5]|24[1-5]|[4-7]01)|110[0-8]))',
    '396' => '(?:0(?:0(?:1[0-5]|0\d|2[1-9]|3[0-3])|21[1-7]|40[1-7]|30[1-5]|11[1-4]|621))',
    '397' => '(?:0(?:00[0-3]|30[12]|[12]01))',
    '398' => '(?:000[0-4])',
    '399' => '(?:(?:0(?:7(?:0[0-6]|[14][1-6]|[23][1-8])|0(?:71|3[3-9]|2[1-7]|1[1245]|0[0-24-7])|4(?:00|2[1-8])|2(?:00|1[1-4])|10[12]|51[12]|6[05]1)|7(?:4(?:1[1-8]|0[1-5])|7(?:11|0[0-2])|3(?:11|0[12])|10[1-5]|50[0-4]|20[0-2]|601)|4(?:1(?:1[1-7]|0[0-8])|(?:3[02]|5[01])1|60[0-5]|23[12]|43[12])|3(?:3(?:11|0[0-4])|10[0-7]|70[0-5]|80[0-4]|20[0-2]|50[0-2])|1(?:2(?:21|0[0-3])|6(?:01|1[12])|50[0-5]|31[1-3]|40[13]|801)|2(?:6(?:0[1-7]|1[12])|56[1-6]|43[1-4]|10[0-2]|22[1-3])|8(?:2(?:51|0[0-5]|1[12])|60[0-5]|30[1-5]|10[1-3]|501)|9(?:(?:[16]0|[25]1)1|4(?:00|2[12])|30[01])|6(?:20[0-3]|30[1-3]|46[12]|101)|5(?:50[0-4]|30[0-3]|60\d)))',
    '400' => '(?:(?:0(?:0(?:[46][1-9]|1[1-7]|[25][1-8]|0[0-8]|[37][1-5]|8[1-3])|8(?:[14][1-5]|3[1-6]|6[1-7]|[025][1-8])|2(?:3[1-4]|4[12]|[02][1-6]|1[1-5])|1(?:0[0-8]|[12][1-8])|3(?:3[1-7]|1[1-9]|0[1-68])|4(?:2[1-6]|1[1-7]|0[0-5])|5(?:0[0-6]|1[1-5])|60[1-8])|1(?:1(?:31|[12][1-7])|5(?:1[1-5]|0[1-8])|21[1-9])))',
    '401' => '(?:0(?:0(?:1[1-6]|2[1-5]|0[0-6])|3(?:[12]0|0[0-5]|3[1-8])|5(?:0[0-2]|1[12])|201))',
    '402' => '(?:0(?:0(?:[1-3][1-5]|[45][1-6]|0[0-6])|2(?:1[1-9]|0\d|2[1-8])))',
    '403' => '(?:00(?:2[1-3]|1[1-8]|0\d))',
    '404' => '(?:0(?:0(?:[34][1-7]|[125][1-6]|0[0-7])|2(?:11|0[1-6])))',
    '405' => '(?:00(?:[14][1-8]|[5-7][1-9]|0[0-7]|3[1-6]|2[1-5]))',
    '406' => '(?:0(?:8(?:[01][1-8]|4[1-6]|[235][1-5])|0(?:0[0-5]|2[1-8]|1[1-5]|[34][1-6])))',
    '407' => '(?:0(?:0(?:5[1-578]|3[1-7]|0[0-7]|[12][1-5]|4[1-6])|3(?:11|[02][12])|17[1-6]|26[1-3]))',
    '408' => '(?:0(?:0(?:2[1-6]|0[0-4]|3[1-7]|1[1-9]|4[1-4])|3(?:0[1-7]|1[1-9])|1(?:0[1-5]|1[1-7])|20[1-7]))',
    '409' => '(?:(?:3(?:8(?:6[1-7]|5[1-4]|0[0-4]|[134][1-5]|2[1-3])|1(?:2[1-6]|0[1-7]|1[1-8])|6(?:0[0-7]|2[1-6]|1[12])|4(?:3[1-7]|2[1-4])|3(?:0[1-7]|1[1-3])|2(?:3[1-4]|4[1-5])|7(?:1[12]|0[1-4]))|2(?:7(?:1[1-5]|0[0-5]|3[1-4]|2[1-7])|5(?:00|2[1-4]|3[1-9])|9(?:3[1-8]|4[1-7])|4(?:1[1-5]|0[1-6])|21[1-7]|30[1-5]|10[0-3])|0(?:1(?:00|3[1-8]|4[12]|1[1-5]|2[1-6])|3(?:0[0-6]|1[1-8])|6(?:2[1-7]|1[1-8])|2(?:00|11)|50[1-6])|1(?:3(?:21|[01][1-6])|2(?:1[1-3]|0[1-5])|50[12])))',
    '410' => '(?:(?:0(?:8(?:[37][1-6]|[59][1-5]|[14][1-9]|2[1-4]|[06][1-7]|8[1-8])|0(?:[13][1-8]|2[12]|[45][1-9]|0[0-7]|6[1-5])|3(?:21|[01][1-9])|2(?:[23][1-5]|4[1-4])|10[1-6])|2(?:1(?:[03][1-3]|[124][1-4])|3(?:0[1-4]|1[1-8]|2[1-5])|5(?:[01][1-9])|2(?:2[13]|0[0-5]|1[1-4])|4(?:1[1-8]|0[0-7]))|3(?:6(?:2[1-7]|1[1-8]|0[0-7])|2(?:0[1-9]|1[1-7])|5(?:1[1-5]|0[0-2])|30[1-4]|40[12])|1(?:3(?:0[0-8]|[12][1-7])|1(?:0\d|[12][1-8])|43[12]|231)))',
    '411' => '(?:0(?:8(?:[03-5][1-8]|1[1-7]|2[1-4])|9(?:51|3[1-6]|4[1-5]|0[1-7]|1[1-8])|0(?:0[01]|1[1-9]|4[1-7]|[23]\d)))',
    '412' => '(?:00(?:51|[1-3][1-9]|0\d|4[1-8]))',
    '413' => '(?:0(?:0(?:4[12]|[1-3][1-9]|0[0-6])|7(?:0[1-5]|1[1-6])|5(?:0\d|1[1-6])|1(?:11|0[1-3])|23[1-5]|30[0-4]|411))',
    '414' => '(?:00(?:0[0-6]|4[1-6]|5[1-5]|[1-3][1-8]))',
    '415' => '(?:0(?:0(?:1[1-8]|[23][1-9]|0[01])|3(?:2[1-7]|1[1-4]|0[0-6])|15[1-6]|53[1-3]))',
    '416' => '(?:09(?:[0134][1-9]|2[1-4]|5[1-5]))',
    '417' => '(?:0(?:0(?:0[0-4]|5[1-8]|4[1-9]|3[1-7]|7[1-3]|2[1-6]|[16][1-5])|8(?:0[1-9]|6[1-4]|1[1-7]|4[1-8]|2[1-6]|[35][1-5])))',
    '418' => '(?:0(?:0(?:2[1-6]|0[0-7]|[13][1-9]|[4-7][1-8])|1(?:0[1-9]|1[1-7])))',
    '419' => '(?:0(?:1(?:1[1-6]|2[1-5]|0[0-7])|3(?:0[1-5]|1[1-7])|20[1-5]))',
    '420' => '(?:0(?:8(?:2[1-5]|[78][1-6]|1[0-356]|4[1-7]|[356][1-9]|0[13-5])|0(?:[023][1-9]|5[1-4]|[1467][1-8])|9(?:4[1-9]|[35][1-7]|6[1-8]|[01][1-6]|2[1-5])))',
    '421' => '(?:(?:0(?:1(?:[13][1-7]|[02][1-6])|5(?:3[1-5]|[12][1-7]|0\d)|4(?:2[12]|0[1-9]|1[1-5])|2(?:1[1-8]|0[1-6])|30[0-5])|1(?:1(?:3[12]|2[1-4]|0[1-3]|1[1-5])|2(?:2[1-6]|1[1-7]|0[12])|3(?:0[1-9]|1[1-6])|40[1-9])|2(?:1(?:1[1-8]|0[1-9]|2[1-5])|2(?:[12][1-7]|0[1-3])|30[1-9])|3(?:1(?:0[1-7]|1[1245])|2(?:0[1-3]|1[1-5])|30[1-6])))',
    '422' => '(?:(?:80(?:[2-46][1-7]|0[1-9]|[157][1-8])|0000))',
    '424' => '(?:0(?:8(?:6[1-6]|[58][1-8]|[0-37][1-9]|4[1-7])|0(?:[1346][1-8]|[02][1-9]|5[1-7])|9(?:[01][1-7]|[2-4][1-9])|1(?:0[1-7]|1[1-4])|4(?:0[1-6]|1[1-5])|2(?:1[12]|0[1-6])|30[1-6]))',
    '425' => '(?:00(?:0[0-7]|[34][1-6]|9[12]|[258][1-8]|[17][1-7]|6[1-9]))',
    '426' => '(?:0(?:0(?:[38][1-8]|[07]\d|[4-6][1-7]|[12][1-9])|2(?:2[1-4]|0[1-5]|1[1-3])|13[1-4]))',
    '427' => '(?:0(?:0(?:61|0\d|4[1-8]|[1-35][1-9])|1(?:0[1-8]|1[1-3])|23[1-3]))',
    '428' => '(?:0(?:0(?:[013][1-9]|2[3-8]|4[1-46-9])|3(?:1[1-5]|0[0-6])|4(?:0[12]|1[1-8])|10[1-6]|50[1-5]|21[12]))',
    '430' => '(?:(?:0(?:8(?:[03][1-8]|[125][1-7]|4[1-6])|9(?:1[1-35-9]|2[3-9]|0[1-7]|[34][1-9]))|77(?:90|0[1-9]|4[0-5]|[1-3]\d)))',
    '431' => '(?:(?:3(?:1(?:2[1-6]|1[1-5]|0[1-8])|3(?:0[1-6]|1[1-5])|7(?:6[1-4]|5[1-6])|42[1-8]|90[1-8]|53[1-6]|80[1-4]|64[1-3])|0(?:4(?:2[1-9]|4[1-4]|[135][12]|0[0-5])|2(?:0[1-3]|1[1-4])|30[1-4]|10[1-3])|1(?:4(?:[01][1-7]|2[1-5])|1(?:1[1-5]|0[1-4])|20[1-9]|30[1-5])|2(?:2(?:0[1-7]|[12][1-6])|53[1-7]|10[1-4])|41(?:21|0[1-3]|1[12])))',
    '432' => '(?:(?:80(?:71|[13-5][1-8]|6[1-9]|[02][1-7])|0000))',
    '433' => '(?:81(?:0[1-589]|2[1-7]|1[1-46-9]))',
    '434' => '(?:00(?:3[1-8]|2[1-9]|1[1-7]|0[0-7]|4[1-6]))',
    '435' => '(?:00(?:5[1-7]|2[1-9]|[0134][1-8]))',
    '436' => '(?:0(?:0(?:[1568][1-9]|9[0-4]|[02-47]\d)|1(?:0[1-6]|1[1-7])|3(?:3[1-8]|4[1-3])|22[1-7]))',
    '437' => '(?:(?:1(?:4(?:3[1-9]|0[1-7]|1[1-6]|2[1-5])|1(?:1[1-9]|2[1-6]|0[1-5])|5(?:0[1-7]|[12][1-4])|6(?:1[1-5]|2[1-3]|0[0-5])|2(?:1[1-8]|0[1-9])|3(?:1[12]|0[1-6]))|0(?:0(?:[23][1-9]|[156][1-7]|0[0-6]|4[0-7])|2(?:[12][1-7]|0[0-8])|6(?:[01][1-8]|2[1-6])|12[1-7])))',
    '438' => '(?:0(?:0(?:8[1-68]|4[1-7]|[136][1-9]|0[0-8]|[25][1-8]|7[1-578])|8(?:2[1-5]|[013][1-8])|2(?:3[1-6]|0[1-7]|2[1-4]|1[1-8])|1(?:1[1-6]|0[1-8]|2[1-7])))',
    '439' => '(?:00(?:0\d|3[1-7]|1[1-9]|2[1-6]))',
    '440' => '(?:0(?:0(?:[2-57][1-8]|6[1-9]|[018][1-6]|9[1-5])|8(?:[38][1-8]|[279][1-7]|5[13-8]|[01][1-6]|[46][1-5])))',
    '441' => '(?:(?:1(?:3(?:2[1-9]|[1346-8][1-8]|5[1-5]|0[0-7])|6(?:93|1[1-6]|0[1-5]|2[1-4]|3[1-46])|2(?:31|0[1-6]|2[1-3]|1[12])|4(?:[0-2][1-4])|9(?:[45][1-6])|1(?:1[1-5]|0[1-6])|53[1-6])|8(?:0(?:[1-3568][1-9]|9[0-3]|7[1-7]|[04][1-8])|1(?:[23][1-5]|[04][1-9]|[15][1-7]))|3(?:1(?:[15][1-5]|[02][1-6]|4[1-7]|3[1-4])|4(?:2[1-7]|1[1-9]|0\d|3[1-6])|6(?:2[1-7]|[01][1-9])|2(?:0[1-3]|1[1-4])|50[1-5]|30[12])|0(?:3(?:2[1-3]|1[1-6]|0[1-4])|1(?:[05][1-6])|2(?:0[1-4]|1[1-5])|000)|2(?:5(?:31|2[1-6]|1[1-7])|3(?:0[0-3]|1[1-7])|22[1-4]|43[1-4]|601)))',
    '442' => '(?:0(?:8(?:6[1-3]|[01378][1-9]|5[1-7]|[24][1-8])|0(?:5[1-5]|0[0-8]|[1-46][1-9])))',
    '443' => '(?:0(?:0(?:2[12]|[34][1-8]|0[0-8]|5[1-9]|1[1-4])|10[1-6]))',
    '444' => '(?:(?:0(?:0(?:0\d|[3-7][1-9]|1[1-6]|2[1-5])|8(?:[35][1-9]|[01][1-7]|[467]\d|2[1-8])|9(?:1[1-8]|2[1-4]|[034][1-9]|5[01])|2(?:[0-2][1-6]|4[1-7]|3[1-4])|3(?:2[1-8]|[13][1-6]|0[1-5])|5(?:0[1-4]|[13][1-7]|2[1-6])|4(?:1[1-6]|2[1-9]|0[1-7])|1(?:1[13-7]|2[1-8]|0[0-4])|70[1-4])|2(?:8(?:[03][1-9]|[124][1-7])|1(?:1[1-8]|3[1-7]|[04][1-9]|2[1-3])|3(?:0[1-3]|5[1-5]|2[14-7]|4[2-4]|3[1-7]|1[1-4])|5(?:2[1-8]|3[1-3]|1[0-7]|0[1-6])|4(?:51|1[1-9]|0[1-79]|2[34])|2(?:0[1-7]|1[1-8]|2[1-6])|60[1-8])|3(?:2(?:31|42|5[12]|1[1-36]|0[1-35-8]|2[1-3]|6[1245])|5(?:0[1-8]|2[1-7]|1[1-6])|6(?:1[1-7]|2[1-6]|0[1-5])|1(?:51|7[1-5]|6[1-8])|4(?:3[1-7]|4[1-9])|3(?:3[1-5]|4[1-4]))|1(?:3(?:2[1-5]|3[1-6]|0[0-5]|1[1-4])|2(?:[12][1-5]|0[1-6])|1(?:5[1-5]|6[1-6]))))',
    '445' => '(?:0(?:8(?:9[1-4]|[02-58][1-7]|7\d|[16][1-6])|0(?:[36][1-5]|0[0-6]|[12457][1-7]|8[1-4])))',
    '446' => '(?:00(?:0[0-8]|[135][1-9]|2[1-7]|[467][1-6]))',
    '447' => '(?:0(?:8(?:[024-8][1-9]|[13][1-8])|0(?:[27][1-9]|1[1-7]|[3-68][1-8]|0[0-8])))',
    '448' => '(?:0(?:8(?:2[1-5]|1[0-6]|0[1-9]|6[12]|[3-5][1-8])|0(?:[2-4][1-9]|0[0-8]|1[1-5])))',
    '449' => '(?:0(?:2(?:0[0-6]|1[1-6])|40[0-5]))',
    '450' => '(?:(?:6(?:2(?:90|0[1-9]|[1-3]\d|4[0-7])|6(?:90|4[0-6]|[1-3]\d|0[1-9])|0(?:90|[1-4]\d|0[1-9]|5[01])|4(?:90|3[0-4]|[12]\d|0[1-9])|3(?:[49]0|0[1-9]|[1-3]\d))|000[1-7]))',
    '451' => '(?:(?:00(?:00|[35][1-5]|[146][1-6]|[27][1-7]|8[1-4])|60(?:[49]0|[1-3]\d|0[1-9])))',
    '452' => '(?:0(?:0(?:5[1-5]|2[1-6]|[34][1-7]|1[0-8]|6[1-8]|0\d)|8(?:2[1-4]|[03][1-9]|[14][1-8])|9(?:0[1-8]|4[1-7]|1[1-9]|6[1-3]|3[1-5])))',
    '453' => '(?:(?:0(?:8(?:7[1-3]|2[1-8]|6[1-7]|[013-5][1-9])|0(?:[135][1-8]|4[1-7]|[26][1-9]|0[02]))|61(?:90|0[1-9]|[12]\d|3[0-6])))',
    '454' => '(?:0(?:9(?:[78][1-6]|[0-469][1-7]|5[1-9])|8(?:0[1-8]|6\d|7[1-7]|[1-5][1-9])|0(?:3[1-7]|[45][1-9]|2[1-8]|1[1-6]|0[0-7])))',
    '455' => '(?:0(?:8(?:[1-3][1-5]|0[1-6]|8[1-7]|[67][1-9]|[45][1-8])|0(?:0[0-8]|[127][1-8]|[3-5][1-7]|6[1-9])))',
    '456' => '(?:00(?:[147][1-8]|[23][1-7]|[56][1-9]|0[0-6]))',
    '457' => '(?:0(?:0(?:[257][1-8]|0[0-8]|[346][1-9]|1[1-6])|8(?:[56][1-6]|[02][1-8]|[34][1-7]|1[1-9])))',
    '458' => '(?:0(?:0(?:4[1-7]|3[1-9]|0\d|2[1-5]|1[1-6])|8(?:3[0-7]|[04][1-9]|[12]\d)|9(?:0[1-3]|2[0-24-9]|1[0-35-9])))',
    '459' => '(?:80(?:0[1-9]|1[1-6]))',
    '460' => '(?:00(?:0[0-8]|1[1-8]|3[12]|2[1-6]))',
    '461' => '(?:00(?:3[1-8]|0\d|2[1-7]|1[1-9]|4[03-9]))',
    '462' => '(?:0(?:8(?:0[1-57-9]|1[0-4689]|2[3-9]|4[1-7]|[56][1-9]|3[1-8])|0(?:[26][1-6]|[13][1-8]|0\d|4[1-7]|5[1-9])))',
    '463' => '(?:0(?:0(?:1[0-7]|[078]\d|9[0-8]|[34][1-8]|5[1-7]|[26][1-9])|8(?:0[1-9]|1[1-5])))',
    '464' => '(?:0(?:0(?:4[1-6]|0[0-8]|[1-3][1-9]|[5-9][1-7])|8(?:71|[04][1-8]|5\d|1[1-9]|[23][1-7])))',
    '465' => '(?:00(?:[39][1-7]|6[1-9]|[124578][1-8]|0[02-9]))',
    '466' => '(?:0(?:0(?:5[1-9]|[2-4][1-7]|0[0-6]|1[1-6]|6[1-5])|8(?:1[1245]|0[1-7]|[24][1-9]|[35][1-8])))',
    '467' => '(?:0(?:8(?:[15][1-6]|[026][1-8]|7[1-9]|[34][1-7])|0(?:0[0-8]|[26][1-8]|1[1-7]|[3-5][1-9])))',
    '468' => '(?:0(?:0(?:3[0-57-9]|1[1-5]|5[1-68]|[02]\d|[46][1-9]|7[1-7])|836))',
    '470' => '(?:(?:0(?:3(?:4[1-8]|[0-2][1-9]|6[1-4]|3[1-5]|[57][1-6])|5(?:[3-7][1-5]|[0-2][1-6])|1(?:[12][1-8]|0[0-5]|[356][1-6])|4(?:[1347]1|5[1-3]|[026][1-4])|2(?:0\d|[12][1-7]|3[1-3]))|2(?:3(?:[1-57][1-9]|8[02-9]|0\d|6[1-6])|5(?:21|0[1-8]|3[12]|[14][1-7]|5[1-6])|2(?:1[1-7]|0[0-7])|4(?:1[1-4]|0[1-9])|10[0-5])|1(?:1(?:3[1-3]|1[1-6]|[46][1-8]|0\d|5[1-4]|2[1-7])|2(?:1[1-9]|0[1-7]))|3(?:2(?:00|3[1-6])|3(?:00|2[12])|50[1-5]|41[12])))',
    '471' => '(?:0(?:8(?:[01467][1-9]|[235][1-8])|0(?:[124-7][1-9]|0\d|3[1-8])))',
    '472' => '(?:00(?:[35][1-8]|[124][1-7]|0[0-7]))',
    '473' => '(?:09(?:3[1-9]|[0-2][1-8]))',
    '474' => '(?:00(?:11|6[12]|4[1-8]|3[15-8]|0[0-3]|7[1-4]|2[1-7]|5[1-35-7]))',
    '475' => '(?:0(?:8(?:8[1-7]|[56][1-9]|[02-47][1-8]|1[3-79])|0(?:[1-3][1-9]|[4-8][1-8]|0\d)|9(?:0[1-6]|[235][1-9]|[467][1-8]|1[124-8])))',
    '476' => '(?:00(?:0[0-6]|1[1-5]))',
    '477' => '(?:003[1-7])',
    '478' => '(?:00(?:5[1-9]|[34][1-7]|[12][1-8]|6\d|0[0-6]))',
    '479' => '(?:0(?:8(?:[4-6][1-8]|8[12]|[0-3][1-9]|7[13])|0(?:7[1-79]|0\d|[1-46][1-9]|5[3-9])))',
    '480' => '(?:(?:1(?:1(?:0[02-8]|[4-7][1-8]|[12][1-9]|8[1-4]|3[2-9])|3(?:[023][1-9]|4[1-7]|1[1-8])|2(?:0[1-7]|1[1-9]))|0(?:1(?:51|0[0-7]|[34][1-9]|2[1-7])|30[1-6]|20[0-2])))',
    '481' => '(?:00(?:1[1-4]|3[1-9]|[04][0-6]))',
    '482' => '(?:00(?:0[0-7]|[2-4][1-6]|1[1-8]))',
    '483' => '(?:(?:8(?:3(?:[13-8][1-9]|[02][1-8])|1(?:7[1-7]|[045][1-9]|[1-368][1-8])|0(?:[013-58][1-8]|7[124-7]|[26][1-9])|2(?:[3-57][1-9]|6[2-9]|1[1-7]|[02][1-8])|4(?:3[1-3]|[0-2][1-9]))|0000))',
    '484' => '(?:0(?:8(?:[25][1-8]|0[1-7]|[136-9][1-9]|4[1-6])|0(?:[02]\d|3[1-8]|8[1-7]|[14579][1-9]|6[1-6])|9(?:6[1-6]|3[1-7]|[15][1-9]|[024][1-8])))',
    '485' => '(?:0(?:0(?:[24-6][1-9]|1[1-7]|3[1-79]|7[1-8]|0[0-8]|8[1-5])|8(?:3[12]|2[1-9]|1[1-5]|0[1-6])))',
    '486' => '(?:0(?:9(?:3[1-7]|[0246][1-9]|[15][1-8])|8(?:[01][1-9]|4[124-69]|[23]\d|5[1-8])|000))',
    '487' => '(?:00(?:[0-2][1-7]|3[1-5]))',
    '488' => '(?:0(?:0(?:6[1-8]|0[0-8]|7\d|2[1-4]|[145][1-7]|8[1-6]|3[1-5])|8(?:8[1-4]|4[013-7]|2[1-7]|5[12457-9]|1[3-8]|7[1-6]|0[1-5]|3[035689]|6[1367])))',
    '489' => '(?:0(?:8(?:[369][1-8]|[0-24578][1-9])|9(?:5[1-5]|6[1-6]|[18]\d|3[1-8]|[0247][1-9])|0(?:3[1-7]|[267][1-9]|[145][1-8]|0\d)))',
    '490' => '(?:1(?:4(?:4[1-7]|[23][1-8]|1[1-5]|0[0-7])|1(?:3[1-7]|0[0-7]|1[1-6]|4[1-5])|2(?:2[1-6]|0[0-7]|1[1-4])|3(?:2[1-3]|[01][1-5])))',
    '491' => '(?:0(?:0(?:[48][1-6]|1[1-5]|[5-7][1-9]|3[1-7]|2[1-8]|0[0-5])|8(?:5[1-9]|1[1-7]|[34][1-8]|6[1-35-9]|0[1-6]|8[1-3]|2[13-8]|7[1-489])|9(?:[03][1-8]|1[1-9]|2[1-7])|1(?:4[1-4]|3[1-6]|[0-2][1-5])|3(?:5[1-4]|[67][1-6])|201))',
    '492' => '(?:(?:8(?:0(?:[035-7][1-8]|1[1-7]|[2489][1-5])|1(?:[46][1-7]|[013][1-9]|[257][1-8]|8[1-6])|3(?:[05][1-8]|2[1-35-9]|1\d|[38][1-9]|4[124-9]|9[1-3]|7[1-5]|6[1-6])|2(?:[1-3]\d|[06-8][1-9]|5[1-7]|4[1-6])|4(?:[023][1-9]|1\d|[46][1-8]|5[1-6]))|0000))',
    '493' => '(?:(?:000[1-7]|800[1-3]))',
    '494' => '(?:00(?:1[1-9]|0[1-8]))',
    '495' => '(?:00(?:3[1-7]|[12][1-5]|0[1-3]))',
    '496' => '(?:(?:0(?:8(?:[57][1-7]|[0-46][1-9])|0(?:0\d|7[12]|[34][1-8]|[12][1-9])|9(?:1[1-5]|4[1-7]|2[1-4]|[03][1-9]))|80(?:20|0[1-9]|[134]\d)))',
    '497' => '(?:00(?:1[1-6]|0[0-6]|[3-5][0-8]))',
    '498' => '(?:0(?:0(?:6[1-9]|[1-5][1-8]|0[0-7])|8(?:2[1-3]|0[1-8]|1[1-9])))',
    '500' => '(?:(?:8(?:8(?:91|[0-8][1-9])|0(?:[0-8][1-9])|1(?:[0-8][1-9])|4(?:[0-8][1-9])|3(?:3[1-79]|[0-24-8][1-9])|2(?:07|[25-8][1-9]|4[1-7]|3[1-8]|1[1-3]))|0000))',
    '501' => '(?:(?:3(?:8(?:[1-3][1-9]|5[1-7]|[046-8][1-8])|7(?:7[1-3]|0[0-6]|[45][1-6]|8[1-8]|2[1-9]|6[1-4]|[13][1-7])|9(?:[0167][1-9]|4[1-7]|[25][1-8]|3\d)|2(?:[26][1-8]|[15]\d|[34][1-7]|0[0-7])|1(?:0[1247-9]|[35][1-6]|[124][1-7])|(?:60|5[0-2])1|30[0-7])|0(?:4(?:3[1-9]|[25][1-8]|1\d|[467][1-6]|0[0-7])|5(?:[1-36][1-5]|5[1-6]|0[0-4])|6(?:3[1-5]|0[0-7]|1[1-9]|2[1-8])|2(?:[13][1-7]|2[1-5]|0[0-6])|1(?:2[1-4]|0[1-6]|1[1-357-9])|3(?:[12][1-4]|0[1-7])|8(?:1[1-7]|0[2-5])|70[1-8]|90[1-3])|6(?:0(?:0[1-6]|6[1-5]|[389][1-8]|[125][1-9]|[47][1-7])|2(?:0\d|[13][1-8]|[47][1-4]|2[1-9]|[56][1-7])|3(?:2[1-8]|3[0-8]|0[1-4]|1[1-9])|1(?:0[0-5]|3[1-5]|2[1-3]|1[1-35]))|2(?:5(?:4[1-5]|3[1-6]|[56][1-7]|[017][1-9]|2[1-8])|1(?:[1-3][1-5]|0[0-5])|3(?:[23]1|0[1-3]|1[1-5])|8(?:0[1-35-9]|1[124-7])|25[1-9]|60[1-7]|901)|1(?:1(?:[138][1-6]|[046][1-9]|5\d|[27][1-8])|5(?:2[1-9]|0[1-7]|1[1-8]|3[1-6])|2(?:3[1-6]|0[1-35])|3(?:1[1-7]|0[1-3]))|4(?:2(?:41|[23][1-8]|1[1-9]|0[0-7])|5(?:0[1-9]|1[0-8])|6(?:1\d|0[1-8])|10[1-7]|30[1-7]|45[1-5])|5(?:4(?:1[1-7]|[02][1-6])|1(?:[12][1-6]|0[1-5])|50[1-7]|6(?:00|2\d)|30[1-5]|231)))',
    '502' => '(?:0(?:0(?:5[1-6]|3[1-8]|8[12]|[01467][1-7]|2[1-9])|8(?:0[1-3]|6[1-6]|3[1-8]|[78][12]|5\d|[24][1-9]|1[1-7])|9(?:[023][1-9]|1[1-7])))',
    '503' => '(?:(?:0(?:8(?:6[1-5]|1[1-7]|[3489][1-9]|[0257][1-8])|9(?:6[1-5]|[28][1-6]|[01][1-8]|[3479][1-7]|5[1-9])|6(?:0[0-68]|[13][1-8]|2[1-9]|4[13-8]|5[1-5])|1(?:41|1[1-8]|2[1-9]|0[0-6])|0(?:0\d|1[1-9]|2[1-7]|3[1-6])|2(?:[13][1-6]|0[0-6])|3(?:2[1-3]|0[1-7]|1[1-4])|4(?:1[1-5]|0[1-8])|53[1-6])|1(?:3(?:[28][1-5]|0[0-6]|3[1-9]|1[1-7])|2(?:[67][1-8]|5[1-6]|4[1-5])|5(?:2[1-4]|3[12]|0[01]|[14][1-5])|6(?:2[1-6]|1[1-4]|0[12]|3[1-8]))|2(?:3(?:41|0[0-6]|1[1-9]|2[1-8])|2(?:1[1-6]|0[1-8]|2[1-7])|4(?:[12][1-9]|0\d)|1(?:0\d|1[1-4]|2[1-5])|50[1-6])))',
    '504' => '(?:0(?:9(?:71|1[1-6]|[34][1-5]|[05][1-9]|[26][1-8])|8(?:61|[15][1-6]|4[1-7]|[023][1-9])|0(?:0\d|[13][1-8]|4[1-7]|2[1-6])))',
    '505' => '(?:0(?:0(?:[1-3][1-9]|7[1-7]|0\d|[45][1-6])|1(?:30|0[0-8]|[12][1-6])|30[0-7]|42[1-3]|53[12]))',
    '506' => '(?:(?:0(?:8(?:2[1-5]|[0135][1-8]|4[1-7])|0(?:2[1-6]|3[1-5]|0\d|4[1-8]|5[1-9]|1[1-7])|2(?:71|0[1-7])|10[1-7])|1(?:1(?:3[1-3]|2[1-6]|5[1-8]|6[12]|0[0-8]|4[1-9]|1[1-4])|3(?:1[1-9]|0[1-8])|2(?:0[1-6]|1[1-7])|4(?:3[1-4]|2[1-9]))|2(?:1(?:1[1-8]|0[13-6]|[23][1-5])|25[1-8])))',
    '507' => '(?:0(?:0(?:[13][1-9]|[24-7][1-8]|0[0-8])|8(?:[1-4][1-8]|0[1-7])|901))',
    '508' => '(?:0(?:0(?:[14][1-5]|0[0-7]|2[1-4]|3[1-8])|(?:35|42|1[01])1|20[1-4]|50[12]))',
    '509' => '(?:(?:4(?:2(?:3[1-7]|[0-2467][1-5]|5[1-6])|1(?:2[1-6]|1[1-79]|0[1-8])|4(?:1[1-5]|0[1-6]|2[1-4])|3(?:0[1-6]|1[1-8])|5(?:[34][1-5]))|0(?:2(?:6[1-6]|[35]\d|1[1-8]|0[0-8]|2[1-4]|4[0-25-9])|1(?:3[1-6]|0[1-9]|[124][1-7])|3(?:0[0-7]|1[1-5])|40[0-3]|511)|7(?:7(?:31|[01][1-8]|2[1-6])|8(?:31|[0-2][1-6])|5(?:21|1[1-3]|0[1-7])|60[1-8]|2(?:11|0\d)|12[1-6]|40[1-3]|32[12])|3(?:3(?:0[1-6]|[12][1-7])|2(?:0[1-7]|1[1-8])|4(?:1[1-9]|0[1-5])|1(?:1[1-5]|0[1-7])|505)|5(?:1(?:[67]1|1[1-8]|[24][1-7]|5[1-4]|0[0-7]|3[1-6])|3(?:[01][12])|20[1-3]|40[1-3])|2(?:5(?:1[1-9]|0[1-8])|6(?:1[1-5]|0[1-4])|13[1-8]|20[0-7]|31[1-4]|42[1-4]|70[12])|1(?:6(?:1[1-6]|0[1-7]|2[1-4])|1(?:0[0-8]|1[1-3])|30[0-3]|22[12]|431)|6(?:1(?:3[1-5]|1[1-6]|0[0-8]|2[1-8])|36[1-3]|47[12]|251)|9(?:2(?:01|3[12])|13[12])|8(?:23[12]|301)))',
    '510' => '(?:(?:0(?:0(?:3[1-5]|7[1-6]|0[0-8]|[149][1-8]|2[1-7]|[568][1-9])|8(?:[23][1-9]|9[1-4]|[05][1-7]|[46][1-8]|1[0-5]|8[1-6]|7[1-5])|2(?:6[1-6]|1[1-36-9]|5[1-9]|4[1-4]|[23][1-7]|0[1-8])|9(?:71|[45][1-8]|6[1-3])|3(?:[01][1-8])|10[1-7])|8(?:0(?:1[1-7]|[03][1-9]|2[1-8])|1(?:2[1-5]|1[1-4]|0[1-7]))|1(?:2(?:00|[2-4][1-6]|5[1-3])|3(?:2[1-8]|1[12]))))',
    '511' => '(?:(?:0(?:0(?:5[1-8]|0\d|2[1-7]|[1346-8][1-9])|2(?:0[0-8]|[1568][1-7]|3[1-3]|7[1-6]|[24][1-5])|8(?:[023][1-9]|6[1-7]|4[1-8]|1\d|5[1-5])|9(?:4[1-7]|3[1-9]|[0-2][1-4])|4(?:0[1-6]|[1-3][1-8])|5(?:0[1-8]|2[1-4]|1[1-9])|1(?:0[1-6]|2[1-5]|1[1-8]))|11(?:2[1-8]|3[1-7]|[04][1-9]|1[1-6])))',
    '512' => '(?:(?:1(?:2(?:0[1-8]|1[1-6])|1(?:1[13-6]|0[1-5])|30[1-6])|0(?:9(?:0[1-8]|1[1-4]|3[1-6]|2[1-5])|301)|80(?:[56][1-6]|4[1-8])))',
    '513' => '(?:(?:0(?:8(?:3[1-7]|[01][1-9]|[24][1-8]|5[1-5])|0(?:[145][1-9]|[23][1-8]|0\d))|112[1-4]))',
    '514' => '(?:(?:0(?:0(?:[25][1-8]|[01]\d|3[1-9]|[47][1-7]|8[1-6]|6[1-5])|8(?:[02][1-6]|1[1-9]|3[1-8])|1(?:31|0[1-4]|[12][1-6])|3(?:2[13-6]|[01][1-5]))|2(?:3(?:[0-2][1-8])|2(?:1[1-4]|0[1-8]|2[12])|1(?:0[1-7]|1[1-5]))|1(?:1(?:2[1-5]|[03][1-9]|1[1-8])|25[1-8])))',
    '515' => '(?:(?:0(?:0(?:0[0-7]|[46][1-6]|[78][1-8]|[1-3][1-9]|5[1-7])|3(?:[35][1-4]|0[0-3]|4[1-9]|1[1-7]|2[1-5])|8(?:[23][1-5]|0[1-4]|[14][1-8])|1(?:2[1-8]|0[1-4]|1[1-9])|2(?:0[1-8]|1[1-7])|5(?:[12]1|0[1-9]))|2(?:3(?:[023][1-5]|[15][1-7]|4[1-4])|1(?:0[1-9]|2[1-4]|3[1-3]|1[1-5])|5(?:1[1-7]|2[1-6]|0[1-5])|6(?:2[1-4]|1[1-7]|0[1-5])|4(?:1[1-4]|0[1-9]))|1(?:7(?:3[1-4]|2[1-7])|61[1-8]|10[1-7]|50[1-6]|20[1-5]|30[1-4]|41[1-3])|3(?:13[1-9]|53[1-6]|20[1-3]|31[1-3]|421)))',
    '516' => '(?:(?:0(?:0(?:[1-3][1-8]|0\d|7[1-9]|5[1-4]|[46][1-7])|1(?:0\d|1[1-8])|80[1-6]|22[12])|1(?:2(?:4[1-7]|3[1-8])|30[1-9]|10[1-8]|53[1-6]|42[1-3])|21(?:1[1-9]|0[0-8])))',
    '517' => '(?:0(?:0(?:81|4[1-7]|0[0-5]|2[1-6]|[13][1-5])|2(?:0[1-9]|1[1-8])|50[0-7]|40[1-5]|70[1-5]|60[1-4]))',
    '518' => '(?:(?:0(?:4(?:2[1-8]|[03]\d|[167][1-9]|5[3-9]|[48][1-6])|8(?:[56][1-9]|[2-4]\d|7[1-578]|1[0-8]|0[1247-9])|7(?:[23][1-9]|[14]\d|5[1-6]|[07][1-5]|6[1-3])|6(?:2[1-8]|1\d|0[1-9]|3[1-4]|4[1-7])|0(?:[12][1-7]|0[0-8]|3[1-6])|1(?:31|1[1-6]|2[1-7]|0[1-8])|2(?:0[1-6]|2[1-7]|1[1-9])|50[1-5])|1(?:3(?:0[1-7]|1[1-9]|2[1-6])|4(?:0[13-8]|1[2467]|2[124-9])|1(?:4[1-7]|5[1-5]))))',
    '519' => '(?:(?:0(?:1(?:[78]1|0[0-6]|[23][1-7]|[156][1-9]|4[1-8])|4(?:0[0-8]|[23][1-8]|1[1-7])|2(?:7[12]|2[1-3]|1[1-5])|3(?:2[1-4]|1[1-6])|6(?:11|0[1-9])|50[1-7])|2(?:1(?:00|[578][1-9]|6[1-7]|4[1-8])|5(?:1[1-8]|0[1-7]|2[1-5])|4(?:0[0-5]|2[1-9]|1[1-3])|7(?:3[1-6]|0[0-4])|2(?:0[1-4]|1[1-6])|63[1-4]|80[12]|911)|3(?:6(?:6[3467]|3[47-9]|2[01356]|4[0236-8]|7[1-4]|5[1-3689]|0[0-24-69]|1\d)|4(?:21|1[1-5]|0[0-8])|20[1-9]|81[1-4]|92[1-4]|70[12]|111)|1(?:1(?:0[1-8]|[12][1-9])|4(?:[0-2][1-6])|7(?:11|0[1-8]))|5(?:4(?:1[1-7]|0[1-6])|7(?:0[01]|1[1-8])|2(?:11|0[0-6])|32[1-7]|83[1-5])|4(?:3(?:00|2[1-7])|44[1-9]|20[1-7]|56[1-6]|67[1-5])))',
    '520' => '(?:(?:0(?:0(?:0[0-6]|[1-3][1-8]|[4-6][1-7])|8(?:71|[45][1-6]|[023][1-7]|6\d|1[1-8])|5(?:2[1-9]|[03][1-3]|1[1-6])|2(?:3[1-6]|4[1-8]|2[1-7])|1(?:1[1-6]|0[1-7])|4(?:6[1-5]|7[1-8])|3(?:6[1-3]|5[1-7]))|1(?:6(?:3[1-6]|[05][1-5]|2[1-3]|1[1-4]|4[1-8])|4(?:01|[125][1-5]|3[1-3]|4[1-4])|8(?:[02][1-6]|1[1-4]|3[1-7])|2(?:1[1-7]|2[1-4]|[03][1-5])|1(?:0[0-3]|4[1-4]|1[12]|[23][1-3])|5(?:[12][12]|[03][1-3]))|2(?:1(?:1[1-8]|0[12]|6[1-7]|5[1-3]|[2-4][1-5])|3(?:2[1-4]|0[0-5]|6[1-5]|1[1-6]|[3-5][1-3])|5(?:31|7[1-3]|0[0-4]|[45][12]|[126][1-4])|4(?:[13][1-7]|2[1-4])|2(?:7[1-9]|6[1-7]))|3(?:0(?:0[0-6]|[1-4][1-7])|2(?:4[124-8]|0[0-3]|2[1-3]|[35][1-5]|1[1-6])|3(?:0[1-8]|3[1-3]|[12][1-6])|4(?:2[1-7]|[01][1-5]|3[1-6])|1(?:21|1[1-6]|0[1-9]))))',
    '521' => '(?:(?:0(?:0(?:[6-8][1-4]|0[0-4]|[23][1-5]|1[1-6]|9[1-3])|2(?:4[1-5]|3[1-6]|0[1-3]|2[1-7]|1[1-9])|3(?:2[1-7]|1[1-4]|0[1-8]))|1(?:1(?:[23][1-6]|[01][1-5]|4[1-7])|2(?:[0-4][1-5])|3(?:[015]1|3[1-4]|2[12]|4[1-6]))))',
    '522' => '(?:0(?:0(?:7[1-5]|4[1-7]|[13568][1-9]|2[1-79]|0\d)|3(?:0[0-6]|4[1-3]|5[1-6]|3[1-8]|2[1-7]|1[1-9])|2(?:71|[26][1-3]|0[01]|[145][1-4]|3[1-9])))',
    '523' => '(?:0(?:8(?:[1468][1-9]|[357][1-7]|[029][1-8])|0(?:[238][1-7]|6[1-4]|0[0-5]|[45][1-8]|[17][1-6])))',
    '524' => '(?:0(?:0(?:[56][1-5]|[14][1-6]|2[12]|0[0-4]|3[1-7])|2(?:0[1-3]|1[1-5])|10[1-4]))',
    '525' => '(?:00(?:0[0-7]|1[1-6]|7[12]|4[1-578]|5\d|2[1-9]|[36][1-7]))',
    '526' => '(?:0(?:2(?:[125-7][1-7]|0[1-9]|[34][1-6])|0(?:5[1-9]|[34][1-7]|[16][1-8]|0[0-5]|2[1-5])|8(?:3[1-5]|0[1-6]|[14][1-7]|2[1-9])|1(?:0[1-8]|3[1-5]|[12][1-6])))',
    '527' => '(?:0(?:0(?:0[0-7]|9[1-3]|7[1-6]|[1-3][1-9]|[4-68][1-7])|1(?:6[1-6]|[147][1-5]|2[1-9]|5[1-7]|[03][1-8])|2(?:1[1-6]|3[12]|2[1-8]|0[1-9])))',
    '528' => '(?:0(?:0(?:0[0-7]|[35][1-8]|2\d|[46][1-9]|7[1-4]|1[1-7])|2(?:3[1-5]|1[1-3]|2[1-4]|0[1-8])))',
    '529' => '(?:(?:1(?:6(?:[245][1-8]|[01]\d|3[1-6]|6[1-5])|5(?:[45]1|3[1-7]|[0-2][1-4]|7[12]|6[1-6])|4(?:[0-4][1-5])|2(?:[02][1-8]|3[1-7]|1[1-4])|8(?:[25]1|[01][1-4]|3[1-6]|4[1-3])|1(?:00|7[1-7]|6[1-9]|5[1-6])|3(?:31|0[0-3]|[12][1-5]))|0(?:3(?:[16][1-7]|[05][1-4]|2[12]|3[1-5]|4[1-6])|2(?:41|3[1-4]|[25][1-3]|[0167][1-5])|5(?:41|[23][1-7]|1[1-5]|0[1-6])|4(?:3[1-7]|0[1-4]|1[1-5]|2[1-6])|1(?:[0-3][1-3]|4[1-4])|7(?:0[1-8]|1[1-5]|2[1-6]))))',
    '530' => '(?:(?:6(?:1(?:90|0[1-9]|[12]\d|3[0-5])|0(?:90|[1-3]\d|0[1-9]))|00(?:[45][1-7]|0[0-5]|[1-3][1-8])))',
    '531' => '(?:(?:6(?:0(?:90|0[1-9]|[1-3]\d)|1(?:90|[1-3]\d|0[1-9]))|00(?:41|7[1-7]|6[1-4])))',
    '532' => '(?:00(?:3[1-6]|1[1-3]|0[0-6]|2[1-8]))',
    '533' => '(?:00(?:1[1-5]|3[1-3]|0[0-7]|2[1-4]))',
    '534' => '(?:00(?:0[0-2]|1[1-6]|2[1-7]))',
    '535' => '(?:00(?:31|0[0-5]|2[12]|1[1-3]))',
    '536' => '(?:00(?:2[1-5]|0[0-8]|1[1-7]))',
    '537' => '(?:00(?:1[1-4]|0[0-3]|2[1-5]))',
    '538' => '(?:00(?:00|[45][1-4]|3[1-7]))',
    '539' => '(?:0000)',
    '540' => '(?:(?:6(?:1(?:90|0[1-9]|[12]\d|3[0-8])|2(?:90|3[0-8]|[12]\d|0[1-9])|0(?:90|3[0-7]|0[1-9]|[12]\d)|3(?:90|1\d|0[1-9]|2[0-6]))|00(?:[23][1-9]|0[1-8]|1\d)))',
    '541' => '(?:00(?:5[1-9]|4[1-8]))',
    '542' => '(?:00(?:12|[67][1-7]|8[1-6]))',
    '543' => '(?:00(?:3[1-7]|[12][1-8]|[57][1-6]|4[1-5]|6[1-3]|0[0-2]))',
    '544' => '(?:00(?:3[1-4]|[12][1-5]|0[0-6]))',
    '545' => '(?:(?:00(?:[245][1-3]|0[0-5]|1[1-4]|3[1-7])|60(?:[69]0|0[1-9]|[1-5]\d)))',
    '546' => '(?:00(?:3[1-5]|0[0-3]|[124][1-4]))',
    '547' => '(?:00(?:1[1-6]|3[1-5]|0[0-6]|2[1-7]|4[1-8]))',
    '549' => '(?:00[0-2]1)',
    '550' => '(?:00(?:2[1-7]|0[0-6]|1[1-5]))',
    '551' => '(?:00(?:0[0-3]|[1-3][1-3]))',
    '552' => '(?:00(?:1[1-6]|0[0-7]|2[1-3]))',
    '553' => '(?:000[0-7])',
    '554' => '(?:00(?:[12][1-4]|5[12]|0[0-2]|[34][1-3]))',
    '555' => '(?:00(?:[34][1-4]|1[1-3]|2[1-5]|0[01]))',
    '556' => '(?:00(?:0[0-6]|1[1-7]|2\d))',
    '557' => '(?:00(?:6[1-3]|1[1-6]|[245][1-5]|0[0-4]|3[1-4]))',
    '558' => '(?:00(?:0[0-4]|4[1-7]|2[1-4]|3[1-3]|1[1-5]|5[1-6]))',
    '559' => '(?:00(?:2[1-6]|0[0-7]|1[1-7]|3[1-4]))',
    '560' => '(?:00(?:0[0-5]|[1-5][1-6]|8[1-5]))',
    '561' => '(?:08(?:0[1-8]|1[1-7]|9[1-4]|[25][1-9]|[6-8][1-5]|[34][1-6]))',
    '562' => '(?:00(?:[34][1-6]|1[1-5]|0[0-6]|2[1-9]))',
    '563' => '(?:0(?:0(?:00|2[1-9]|1[1-7]|5\d|[34][1-8])|3(?:00|41|7[1-3]|5[1-6]|6[1-8])|1(?:1[1-4]|0[0-5]|3[1-5]|2[1-3])|2(?:5[125-8]|1[1-9])|801))',
    '564' => '(?:00(?:4[1-5]|[6-8][1-3]|5[1-4]|3[1-9]|[12][1-8]|0[0-4]))',
    '565' => '(?:08(?:[14][1-8]|3[1-7]|6[1-3]|[57][1-5]|[02][1-6]))',
    '566' => '(?:00(?:7[1-4]|4[1-7]|[2356][1-5]|1[1-3]|0[0-2]))',
    '567' => '(?:0(?:8(?:0[1-6]|1\d|5[0-5]|[368][1-8]|9[1-7]|[247][1-9])|0(?:[25][1-9]|[36][1-7]|8[4-6]|0\d|4[1-8]|1[0-8]|7[1-6])))',
    '568' => '(?:00(?:8[1-9]|9[1-8]))',
    '569' => '(?:(?:0(?:0(?:[13][1-6]|0[0-7]|[24-69][1-7]|[78][1-8])|8(?:[0245][1-7]|1[1-8]|3[1-6]))|1(?:1(?:[34][1-7]|0[1-9]|[12][1-8])|0(?:0[1-5]|2\d|1[1-8]|5[1-4]|3[1-9]|4[1-7]))))',
    '570' => '(?:00(?:[56][1-6]|[237][1-9]|[18][1-7]|[49][1-8]|0\d))',
    '571' => '(?:00(?:2[1-9]|1[1-7]|[46][1-8]|[357]\d|0[0-257-9]))',
    '572' => '(?:0(?:0(?:1[1-9]|6[1-7]|[02358]\d|[47][1-8])|8(?:3[1-9]|6[1-7]|[1245]\d|0[136])))',
    '573' => '(?:(?:0(?:0(?:0[0-7]|9[1-5]|[1258][1-8]|[367][1-7]|4[1-9])|1(?:71|4[1-6]|[03][1-7]|[1256][1-8]))|11(?:[09][1-7]|[45][1-9]|[1-36-8][1-8])))',
    '574' => '(?:00(?:4[1-6]|0[0-8]|2[1-8]|[1357][1-7]|6[1-4]))',
    '575' => '(?:00(?:4[1-5]|[13][1-6]|6[1-3]|[25][1-4]|0[0-4]))',
    '576' => '(?:00(?:2[12]|5[1-4]|1[1-7]|4[1-3]|0[0-6]|[36][1-6]))',
    '577' => '(?:0(?:0(?:3[2-7]|4[24-8]|[16][1-7]|[25][2-8]|0[0-7])|8(?:[04][1-9]|[23][1-7]|1[1-8])))',
    '578' => '(?:09(?:[0-28][1-5]|6[13-7]|3[1-7]|[457][1-8]))',
    '579' => '(?:80(?:[3-5][1-8]|2[1-7]|6[1-6]|[01][1-5]))',
    '580' => '(?:00(?:[24][1-6]|0[0-6]|1[1-7]|3[1-4]))',
    '581' => '(?:0(?:0(?:[136][1-9]|7[1-7]|2\d|8[1-8]|5[1-6]|[49][1-5]|0[0-7])|8(?:1[1-8]|6[1-9]|[34][1-7]|[02][1-3]|5[1-6]|[78][1-5])))',
    '582' => '(?:00(?:[0-2]\d))',
    '583' => '(?:0(?:8(?:[78][1-6]|[4-6][1-8])|0(?:1[1-8]|0\d|[23][1-7])|99[1-6]))',
    '584' => '(?:00(?:9[1-5]|[18][1-6]|7[0-46-9]|[36][1-9]|4\d|0[0-8]|[25][1-8]))',
    '585' => '(?:00(?:1[1-4]|2[1-7]|[3-5][1-5]|0[0-6]))',
    '586' => '(?:00(?:0\d|[145][1-8]|[27-9][1-7]|[36][1-9]))',
    '587' => '(?:00(?:[23][12]|0[0-3]|[15][1-4]|4[1-3]|6[1-6]))',
    '589' => '(?:00(?:0\d|2[1-3]|[13][1-6]))',
    '590' => '(?:0(?:0(?:[124][1-8]|0[0-8]|7[1-9]|[35][1-7]|6[1-6])|9(?:1[1-3]|[02][1-8]|[3-6]\d|[78][1-7])|1(?:[35][1-8]|[12][1-7]|0[0-6]|4[1-5])|4(?:61|[12][1-7]|4[1-9]|5\d|3[1-6]|0[0-7])|5(?:0[0-5]|[13][1-5]|2[1-6])|8(?:3[1-7]|1[1-4]|0[1-9]|2\d)))',
    '591' => '(?:(?:80(?:2[1-5]|4[1-6]|3[1-7]|1[1-4]|0[1-8])|0000))',
    '592' => '(?:(?:83(?:3[1-5]|4[1-9]|5[12])|00(?:0[0-6]|1[1-4])))',
    '593' => '(?:(?:83(?:1[1-7]|2[1-9]|0[1-8])|0000))',
    '594' => '(?:(?:00(?:5[1-4]|[34][12]|[67][1-6]|0[0-6]|[128][1-3])|11(?:5[1-7]|4[1-4]|[12][1-8]|[03][1-6])))',
    '595' => '(?:0(?:0(?:81|0[0-7]|7[1-5]|[45][1-6]|2[1-8]|[16][1-7]|3[1-9])|8(?:1[1-4]|0[1-5])))',
    '596' => '(?:0(?:0(?:7[1-8]|[356][1-7]|4[1-9]|0[0-6]|[12][1-6])|8(?:1[1-7]|[02][1-8]|4[1-5]|3[1-6])|1(?:0[1-5]|1[1-6])|901))',
    '597' => '(?:0(?:0(?:4[1-6]|[17-9][1-5]|[236][1-3]|5[1-4]|0[0-5])|1(?:1[1-3]|0[1-7])))',
    '598' => '(?:00(?:1[1-6]|7[1-5]|[269][1-4]|3[1-7]|[45][1-8]|0[0-8]))',
    '599' => '(?:(?:8(?:2(?:7[1-6]|6[1-7]|5[1-4]|[34][1-8])|1(?:2[1-8]|0[1-47]|1[1-6]))|0(?:2(?:0[0-5]|[13][1-6]|2[1-5])|3(?:1[1-4]|0[0-4])|000)))',
    '600' => '(?:(?:8(?:8(?:8[1-8]|[279][1-9]|[03-5][1-7]|1[1-6]|6[1-5])|3(?:[58][1-9]|7[1-7]|[03][1-8]|[1249]\d|6[1-5])|2(?:[02-6][1-9]|1\d)|0(?:[0138][1-9]|[24-79]\d)|4(?:[1-4689]\d|[057][1-9])|1(?:[1-35-9]\d|[04][1-9]))|0000))',
    '601' => '(?:(?:8(?:1(?:5[1-5]|[14][1-6]|[0278][1-8]|[36][1-7])|4(?:[27][1-8]|[346][1-9]|[015][1-7])|3(?:[56][1-7]|[0247][1-9]|[1389]\d)|0(?:[013][1-7]|2[1-9]|4[1-8])|2(?:1[1-3]|0[1-7]))|1(?:3(?:[0137][1-8]|[2458][1-7]|[69][1-6])|4(?:1[1-7]|6[1-4]|3[1-9]|[0245][1-6])|2(?:[35][1-5]|4[1-8])|1(?:1[1-3]|[02][1-5]))|0(?:7(?:[24][1-4]|7[1-8]|[0356][1-5]|1[1-6])|1(?:0[12]|[2-4][1-5]|1[1-3])|2(?:5[12]|7[1-8]|6[1-6])|3(?:1[1-6]|2[1-4])|5(?:4[1-3]|3[1-6])|40[1-6]|000)))',
    '602' => '(?:(?:8(?:2(?:[12468][1-8]|[03579][1-9])|4(?:5[1-5]|[127-9][1-8]|[0346][1-9])|3(?:[156][1-9]|[278][1-7]|[034][1-8]|9[1-5])|1(?:[01367][1-9]|[245][1-8])|0(?:[3-6][1-8]|[12][1-9]|[07][1-7]))|0(?:0(?:[468][1-7]|[1259][1-9]|7[1-4]|0[0-8]|3[1-8])|8(?:81|[134][1-9]|[025-79][1-8])|9(?:[14][1-8]|0[1-7]|[35][1-9]|2[1-6]))))',
    '603' => '(?:(?:8(?:4(?:[67][1-9]|9[1-4]|[1-35][1-7]|[048][1-8])|0(?:[0-3][1-8]|[478][1-7]|[56][1-6])|1(?:2[1-6]|[16][1-7]|[347][1-9]|[05][1-8])|3(?:7[1-8]|[2-5][1-7]|[16][1-6]|0[1-5])|8(?:[2-4][1-8]|[01][1-7]|6[1-3]|5[1-6])|2(?:[02][1-8]|[134][1-7]))|0000))',
    '604' => '(?:(?:8(?:0(?:9[1-5]|[036-8][1-6]|[1245][1-7])|4(?:[3569][1-7]|1[1-8]|[24][1-6]|[078][1-5])|1(?:[035-7][1-6]|1[1-8]|[248][1-7])|2(?:5[1-8]|[0-467][1-7])|3(?:2[1-7]|8[1-4]|[47][1-5]|[01356][1-6])|8(?:[13][12]|4[1-7]|[27][1-4]|6[1-3]|0[1-5]|5[1-6]))|0(?:0(?:0[0-5]|[78][1-7]|[2369][1-6]|[145][1-5])|9(?:[01][1-7]|4[1-4]|[23][1-5]|[5-9][1-6])|8(?:[01][1-5]|[78][1-6]|[2-6][1-7]))))',
    '605' => '(?:0(?:9(?:[078][1-9]|[245][1-7]|[136][1-8]|9[1-5])|0(?:0\d|5[12]|3[1-8]|[126-8][1-9]|4[1-6])|8(?:[0457][1-8]|1[1-7]|[23][1-9]|6[1-5])))',
    '606' => '(?:(?:8(?:2(?:[1-8][1-7]|9[1-5]|0[1-6])|3(?:[01589][1-7]|[2-467][1-6])|1(?:5[1-8]|[0-246-8][1-7]|3[1-6])|0(?:1[1-4]|[02-5][1-7]|8[1-6]|[67][1-5])|4(?:[0134][1-7]|2[1-8]|5[1-5]))|0(?:0(?:3[1-7]|[258][1-9]|[4679][1-8]|[01]\d)|9(?:[0-24-6][1-7]|3[1-8])|8(?:[0-46][1-7]|5[1-6]))))',
    '607' => '(?:(?:8(?:4(?:[34][1-3]|[5-7][1-6]|8[1-5]|9[1-8]|[0-2][1-9])|0(?:91|[34][1-5]|8\d|5[12]|1[1-8]|[0267][1-9])|1(?:4[1-7]|[08][1-9]|9[1-4]|[67]\d|[1-35][1-6])|2(?:61|[1-35][1-9]|0[1-4]|4[12])|3(?:11|3[1-7]|[02][1-9]|[45][1-8]))|0000))',
    '610' => '(?:(?:0(?:3(?:4[1-3]|1[1-5]|2[1-6]|6[12]|5[1-7]|3[1-4]|0[0-3])|2(?:[1-46]1|0[0-2]|5[1-5])|1(?:21|1[1-8]|0[0-3])|000)|11(?:2[1-8]|0[1-7]|[15][1-3]|[34][1-6])))',
    '611' => '(?:00(?:2[1-9]|0[0-3]|[14][1-5]|3[1-3]))',
    '612' => '(?:(?:8(?:2(?:[01347][1-9]|[589][1-7]|[26][1-8])|3(?:[03][1-8]|7[1-79]|4[1-7]|[1256][1-9]|8[14-8]|9[1-5])|0(?:[47][1-8]|[0-258][1-9]|6[1-7]|3[1-46-9])|4(?:[13468][1-9]|9\d|2[1-35-9]|7[136-8]|5[0-24-79]|0[1-5])|1(?:41|5[1-8]|0[1-9]|2[1-5]|[13][1-6]))|0(?:8(?:5[1-6]|[0-46-8][1-9])|0(?:0\d|[36][1-8]|7[1-4]|[12458][1-9]))))',
    '613' => '(?:0(?:0(?:00|[2-4][1-6])|9(?:1[1-6]|0[1-7])|85[1-3]))',
    '614' => '(?:(?:8(?:0(?:[29][1-6]|7[1-9]|1[1-7]|[04-68][1-8]|3\d)|1(?:2[1-8]|[19][1-7]|8[1-4]|[45][1-9]|[0367][1-6])|2(?:1[1-6]|[38]\d|[04-6][1-8]|9[1-7]|[27][1-9])|3(?:0[1-8]|[267][1-7]|4[1-9]|5[1-3]|1[1-5]|3[1-6]))|0000))',
    '615' => '(?:(?:8(?:2(?:[16-8][1-7]|[023][1-8]|[459][1-6])|1(?:[389][1-6]|[26][1-5]|[157][1-8]|[04][1-7])|0(?:[01][1-8]|[23578][1-7]|6[1-5]|4[1-6])|30[1-3])|0(?:0(?:1[1-6]|8[1-5]|7[1-4]|[02369][1-7]|[45][1-8])|8(?:4[1-6]|8[1-5]|6[1-4]|[02][1-7]|[1357][1-8])|9(?:2[1-6]|[01][1-7]|3[1-8]))))',
    '616' => '(?:(?:8(?:2(?:[35-7][1-8]|[0-28][1-9]|[49][1-7])|1(?:\d[1-7])|4(?:7[1-5]|9[1-4]|3[1-9]|[0148][1-7]|[256][1-8])|3(?:[0-689][1-7]|7[1-6])|0(?:[0-79][1-7]|8[1-5]))|00(?:[12][1-7]|0[0-7])))',
    '617' => '(?:0(?:8(?:[1-3][1-8]|[45][1-7])|00[0-6]))',
    '618' => '(?:00(?:[7-9]1|2[1-4]|0[0-4]|1[1-5]))',
    '619' => '(?:(?:1(?:1(?:3[1-6]|1[1-3]|[45][1-4]|[02][1-7])|2(?:0[0-5]|2[1-6]|1[1-3])|4(?:[12][12]|0[0-2])|30[0-4])|02(?:[13][1-8]|[04][0-6]|2[1-5])))',
    '620' => '(?:(?:0(?:8(?:9[1-5]|[3-57][1-9]|[16][1-7]|[028][1-8])|9(?:[15][1-8]|2[0-8]|7[1-4]|[0368][1-9]|4[03-9])|0(?:[235][1-9]|[146][1-7]|7[1-8]|0[0-5])|3(?:4[12]|2[1-7]|[13][1-4]|0[1-5]|5[1-6])|2(?:[02]1|1[1-4]))|1(?:4(?:[2-4][1-5])|3(?:0[12]|1[1-4]))))',
    '621' => '(?:0(?:8(?:4[1-7]|[126][1-9]|3[1-5]|[05][1-6])|0(?:4[1-6]|2[1-9]|5[1-4]|3[1-7]|1[1-8]|0[0-8])|2(?:[35][1-5]|[46][1-3])|1(?:1[1-5]|0[1-4]|2[1-7])))',
    '622' => '(?:0(?:0(?:2[1-5]|[36][1-6]|0[0-4]|[14][1-7]|5[1-9])|2(?:0[0-3]|[12][1-4]|3[1-6])|3(?:2[1-5]|1[1-6]|3[12]|0[1-4])|4(?:4[1-5]|5[1-3])))',
    '623' => '(?:(?:0(?:0(?:5[1-4]|3[1-7]|0[0-8]|[1246][1-6])|3(?:4[1-6]|5[1-3]|6[1-4])|1(?:1[1-7]|0[1-8])|2(?:[23][1-6]))|11(?:[23][1-4])))',
    '624' => '(?:0(?:9(?:6[1-8]|[02][1-9]|1[1-4]|3[1-7]|[45][1-6])|8(?:5[1-5]|[0-3][1-6]|4[1-3])|1(?:1[1-8]|2[1-5]|0[1-3])))',
    '625' => '(?:0(?:0(?:[02368][0-7]|1[0-6]|[57][0-8]|4[0-5])|1(?:5[1-8]|[34][1-7])))',
    '626' => '(?:0(?:0(?:5[1-5]|1[1-9]|[347][1-7]|2\d|6[1-8]|0[0-8])|4(?:0[0-5]|1[1-7]|3[1-3]|2[1-5])|2(?:1[1-3]|0[1-6]|2[1-7])))',
    '627' => '(?:0(?:0(?:3[1-8]|2[1-7]|[15][1-4]|0[0-7]|4[1-5])|2(?:0[12]|2[1-8]|[34][1-9]|1[1-6])|1(?:4[1-5]|[23][1-3]|[01][12])))',
    '629' => '(?:(?:3(?:4(?:[04][1-9]|2[1-4]|3[1-8]|1[0-6])|1(?:1[1-3]|3[1-6]|2[12]|0[1-4])|5(?:7\d|5[1-9]|6[1-6])|24[1-6])|1(?:1(?:1[1-7]|2[12]|0[1-8]|[34][1-5])|2(?:5[1-7]|[67][1-4]|4[1-5])|3(?:2[1-3]|[01][1-5]))|2(?:5(?:[03][1-4]|1[1-5]|2[1-3])|2(?:00|51|[34][1-4]|6[1-3])|4(?:0[1-4]|[12][1-3])|3(?:1[1-4]|0[1-3]))|0(?:1(?:41|[035][1-4]|2[12]|1[1-5]|6[1-6])|3(?:41|0[12]|3[1-5]|[12][1-3])|271)))',
    '630' => '(?:(?:8(?:2(?:[0-68][1-8]|[79][1-7])|3(?:[79][1-4]|[05][1-7]|[1-4][1-8]|[68][1-5])|0(?:[24][1-5]|1[1-6]|0[1-3]|3[1-7]|5[1-4])|1(?:1[1-5]|4[1-6]|[23][1-7]|0[1-8])|4(?:[15][1-4]|[02-4][1-5]))|0(?:2(?:1[1-5]|0[0-3]|3[1-9]|6[1-7]|[245][1-8]|7[12])|1(?:01|1[1-6]|2[1-3]|4[12]|3[1-8])|000)|2(?:2(?:1[12]|3[1-4]|[02][1-5])|1(?:[67][1-8]|5[1-3])|3(?:[04][1-6]|5[1-7]))|1(?:1(?:0[1-5]|2[1-6]|1[1-3])|2(?:3[1-7]|4[1-5]))))',
    '631' => '(?:0(?:0(?:2[1-7]|[07][1-8]|[13-6][1-6])|8(?:[12][1-8]|3[1-7]|[04][1-6])))',
    '632' => '(?:0(?:0(?:[1457-9][1-8]|6[1-9]|0[0-7]|3[1-6]|2[1-5])|2(?:[25]1|[04][1-7]|3[12])|1(?:[0-2][1-3])))',
    '633' => '(?:(?:0(?:0(?:91|5[1-5]|3[1-6]|0[0-7]|8[1-7]|7[1-9]|[1246][1-8])|2(?:5[1-7]|[12][1-8]|0[0-8]|[34][1-6])|1(?:[12][12]|0[1-8]|3[1-3])|31[1-7]|42[1-5])|2(?:1(?:[256][1-6]|3[1-9]|4[1-4]|1[1-7]|7\d|0[1-8])|2(?:2[1-7]|[01][1-5])|4(?:00|3[1-3]|[24][1-4])|3(?:[01][1-4]))|1(?:2(?:1[1-6]|0[0-3])|30[0-4])))',
    '634' => '(?:0(?:0(?:2[1-9]|[13][1-4]|0\d|7[1-8]|5[12]|6[1-5]|4[1-6])|1(?:[13][1-8]|0[0-8]|[24][1-5])|8(?:[134][1-7]|2[1-9]|0[1-5])))',
    '635' => '(?:0(?:0(?:2[1-6]|5[1-9]|[1346-9][1-7]|0[0-4])|1(?:[12][1-3]|3[1-6]|0[0-4]|[45][1-4])|8(?:[023][1-5]|1[1-8])))',
    '636' => '(?:0(?:3(?:0[0-7]|5[1-5]|[14][1-7]|[23][1-9])|0(?:8[12]|0[0-3]|5[1-7]|[2679][1-3]|1[1-5])|2(?:[02][1-6]|[13][1-7]|4[1-8])|1(?:1[1-6]|0[0-6]|3[1-3]|[245][1-4])|9(?:3[1-8]|[01][1-6]|[24][1-5])|8(?:[01][1-5]|[23][1-4])))',
    '637' => '(?:(?:0(?:0(?:[49][1-3]|0[0-6]|[26]\d|[37][1-8]|[58][1-4]|1[1-9])|4(?:1[1-79]|0[1-9]|2[1-5])|1(?:0[1-5]|1[1-7])|2(?:3\d|2[1-7]))|1(?:2(?:1[1-7]|2[1-5])|5(?:00|5[1-9])|10[1-8]|66[1-8]|33[1-6]|44[1-6])))',
    '638' => '(?:0(?:0(?:0[0-3]|[134][1-5]|2[1-6])|8(?:21|1[12]|[03-5][1-3])|2(?:[125]1|0[0-3]|[34][1-3])|6(?:5[1-7]|4[1-4]|6[1-3])|3(?:1[1-5]|0[0-5]|2[12])|5(?:[45][1-3]|6[1-4])|431))',
    '639' => '(?:(?:2(?:2(?:0[0-7]|[237][1-9]|1[1-7]|[4-6][1-8])|1(?:3[1-8]|[24][1-7]|0[0-3]|6[1-4]|1[1-3]|5[1-5])|3(?:[12][1-8]|3[1-7]|[04][1-6]))|1(?:0(?:4[1-5]|6[1-6]|[13][1-9]|[025][1-8])|1(?:3[1-8]|0[0-8]|[56]\d|[14][1-9]|2[1-7]))|3(?:1(?:[12][1-8]|0[0-8])|6(?:0[1-4]|3[1-5]|[12][1-3])|5(?:00|4[1-3]|5[1-8])|4(?:4[1-6]|3[1-7])|70[0-5]|32[1-5]|80\d)|02(?:[5-7][1-6]|4[1-5]|0[0-6]|[23][1-7]|1[1-8])))',
    '640' => '(?:(?:8(?:2(?:[0157][1-6]|[239]\d|8[1-8]|[46][1-9])|3(?:[46][1-5]|0[1-6]|7[1-8]|[259]\d|[38][1-7]|1[1-9])|0(?:[035][1-9]|[14][1-7]|7[1-8]|[26]\d)|4(?:[58][1-3]|[23][1-5]|1[1-6]|7[12]|[046][1-4])|1(?:5\d|[02][1-8]|[13][1-9]|4[1-6]))|1(?:2(?:[135][1-5]|2[1-3]|4[1-4]|0[1-7])|1(?:[2-4]1|[17][1-5]|0[0-3]|6[1-7])|3(?:3[1-3]|6[1-6]|5[1-4])|4(?:81|7[1-6]))|0(?:3(?:1[1-6]|4[1-5]|[35][1-3]|[26][1-4]|0[1-7])|4(?:[25][1-4]|4[1-3]|[01][1-6])|1(?:1[1-5]|0[1-3])|000)))',
    '641' => '(?:00(?:[35][1-6]|[124][1-5]|6[12]|0[1-8]))',
    '642' => '(?:00(?:0[0-4]|[12][1-9]|3[1-5]))',
    '643' => '(?:0(?:1(?:5[1-3]|[67][1-6]|3[1-7]|4[1-4]|2[1-9])|0(?:3[1-4]|0[0-7]|[57][1-5]|[26][1-6])|8(?:[01][1-3]|5[1-5]|4[1-8])|5(?:51|4[1-4]|2[12]|1[1-5]|3[1-3])|3(?:1[1-4]|6[1-6])|6(?:0[1-5]|1[1-4])))',
    '644' => '(?:(?:1(?:1(?:[01]1|[24][1-3]|5[12]|[36][1-4])|2(?:[03]1|[14][1-4]|2[12]))|0(?:0(?:[124][1-5]|0[0-5]|3[1-4])|2(?:1[1-8]|0[12]))))',
    '645' => '(?:0(?:0(?:0[0-6]|1[1-4]|2[1-8])|5(?:51|2[1-5])|20[1-8]|41[1-7]|30[1-3]))',
    '646' => '(?:(?:0(?:0(?:1[1-5]|6[1-3]|5[0-46-9]|2[1-9]|0[0-5]|[34][1-8])|3(?:1[1-4]|0[1-5])|21[1-7]|10[12])|1(?:4(?:21|3[1-9]|1[1-7]|0[12])|3(?:2[1-6]|3[1-9])|21[1-4]|101)))',
    '647' => '(?:(?:1(?:7(?:5[1-3]|[23][1-6]|0[1-5]|4[1-4]|1[1-7])|2(?:71|2[1-3]|1[1-6]|3[1-5]|0[1-7])|60[0-5]|32[1-5]|58[1-4]|10[1-3])|00(?:[68]1|1[1-9]|[35][1-4]|0[0-8]|2[0-5]|4[1-5]|7[1-3])))',
    '648' => '(?:0(?:0(?:[38][1-8]|[45][1-4]|[19][1-9]|0[0-7]|6[1-6]|[27][1-5])|2(?:[13-5]1|2[1-7]|0[0-2]|6[1-3])|1(?:[125-7]1|3[1-3]|0[01]|4[1-5])|40[1-5]|30\d))',
    '649' => '(?:(?:6(?:2(?:0[0-8]|[25][1-8]|6[1-4]|1[1-9]|7[1-5]|3[1-6]|4[1-68])|5(?:[56][1-5]|2[1-6]|7[1-3]|[01][1-4]|[34][12])|4(?:4[1-7]|5[12]|[12][1-8]|3[1-5]|0[0-7])|3(?:2[1-6]|3[1-9]|[01][1-8])|6(?:31|2[1-4]|[01][1-6])|1(?:[02][1-5]|[16][12]))|1(?:3(?:00|2[1-5]|1[1-6]|[34][12])|2(?:3[1-4]|0[0-3]|1[1-3]|2[1-5])|1(?:[12][1-3]|0[0-4]|3[1-4])|5(?:00|3[1-7]|2[1-8])|44[1-4])|0(?:1(?:01|5[1-6]|[23][1-3]|4[1-7]|6[1-4]|1[12])|3(?:1[1-7]|0[0-7])|4(?:3[1-7]|2[12]))|2(?:5(?:11|2[1-5]|3[1-9])|6(?:[23]1|0[0-4]|1[12])|3(?:3[1-4]|2[1-6])|10[0-8]|2(?:11|0[01]))|4(?:1(?:0[0-6]|2[1-6]|1[1-7])|2(?:[12][1-7]|3[1-6])|4(?:4[1-4]|5[1-5])|56[1-5])|7(?:1(?:0[0-4]|[36][1-7]|2[1-3]|4[1-6]|[157][1-5])|2(?:1[1-6]|0[1-7]))|5(?:3(?:71|0[0-4]|3[1-9]|1[1-4])|1(?:00|7[12]|4[1-8]|3[1-7])|4(?:5[1-4]|6[1-6]))|3(?:5(?:1[0-8]|0[0-3]|2[1-4])|1(?:6[1-9]|[45][1-3])|63[1-3])))',
    '650' => '(?:00(?:4[1-8]|[12][1-7]|3[1-9]|0[0-7]))',
    '651' => '(?:(?:1(?:2(?:[16][1-4]|[23][1-3]|[04][1-6]|5[1-5])|3(?:2[12]|[35][1-4]|1[1-3]|0[1-6]|4[1-5])|1(?:3[1-3]|0[0-6]|2[1-5]|1[1-4]|4[1-7])|5(?:[12][1-6]|0[1-5])|4(?:01|[13][1-3]|2[1-4])|6(?:0[1-4]|1[1-6]|2[1-3]))|2(?:2(?:3[1-9]|4[1-4]|[0157][1-7]|[26][1-8])|1(?:0[1-9]|1[1-7]|[34][1-8]|2\d)|3(?:21|1[1-3]|[03][1-4])|4(?:1[1-4]|0[1-5]))|00(?:[568][1-8]|9[1-7]|7[1-9])))',
    '652' => '(?:0(?:8(?:[16][1-6]|[578][1-5]|2[1-3]|[034][1-7]|9[1-8])|0(?:71|0[0-8]|5[1-8]|4[1-7]|2[1-3]|6[1-5]|[13][1-6])))',
    '653' => '(?:0(?:8(?:[05][1-6]|4[1-5]|[38][1-8]|7[1-9]|1[1-4]|[26][1-7])|0(?:0[0-4]|3[1-9]|1[1-6]|[245][1-5])))',
    '654' => '(?:0(?:0(?:81|[34][1-9]|[126][1-8]|0\d|5[1-5]|7[1-6])|1(?:[0246][1-3]|5[1-5]|[13][1-4])))',
    '655' => '(?:0(?:0(?:[2-4][1-9]|5[12]|1[1-8]|0\d)|8(?:[57][1-4]|6[1-5]|[89][1-6])))',
    '656' => '(?:(?:0(?:4(?:00|5[1-7]|8[1-4]|[27][1-8]|6[12]|[34][1-6]|1[1-3])|0(?:31|0[0-6]|4[1-6]|5[1-5]|1[1-8]|2[1-7])|5(?:[25]1|1[1-8]|3[1-4]|0[1-3]|4[1-6])|3(?:41|1[1-5]|3[12]|[02][1-8])|1(?:[0136]1|2[12]|5[1-4]|4[1-3])|6(?:51|6[1-3])|961)|1(?:3(?:[04][1-4]|[23][1-7]|1[1-8])|5(?:[34]1|0[1-3]|2[1-6]|1[12]|5[1-8])|7(?:1[12]|2[1-7]|4[1-3]|3[1-6])|60[1-6])|2(?:1(?:00|6[1-3]|[25][1-6]|3[12]|4[1-4])|3(?:11|2[1-3]|3[1-4]|0[1-7])|2(?:2[1-5]|1[1-4])|5(?:[34][1-3])|4[05]1)))',
    '657' => '(?:0(?:0(?:0[0-2]|4[1-5]|[136][1-8]|[25][1-9])|8(?:3[1-8]|1[1-7]|6[1-4]|0[1-5]|[245][1-6])|1(?:11|0[1-5])))',
    '658' => '(?:00(?:[37][1-3]|[16][1-6]|0[0-5]|4[1-8]|2[1-7]|[58][1-4]))',
    '659' => '(?:00(?:0[0-4]|[26][1-8]|[38][1-7]|4[1-3]|5[1-5]|[179][1-6]))',
    '660' => '(?:0(?:8(?:5[16-8]|[0267][1-8]|3[1-57]|4[1-6]|[18][1-5]|9[1-3])|0(?:00|9[1-6]|5[1-5]|6[1-4]|[78][1-7])))',
    '661' => '(?:0(?:0(?:1[1-4]|4[1-7]|2[1-6]|3[1-5]|0[1-3])|9(?:6[1-7]|7\d|8[1-5]|5[1-3])))',
    '662' => '(?:0(?:0(?:[1378][1-8]|[246][1-7]|9[1-9]|5[1-4]|0[0-6])|8(?:2[2-8]|[36][1-8]|5[1-7]|[17][1-5]|[489][1-6])|9(?:[127][1-8]|3[1-4]|[45][1-7]|6[1-5])))',
    '663' => '(?:8(?:1(?:5[1-6]|4[1-3]|[02368][1-7]|7[1-9]|1[1-4])|2(?:1[1-5]|[03][1-4]|2[1-9]|4[1-7])|0(?:1[1-7]|0[1-6]|[23][1-5])))',
    '664' => '(?:0(?:8(?:[58][1-8]|[39][1-9]|4[2-7]|[67][1-5])|0(?:31|1[1-7]|2[02-9]|0[0-8])))',
    '665' => '(?:0(?:8(?:91|5[1-6]|[046][1-8]|[1-378][1-7])|0(?:0[0-7]|7[1-6]|[23][1-5]|[14-6][1-7])))',
    '666' => '(?:0(?:1(?:[01][1-7]|2[1-9]|6[12]|[3-5][1-8])|2(?:[25][1-7]|0[0-4]|3[1-8]|6[12]|1[1-5]|4[1-6])|0(?:0[0-7]|2[1-6]|[13][1-7])))',
    '667' => '(?:(?:1(?:3(?:2[1-6]|6[1-8]|[05][1-4]|[134][1-7])|5(?:[14][1-5]|[023][1-3])|1(?:0[1-5]|1[1-9]|2[1-8]))|0(?:0(?:2[1-4]|3[12]|0[0-5]|1[1-6]|4[1-5]|5[1-3])|1(?:0[1-7]|[23][1-6]|[14][1-5])|3(?:0[1-6]|[12][1-5])|43[1-6])))',
    '668' => '(?:0(?:0(?:0[0-6]|3[1-3]|[68][1-5]|1[1-6]|7[1-8]|[245][1-7])|2(?:[13][1-8]|[07][1-9]|5[1-7]|[46][1-6]|2[1-5])|3(?:[24][1-5]|7[1-6]|[13][1-7]|[056][1-4])|8(?:[2-4][1-4]|[01][1-7]|6[1-6]|[57][1-5])))',
    '669' => '(?:(?:2(?:4(?:4[1-7]|3[1-9]|[01][1-8]|[256][1-5])|3(?:[24][1-6]|0\d|1[1-8]|[35][1-7]|6[1-9])|1(?:1[1-4]|6[1-3]|[2-4][1-5]|[05][1-6])|5(?:1[1-3]|[034][1-5]|2[1-7]|5[1-4])|7(?:0[1-4]|3[1-7]|[12][1-8])|2(?:31|[12][1-4]|0[1-6])|8(?:2[1-7]|[01][1-5])|6(?:1[1-6]|0[1-5]))|6(?:7(?:61|3[12]|2[1-8]|4[1-7]|5[1-3]|0[0-2]|1[1-6])|4(?:0[1-4]|3[1-3]|[12][1-6])|5(?:00|5[1-9]|6[1-4]|4[1-6])|8(?:2[12]|0[1-8]|3[1-3]|1[1-5])|2(?:0[1-3]|1[1-8]|2[1-9])|1(?:0[1-3]|1[1-6]|2[1-7])|3(?:[35][1-5]|4[1-4])|9(?:5[1-4]|4[1-6])|67[12])|3(?:1(?:3[12]|[246][1-8]|5[1-9]|1[1-3]|0[1-5])|6(?:[135][1-4]|[024][1-6])|8(?:4[1-3]|1[12]|2[1-7]|[03][1-4])|4(?:0[1-4]|6[1-7]|1[1-6])|5(?:7[1-5]|8[1-3])|3(?:0\d|1[1-6]))|1(?:3(?:0[0-4]|5[1-8]|1[1-7]|[34][1-9]|2[1-5])|5(?:4[1-8]|[013][1-7]|2[1-9])|1(?:3[1-6]|0[1-4]|4[1-9]|[126][12])|2(?:[13-5]1|0[1-5]|2[12])|4(?:[01][1-7]))|5(?:3(?:1[1-5]|4[1-6]|2[1-8]|0[1-7]|[35-7][1-9])|2(?:[356][1-8]|0[0-4]|2\d|[14][1-6])|1(?:0[1-4]|[45][1-3]|3[1-6]|[12][1-5]))|4(?:3(?:[24][1-5]|0[12]|[13][1-7])|2(?:5[1-3]|6[1-5]|7[1-4])|1(?:41|[23][1-5]))))',
    '670' => '(?:0(?:8(?:4[1-9]|[1-3578][1-7]|[069][1-8])|0(?:1[1-7]|[24][1-9]|[35][1-8]|0\d|7[1-5]|[689][1-6])|9(?:5[1-5]|[079][1-6]|6[124-6]|8[1-79]|4\d|[1-3][1-7])))',
    '671' => '(?:(?:1(?:2(?:4[12]|2[1-8]|5[1-7]|1[1-4]|6[1-3]|0[1-5]|3[1-6])|5(?:[16]1|0[0-4]|2[1-4]|5[1-7]|7[1-6]|[34][1-5])|1(?:0[1-8]|2[1-5]|[13-5][1-6])|6(?:[25]1|[014][1-3]|6[1-5]|3[12])|3(?:[02]1|[134][12]))|2(?:5(?:1[1-9]|0[0-8]|[25][1-8]|[67]\d|4[1-5]|3[1-6])|2(?:[14][1-7]|[23][1-4]|0[1-3])|1(?:0[1-356]|2[1-4]|[13][1-7])|4(?:01|[12][1-6]))|4(?:1(?:3[1-9]|4[1-4]|0[1-8]|[12][1-5])|2(?:21|0[1-4]|3[12]|1[1-6]|4[1-5]))|0(?:2(?:[25][1-6]|0[1-57-9]|3[1-4]|1[124-9]|4[1-8])|1(?:[02][1-3]|1[12]))|32(?:[01][12]|3[1-3]|2[1-5])))',
    '672' => '(?:(?:80(?:[378]\d|9[0-8]|6[1-49]|4[013-9]|0[1-4]|[15][1-9]|2[1-5])|010[1-3]))',
    '673' => '(?:(?:0(?:8(?:9[1-8]|7\d|5[1-7]|4[1-9]|6[0-26-8]|8[1-6])|4(?:[12][1-5]|[3-5][1-6]|0[0-5])|0(?:0\d|[13][1-8]|[24][1-9])|7(?:[02][1-4]|5[1-8]|3[1-6]|1[1-5]|4[1-3])|5(?:[24]1|3[1-4]|5[1-3]|[01][1-6]))|1(?:4(?:[267][1-5]|[15][1-6]|0[0-4]|4[1-7]|3[1-4])|3(?:41|2[1-5]|[01][1-4]|3[1-8])|1(?:[12][1-9]|0[1-8])|2(?:3[1-6]|4[1-4]))))',
    '674' => '(?:00(?:9[1-5]|6[1-9]|[78][1-4]|5\d))',
    '675' => '(?:(?:0(?:1(?:5[014-9]|0[0-5]|[24][1-8]|6[02-4]|[13][1-7])|0(?:[01]\d|[56][1-8]|[24][1-7]|3[1-9])|3(?:21|1[1-4]|4[1-7]|[03][1-6]))|2(?:4(?:[25][1-6]|[46][1-5]|[013][1-4])|3(?:[01][1-3]|[46][1-6]|[25][1-4]|3[1-7])|2(?:[03][1-4]|[124][1-3])|1(?:1[1-4]|0[1-5]))|1(?:3(?:7[1-9]|[1-3][1-8]|[056]\d|4[1-6])|2(?:[023][1-6]|1[1-8])|1(?:1[1-6]|0[0-5]|2[1-7]))))',
    '676' => '(?:0(?:0(?:[14][1-9]|0[0-8]|[2367][1-8]|8[12]|5[1-6])|8(?:2[1-8]|0[1-9]|1[1-6])))',
    '677' => '(?:0(?:0(?:1[1-8]|5[1-7]|4[1-4]|[36][1-9]|0[0-6]|2[1-6])|1(?:[23][12]|1[1-4]|0[1-5])))',
    '678' => '(?:(?:0(?:0(?:31|[47][1-4]|6[1-7]|[189][12]|0[0-8]|5[1-6]|2[1-5])|2(?:5\d|0[0-8]|[2-4][1-9]|1[1-7])|1(?:41|[67][1-6]))|1(?:2(?:3[1-3]|[25][1-6]|6[12]|7[1-8]|0[0-5]|4[1-4]|1[1-9])|18[1-6])))',
    '679' => '(?:(?:5(?:3(?:1[1-9]|[23][1-5]|4[1-6]|0[0-7])|1(?:[56][1-5]|4[1-8]|3[1-7])|5(?:1[1-4]|[023][1-5])|2(?:1[1-5]|[02][1-7])|6(?:5[1-4]|4[1-6]))|4(?:1(?:[037]\d|[26][1-9]|[145][1-6])|3(?:2[1-7]|0[1-5]|[14][1-6]|3[1-3])|0(?:[12][1-7]|0[1-8])|2(?:[23][1-3]|0[1-6]|1[1-5]))|2(?:1(?:01|[24][1-4]|6[1-7]|3[12]|[15][1-5])|3(?:0[0-4]|1[1-8]|[23][1-7])|4(?:[0-2][1-5]|3[1-4])|2(?:1[1-8]|0[0-5]))|3(?:4(?:[035][1-3]|[12][1-4]|4[12])|1(?:0[0-4]|1[1-6]|2[1-5])|3(?:[14]1|2[1-6]|[03][12]))|1(?:1(?:[13][1-5]|0[0-7]|2[1-4])|3(?:2[1-7]|3[1-8])|2(?:[01][1-5]))|0(?:3(?:[02][1-4]|1[1-6])|2(?:0[1-7]|[12][1-3])|10[1-9])))',
    '680' => '(?:(?:0(?:0(?:81|5[1-6]|[134][1-7]|[27][1-4]|0[0-8]|6[12])|4(?:0[0-8]|3[1-8]|[25][1-7]|7[1-4]|6[1-3]|4[1-5]|1[1-6])|8(?:4[1-7]|[12][1-4]|[35-7][1-5]|0[1-6])|9(?:0[1-9]|2[1-4]|4[1-7]|[13][1-5])|7(?:[13][1-5]|0[01]|4[1-6]|2[1-8])|2(?:0[1-8]|[12][1-6])|5(?:4[1-5]|[23][1-7])|1(?:[3-5][1-6])|3(?:1[1-6]|0[1-7])|6(?:0[1-7]|1[1-4]))|1(?:2(?:0[1-9]|[35][1-4]|2[1-5]|[14][1-6])|1(?:[5-7][1-7]|3[1-3]|4[1-6])|4(?:3[1-9]|4[1-4]|[12][1-8]))|80(?:2[12]|6[2-6])))',
    '681' => '(?:00(?:0[0-3]|[17][1-4]|4[1-7]|[35][1-6]|[26][1-5]))',
    '682' => '(?:0(?:8(?:7[1-5]|2[1-6]|[013-68][1-7])|1(?:00|6[1-3]|2[1-5]|[34][1-6]|7[1-36-8]|5[1-9])|9(?:[35][1-4]|4[1-8]|[01][1-5]|2[1-6])|0(?:1[1-8]|0[0-6]|3[1-6]|[24][1-5])|6(?:[34][1-5]|2[1-6]|1[1-35]|0[1-7])|4(?:[03][1-4]|[12][1-3])|7(?:1[1-5]|2[1-4]|0[0-4])|3(?:7[45]|1[1-7]|0[1-3])))',
    '683' => '(?:0(?:0(?:5[1-5]|[1-46][1-7]|0\d)|3(?:2[1-3]|0[0-2]|5[1-6]|4[1-5]|1[12]|[36][1-7])|8(?:[1-4][1-6]|[05][1-5])|2(?:1[1-8]|[25][1-7]|0[1-4])|10[1-5]))',
    '684' => '(?:0(?:0(?:3[1-4]|[12][1-7]|0[0-6]|[4-7][1-6])|4(?:0[0-4]|1[1-3])|10[0-7]|30[0-3]|211))',
    '685' => '(?:0(?:0(?:[12][1-7]|0[0-7])|3(?:1[1-4]|0[1-6])|4(?:1[1-3]|3[1-5])|10[1-6]))',
    '689' => '(?:(?:0(?:7(?:1[1-5]|[03][1-7]|2[1-9])|5(?:01|3[1-7]|[12][1-9])|2(?:2[1-6]|[01][1-7])|3(?:4[1-5]|3[1-4]|5[1-7])|4(?:1[1-3]|2[1-6]|0[1-5])|1(?:0[1-6]|1[1-7])|60[1-7])|3(?:5(?:00|5[1-3]|1[1-5]|2[1-4]|[34][1-7])|3(?:3[1-6]|[01][1-9]|2[1-7])|1(?:0[1-6]|3[2-6]|[12][1-5])|2(?:0[0-5]|1[1-4]|2[1-6])|4(?:1[1-8]|2[1-5]|0[1-3]))|1(?:4(?:[45][1-5]|2[1-6]|[13][1-7]|6[1-8]|0[0-4])|1(?:2[1-6]|[01][1-7])|3(?:[12][1-6]|0[1-7])|2(?:01|2[1-9]|1[1-5]))|4(?:2(?:[013][1-7]|[24][1-6])|1(?:2[1-3]|1[1-5]|3[1-6]|0[0-8])|4(?:0[0-3]|1[1-4]|3[1-5]|2[1-6])|5(?:0[0-5]|[12][1-7]))|2(?:3(?:[1-5][1-6]|0[0-6])|5(?:4[1-4]|[01][1-3]|[23][1-5])|2(?:2[134]|1[1-6]|0[0-8])|1(?:0[1-6]|1[1-5]))|5(?:2(?:00|[12][1-6])|5(?:5[12]|3[1-4]|4[1-5])|6(?:7[1-3]|6[1-6])|13[1-7])))',
    '690' => '(?:(?:0(?:8(?:0[1-4]|5[124-69]|6\d|[478][1-8]|[12][1-6]|3[1-5])|0(?:6[1-5]|0[0-7]|2[1-7]|4[1-9]|1[1-57]|[35][1-8])|1(?:51|3[1-3]|[24][12])|3(?:3[1-3]|2[1-4])|4(?:11|0[12])|26[1-6])|2(?:5(?:2[1-5]|1[1-3])|6(?:25|3[1-4])|40[0-6]|70[1-6]|10[1-5]|31[1-4]|80[12])|1(?:1(?:1[1-5]|0[1-4])|2(?:[12][1-3])|40[1-8]|31[1-5]|50[1-5])|3(?:20[03-7]|51[1-6]|40[1-5]|31[1-4])))',
    '691' => '(?:00(?:[124][1-5]|[67][1-6]|5[1-3]|[03][1-4]))',
    '692' => '(?:0(?:0(?:[1346][1-7]|7[1-57]|[25][1-8]|0[0-7])|2(?:1[1-8]|0[1-7])|4(?:0[1-5]|1[1-3])|32[1-6]|62[1-5]|73[1-3]))',
    '693' => '(?:0(?:0(?:4[1-6]|2[1-9]|7[1-4]|3[1-7]|8[12]|1[1-57]|[56][1-8]|0[0-8])|5(?:[02][1-6]|1[12])|10[1-6]|21[1-6]))',
    '694' => '(?:0(?:0(?:0[0-4]|[4-6][1-4]|1[1-3]|[23][1-5])|30[1-5]|22[1-4]|43[1-3]))',
    '695' => '(?:0(?:0(?:1[1-7]|2[1-4]|0[0-7])|1(?:0[1-3]|5[1-6])))',
    '696' => '(?:(?:0(?:0(?:1[1-3]|0[0-7])|7(?:0[1-6]|1[1-3])|1(?:31|0[0-4])|31[1-7]|40[1-7]|50[1-6]|22[1-5]|60[1-3])|1(?:1(?:3[1-7]|4[1-5])|22[1-6])))',
    '697' => '(?:(?:0(?:0(?:6[1-5]|0[0-7]|[1-5][1-7])|3(?:0[1-5]|1[12])|4(?:31|2[1-7])|51[1-4]|12[1-3]|21[1-3]|631)|1(?:3(?:3[1-8]|2[1-7])|2(?:0[1-4]|1[1-5])|12[1-3])))',
    '698' => '(?:(?:0(?:0(?:51|0[0-7]|[1-4][1-7])|2(?:1[1-4]|0[1-7])|41[1-4])|2(?:14[1-6]|25[1-5])|12(?:01|[12][1-3])))',
    '699' => '(?:(?:1(?:2(?:[236][1-4]|4[1-5]|[01][1-6]|5[1-3])|3(?:1[12]|[23][1-4]|4[1-3])|1(?:[12][1-5]|0[1-6])|8(?:[0-3][12])|5(?:00|1[1-7])|4(?:01|3[1-4])|70[1-3]|62[12]|94[12])|0(?:7(?:[145]1|3[1-3]|[02][12]|6[1-4])|6(?:31|1[1-5]|[24][1-4])|1(?:0[1-9]|1[0-2])|8(?:2[1-5]|1[1-7])|5(?:[05][1-5])|40[1-8]|90[1-6]|20[1-5])|5(?:6(?:2[12]|[13][1-7]|0[0-7])|5(?:1[1-7]|2[1-5]|0[0-7])|2(?:21|[01][1-7])|1(?:3[1-4]|2[1-7])|30[1-7])|4(?:6(?:0[05]|2[1-7]|3[1-3])|7(?:1[1-5]|0[1-467])|22[1-6]|50[1-5]|43[12]|[13]11)|3(?:2(?:1[1-7]|2[1-6])|50[1-6]|67[1-6]|76[1-6]|30[1-3]|16[12])|2(?:5(?:0[1-7]|1[1-6])|8(?:4[12]|3[1-7])|21[1-6]|30[1-5])))',
    '700' => '(?:0(?:9(?:4[1-5]|[13568][1-6]|[027][1-7])|0(?:[14][1-7]|8\d|0[0-5]|[26][1-8]|3[1-5]|[57][1-6])|8(?:5[1-6]|[246][1-7]|[013][1-8])))',
    '701' => '(?:(?:2(?:2(?:[12][1-6]|0[1-5])|6(?:[01][1-6]|2[1-5])|5(?:0[1-4]|[12][1-5])|4(?:4[1-6]|3[1-7])|1(?:5[1-5]|4[1-4]))|1(?:3(?:4[1-6]|[35][1-7])|2(?:1[1-4]|2[1-6]|0[1-5])|1(?:[35][1-4]|4[1-5])|6(?:1[1-3]|0[1-5])|52[1-7]|46[1-5])|0(?:1(?:3[1-6]|[0146][1-5]|5[1-3])|2(?:21|1[1-5]|0[1-6])|30[0-4])|4(?:2(?:00|6[1-5]|[17][1-6]|4[13-8]|[235][1-4])|30[1-4]|50[12])|320[1-4]))',
    '702' => '(?:80(?:2[1-7]|[3-5][1-8]|[01][1-6]))',
    '703' => '(?:82(?:[16][1-7]|[02-57-9][1-8]))',
    '704' => '(?:81(?:5[1-5]|[679][1-6]|[0-2][1-7]|4[1-9]|8[1-4]|3[1-8]))',
    '705' => '(?:0(?:0(?:0[0-3]|[1-3][1-6])|13[1-3]))',
    '706' => '(?:0(?:0(?:1[1-4]|2[1-8]|0[0-2])|1(?:[3-5][1-4])|3(?:0[1-6]|1[1-7])|22[1-6]))',
    '707' => '(?:0(?:0(?:[356][1-7]|0[0-5]|2[1-5]|[14][1-6])|4(?:[0-3][1-7])|1(?:[23][1-4]|1[1-3])|50[0-6]|20[1-6]))',
    '708' => '(?:(?:0(?:8(?:[035][1-7]|[6-8][1-6]|[124][1-5])|0(?:5[1-3]|0[0-7]|1[1-6]|2[1-4]|[3467][1-7])|3(?:1[1-7]|0[0-5]|6[1-6]|[2-4][1-5]|5[1-3])|4(?:2[1-7]|3[1-5])|5(?:1[12]|0[1-4])|70[1-5]|601)|1(?:5(?:[024][1-7]|[13][1-6])|3(?:0[0-7]|2[1-6]|1[1-5])|1(?:1[1-7]|2[1-6]|0[1-5])|2(?:[0-2][1-6]))))',
    '709' => '(?:(?:0(?:8(?:[457][1-6]|6[1-5]|0[0-7]|[12][1-7]|3[1-8])|4(?:0[0-4]|[2-5][12]|[16][1-4])|6(?:1[1-5]|[23][1-6]|0[1-7])|7(?:21|[03][1-6]|1[1-9])|5(?:[0-2][1-6])|2(?:1[1-4]|2[1-6])|30[1-4])|3(?:6(?:3[1-6]|0[0-6]|[12][1-7])|1(?:[04][1-5]|[1-3][1-4])|9(?:51|[13][1-5]|2[1-4]|0[1-8])|7(?:0[0-7]|2[1-6]|1[1-7])|4(?:[01][1-7]))|4(?:2(?:0[1-5]|[13][1-6]|[245][1-7])|3(?:2[1-4]|0[0-7]|1[1-6]|3[1-5])|6(?:[0-2][1-6]|3[1-5]))|2(?:1(?:2[1-6]|[013][1-7])|4(?:1[1-3]|2[12]|0[1-4])|6(?:6[1-4]|7[1-6])|3(?:3[1-4]|4[1-5])|55[1-4])|12(?:1[1-6]|0[1-4])))',
    '710' => '(?:(?:0(?:0(?:[34][1-8]|[25][1-7]|0[0-7]|1[1-6]|6[1-5])|8(?:2[1-6]|[0134][1-7])|1(?:51|3[1-3]|4[1-6])|2(?:[56][1-3]))|1(?:3(?:1[1-5]|0[1-6])|20[1-3]|10[12])))',
    '711' => '(?:09(?:[0-3][1-7]))',
    '712' => '(?:80(?:[46][1-6]|1[1-5]|7[1-4]|[35][1-9]|[02][1-7]))',
    '713' => '(?:81(?:2[1-7]|0[1-3]|1[1-6]))',
    '714' => '(?:(?:0(?:0(?:0[0-7]|6[1-6]|2[1-5]|[347-9][1-8]|1[1-4]|5[1-7])|30[12]|101)|1(?:2(?:2[1-7]|1[1-5]|0[0-6])|4(?:1[1-5]|0[1-7]))|2(?:1(?:[01][1-4]|2[1-5])|23[1-4]|341)))',
    '715' => '(?:00(?:2[1-6]|0[0-6]|1[1-9]))',
    '716' => '(?:(?:0(?:0(?:0\d|6[1-8]|4[1-7]|5[1-4]|[1-3][1-9])|3(?:11|0[1-4]|3[1-5]|2[1-3])|2(?:1[12]|0[1-7]|2[1-3])|1(?:[02][12]|1[1-3]))|1(?:4(?:11|[03][1-3]|2[12])|1(?:31|0[0-2]|[12][12])|3(?:11|2[12])|55[1-4]|24[12])))',
    '717' => '(?:0(?:0(?:[0-2][1-7])|4(?:[0-2][1-6])|7(?:3[1-7]|4[1-6])|5(?:1[1-5]|0[1-7])|6(?:1[1-3]|0[1-4])|10[1-5]|201))',
    '718' => '(?:0(?:0(?:1[1-7]|0[0-7])|3(?:0[1-7]|1[1-3])|10[1-4]|211))',
    '719' => '(?:(?:3(?:1(?:[15][1-7]|[2-4][1-6]|0[0-7])|2(?:0[1-6]|2[1-8]|1[1-4])|50[1-7]|81[1-4]|61[12]|70[12])|1(?:1(?:0[0-6]|6[1-5]|[2-57][1-6]|1[1-7])|3(?:2[1-4]|1[1-6]))|2(?:7(?:3[12]|2[1-3])|23[1-4]|12[1-3]|34[1-3]|64[1-3]|40[12]|55[12]|80[12])|0(?:2(?:00|21|[3-5][1-4])|1(?:1[1-3]|0[1-6])|30[0-4])))',
    '720' => '(?:(?:0(?:0(?:[03][1-4]|[67][1-7]|1[13-7]|[89][1-3]|[45][1-6]|2[1-5])|8(?:[24][1-5]|[03][1-9]|1[1-8])|4(?:11|0[1-3])|5(?:51|4[1-3])|20[1-4]|31[1-3])|1(?:1(?:3[1-5]|4[1-7])|6(?:[02][1-4])|8(?:00|1[12])|41[0-6]|26[1-5]|52[1-5]|70[1-5]|90[12])|2(?:1(?:[12][1-7]|0[1-8])|41[02-9]|52[1-5]|60[12])))',
    '721' => '(?:0(?:9(?:31|1[1-7]|2[1-79]|5[1-8]|6[1-6]|[47][1-5]|0[1-46-8])|000))',
    '722' => '(?:(?:0(?:0(?:[13][1-8]|6[12]|0[0-8]|4[1-7]|7[1-3]|2[1-6]|5[1-5])|3(?:[45][1-5]|[1-3][1-6])|2(?:21|[13][1-5]|0[12])|4(?:11|3[12]|0[1-3]))|1(?:5(?:01|1[1-6]|6[1-5])|1(?:00|1[1-7]|2[1-3])|4(?:01|1[1-7])|7(?:[03][12])|62[1-7]|20[1-4]|30[1-4])|2(?:4(?:0[1-5]|3[12]|1[1-7])|6(?:41|3[1-3])|32[1-4]|21[1-3]|10[12])))',
    '723' => '(?:0(?:0(?:2[12]|[14][1-7]|5[1-4]|0[0-7]|3[1-5]|6[1-6])|1(?:4[1-8]|3[1-4])))',
    '725' => '(?:0(?:0(?:0[0-5]|1[1-3]|2[1-6])|2(?:00|31)|30[1-3]|40[1-3]))',
    '726' => '(?:00(?:2[1-7]|1[1-3]|0[0-6]|3[1-6]))',
    '727' => '(?:0(?:0(?:2[1-6]|0[0-8]|1[1-7])|4(?:2[1-5]|[01][1-3])|3(?:21|[01][12])|11[1-4]|62[1-4]|20[1-3]))',
    '728' => '(?:0(?:0(?:0[0-7]|[12][1-7])|1(?:01|[12][1-5]|3[1-3])|2(?:11|0[1-3])|40[1-7]|62[1-5]|50[1-4]))',
    '729' => '(?:(?:3(?:4(?:31|[01][1-5]|2[1-4])|7(?:2[12]|[01][1-3])|2(?:[0-2][12])|1(?:0[1-7]|1[12])|30[1-7]|51[1-6]|60[12])|5(?:1(?:2[1-8]|[13][12])|7(?:4[1-5]|[23][1-3])|6(?:[01][1-3])|45[1-6]|50[1-6]|24[1-4]|81[1-3])|6(?:2(?:0[1-5]|1[1-6])|1(?:[34][1-4])|7(?:0[12]|1[1-6])|61[1-6]|33[1-5])|0(?:1(?:4[12]|0[1-6]|1[1-5])|4(?:1[1-9]|7[1-5])|32[1-49]|25[12])|4(?:2(?:11|0[1-8]|2[1-7])|1(?:0[1-6]|1[1-3])|30[1-8])|1(?:3(?:[23][1-3])|40[1-6]|21[1-3])|2(?:3(?:61|1[1-7])|25[1-3])))',
    '730' => '(?:0(?:0(?:0[0-5]|[13][1-7]|[24][1-9]|5[1-5])|8(?:1[1-4]|[34][1-7]|[025][1-6])))',
    '731' => '(?:(?:0(?:1(?:1[1-3]|2[1-6]|3[5-9]|[45][1-4]|0[0-3])|5(?:4[1-4]|1[1-3]|0[0-2]|[23][1-5])|2(?:2[1-5]|3[1-6]|0[12]|1[1-7])|30[1-6]|70[1-3]|61[12])|3(?:8(?:01|4[2-5]|1[023]|3[1-5]|2[14])|1(?:7[1-5]|6[13-9])|5(?:61|0[0-3]|5[12])|3(?:5[1-5]|6[1-3])|6(?:64|2[12])|27[12]|41[12]|70[12])|1(?:5(?:3[1-5]|[12][1-6]|0[0-6])|7(?:0[1-6]|1[1-4])|1(?:71|4[12])|22[1-3])|2(?:3(?:2[1-4]|1[1-7])|4(?:4[12]|3[1-7])|10[1-7]|20[1-6]|55[12])|51(?:0\d|6[12]|[23][1-8]|[145][1-7])|4(?:2(?:00|31|1[1-5]|2[1-9])|3(?:31|1[1-4]|2[1-5]|0[01]))))',
    '732' => '(?:0(?:0(?:[16][1-8]|0\d|5[1-7]|[24][1-9]|3[1-6])|8(?:2[1-8]|1[14-9]|0[1-7])))',
    '733' => '(?:0(?:8(?:2[1-3]|[046][1-5]|1[1-6]|7[1-7]|[35][1-4])|0(?:2[1-5]|1[1-3]|0[0-7]|3[1-7])))',
    '734' => '(?:0(?:0(?:[1-5][1-7]|6[1-4]|0[0-7])|30[1-4]|10[1-3]))',
    '735' => '(?:00(?:0\d|1[1-7]|2[1-9]))',
    '736' => '(?:00(?:71|0[0-5]|6[1-8]|8[1-9]|1[1-4]|3[1-5]|[245][1-6]))',
    '737' => '(?:(?:0(?:8(?:0[1-9]|5[1-4]|6[1-7]|[1-37][1-8]|4[1-6]|8[1-5])|0(?:0[0-5]|[27][1-9]|[136][1-5]|[45][1-6])|1(?:4[1-6]|[12][1-5]|6[1-3]|[05][1-7]|3[1-8])|9(?:3[1-6]|1[1-5]|0[1-8]|2[1-4])|3(?:11|0[1-3])|40[1-3])|2(?:6(?:1[4-7]|0[1-9]|3[1-7])|1(?:2[1-6]|0[01]|[13][1-3])|5(?:[01][1-9])|3(?:0[1-3]|1[1-6])|21[1-5])|1(?:2(?:[01][1-7])|377)))',
    '738' => '(?:0(?:0(?:60|4[1-3]|0[0-7]|5[1-6]|[12][1-7]|3[1-9])|2(?:8[12]|2[1-6]|0[1-5])|51[1-4]|60[1-3]|72[12]|301))',
    '739' => '(?:(?:0(?:4(?:88|0[1-8]|6[1-467]|3[2-47]|1[1-4]|7[1-9]|5[24-9]|[24][1-6])|6(?:[14][1-6]|0[0-7]|6[13-57]|[35][1-7]|2[1-8])|0(?:0[0-8]|3[1-8]|4[1-9]|[12][1-6])|5(?:88|2[1-5]|3[1-6]|4[1-3]|0[1-7]|5\d|1[1-8])|1(?:4[124-7]|[35][1-3])|3(?:2[1-4]|1[1-5]|0[1-3])|26[1-9])|2(?:1(?:1[1-7]|0[1-6]|2[1-5])|6(?:31|[12][1-9])|3(?:0[1-4]|1[1-8])|2(?:11|0[1-9])|40[1-5]|50[1-4]|73[12])|1(?:7(?:00|4[1-3]|[35][1-4])|10[1-8]|80[1-7]|20[1-5]|41[1-4]|30[1-3]|521)))',
    '740' => '(?:(?:0(?:0(?:51|3[1-7]|1[1-9]|2[1-8]|0[0-4]|4[1-5]|6[1-3])|3(?:[12][1-7]|0[1-6])|50[1-5]|60[1-5]|72[1-5]|90[1-4]|81[12])|1(?:4(?:41|88|3[12]|0[1-7]|2[4-68]|1[1-3]|5[1245])|2(?:[034][12]|1[1-9]|2[1-5]))))',
    '741' => '(?:00(?:9[1-4]|[78][1-5]|6[1-3]))',
    '742' => '(?:(?:0(?:3(?:01|4[1-4]|3[1-8]|2[1-6]|1[1-5])|0(?:41|0\d|2[1-4]|1[0-2]|3[1-6])|4(?:[12][1-7])|(?:11|20)1)|2(?:10[0-8]|51[1-8]|80[1-7]|71[1-6]|92[1-4]|30[12]|60[12])|1(?:1(?:1[1-4]|0[0-7])|5(?:0[0-4]|1[1-7])|40[0-4]|35[1-3])))',
    '743' => '(?:0(?:0(?:31|0\d|5[12]|4[1-8]|[12][1-3]|[67][1-5])|10[1-5]))',
    '744' => '(?:0(?:0(?:[3-5][1-3]|6[1-35]|7[1-5]|[12][1-57-9]|0[0-8])|27[1-6]))',
    '745' => '(?:(?:0(?:8(?:6[1-9]|[1-48][1-7]|[057][1-8])|0(?:[1-5][1-7]|0[0-7]|[67][1-6])|6(?:[246][1-3]|1[1-8]|3[12]|5[1-4])|5(?:01|1[12])|12[1-5]|30[1-4]|24[12]|40[12])|113[12]))',
    '746' => '(?:0(?:0(?:5[1-6]|[46][1-5]|3[1-8]|[0-2][1-9]|8[1-4])|10[1-5]))',
    '747' => '(?:(?:0(?:0(?:5[1-6]|0[0-6]|2[1-9]|1[1-4]|[346][1-7])|8(?:[014][1-9]|2[1-5]|3[1-6])|6(?:21|1[12])|10[1-7]|23[1-5]|34[1-4]|52[1-4]|40[12])|1(?:2(?:21|3[12])|111)))',
    '749' => '(?:010[1-3])',
    '750' => '(?:(?:0(?:0(?:[1245][1-9]|[68][1-7]|0\d|7[1-8]|3[1-6]|9[1-5])|4(?:3[1-3]|[025][1-5]|[14][1-6])|3(?:[01][1-7]|2[1-5])|60[1-6]|25[1-3])|11(?:71|[15][1-6]|[26][1-4]|[34][1-7]|0[12])))',
    '751' => '(?:08(?:8[1-8]|[23]\d|[014-7][1-9]))',
    '752' => '(?:09(?:1[1-6]|[2469][1-8]|[78]\d|5[1-9]|[03][1-7]))',
    '753' => '(?:0(?:0(?:[3-6][1-8]|7\d|8[1-9]|1[125-8]|0[01]|[29][1-5])|8(?:[03-69]1|2[1-6]|7[12]|1[1-8])|2(?:31|1[1-5]|4[1-3]|[25][12])|30[1-3]|101))',
    '754' => '(?:(?:0(?:0(?:1[1-5]|3[1-3]|2\d|0[1-8])|89[1-7]|21[1-4]|51[1-4]|12[1-3]|60[1-3]|30[12]|411)|1(?:31[1-5]|10[12]|277)))',
    '755' => '(?:0(?:0(?:8[1-6]|[5-7][1-8]|0\d|9[1-7]|[1-4][1-9])|8(?:10|0[1-9])|15[1-5]|241))',
    '756' => '(?:0(?:8(?:[47][1-8]|[08][1-9]|[135][1-7]|6[1-6]|2[1-5])|0(?:6[037]|9[1-5]|0[013-57-9]|[13]\d|8[06-8]|[57][1-7]|[24][1-9])))',
    '757' => '(?:0(?:0(?:1[1-3]|0[1-6])|21[1-7]|40[12]))',
    '758' => '(?:0(?:0(?:11|7[1-467]|0[0-4]|[2-5][1-7]|6[1-3])|(?:[57]0|14)1|30[1-5]|21[1-3]|61[1-3]))',
    '759' => '(?:(?:6(?:5(?:3[1-4]|4[12]|2[1-5])|3(?:0[1-3]|1[1-7])|6(?:[01][1-4])|12[12])|3(?:6(?:00|11|2[12])|(?:41|72)1|20[1-4]|11[1-3]|30[1-3]|80[1-3]|50[12])|4(?:10[0-7]|40[1-5]|50[1-5]|62[1-3]|71[1-3]|211)|2(?:2(?:00|2[1-3]|1[1-4])|1(?:31|[45][12])|30[12])|0(?:2(?:1[1-3]|0[1-9])|1(?:3[1-6]|2[1-4]))|1(?:34[1-3]|51[1-3]|23[12]|42[12]|60[12])|5(?:(?:10|24)1|51[1-3]|33[12])))',
    '760' => '(?:00(?:80|9[1-3]|[17][1-9]|[024]\d|[356][0-8]))',
    '761' => '(?:(?:0(?:1(?:30|[12][1-3]|0[1-4])|3(?:[0-2][1-3])|4(?:50|3[1-4]|4[1-6])|70[0-5]|61[1-5]|90[1-5]|82[1-3])|4(?:1(?:3[1-4]|2[12]|[15][1-5]|4[1-6]|0[0-6])|4(?:2[1-6]|0[1-5]|3[1-4]|1[12])|30[0-8]|66[1-4])|80(?:4[1-7]|7[1-9]|6[1-4]|5[1-8]|[018][1-5]|2[1-6]|3[1-3])|2(?:20[1-8]|40[1-8]|30[04-8]|10[1-3])|1(?:70[1-8]|40[1-6]|61[1-6]|50[1-4])|3110))',
    '762' => '(?:00(?:0[0-7]|7[1-3]|[135][1-8]|[2468][1-7]))',
    '763' => '(?:0(?:0(?:3[0-4]|4[1-8]|2[1-9]|0[0-7]|[68][1-6]|[1579][1-5])|1(?:11|0[1-8])|2(?:31|2[1-8])))',
    '764' => '(?:00(?:[45]0|0[0-6]|[1-3][1-8]))',
    '765' => '(?:00(?:40|[357][1-3]|1[1-4]|0[0-4]|[26][12]))',
    '766' => '(?:0(?:0(?:[12][1-7]|0[0-7])|20[1-4]))',
    '767' => '(?:00(?:1[1-4]|2[12]|0[0-4]|3[1-3]))',
    '768' => '(?:0(?:0(?:40|6\d|5[12]|[12][1-4]|3[1-3]|7[0-6]|0[0-2])|10[1-5]))',
    '769' => '(?:(?:2(?:3(?:2[1-3]|0[0-6]|1[1-5])|5(?:2[01]|1[1-9])|7(?:0[0-5]|1[1-5])|90[1-8]|60[1-6]|10[1-5]|40[12])|1(?:6(?:2[1-5]|1[1-7]|0[1-4])|4(?:10|0[1-8])|10[1-9]|50[1-8])|0(?:2(?:1[0-3]|0\d|2[1-8])|3(?:0[1-3]|1[1-9])|10[1-5]|40[12])))',
    '770' => '(?:(?:0(?:8(?:[27][1-4]|4[1-7]|[06][1-8]|[15][1-6]|3[1-5])|0(?:1[12]|[24][1-8]|6[1-4]|3[1-9]|0[0-6]|5[1-3])|9(?:1[1-8]|[023][1-9]|4[1-4]))|80(?:0[1-8]|1[12]|7\d|8[1-4]|3[1-3]|5[1-6]|4[01]|2[1-5]|6[134])))',
    '771' => '(?:(?:1(?:2(?:40|[057][0-3]|2[0-4]|[13][0-2]|6[0-24-7])|3(?:[235]0|4[1-7]|1[01]|0[0-2])|6(?:1[0-6]|0[1-4]|2[1-7])|7(?:14|0[0-6])|50[1-9]|15[1-6]|40[1-3])|0(?:1(?:3\d|1[1-7]|4[1-4]|2[1-9]|0[1-6])|2(?:20|0[0-7]|1[1-9])|3(?:6\d|7[1-8]))|5(?:5(?:3[12]|[01][1-8])|4(?:1[0-3]|0[1-9])|17\d|20\d|32\d)|6(?:1(?:1[1-8]|0[1-7])|32[1-8]|40[1-5]|51[12])|4(?:30[0-8]|26[1-7]|50[0-5]|10[0-2])|2(?:10[1-7]|30[1-6]|50[1-3])|3(?:20[0-3]|31[01]|42[12])))',
    '772' => '(?:00(?:60|5[1-3]|3[1-5]|2[12]|0[0-4]|4[1-4]|1[1-7]))',
    '773' => '(?:00(?:31|70|[01]\d|2[0-5]))',
    '774' => '(?:(?:00(?:30|4[1-9]|1[1-7]|0\d|2[1-3])|1760))',
    '775' => '(?:0(?:5(?:1[0-3]|0[1-9])|0(?:1[0-3]|0[0-7])|3(?:10|0[1-9])|20[02-6]|41[1-5]|101))',
    '776' => '(?:00(?:20|3[1-7]|1[0-5]|0[0-7]))',
    '777' => '(?:0(?:00[1-7]|30[1-3]))',
    '778' => '(?:(?:0(?:0(?:[24]0|1[0-4]|0\d|3[12])|1(?:65|0[1-5])|20[1-6])|525[1-4]))',
    '779' => '(?:(?:3(?:2(?:[23][1-6]|[14][1-5]|0[0-8])|1(?:0[1-6]|3[1-3]|1[1-9]|2[0-8])|6(?:10|3[1-9]|2[05]|0[0-4])|30[1-7]|40[1-7]|50[1-5]|74[1-5])|1(?:1(?:[01][1-9]|2[1-3])|2(?:[34][1-6])|(?:51|7[45])0|6(?:20|3[01])|40[1-4])|5(?:3(?:2[1-8]|[034][1-7]|1[1-6])|1(?:7[1-3]|6[1-6])|4(?:22|5[1-3]))|0(?:1(?:1[1-9]|0[0-8])|2(?:2[1-5]|3[0-8])|3(?:[01][1-5]))|4(?:70[0-7]|30[1-7]|40[1-7]|80[1-7]|10\d)|2(?:10[1-9]|30[0-7])))',
    '780' => '(?:(?:0(?:9(?:[19][1-6]|8[1-5]|3[1-8]|[24][1-9]|0[1-4]|[5-7][1-7])|0(?:[56][1-6]|[37][1-4]|2[1-7]|[48][1-8]|0[0-4])|8(?:[57]0|2[1-5]|0[1-6]|1[1-8]|[346][1-4]))|80(?:[49]0|[02][1-8]|1\d|7[1-7]|[38][1-9]|5[0-2]|6[1-6])))',
    '781' => '(?:(?:1(?:1(?:[26][1-5]|3[1-6]|4[1-3]|[15][1-4]|0[0-5])|3(?:1[1-5]|[23][1-8]|0[0-8])|5(?:1[1-8]|2[0-4]|0[0-6]|3[1-5])|7(?:[46][1-6]|5[1-8])|6(?:0[1-9]|2[0-8]|1\d)|91[1-5]|80[1-4])|3(?:7(?:2[1-5]|1[1-7]|4[12]|0[0-5])|1(?:0[1-8]|[12][1-5])|6(?:1[0-57-9]|0\d|2[0-4])|2(?:1[1-4]|[02][1-3])|33[1-7]|52[1-6]|40\d)|5(?:2(?:3[1-5]|0[0-6]|1[1-3]|2[1-4]|4[12])|6(?:[01][1-6]|2[12])|4(?:6[1-9]|5[1-5])|3(?:10|3[12])|70[0-8]|10[1-8])|2(?:1(?:1\d|2[0-46-8]|0[0-8]|6[1-7]|5[1-5]|[34][1-6])|6(?:1[1-6]|0[1-5])|3(?:[23][1-5])|40[12]|51[12])|4(?:2(?:3[1-6]|0[1-8]|[124][1-7])|4(?:1[1-5]|0[1-6])|5(?:3[01]|2[1-9])|64[1-5])|0(?:2(?:7[01]|6[12]|4[0-5]|5[0-3])|3(?:0[1-4]|2[1-5]|1[1-6])|01[0-5]|11[1-4])|6(?:4(?:[16]0|4[1-9]|0[0-3]|2[1-7]|[35]\d)|20[0-2]|83[1-3]|74[12])|81(?:3[0-6]|2[1-6]|0[1-5]|1[1-4])|7(?:30[0-4]|41[1-4]|10\d|220)))',
    '782' => '(?:00(?:5[14-9]|[01]\d|4[1-7]|[37][1-9]|6[1-4]|2[1-5]))',
    '783' => '(?:00(?:9[1-6]|1[1-4]|2[1-9]|[38][1-7]|[57][1-8]|[06][0-8]|4\d))',
    '784' => '(?:0(?:0(?:10|2\d|5[1-8]|0[0-8]|3[1-4]|4[1-6]|6[1-5])|27[1-8]))',
    '785' => '(?:0(?:6(?:[36][1-6]|[45][1-8]|0[0-8]|1[0-3]|2[1-7])|0(?:3[0-7]|2[1-8]|1[0-8]|0\d|5[1-9]|4[1-7])|1(?:7[1-4]|6[1-7])|2(?:[01]\d)|77[1-6]|50[1-5]|41[1-3]))',
    '786' => '(?:0(?:0(?:[235-9][1-8]|[01][0-8]|4[1-9])|5(?:0[1-4]|1[1-7]|[23][1-5])|3(?:2[1-7]|0[1-8]|1[1-6])))',
    '787' => '(?:(?:0(?:3(?:3\d|[0-2][0-8])|0(?:3[0-8]|[0-2]\d|5[0-2])|8(?:0[0-7]|1[1-6])|5(?:5[6-9]|6[0-3])|4(?:5[0-3]|4[5-7])|1(?:5\d|6[0-3])|77[1-6]|24[0-4]|66[5-9])|1(?:6(?:0[1-7]|1[1-8])|10[1-9]|32[1-6]|44[1-4]|22\d|55\d)))',
    '788' => '(?:0(?:3(?:[1-3][1-5]|0[02]|[4-6][1-3])|0(?:[03]\d|2[1-8]|1[0-5]|5[1-4]|4[1-9])|2(?:6[1-8]|7[1-4])|78[1-6]|67[7-9]))',
    '789' => '(?:(?:1(?:2(?:[23][1-5]|1[1-8]|0[0-5])|9(?:2[1-5]|3[1-6]|1[1-3]|0[0-5])|7(?:1[1-6]|2[0-5]|0[1-8])|4(?:1\d|0[1-9])|30[0-4])|0(?:2(?:3[1-7]|4[1-8]|5[0-5])|3(?:1[1-6]|2[1-5]|0[0-7])|1(?:6\d|7[0-4]|5[6-9])|58[1-7]|42[6-8])))',
    '790' => '(?:0(?:8(?:1[1-4]|[26][1-7]|[03-57][1-8])|0(?:[25][1-6]|[034][1-8]|1[1-4]|6[1-7])|9(?:5[12]|4[1-8]|6[1-7]|3[1-4]|[02][1-5]|1[1-6])))',
    '791' => '(?:(?:0(?:5(?:10|62|4[1-3]|[03][1-8]|2[1-7])|2(?:0[0-5]|4[1-5]|1[1-6]|2[1-3])|1(?:50|[03][1-5]|2\d|1[1-4])|3(?:[02][1-3]|1[1-5])|0(?:00|54))|3(?:1(?:[12]0|5[1-5]|0[0-2]|4[1-3]|[36][1-4])|3(?:10|0[01]|4[1-3]|6[0-4]|[235][12])|5(?:[12][1-4]|0[1-6])|20[1-6])|1(?:1(?:[0-3][1-6])|2(?:[12][1-3]|0[0-7])|5(?:[01][1-5])|7(?:10|0[1-9])|80[1-3])|80(?:[028][1-7]|4[1-4]|[17][1-9]|5[1-8]|6\d|3[124-6]|9[1-3])|2(?:1(?:1[1-7]|0[0-3]|[34][1-5]|2[0-6])|20[1-7])|4(?:5(?:1[01]|0[1-9])|32[1-4]|43[12])))',
    '792' => '(?:0(?:8(?:2[1-9]|7[1-4]|[35][1-7]|[468][1-8]|9[0-8]|[01][1-5])|0(?:[568]0|3[1-5]|2[1-6]|0\d|7[12]|[14][1-7])))',
    '793' => '(?:0(?:0(?:2[1-8]|[56][1-7]|1[067]|0[0-7]|4[1-6]|7[1-5]|3[04-9])|21[1-6]|10[1-3]))',
    '794' => '(?:(?:0(?:0(?:8[1-7]|[47][1-4]|[56][1-9]|[1-3][1-8]|0[0-7])|8(?:[45]0|6[1-3]|[01][1-5]|3[12]|2[1-7])|1(?:1[1-7]|0[1-9]|2[1-5]))|2(?:5(?:[235]0|4[0-2]|0\d|1[0-3])|1(?:0[1-4]|1\d)|30[1-5]|20[1-4]|410)|1(?:30[1-9]|40[1-4]|10[1-3])))',
    '795' => '(?:0(?:0(?:8[1-9]|5[1-4]|0\d|3[12]|7[0-8]|4[1-6]|2[1-5]|6[1-59]|1[1-3])|30[1-9]))',
    '796' => '(?:(?:0(?:0(?:5[1-6]|0[0-5]|[478][1-8]|1[0-4]|3[1-7]|[26][1-9])|8(?:1[1-6]|0[1-5]|2[1-3])|9(?:0[1-9]|1[0-5])|3(?:1[1-3]|0[0-8])|1(?:70|1[12])|50[1-6]|20[1-5]|61[1-5]|42[12])|80(?:60|2[05]|0[1-8]|3[05-9]|5[0-4]|4[01]|1[015])))',
    '797' => '(?:(?:1(?:7(?:0[1-5]|1[1-7])|32[1-8]|50[1-8]|60[1-8]|10[1-7]|21[1-7]|43[1-4])|0(?:0(?:3[0-7]|4[1-6]|[01][0-8]|2\d)|11[1-3]|20[1-3])))',
    '798' => '(?:(?:1(?:3(?:6[1-7]|[12][1-4]|0[0-3]|[47][1-5]|5[1-6]|3[1-3])|1(?:[02][1-5]|1[1-6]|4[1-3]|3[1-9])|50[1-7])|0(?:0(?:[6-8][0-8]|4[0-5]|5[0-4]|[39]\d|[0-2][0-7])|10[1-4]|21[12])|4(?:1(?:10|[23][1-6]|0[0-5])|2(?:[01][1-9])|3(?:5[1-3]|4[1-9])|40[1-8])|3(?:3(?:[35][1-8]|6[1-4]|[0-2][1-3]|4[1-6])|70[1-8]|27[12])|21(?:46|0[0-6]|1[1-3])))',
    '799' => '(?:(?:3(?:4(?:70|[13][1-3]|5[1-6]|2[12]|0[1-7]|[46][1-4])|7(?:[1-3]0|0[1-7]|[57][12]|[46][1-3])|1(?:2[1-8]|0[0-5]|3[1-6]|1[1-5])|31[1-4]|20[127])|2(?:4(?:2[1-6]|[05][1-8]|[136]\d|4[1-7])|1(?:0[1-9]|1[0-8]|2[1-3])|6(?:5[1-6]|4[1-9]|6[12])|3(?:0[1-9]|1[0-2])|20[1-9])|1(?:3(?:[056][1-4]|1[1-7]|7[12]|3[1-6]|[24][1-5])|5(?:[023][1-7]|1[1-4])|1(?:0[1-8]|1[12])|60[1-8])|0(?:4(?:0[0-5]|3[1-6]|[12][1-3])|1(?:[01][1-3]|2[1-8])|7(?:[12][1-4]|0[1-5])|6(?:50|4[1-5])|30[1-4])))',
    '800' => '(?:0(?:0(?:3\d|0[0-8]|[14][1-8]|5[1-7]|6[1-4]|2[1-9])|3(?:2[1-4]|5[1-7]|3[1-8]|6[1-6]|[14][1-5]|0[0-6])|2(?:0[1-9]|3[1-7]|[12]\d|[45][1-8])|1(?:0[12]|1[1-8])))',
    '801' => '(?:08(?:[2578][1-6]|6[1-5]|0[1-58]|[13][1-4]|4[12]))',
    '802' => '(?:0(?:0(?:[48][1-5]|[256][1-6]|7[1-7]|0[0-8]|[13][1-8]|9[12])|8(?:0[1-5]|[12][1-6]|3[1-8]|4[12])|9(?:8[1-6]|7[1-9])))',
    '803' => '(?:0(?:8(?:[1-3][1-8]|[45][1-6]|[06][1-5])|2(?:6[1-8]|7[1-9])|18\d))',
    '804' => '(?:00(?:3[1-3]|[12][1-5]|0[0-4]|[67][1-7]|[4589][1-4]))',
    '805' => '(?:00(?:71|[05]\d|3[1-8]|2[1-7]|[146][1-9]))',
    '806' => '(?:00(?:0[0-6]|[4-6][1-9]|3\d|[12][1-8]))',
    '807' => '(?:(?:0(?:8(?:6[1-8]|[03-5][1-7]|[27][1-9]|1[1-5])|0(?:31|1[12]|[47][1-8]|5[1-6]|[28][1-5]|0[0-7])|1(?:[1-4][1-3]|0[0-2]))|1(?:1(?:5[1-4]|[34][1-6]|[12][1-5]|0[1-3])|3(?:1[1-5]|0[0-8])|26[1-5])))',
    '808' => '(?:0(?:0(?:5[1-5]|[36][1-6]|[1247][1-7]|0[0-8])|1(?:75|0[1-689]|1[1-3]|3[1-9]|2[1-4]|4[1-8])))',
    '809' => '(?:00(?:41|2[1-8]|0[0-4]|3\d|1[1-9]))',
    '810' => '(?:0(?:0(?:2[1-9]|[36][1-7]|1[1-8]|0[0-5]|7[1-6]|[45][1-5])|80[12]))',
    '811' => '(?:(?:5(?:1(?:1[1-7]|4[1-4]|6[1-3]|0[0-7]|[25][1-5]|3[1-6])|5(?:01|[45][1-6]|[1-3][1-3])|2(?:0[1-4]|2[1-6]|1[1-5])|7(?:5[1-7]|[34][1-4])|3(?:01|[12][1-6])|46[1-8])|3(?:1(?:1[1-8]|[23][1-7]|0[0-7])|4(?:40|3\d|0[0-8]|2[1-5]|1[1-6])|5(?:1[1-6]|2[12]|0[1-7])|2(?:[02]\d|1[1-9])|3(?:0[1-9]|1[12])|701)|4(?:1(?:13|[57][1-7]|4[1-35-8]|6[1-6]|8[1-5])|2(?:2\d|4[12]|1[1-8]|0[0-5]|3[1-9])|3(?:[14][1-3]|0[0-7]|[23][1-4]))|1(?:2(?:2[1-4]|0[0-4]|[13-5][1-6])|3(?:0[23]|6[1245]|5[1-6]|4[3-7]|[12][1-4])|1(?:[1-3][1-4]|0[1-3]))|2(?:1(?:3[12]|0\d|2[1-9]|1[1-5])|2(?:21|4[1-8]|0\d|3[1-3])|4(?:1[1-6]|0[0-5])|3(?:[01]\d)|50[0-3])|0(?:1(?:[02][0-4]|1\d)|2(?:[01][1-6])|32[1-5])))',
    '812' => '(?:0(?:0(?:2\d|0[0-8]|1[1-8]|[36][1-9]|5[1-5]|4[1-6])|8(?:7[1-9]|9[1-7]|5[1-578]|8[1-8]|6[1-3])))',
    '813' => '(?:00(?:62|0[0-58]|1[1-9]|2[13-5]|3[1-6]|4[1-5]))',
    '814' => '(?:0(?:1(?:7[1-7]|[134][1-4]|0[0-6]|2[1-3]|[56][1-5])|0(?:0[0-6]|2[1-3]|[13][1-5])))',
    '815' => '(?:00(?:63|4[128]|7[1-5]|0[014]|8[1-4]|3[1-8]))',
    '816' => '(?:0(?:8(?:4[1-9]|[167][1-4]|0[1-7]|3[1-3]|2[1-6]|5[1-5])|9(?:[478][1-3]|3[1-5]|[05][1-6]|1[12]|[26][1-4])|000))',
    '817' => '(?:(?:1(?:2(?:23|1[2-4]|3[1-4]|5[1-7]|4[156]|0[12])|7(?:0[1-4]|[12][1-5])|5(?:[13][1-3]|2[1-5])|10[1-7]|30[1-7]|41[1-3]|60[1-3])|0(?:0(?:2[1-4]|0[0-356]|1[1-6]|3[1-5])|24[1-8]|15[1-7]|32[1-6]|43[1-5]|51[1-4])|2(?:24[1-3]|33[1-3])))',
    '818' => '(?:0(?:0(?:[17][1-4]|5[1-9]|4[1-7]|[23][1-6]|8[1-5]|6[13-8]|0[0-7])|1(?:3[1-9]|0[0-5]|2[1-5]|1[01457-9])))',
    '819' => '(?:(?:1(?:1(?:5[1-6]|[1-3][1-9]|4[1-7]|0[0-8])|3(?:[03][1-6]|[12][1-5])|6(?:[03]1|1[1-6]|4[12]|2[1-7])|5(?:8[1-3]|7[1-5]|6[1-4]))|0(?:0(?:3\d|[125][1-5]|4[1-6]|0[0-25-7])|3(?:7[1-9]|8[1-8]|6[67])|16[1-9]|20[1-5])))',
    '820' => '(?:(?:0(?:0(?:3[1-3]|1[1-8]|2[12]|0[0-5]|[47]\d|5[1-4]|[68][1-9])|3(?:2[1-3]|0[1-6]|3[1-7]|1[1-4])|1(?:[01][1-6])|7(?:1[1-3]|0[1-9])|20[0-7]|50[1-6]|60\d)|11(?:1[1-4]|0[0-6])))',
    '821' => '(?:00(?:1[1-4]|0[24]))',
    '822' => '(?:(?:0(?:0(?:0[0-8]|[12][1-7]|3[1-4])|1(?:01|[23][1-4]|[15][1-3]|4[1-6]))|1(?:3(?:1[1-8]|0[0-7]|2[1-6])|2(?:0[0-2]|1[12])|40[0-6]|10[1-3])))',
    '823' => '(?:00(?:0[0-5]|1[1-7]))',
    '824' => '(?:0(?:0(?:0[0-8]|[1-356][1-8]|[47][1-9])|2(?:2[1-6]|3[1-5]|[45][1-4]|[01][1-7])|1(?:0[1-7]|[12][1-5])|8(?:0[0-2]|1[1-8]|2[12])|4(?:00|11|3[12])|5(?:00|1[12])|60[0-4]|72[1-3]))',
    '825' => '(?:00(?:1[1-8]|0[0-5]))',
    '826' => '(?:00(?:02|2[1-7]|3[1-3]|4[1-5]))',
    '827' => '(?:000[0-4])',
    '828' => '(?:00(?:[3568][1-6]|1[1-3]|7[1-7]|4[1-9]|0[0-5]|2[1-8]))',
    '829' => '(?:0(?:3(?:[24][1-3]|[013][1-5])|1(?:51|1[1-7]|0[0-8]|2[1-5])))',
    '830' => '(?:(?:0(?:0(?:[2-5][1-9]|7\d|1[1-8]|[06][1-6])|2(?:0[1-7]|[12][1-6])|4(?:1[1-7]|2[1-5]|0[0-6])|1(?:0[1-5]|1[1-6]))|1(?:1(?:[0-2][1-7])|2(?:1[1-4]|0[0-6]|2[1-6]))))',
    '831' => '(?:00(?:1[1-7]|2[1-8]|0[0-8]|[34][1-5]))',
    '832' => '(?:0(?:0(?:0[0-7]|4[1-6]|5\d|1[1-8]|[37][1-7]|[268][1-9])|8(?:1[1-6]|0[1-7]|2[1-8])))',
    '833' => '(?:00(?:5[1-6]|0[0-7]|[1-4][1-7]))',
    '834' => '(?:(?:0(?:0(?:3[1-4]|[46][1-7]|[12][1-6]|[578][1-5]|0[0-6])|1(?:1[1-5]|2[1-3]|0[0-5])|201)|1(?:2(?:1[1-7]|2[12]|0[1-5])|10[1-4]|40[12])))',
    '835' => '(?:0(?:0(?:2[1-5]|0[0-7]|1[1-9])|1(?:1[1-5]|3[1-6]|0[1-4])))',
    '836' => '(?:0(?:0(?:0[0-7]|[1-9][1-7])|8(?:[0-79][1-7]|8[1-6])))',
    '837' => '(?:09(?:2[1-8]|0[1-7]|1[0-7]))',
    '838' => '(?:(?:0(?:0(?:0[0-5]|4[1-8]|7[12]|2\d|[1356][1-9])|1(?:[23][1-8]|0\d|4[1-4]|1[1-6])|2(?:1[1-5]|2[1-8]|0[1-7])|8(?:0[1-4]|1[1-7]|2[1-5]))|1(?:5(?:21|1[1-5]|0[1-7])|3(?:[01][1-7])|70[0-2]|60[12])))',
    '839' => '(?:(?:0(?:8(?:0[1-9]|[1-3][1-7]|6[1-5]|[45][1-3])|2(?:[0-2][1-5]|[4-6][1-4])|000)|1(?:2(?:3[1-4]|2[1-8]|[01][1-6])|3(?:21|3[1-3]|4[1-4]|0[1-8]|1[12])|4(?:21|0[0-8]|1[1-5]))))',
    '840' => '(?:(?:0(?:0(?:0[1-8]|[2-4][1-7]|1[1-35-7]|5[1-6])|8(?:5\d|[36][1-4]|4[1-5]|[0-2][1-6])|5(?:2[12]|0[1-4]|3[1-7]|1[1-6]|4[1-5])|2(?:[01][1-5]))|2(?:2(?:1[1-4]|0[1-5]|2[1-3])|10[1-6])|110[1-6]))',
    '841' => '(?:0(?:0(?:2[1-7]|[38][1-9]|0[0-5]|[146][1-8]|[57][1-6])|20[0-5]))',
    '842' => '(?:0(?:0(?:6[1-8]|5[1-6]|[13][1-5]|0[0-7])|1(?:2[1-3]|0[1-47])|20[1-3]|30[1-3]))',
    '843' => '(?:0(?:0(?:0[0-3]|[12][1-4])|30[0-5]|23[1-4]|15[1-3]))',
    '844' => '(?:00(?:0\d|[12][1-8]))',
    '845' => '(?:00(?:[23][1-5]|0[0-5]|1[1-4]))',
    '846' => '(?:00(?:[34]1|1[1-4]|2[1-5]|0[0-7]))',
    '847' => '(?:(?:0(?:0(?:[78][1-5]|5[1-6]|0[0-5]|2[1-8]|[146][1-7]|3[1-4])|8(?:[258][1-5]|7[1-6]|6[1-3]|1[1-7]|[034][1-4])|1(?:[02][1-4]|3[1-6]|1[1-5])|3(?:0[1-6]|[12][1-7])|40[1-6])|1(?:4(?:0[0-5]|[23][1-5]|[14][1-6])|5(?:[0-2][1-7])|2(?:1[1-4]|0[1-3]|2[1-5])|10[1-8])))',
    '848' => '(?:0(?:0(?:3[1-5]|1[1-6]|0[0-7]|4[1-7]|2[1-8])|1(?:4[1-6]|[02][1-5]|3[1-4]|1[1-7])|40[1-8]))',
    '849' => '(?:(?:0(?:9(?:0[1-6]|1[1-9]|[23][1-8])|1(?:0[0-2]|[12][1-4])|3(?:[01][1-6])|50[0-6]|20[1-5]|40[1-3]|000)|1(?:4(?:[12][1-6]|0[1-4])|3(?:1[1-5]|2[1-4]|0[0-4])|1(?:1[1-6]|0[0-6])|6(?:0[0-3]|1[1-6])|2(?:21|0[1-8]))|4(?:1(?:[4-7][1-6])|2(?:[58][1-6]|[67][1-4]))|3(?:2(?:1[1-9]|2[1-4]|[03][1-3])|1(?:1[1-5]|[23][1-3]|0[1-4]))|5(?:1(?:31|0[1-5]|1[1-3]|2[1-4])|2(?:6[1-4]|5[1-7]))|2(?:3(?:0[1-5]|4[12])|20[1-4]|10[0-2])))',
    '850' => '(?:0(?:9(?:1[1-8]|[347][1-7]|[256][1-4]|0[1-9]|8[1-5]|9[1-6])|0(?:[14-6][1-8]|3[1-7]|[27][1-9]|0[0-7])|8(?:5[1-5]|[14][1-3]|[02][1-4]|[37][1-7]|6[12])))',
    '851' => '(?:(?:2(?:1(?:11|3[01]|2[1-9]|0[0-8])|4(?:2[1-7]|0[13-5]|1[13])|2(?:1[1-6]|0[1-7])|32[1-7])|0(?:1(?:[12][1-6]|0[1-4]|3[1-7])|2(?:[45][1-5])|3(?:10|0[12])|40[1-8]|50[1-7])|3(?:3(?:0[1-6]|1[1-5])|4(?:06|2[1-5])|5(?:11|0\d)|21[1-5]|10[1-3])|1(?:1(?:3[1-7]|2[1-5])|201|315)))',
    '852' => '(?:8(?:0(?:6[1-5]|[35][1-6]|[124][1-7]|0[1-8])|1(?:4[1-6]|[235][1-7]|[01][1-8])))',
    '853' => '(?:(?:0(?:0(?:6[1-6]|3[1-3]|0[0-7]|2[1-7]|[45][1-4]|1[1-8])|2(?:0[1-8]|1[1-5])|6(?:1[1-3]|0[1-9])|50[1-8]|70[1-6]|31[1-3]|41[1-3])|2(?:3(?:[01][1-5])|17[1-4]|20[1-4]|48[12])|3(?:32[1-3]|10[12])))',
    '854' => '(?:(?:0(?:0(?:[19][1-6]|0[0-7]|6[1-9]|[24578][1-7]|3[1-8])|5(?:0[0-5]|1[1-7])|20[1-9]|40[1-7]|12[1-6]|70[1-3]|30[12]|621)|11(?:[02][1-5]|1[1-4])))',
    '855' => '(?:0(?:8(?:4[1-3]|[35][1-6]|2[1-5]|[07][1-9]|[168][1-7])|0(?:3[1-68]|[24][1-6]|5[1-9]|[167][1-8]|0[0-8])))',
    '856' => '(?:0(?:8(?:2\d|1[1-8]|0[1-9]|[34][1-7])|0(?:3[1-5]|4[1-8]|[02]\d|1[1-9])))',
    '857' => '(?:(?:0(?:0(?:71|0[01]|[56][1-9]|[1-3][1-8]|4\d)|8(?:[14][1-3]|0[1-6]|5[1-5]|2[12]|[36][1-4]|7[1-9])|3(?:00|61|1[1-5]|5[1-3]|[24][1-4]|3[1-8])|1(?:[02-4][1-6]|1[1-5])|4(?:31|1[1-4]|0[1-6]))|4(?:4(?:1[1-6]|0[0-245])|7(?:1[12]|0\d)|81[1-6]|21[1-4]|51[1-4]|60[1-4]|90[1-4]|10[1-3])|2(?:3(?:2[1-8]|1[12]|0[1-7])|4(?:1[1-37-9]|2[1-7]|0[1-35])|22[1-3]|53[12])|1(?:1(?:5[1-3]|[67][1-6])|23[1-5])|3(?:(?:27|31)1|10[1-3])))',
    '858' => '(?:09(?:31|65|[01][1-8]|2[1-6]))',
    '859' => '(?:(?:3(?:2(?:4[1-4]|3[1-7]|[12][1-6]|0[1-5])|7(?:0[0-6]|1[1-6]|2[1-8])|6(?:0[0-8]|1[1-9])|1(?:6[1-6]|5[1-8])|9(?:2[1-9]|3[1-3])|8(?:0\d|1[12])|45[1-4])|5(?:1(?:3[1-4]|1[1-8]|0[0-4]|4[1-5]|[25][1-3])|5(?:2[1-7]|[03][1-5]|1[1-6])|3(?:8[1-4]|[67][1-6])|70[1-7]|80[1-6])|4(?:5(?:0[0-7]|3[1-6]|1[1-8]|2[1-9])|7(?:6[1-9]|[57][1-8]|4[1-5])|8(?:1[1-5]|[02][1-7])|30[1-9])|0(?:1(?:71|0[1-6]|3[1-3]|5[1-4]|[1246][1-7])|4(?:1[1-8]|0[1-7])|3(?:1[1-5]|0[1-7]))|6(?:1(?:[02][1-6]|[14][1-5]|3[1-4])|3(?:1[1-7]|0[1-5]|2[1-6])|4(?:1[1-5]|0[1-9])|20[1-7])|1(?:3(?:2[1-5]|1[1-7]|0[1-8])|1(?:0[1-7]|1[1-6])|2(?:[01][1-6])|4(?:1[1-5]|0[1-4])|50[1-5])|2(?:2(?:[01][1-6])|1(?:[12][1-3])|3(?:16|0[1-6])|60[0-6]|41[1-6]|50[1-4])))',
    '860' => '(?:0(?:0(?:[0468][1-8]|[1-357][1-9])|8(?:[014][1-8]|3[1-4]|6[1-3]|[25][1-6])))',
    '861' => '(?:(?:0(?:5(?:0[01]|[57][1-6]|[36][1-5]|4[1-8]|1[1-9]|2[1-7])|1(?:[03-5][1-6]|6[1-5]|[12][1-7])|8(?:0[0-5]|3[1-7]|2[1-3]|1[1-5])|3(?:31|[02][1-4]|8[12]|1[1-6])|4(?:1[1-4]|[02][1-6])|9(?:[12][1-5]|0[1-6])|60[1-5]|000)|4(?:1(?:7[1-3]|0[1-689]|[1-6][1-7])|7(?:1[1-6]|0[0-7]|2[1-35-7]|3[1-7])|2(?:1[1-5]|[02][1-6]|3[1-7])|4(?:[0-2][1-7])|6(?:3[1-5]|2[1-3]|1[1-8]|0\d)|30[1-7])|3(?:5(?:1[1-8]|0[0-3]|3[1-4]|4[1-7]|2[1-6])|9(?:[02][1-8]|3[1-7]|1[1-6])|8(?:1[1-3]|0[1-6]|[34][1-5])|2(?:11|0[0-8]|4[1-5])|6(?:7[1-3]|6[1-5])|4(?:21|5[1-5])|78[1-9]|1(?:31|0\d)|32[1-3])|1(?:3(?:31|[15][1-7]|6[1-8]|0\d|[24][1-6])|1(?:0[0-5]|1[1-6])|2(?:0[1-5]|1[1-4])|6(?:8[1-6]|7[1-3])|44[12])|5(?:5(?:2[1-6]|0[1-4]|[13][1-7])|2(?:7[1-4]|[56][1-5]|8[0-24-9])|34[1-8]|40[1-6])|2(?:2(?:1[12]|[24][1-4]|0[0-6]|3[1-6])|1(?:18|0[1-8])|40[0-5])|80(?:4[1-6]|7[1-5]|0[1-35-7]|3[01457-9]|2[89]|6[4-68]|8[1-4]|1[0-79])|6(?:10[1-5]|30[1-5]|40[1-3]|551)|7(?:20[1-4]|31[1-4])))',
    '862' => '(?:09(?:33|2[0-6]|5\d|1[0-8]|7[0-356]|6[0-35-9]|[04][1-9]))',
    '863' => '(?:(?:0(?:0(?:50|2[1-5]|0[0-7]|[14][1-9]|3[1-8])|10[1-3])|1(?:2(?:0[1-5]|1[1-6])|4(?:3[12]|0[134])|1(?:61|1[12])|(?:51|72)1|90[12])|2(?:(?:20|33|61)1|1(?:14|7[12])|50[0-7]|80[1-6]|42[14])))',
    '864' => '(?:0(?:0(?:5[1-7]|4[12]|1[1-5]|3[1-3]|0[0-6]|2[1-35-7])|1(?:31|6[1-6])))',
    '865' => '(?:0(?:0(?:6[1-6]|3[1-5]|7[1-3]|2[1-7]|[145][1-8]|0\d)|1(?:1[1-7]|0[0-4]|[23][1-6])))',
    '866' => '(?:0(?:8(?:[46][1-6]|[018][1-5]|9[1-8]|3[1-4]|[257][1-7])|0(?:[3-68][1-5]|0[0-8]|1[1-7]|[27][1-4])|3(?:[01]3|34)|20[1-3]|10[12]))',
    '867' => '(?:0(?:0(?:[45][1-9]|6[1-8]|0\d|[13][1-6]|2[1-5])|1(?:16|7[1-4])|28[1-4]))',
    '868' => '(?:0(?:0(?:[16][1-6]|9[1-5]|[457][1-8]|0[0-8]|[238][1-7])|4(?:15|51|3[12]|0[08]|4[1-4]|2[1-5])|6(?:0[0-7]|2[1-5]|1[1-6])|8(?:2[1-5]|[01][1-3])|50[0-5]|20[0-3]|30[0-3]|70[0-3]|101))',
    '869' => '(?:(?:0(?:4(?:5[1-7]|0[0-8]|1\d|[23][1-6]|[46][1-5])|5(?:[16][1-3]|4[1-6]|[235][1-4]|0[0-3])|6(?:2[1-4]|[013][1-6])|2(?:3[1-68]|[01][1-3]|2[1-4])|1(?:0[0-6]|[12][1-3])|3(?:2[12]|0[0-5]|1[1-3]))|5(?:1(?:[34][1-8]|[57][1-5]|6[1-6])|4(?:00|61|4[1-3]|[235][1-4])|5(?:7[1-6]|6[1-4])|30[1-7]|60[0-5]|22[1-5])|4(?:2(?:[0-2][1-5])|6(?:1[1-6]|0[0-8])|8(?:1[1-5]|0[1-6])|7(?:0[1-4]|2[1-3])|5(?:01|1[1-5])|30[1-4]|40[1-3])|1(?:2(?:0[0-8]|[23][1-7]|1[1-9])|8(?:2[1-6]|1[1-5])|4(?:0[0-4]|1[12])|1(?:0\d|1[0-5])|50[1-5]|60[0-3])|2(?:2(?:05|3[1-7]|2[1-6])|3(?:0[1-7]|1[1-6])|6(?:21|1[1-3]|0[0-4])|4(?:13|0[0-3])|50[0-6]|80[1-7]|70[0-5])|6(?:1(?:[01][1-5])|2(?:1[1-6]|0[45])|30[1-8]|40[0-5])|3(?:4(?:[17][1-3])|20[1-7]|17[1-5]|60[0-4]|711)))',
    '870' => '(?:(?:0(?:8(?:[2578]\d|[01346][1-9])|9(?:61|0[1-8]|[1-5][1-9])|1(?:7[1-4]|[34][1-9]|[16][1-8]|[025]\d)|0(?:3\d|1[1-8]|[024][1-9])|3(?:[01][1-9]|2[1-7])|2(?:5[1-4]|6[135-8]|7\d|4[1-5]))|1(?:1(?:[15]\d|7[1-467]|[46][1-8]|2[0-68]|[03][1-9])|2(?:2[1-3]|[01][1-5]))))',
    '871' => '(?:0(?:0(?:1[1-6]|[247][1-9]|5[013-9]|[03689]\d)|1(?:22|[16][1-4]|5[1-7]|0[1-5])|4(?:[13][1-4]|0[1-8]|2[12])|9(?:1[1-4]|2[1-8]|0[0-7])|8(?:11|2[1-3]|3[1-4]|0[12])|7(?:1[1-6]|0[1-4])|2(?:26|0[1-8])|31[1-5]))',
    '872' => '(?:(?:0(?:3(?:66|3[1-4]|0[12]|[12][1-8]|4[1-6])|0(?:4[1-7]|1[1-6]|0[01]|[23][1-3])|4(?:5[1-9]|8[1-4]|6[1-6]|7[1-3])|8(?:5[1-8]|6[1-5]|[47][1-3])|5(?:4[1-3]|1\d|[02][1-7])|7(?:2[1-4]|1[12]|[03][1-3])|6(?:6[1-4]|[57][1-5])|1(?:[01][1-4]))|1(?:6(?:5[1-3]|1[1-4])|10[1-7]|20[1-7]|40[1-6]|32[1-4]|501)))',
    '873' => '(?:0(?:0(?:41|53|0[0-8]|3[1-4]|[12][1-5])|5(?:0[0-4]|[12][1-4]|3[1-5])|2(?:[13][12]|0[1-7]|2[1-4])|4(?:32|2[1-4]|0[124-7]|1[245])|35[1-6]|64[1-6]))',
    '874' => '(?:0(?:0(?:3[1-7]|0[0-5]|2[1-5]|[14][1-6])|8(?:[24]\d|[13][1-9]|0[1-5])|9(?:[1-3]\d|0[1-9]|4[1-7])))',
    '875' => '(?:0(?:0(?:6[1-5]|[1245][1-3]|[38][1-4]|7\d|0[0-4])|2(?:3[1-7]|2[1-4]|1[1-6]|0[1-3])|3(?:23|5[1-3]|4[1-4])))',
    '876' => '(?:(?:0(?:0(?:5[1-3]|[2-4][1-7]|6[1-4]|0[0-8]|1[1-8])|8(?:3[1-6]|[12][1-5]|4[1-9]|[05][1-7])|1(?:[01][1-3]|2[1-6])|2(?:[01][1-6]))|1(?:3(?:1[1-3]|0[16])|10[1-6]|20[1-6]|40[1-5]|51[1-3])|2(?:40[1-7]|20[1-3]|30[12]|121)))',
    '877' => '(?:(?:0(?:0(?:[14][1-7]|[358][1-9]|0[0-8]|[67][1-8]|2[1-6])|2(?:21|[01][12])|3(?:[01][12])|11[1-4])|1(?:3(?:7[1-5]|6[1-6]|[58][1-4])|2(?:2[1-5]|[34][1-4])|1(?:21|1[1-3]|0[1-7]))))',
    '878' => '(?:0(?:0(?:2[1-8]|3[1-5]|1[1-3]|0[0-7])|1(?:[45][1-6]|6[1-4])|2(?:56|0[1-6])|57[1-6]|40[1-4]))',
    '879' => '(?:(?:0(?:1(?:[15][1-3]|0[1-7]|[26][1-4])|4(?:[56][1-7]|[47][1-4])|6(?:1[1-9]|0\d|2[1-8])|3(?:1[1-7]|0[1-9])|2(?:2[1-5]|3[1-7])|5(?:0[1-4]|1[1-6])|7(?:2[1-4]|3[1-5])|8(?:4[1-4]|5[1-5])|9(?:41|0[1-4]|1[12]))|6(?:1(?:2[1-8]|1[1-356]|[08][1-4]|3[1-5])|6(?:0[12]|4[1-3]|3[1-5]|[12][1-6])|4(?:[34][1-5]|2[1-6]|0[1-8])|9(?:1[1-4]|2[12]|0[1-5])|2(?:1[1-3]|2[1-4]|0[12])|75[1-9]|86[1-5]|33[1-4])|7(?:1(?:[13]1|0[0-8]|4[1-4]|[25][1-5])|3(?:0[1-7]|1[1-6])|8(?:[78][1-5])|4(?:[01][1-4])|76[1-5]|26[1-4]|50[1-4])|2(?:4(?:61|0[01]|[347][1-6]|1[1-3]|5[1-9]|2[12])|6(?:[08][1-3])|11[1-5]|20[1-3]|501)|4(?:4(?:0[0-6]|1[1-4])|7(?:32|2[1-4])|3(?:01|3[12])|6(?:01|3[12])|80[0-3]|12[1-3]|20[1-3]|52[1-3]|91[12])|5(?:4(?:3[1-7]|0[0-8]|2[1-5]|1[1-3])|5(?:1\d|[35][12]|0[1-46]|2[1-5])|1(?:[01][1-4]))|1(?:1(?:[23][1-8])|3(?:1[1-6]|0[1-7])|50\d)|3(?:10[1-5]|20[1-5]|30[12]|40[12])))',
    '880' => '(?:(?:0(?:8(?:7[1-9]|3[1-7]|[156][1-8]|[02][1-6]|4[1-5])|0(?:0[0-7]|[1-5][1-7])|9(?:5[1-6]|3\d|[02][1-9]|[14][1-7])|3(?:4[145]|0[1-3])|2(?:04|1[1-4])|12[1-5])|2(?:2(?:[23][1-4]|1[1-5])|1(?:1[1-6]|0[1-5])|3(?:03|2[1-35]))|1(?:1(?:21|1[1-4]|0[0-8])|22[1-4]|30[0-3])))',
    '881' => '(?:(?:0(?:0(?:[23][1-7]|0[0-6]|1[1-6])|1(?:[01][1-6]))|1(?:4(?:00|1[1-4])|12[1-3]|23[1-3]|30[1-3])))',
    '882' => '(?:(?:0(?:0(?:[1-57-9][1-7]|6[1-6]|0[0-7])|8(?:1[1-6]|[08][1-5]|[2-7][1-7])|1(?:0[1467]|2[1-9])|2(?:4[1-5]|3[1-8])|40[0-3]|30[124])|1(?:41[1-5]|10[0-3]|20[0-3]|62[12])))',
    '883' => '(?:(?:0(?:0(?:0[0-6]|5[1-3]|1[1-5]|4[1-6]|[36][1-8]|2[1-4])|1(?:11|0[1-9])|30[1-6]|21[1-3]|402)|1(?:60[0-4]|10[0-2]|30[0-2]|21[12]|402)))',
    '884' => '(?:0(?:00[0-6]|10[0-5]))',
    '885' => '(?:(?:0(?:0(?:[59][1-5]|[28][1-6]|0[0-6]|3[1-7]|[17][1-9]|[46][1-4])|22[1-5]|11[1-4])|1(?:10[1-5]|20[1-5]|31[12])))',
    '886' => '(?:0(?:1(?:01|1[1-5])|2(?:03|1[1-3])|00\d))',
    '887' => '(?:0(?:0(?:41|0[0-7]|[23][1-4]|1[1-7])|1(?:11|0[12])))',
    '888' => '(?:0(?:0(?:0\d|1[1-3])|22[12]))',
    '889' => '(?:(?:1(?:4(?:0[0-6]|1[1-5])|6(?:1[1-3]|0[1-9])|9(?:1[1-4]|0[0-7])|7(?:1[36]|0[1-3])|1(?:[02]1|1[12])|30[0-2]|80[1-3]|20[01])|4(?:2(?:2[12]|[34][1-4])|3(?:1[1-4]|0[0-6])|1(?:[56][1-5])|4(?:00|1[1-4])|50[1-6]|60[12])|0(?:6(?:2[1-6]|0[0-5]|1[1-7])|5(?:[01][1-7])|3(?:0[1-4]|2[12])|90[1-3]|10[12])|2(?:5(?:41|2[1-5]|3[1-6]|1[1-4])|1(?:6[1-4]|5[1-6])|40[1-3]|301)|3(?:2(?:[01][1-7])|1(?:4[1-3]|5[1-6])|53[1-4]|311)))',
    '890' => '(?:0(?:0(?:[12578][1-6]|6[1-9]|4[1-7]|3[1-8]|0[0-8])|90[1-3]))',
    '891' => '(?:(?:0(?:1(?:75|5[01]|2[23]|3[1-3]|0[1-9]|1[1-7]|4[13-6])|5(?:0[1-7]|1[1-6])|6(?:14|21|0[1-4])|3(?:04|1[1-5])|40[0-6]|20[1-6]|70[1-5]|91[12])|1(?:4(?:20|0[1-3]|1[1-9])|2(?:22|31|7[45]|0[1-6])|5(?:01|4[1-5])|10[1-8]|30[1-6])|9(?:1(?:[13][1-6]|2[1-5]|0[0-4])|2(?:[23][1-4]|0[0-7]|1[1-5])|30\d)|6(?:2(?:1[1-7]|0[0-3]|2[1-9]|3[1-3])|1(?:[4-6][1-4]))|3(?:1(?:1[1-8]|0[0-4])|2(?:02|2[12])|60[0-7]|70[0-6]|43[12])|7(?:6(?:2[1-4]|1[12]|0[0-5])|1(?:0[0-5]|1[1-6])|42[1-6]|731)|2(?:1(?:[12][1-7]|0[0-6])|3(?:1[1-4]|2[12]|0[1-6]))|8(?:3(?:00|2[1-9])|2(?:[02]1|16)|11[1-7])|4(?:20[0-8]|40[1-9]|31[12])|5(?:20[0-5]|[13]01)))',
    '892' => '(?:08(?:[07][1-7]|1[1-9]|[2-4][1-8]|5[1-5]|6[1-3]))',
    '893' => '(?:(?:0(?:0(?:1[1-6]|0\d|[2-6][1-7])|20[1-3]|13[12])|1(?:6(?:0[0-5]|1[1-5])|20[0-7]|10[1-3]|40[12]|511)|2(?:50[0-5]|30[0-3]|60[1-4]|40[12])))',
    '894' => '(?:(?:0(?:0(?:4[1-8]|0\d|6[1-38]|[12][1-7]|3[1-6])|3(?:3[1-3]|5[12]|2[1-4])|5(?:1[1-3]|0[1-8])|10[0-8]|62[1-7]|77[1-6]|41[12])|1(?:5(?:31|2[1-4]|0\d|1[0-5])|11[1-6]|3(?:04|21)|74[1-6]|20[1-5]|85[1-5])|2(?:4(?:0[1-4]|1[1-7])|23[1-7]|14[1-4]|32[1-3]|50[12]|601)|3(?:10[0-7]|30[0-5]|21[1-4]|41[1-3]|52[1-3]|63[1-3])))',
    '895' => '(?:(?:0(?:0(?:[267][1-7]|4[1-4]|[35][1-6]|1[1-3]|0[0-7])|21[1-4]|13[1-3])|2(?:5(?:0[0-7]|1[1-3]|2[1-9])|1(?:31|0[1-4])|70[1-8]|63[1-5]|20[1-3]|81[1-3]|44[12])|1(?:8(?:1[1-7]|0[0-7])|10[1-6]|50[1-4]|20[1-3]|72[1-3]|40[12])))',
    '896' => '(?:(?:00(?:2[1-8]|5[124-8]|[13][1-7]|[67][1-9]|0[0-6]|4[1-6])|1(?:2(?:81|0[1-6])|5(?:12|21)|41[12]|60[12]|[13]01)))',
    '897' => '(?:(?:0(?:2(?:2[1-4]|0[0-5]|1[1-5])|0(?:31|0\d)|30[1-6]|13[1-3])|1(?:12[1-5]|30[12]|201)))',
    '898' => '(?:0(?:0(?:[08]\d|[135][1-8]|[249][1-9]|[67][1-6])|2(?:21|1[12])|10[12]))',
    '899' => '(?:(?:5(?:4(?:2[12]|0[0-5]|1[1-4]|3[1-3])|2(?:[34]1|0[1-4]|1[1-5]|2[1-3])|1(?:21|1[1-8]|0[1-6])|30[1-8]|65[1-6]|54[1-5])|4(?:3(?:2[1-5]|[45][1-6]|0[0-5]|3[12]|1[1-8])|20[1-4]|50[1-4]|10[1-3]|46[1-3]|63[1-3])|1(?:6(?:2[1-9]|1[1-7]|0[0-4])|3(?:21|0[1-4])|(?:13|50|74)1|92[1-5]|40[0-3]|21[12]|80[12])|2(?:5(?:31|2[1-4]|0[0-6]|1[1-6])|4(?:21|4[1-3]|3[1-4])|70[1-9]|20[1-4]|10[1-3]|311)|0(?:2(?:0[0-8]|1[1-7])|1(?:2[1-6]|3[1-46-8])|4(?:35|0[1-7])|34[12]|50[12])|3(?:3(?:11|0[1-9])|1(?:21|0[1-3])|2(?:21|0[36])|51[1-6]|40[1-5]|611)|6(?:20[0-7]|50[1-7]|10[1-5]|40[1-5]|60[1-4]|30[1-3])|7(?:5(?:03|1[1-3])|10[0-4]|40[1-3]|60[1-3]|21[12]|30\d)|8(?:10[1-6]|42[1-4]|21[1-3]|31[1-3]|51[12]|60\d)))',
    '900' => '(?:00(?:1[1-6]|0[0-6]|3[1-7]|2[1-9]))',
    '901' => '(?:(?:0(?:3(?:0[0-6]|[124][1-5]|3[1-6]|[56][1-4])|2(?:[1-3][1-5]|4[1-4]|0[0-5])|6(?:0[1-8]|1[1-9])|1(?:5[1-6]|4[1-8])|4(?:0[0-6]|1[1-7])|5(?:0[1-4]|1[1-6]))|2(?:1(?:[13][1-4]|0[0-4]|2[1-8])|2(?:0[0-7]|1[1-6]|2[1-7])|4(?:2[1-4]|1[1-7]|0[0-7])|3(?:21|0[0-5]|1[1-7]))|3(?:1(?:0[0-8]|3[1-8]|[12][1-5])|80[0-6]|40[0-3]|70[0-3]|90[0-3]|50[0-2]|31[12]|601)|1(?:1(?:1[1-7]|0[0-5])|4(?:1[1-5]|0[0-7])|5(?:1[1-6]|0[1-5])|20[1-8]|30[0-4])))',
    '902' => '(?:00(?:6[1-9]|7[1-8]))',
    '903' => '(?:0(?:1(?:1[1-8]|0[0-5]|2[1-9])|8(?:[12][1-6]|0[1-7])))',
    '904' => '(?:(?:0(?:0(?:0[0-6]|2[1-3]|3[1-5]|1[1-4])|3(?:2[1-8]|0[0-5]|1[1-6])|1(?:0[0-7]|1[1-7])|4(?:0[0-4]|1[1-7])|20[0-5])|2(?:2(?:[14][1-5]|[23][1-6]|0[0-5])|1(?:7[1-4]|4[1-5]|[56][1-6])|3(?:[01][1-7])|42[1-8])|1(?:1(?:1[1-5]|0[1-8])|30[0-4]|20[0-3])))',
    '905' => '(?:(?:0(?:4(?:2[1-8]|0[0-6]|1[1-5])|2(?:[12][1-9]|0\d)|0(?:2[1-6]|1[1-9]|0\d)|50[0-5]|60[0-5]|70[0-5])|1(?:4(?:00|1[1-7]|2[1-9])|3(?:1[1-9]|0[0-8])|1(?:4[1-7]|5[1-6])|20[0-6]|63[1-5]|50[1-4])|2(?:26[1-9]|17[1-3])))',
    '906' => '(?:0(?:0(?:0[0-8]|1[1-5])|10[1-9]|50[1-7]|30[1-6]|20[1-4]|60[0-3]|42[12]))',
    '907' => '(?:(?:0(?:0(?:0[0-4]|[12][1-4])|24[1-4]|33[1-3]|45[1-3])|1(?:(?:10|22|31|75)1|43[1-5]|54[1-4]|80[01])))',
    '910' => '(?:(?:0(?:3(?:1[1-7]|8[1-4]|[346][1-9]|[07][1-5]|2[1-6]|5[0-7])|0(?:70|5[1-7]|[1-46][1-9]|0[1-6])|2(?:5[1-4]|[237][1-7]|0[0-8]|4[1-6]|[16][1-5])|8(?:4[1-6]|[025][1-9]|[13][1-8])|1(?:5[1-8]|[34][1-7]|2[1-4]|0[1-9]))|3(?:1(?:[1-4][1-8]|0[1-7])|6(?:1[1-7]|0[1-8]|[34][1-6]|2[1-3])|5(?:[15][1-8]|2[1-6])|2(?:5[1-6]|6[1-8])|3(?:7[1-8]|8[1-6])|40[1-5])|2(?:5(?:[1-35][1-7]|0[0-8])|1(?:[56][1-7]|[47][1-8])|3(?:4[1-8]|3[1-9]|5[1-7])|2(?:2[1-7]|1[1-4]|0[1-8])|4(?:6[1-6]|7[1-5]))|1(?:1(?:0[0-6]|4[1-4]|3[1-9]|2[1-7]|1[1-8])|2(?:0[1-6]|[12][1-8])|3(?:[12][1-6]|0[1-5]))|4(?:1(?:1[1-35]|2[1-7]|0[2-5]|3[1-478]|4[124-7])|27[1-7])))',
    '911' => '(?:0(?:0(?:4[1-8]|1[1-7]|0[0-6]|3[1-5]|[25][1-6])|8(?:1[1-7]|[24][1-8]|[03][1-6])))',
    '912' => '(?:0(?:0(?:[68][1-8]|0[0-8]|[124][1-7]|[37][1-6]|[59][1-5])|4(?:0[1-5]|1[1-6]|[23][1-7])|1(?:[34][1-9]|5[1-5])|2(?:0[1-7]|1[1-8]|2[12])|8(?:2[1-7]|[01][1-5])))',
    '913' => '(?:00(?:[06][1-5]|[3-5][1-8]|[12][1-7]))',
    '914' => '(?:0(?:0(?:[357][1-9]|4[1-7]|[12][1-8]|6[1-6]|0[0-7])|8(?:[1-4][1-5]|0[1-35-7])|1(?:2[1-5]|4[1-7]|3[1-8])|3(?:0[1-6]|1[1-7])|2(?:6[1-8]|7[1-4])))',
    '915' => '(?:(?:0(?:0(?:[359][1-7]|6[1-9]|0[0-7]|8[1-5]|[1247][1-6])|8(?:8[1-8]|[24579][1-7]|[013][1-6]|6[1-5])|2(?:[36][1-5]|5[1-6]|2[1-8]|4[1-4]|[01][1-9]))|1(?:2(?:[24][1-6]|[013][1-5])|1(?:1[1-4]|0[1-6]))))',
    '916' => '(?:(?:0(?:0(?:0[0-8]|[36-8][1-8]|[45][1-7]|[12][1-9])|1(?:0[1-8]|[1-4][1-7]|5[1-6])|2(?:0[0-6]|7[1-6]|5[1-5]|6[1-8]|1[1-9]|2[1-7])|3(?:0[1-4]|1[1-6])|42[1-8])|1(?:1(?:33|0[1-7]|1[1-68])|2(?:2[1-5]|3[1-7]))))',
    '917' => '(?:0(?:0(?:0[0-8]|[278][1-8]|[349][1-7]|[156][1-9])|3(?:[67][1-5]|[58][1-7])|2(?:2[1-6]|3[1-8]|4[1-9])|1(?:[01][1-7])))',
    '918' => '(?:(?:8(?:0(?:[15-7][1-8]|0[1-9]|[2-4][1-7]|8[1-3])|1(?:[135-7][1-6]|[08][1-8])|2(?:0[1-7]|3[1-9]|[12][1-8]))|0000))',
    '919' => '(?:(?:0(?:4(?:[56][1-5]|2[1-6]|3[1-7]|[04][1-9]|7[1-79]|[18][1-8])|5(?:[0-4][1-7])|1(?:3[1-356]|0[1-4]|[12][1-9])|3(?:73|0[1-5]|[12][1-8])|7(?:[23][1-7]|4[1-9])|6(?:1[1-6]|2[138]|3[1-4]|0[0-4])|2(?:0[0-6]|[12][1-7])|8(?:[01][1-7]))|1(?:5(?:[13][1-6]|4[1-5]|5[1-9]|0[1-7]|2[1-8])|3(?:0[0-6]|[13][1-6]|2[1-8])|1(?:00|2[1-6]|3[1-8]|4[1-7])|4(?:5[1-5]|6[1-4])|2(?:79|0[1-8]))|2(?:1(?:0[0-7]|1[1-6]|3[1-5]|2[1-9])|3(?:8[1-7]|[5-7][1-6])|2(?:0[0-7]|1[1-6]|2[1-9]))))',
    '920' => '(?:(?:0(?:9(?:1\d|[26-8][1-8]|[45][1-7]|[039][1-9])|1(?:[467][1-8]|[035][1-7]|2[1-9]|1[1-6])|8(?:[135][1-8]|2[1-7]|[046][1-9])|0(?:6[1-57-9]|3[1-6]|1[1-8]|0[0-8]|5[1-9]|[24][1-7])|3(?:81|[46][1-8]|7\d|5[1-7]|3[1-9])|2(?:31|2[3-7]|6[1-9]|7[1-7]|1[0-59]|0\d))|2(?:3(?:[07][1-6]|[245][1-7]|3[1-9]|[16][1-8])|1(?:[03][1-4]|2[1-9]|[46][1-8]|1[1-6]|5[1-5])|50[1-3])|1(?:1(?:6[1-7]|[0-24][1-9]|[35][1-8])|3(?:[124][1-6]|3[1-7]|0[1-4]))|31(?:2[1-6]|3[1-5]|[01][1-7])|82(?:1[6-8]|0[1-5]|2[12])))',
    '921' => '(?:(?:8(?:1(?:[35][1-5]|7[1-8]|1[124-7]|[26][1-4]|4[1-9]|0[1-7])|0(?:[24][1-7]|[01356][1-6])|8(?:2[1-5]|[13][1-7]|[04][1-9]))|0000))',
    '922' => '(?:0(?:0(?:[2-46][1-8]|5[1-7]|0[0-7]|1[1-5])|8(?:[26][1-5]|[13][1-6]|[05][1-7]|4[1-4])|2(?:5[0-8]|2[12]|[46][1-7]|7[13-8])|1(?:1[1-8]|[023][1-9])|4(?:[04][1-6]|3[1-7]|1[1-4]|2[1-8])|3(?:[12][1-6]|[03][1-7])|5(?:6[1-6]|5[1-4])|67[1-39]))',
    '923' => '(?:(?:0(?:9(?:8[1-5]|[27][1-7]|1[1-9]|[03-69][1-8])|0(?:[156][1-6]|3[1-7]|4[1-4]|0[0-5]|[27][1-8])|8(?:[145][1-4]|6[1-9]|[023][1-6])|3(?:2[1-8]|[013][1-6]|4[1-5])|1(?:[578][1-7]|6[1-6]))|1(?:2(?:0[0-8]|[37][1-8]|[124][1-7]|6[1-9]|5[1-4])|1(?:0[0-7]|2[1-4]|1[1-7]))))',
    '924' => '(?:0(?:8(?:[03-578][1-8]|2[0-8]|1[1-9]|6[1-7])|0(?:81|[156][1-9]|[23]\d|4[1-8]|7[1-6]|0[0-7])))',
    '925' => '(?:0(?:0(?:3[1-6]|4[1-9]|5[1-4]|[12][1-8]|0[0-5])|1(?:00|2[1-5]|[35][1-7]|[46][1-8])|4(?:[34][1-8]|[25][1-7])|3(?:45|[18][1-5]|7[1-6]|0[1-7])|6(?:2[1-6]|0[1-8]|1[1-7])|5(?:6[1-6]|7[1-8])|2(?:0[1-7]|1[1-5])))',
    '926' => '(?:0(?:8(?:4[1-6]|5[1-5]|2[1-9]|6[1-7]|[013][1-8])|0(?:0[0-7]|1[1-6]|[2-5][1-8])|3(?:7[1-6]|6[1-7]|8[1-9])|2(?:[02][1-7]|1[1-6])|17[1-9]))',
    '927' => '(?:(?:0(?:0(?:[34][1-9]|[12][1-7]|5[1-8]|0\d)|2(?:0[1-7]|[1-3][1-5])|6(?:1[1-5]|2[1-7]|0[1-9])|4(?:00|3[1-5]|[45][1-4])|3(?:[0-2][1-5])|5(?:[56][1-5]))|2(?:1(?:[57][1-6]|1[1-5]|[03][1-8]|[246][1-7])|3(?:1[1-4]|[0245][1-5]|[36][1-6])|2(?:7[1-7]|8[1-6]))|1(?:2(?:0[0-7]|2[1-8]|3[1-9]|1[1-7])|4(?:6[1-8]|[45][1-7])|3(?:1[1-9]|0[1-4]|2[1-6]))))',
    '928' => '(?:0(?:0(?:[3-5][1-7]|7[1-9]|0[0-8]|[26][1-8]|1[1-6])|2(?:[02-5][1-6]|1[1-8])|3(?:0[1-8]|1[1-4]|[23][1-6])))',
    '929' => '(?:(?:1(?:3(?:3[1-3]|1[1-6]|4[1-5]|0[0-5]|2[1-7])|1(?:0[0-5]|[17][1-7]|2[1-35-7])|7(?:2[1-6]|0[0-6]|1[1-7])|4(?:[0-2][1-6])|2(?:1[0-5]|0[1-8])|6(?:0[1-6]|3[1-7])|8(?:1[1-8]|0[1-5])|5(?:21|7[1-7]))|0(?:4(?:[0-46][1-7]|5[1-6])|3(?:0\d|2[1-8]|1[1-9]|4[1-6]|3[1-5])|2(?:1[1-7]|2[1-4]|3[1-5]|0[1-6])|1(?:[12][1-6]|0[1-8]))|2(?:2(?:1[1-8]|3[1-4]|0[1-9]|[24][1-7])|1(?:0[1-5]|[12][1-6])|3(?:6[1-7]|7[1-9]))))',
    '930' => '(?:(?:0(?:0(?:[79][1-8]|[02-68][1-9]|1[024-9])|8(?:7[1-6]|[015][1-9]|[268][1-7]|9[1-8]|4[1-35-9]|3\d)|3(?:[23][1-6]|[57][1-9]|4[1-7]|[168][1-8]|0[0-5])|9(?:2[1-8]|4[1-4]|9[1-7]|[01356][1-6]|[78][1-5])|2(?:[35][1-7]|[168][1-9]|[02]\d|4[1-8]|7[1-6])|1(?:[16][1-6]|[27][1-7]|4[1-4]|[035][1-8])|4(?:[35][1-8]|7[1-4]|[16][1-7]|0[1-6]|[24][1-5]))|1(?:3(?:77|0[1-5]|1[1-6]|[23][1-8]|6[1-9])|4(?:6[1-6]|5[1-9]|[01][1-8])|2(?:7[1-6]|8[1-7]|6[1-8]))|2(?:2(?:1[1-5]|[045][1-8]|3[1-9]|2[1-7])|1(?:[02][1-8]|1[1-7]))|32(?:77|4[1-8]|[16][1-7]|2[1-4]|3[1-9]|5[1-5]|0[1-68])))',
    '931' => '(?:8(?:3(?:[27][1-8]|[346][1-7]|5[1-9]|[01][1-6])|4(?:[13][1-7]|0[1-9]|2[1-35-8]|4[1-5]|5[1-6])))',
    '932' => '(?:0(?:0(?:0[0-8]|[1245][1-8]|3[1-7]|[67][1-5])|8(?:[245][1-6]|[03][1-8]|6[1-4]|1[1-7])|2(?:[1-5][1-8]|0[1-7])|1(?:3[1-7]|2[1-9]|[01][1-6])|3(?:71|0[1-5]|1[1-7])))',
    '933' => '(?:0(?:9(?:8[1-7]|[0245][1-9]|[367][1-8]|1\d)|8(?:6\d|[15][1-8]|[02-47][1-9])|0(?:3\d|0[0-8]|[157][1-8]|[46][1-7]|2[1-9])|3(?:[03][1-8]|5[1-7]|[12][1-9]|4[1-5])|2(?:5[1-3]|4\d|2[1-8]|[03][1-9])|1(?:[0-2][1-6]|3[1-8])))',
    '934' => '(?:00(?:0[1-5]|1[1-6]|2[1-7]|[39][1-9]|5[1-8]|4\d))',
    '935' => '(?:0(?:0(?:[1-6][1-7]|0[0-7])|2(?:[57][1-8]|6[1-9])|4(?:[02][1-6]|1[1-7])|1(?:[01][1-7])|3(?:3[1-8]|4[1-6])))',
    '936' => '(?:0(?:8(?:91|4[1-9]|[257][1-7]|[0136][1-8]|8[1-5])|0(?:[135][1-9]|2[1-7]|4[1-8]|7[0-8]|6\d|0[0-7])))',
    '937' => '(?:0(?:0(?:4[1-7]|[35][1-9]|1[0-8]|[26][1-8]|0\d)|8(?:[26][1-8]|[03-5][1-7]|1[1-6])))',
    '938' => '(?:0(?:0(?:2[1-8]|[3-5][1-9]|0[0-6]|[6-8][1-6]|1[1-5])|8(?:[023][1-7]|6[1-4]|1[1-6])|1(?:0[1-6]|[67][1-9])|2(?:74|8[1-3])))',
    '939' => '(?:(?:1(?:3(?:7[1-9]|[1-68][1-8]|0[0-8])|5(?:5[1-5]|[1-36][1-8]|[07][1-7]|4[1-9])|8(?:[45][1-6]|7[1-9]|[03][1-7]|[126][1-8])|6(?:0[0-6]|5[1-5]|[247][1-6]|1[0-5]|6[124-7]|3[1-7]|8[124])|7(?:[16][1-6]|2[1-5]|0[1-4]|4[1-7]|3[2-5]|5[124-8])|9(?:[02][1-8]|[67][1-9]|1[1-6])|4(?:2[1-9]|1[1-7]|[03][1-8])|1(?:3[1-6]|0[1-5]|2[0-5]|1[1-9])|2(?:[57][1-5]|6[1-7]))|0(?:6(?:00|[13-6][1-7]|7[1-9]|2[1-8])|5(?:0[1-9]|4[1-7]|[256][1-8]|3[1-6]|1[1-5])|1(?:71|1[1-35-9]|2[1-8]|[34][1-5]|[05][1-6])|7(?:51|0[0-5]|[13][1-7]|[24][1-9])|2(?:8[1-8]|[45][1-7]|7[1-6]|3[1-5])|3(?:[45]1|1[1-9]|6[1-4]|3[12]|0[0-7]|2[1-3])|4(?:[01][1-8])|000)|2(?:4(?:[25][1-6]|[013467][1-7])|3(?:[1-36][1-7]|[07][1-6]|[45][1-5])|7(?:3[1-8]|[0-245][1-9])|2(?:[12][1-6]|[45][1-7]|0[1-9]|3[1-8])|6(?:49|[0-2][1-7]|3[1-9])|1(?:6[1-5]|7[1-6]|8[1-9])|5(?:[01][1-9]))|8(?:0(?:[05][1-8]|[17-9][1-7]|4[1-9]|[236][1-6])|1(?:[46][1-6]|[18][1-5]|3[1-9]|[02][1-4]|[59][1-7]|7[1-8])|2(?:0[1-8]|[78][12]|[3-6][1-4]|1[1-6]|2[1-5]))|35(?:5[1-7]|4[1-8]|[0-3][1-6])))',
    '940' => '(?:(?:0(?:0(?:[57][1-6]|2[1-9]|[16][1-7]|[3489][1-8]|0[0-46-8])|8(?:4[24-9]|6[14-8]|[03][1-6]|5[1-467]|[79][1-8]|1[124679]|8[1-4]|2[124-9])|1(?:3[1-7]|[24][1-9]|5[1-5]|[01][1-6])|2(?:[23][1-7]|[15][1-8]|[04][1-5]))|2(?:1(?:[2-5][1-8]|1[1-7]|0[1-68])|0(?:[35][1-9]|[24][1-6]|[01][1-5])|4(?:[67][1-5]|[01][1-7])|5(?:[01][1-8]|2[1-9])|3(?:2[1-5]|[01][1-6]))|11(?:4\d|7[12]|3[1-9]|[16][1-7]|2[1-3]|0[1-6]|5[1-5])))',
    '941' => '(?:00(?:1[1-69]|0[0-8]|[57][1-8]|[2-4][1-7]|6[1-9]))',
    '942' => '(?:(?:0(?:0(?:91|[38][1-9]|[01][1-4]|2[1-7]|7[124]|[45][1-6]|6[1-5])|1(?:81|7[1-3]|6[1-5]|5[1-8]|[023][1-9]|[14][1-7])|2(?:1[1-6]|[25][1-5]|3[1-48]|[47][1-7]|[06][1-8])|3(?:2[1-7]|[13][1-9]|0[1-8])|5(?:2[1-5]|4[1-4]|3[1-9])|4(?:[01][1-5]))|1(?:5(?:1[1-5]|0[1-6]|2[1-7]|4[1-4]|3[1-8])|4(?:[12][1-9]|0[1-6]|3[1245])|3(?:4[12]|5[1-6])|10[1-7]|21[1-6])))',
    '943' => '(?:0(?:8(?:1\d|7[1-8]|[02-589][1-9]|6[1-6])|1(?:5[1-5]|8[1-7]|[0-3][1-9]|[467][1-8])|6(?:[013][1-7]|[24][1-8])|5(?:2[1-7]|0[1-9]|1[0-6]|3[1-5])|2(?:3[1-6]|0[12]|2[1-8])|3(?:0[1-7]|1[1-8])|4(?:[12][1-7])|000))',
    '944' => '(?:0(?:0(?:[4589][1-8]|2[0-8]|0\d|6[1-4]|[37][1-7]|1[1346-9])|1(?:[0-4][1-9]|5[01])|2(?:0[1-5]|2[1-6]|1[1-7])|3(?:[34][1-5])))',
    '945' => '(?:(?:0(?:0(?:00|[124][1-7]|6[1-8]|[357][1-6])|8(?:5[1-578]|3[1-8]|[124][1-7])|3(?:1[1-7]|0[0-8]|2[1-5])|1(?:1[1-4]|0[1-6])|21[1-9]|40[1-3])|1(?:1(?:[02][1-6]|1[1-8])|2(?:4[1-8]|5[1-3])|5(?:[01][1-5])|3(?:5[1-5]|4[13-5])|43[1-8])))',
    '946' => '(?:0(?:0(?:[358][1-8]|1[12]|7[1-356]|0[0-7]|4[1-3]|6[1-6]|2[1-5])|1(?:[12][1-5]|0[1-9])|2(?:[12][1-6]|0[1-7])|30[1-7]))',
    '947' => '(?:0(?:0(?:[34][1-5]|0[0-5]|[12][1-8]|5[1-4])|2(?:1[1-3]|0[1-5])|10[1-3]))',
    '948' => '(?:0(?:0(?:9[1-3]|[1-47][1-9]|[568][1-8]|0[0-8])|1(?:1[1-4]|0[1-7]|[34][1-6]|2[1-5])|21[1-9]|30[1-6]))',
    '949' => '(?:(?:3(?:4(?:[0-4][1-9])|2(?:01|[34][1-7]|[125][1-6])|1(?:[13][1-7]|0[1-3]|2[1-5])|3(?:6[1-7]|7[1-9])|5(?:6[1-5]|5[1-7])|7(?:3[1-5]|2[1-6])|6(?:7[1-5]|6[1-4]))|8(?:4(?:1[2-9]|[23][1-7]|0[1-9]|4[1-6])|5(?:3[1-4]|2[1-7]|0[2-5]|6[12]|5[124-8]|4[1-5])|6(?:1[1-8]|0[1-4])|7(?:31|2[1-8])|3(?:21|1[1-7])|20[0-7]|12[1-7])|1(?:3(?:[45][1-4]|[12][1-9]|3[1-8]|0[1-6])|7(?:3[1-9]|2[1-7]|4[12]|[01][1-6])|6(?:[01][1-9]|2[1-6])|2(?:0[1-8]|2[1-6]|1[1-5]))|6(?:4(?:[0-3][1-8])|7(?:[46][1-6]|7[1-5]|5[13-7])|6(?:36|8[0-2]|1[125]|0[0-357-9])|5(?:5[1-7]|4[1-5])|3(?:7[1-3]|6[1-6])|10[0-3]|21[12])|7(?:1(?:[12][1-7]|0[1-4]|3[1-8]|4[1-5])|2(?:2[1-9]|4[1-8]|[35][1-6])|4(?:1[1-8]|2[1-4]|0[1-5])|3(?:1[1-9]|0[12])|5(?:0[1-8]|1[1-3]))|4(?:3(?:5[1-3]|4[1-6]|0\d|[12][1-8]|3[1-7])|1(?:2[1-8]|4[1-9]|1[1-4]|3[1-6])|5(?:[01][1-7]|2[1-5])|20[1-6])|2(?:2(?:[01][1-9]|2[1-6]|3[1-5])|3(?:1[1-8]|2[12]|0[1-6])|1(?:41|1[1-3]|0[1-6]))|5(?:4(?:1[1-6]|0[1-9])|2(?:01|1[1-7]|2[1-3])|3(?:4[1-7]|3[1-6])|12[1-4])|0(?:5(?:5[1-8]|3[1-6]|4[1-5])|30[1-8]|46[1-4]|11[12])))',
    '950' => '(?:(?:0(?:0(?:3[1-6]|[14-6][1-7]|[278][1-8]|0[0-5])|9(?:[37][1-3]|[28][1-6]|6[1-5]|5[0-4]|9[1-4]|[04][1-9]|1[1-7])|8(?:7[12]|6[1-8]|1[1-4]|0[1-9]|3[1-7]|[49][1-3]|8[1-6]|[25][1-5])|1(?:2[1-79]|[34]\d|6[1-9]|0[1-7]|5[0-7]|1[1-6])|2(?:0[1-9]|1[0-578])|32[1-9])|1(?:4(?:[013-7][1-7]|2[1-68])|2(?:0[0-489]|[15][1-8]|6[12]|[2-4][1-7])|1(?:51|4[1-8]|2[1-7]|[03][1-6]|1[1-5])|3(?:0[1-5]|[13][1-4]|4[1-9]|2[1-8]))|2(?:0(?:[145][1-5]|[07][1-6]|[23][1-8]|6[1-4])|1(?:3[1-8]|0[12]|[457][1-7]|6[1-4]|1[1-3]|2[1-6])|2(?:01|5[1-6]|6[1-4]))|3(?:3(?:81|4[1-6]|2[1-8]|[56]\d|[17][1-7]|[03][1-9])|1(?:2[1-8]|[03][1-5]|1[1-6]))))',
    '951' => '(?:8(?:0(?:[0-8][1-8])|1(?:[01][1-8]|[2-46][1-7]|5[1-6])))',
    '952' => '(?:(?:0(?:0(?:0[0-7]|1[1-6]|2[1-8])|3(?:0[1-7]|1[1-8]|2[12])|6(?:1[1-5]|[02][1-6])|1(?:1[1-6]|0[1-9])|2(?:0[1-7]|1[1-6])|7(?:[01][1-6])|8(?:5[1-7]|2[1-4])|5(?:[01][1-5])|4(?:3[1-5]|2[12]))|1(?:5(?:7[1-5]|[0-24-6][1-8]|8[1-4]|3[1-9])|3(?:2[1-6]|1[1-5]|0[1-8])|2(?:0[1-9]|1[1-3])|64[1-6]|43[1-5])|3(?:4(?:[23][1-5])|11[1-9]|20[1-7]|54[1-6])|2(?:2(?:1[1-5]|[02][1-6])|13[1-6])))',
    '953' => '(?:0(?:0(?:[26][1-7]|7[1-8]|[13][1-6]|[45][1-5])|1(?:3[1-6]|[02][1-5]|4[1-4]|1[1-7])))',
    '954' => '(?:0(?:0(?:4[1-6]|6[1-478]|1[1-467]|3[1-8]|2[1-7]|0[0-24-8]|[578][1-9])|1(?:81|[26][1-6]|[0457][1-7]|1[12]|3[1-8])|2(?:0[1-7]|2[12]|1[1-8])))',
    '955' => '(?:0(?:0(?:0[0-4]|5[13-7]|[49][1-7]|7[1-3]|2[1245]|[136][1-6]|8[1-5])|1(?:[0-24-6][1-8]|3[1-7])|8(?:[256][1-4]|4[1-5]|1[1-68]|3[1-3]|0[13-8])))',
    '956' => '(?:0(?:8(?:5[1-5]|0[1-6]|[346][1-7]|[12][1-8])|0(?:0[0-7]|4[13-6]|[1-35][1-7])|1(?:01|2[1-3]|1[1-7])))',
    '957' => '(?:0(?:0(?:0[0-7]|[368][1-7]|[12457][1-8]|9[12])|2(?:[23][1-6]|1[2-7]|0[1-7])|1(?:0[0-6]|[12][1-7])|3(?:3[1-6]|[45][1-7])|46[1-6]))',
    '958' => '(?:0(?:8(?:[35-7][1-7]|2[1-4]|[04][1-9]|1[1-8])|2(?:70|6[1-9]|[02-4][1-6]|[15][1-5])|0(?:61|[3-5][1-8]|0[0-8]|1[1-4]|2[1-6])))',
    '959' => '(?:(?:1(?:3(?:[358][1-7]|[247][1-8]|1[1-6]|6[1-3]|0[0-7])|9(?:[0245][1-9]|1\d|[67][1-8]|3[0-8])|2(?:4[1246]|[17][1-7]|3[2-4]|5[1-8]|6[1-5]|2[1-68]|8[0146-9]|0[0-7])|7(?:[26][1-7]|[3-5][1-9]|1[1-8]|0[13-9])|8(?:4[1-8]|1[1-4]|[0356][1-7]|7[1-6]|2[1-5])|1(?:[235][1-6]|[01][1-9]|4[1-8])|6(?:0[0-4]|4[1-4]|3[1-7]|[12][1-5])|5(?:2[1-5]|0[0-3]|1[1-4]))|2(?:0(?:8[1-356]|4[1-9]|[35][1-7]|0[0-7]|[26][1-6]|[17][1-5])|6(?:0\d|[34][1-8]|[1256][1-9]|7[1-7])|4(?:6[1-58]|2[1256]|4[1-5]|[135][1-7]|[07][1-9])|1(?:2[1-6]|3[0-6]|[01][1-7]|4[1-8])|3(?:81|[01][1-5]|2[1-9]|3[1-8])|5(?:[12][1-8]|0[1-7])|8(?:0[1-9]|[12][1-7])|2(?:[12][1-7]|0[1-6])|7(?:0[1-9]|2[1-4]|1[2-6]))|3(?:2(?:0[0-8]|2[1-8]|3[1-7]|5[1-9]|[67][1-5]|[14][1-6])|9(?:[2-4][1-8]|0[1-7]|1[1-9])|4(?:[013][1-7]|4[1-9]|2[1-8])|1(?:1[1-7]|3[1-4]|0[1-8]|2[1-6])|6(?:5[1-3]|6[1-6]))|0(?:1(?:8[1-3]|6[1-5]|[23]\d|7[12]|5[1-7]|[014][1-9])|2(?:5[0-7]|[13][1-7]|0[1-35-8]|[46][1-8]|2[1-578])|4(?:2[1-6]|0[1-7]|[13][1-8])|5(?:21|1[1-9]|0[1-8])|3(?:[01]\d|2[1-3]))|4(?:5(?:1[1-5]|2[1-6]|0[1-7]|3[1-9])|6(?:0[1-68]|3[1-6]|1[12478]|2[1-7])|4(?:41|0\d|1[0-8])|30[1-4])))',
    '960' => '(?:(?:0(?:4(?:[03-6][1-8]|[1278][1-9])|7(?:3[1-6]|[025][1-9]|[48][1-7]|7[2-8]|1[1-35-9]|6[02-9])|6(?:[1-467][1-9]|8[1-8]|[05]\d)|1(?:1[1-6]|0[1-3])|2(?:[0-467]1|5[12])|8(?:11|0[1-9])|90[1-6]|50[12]|000)|8(?:0(?:0[1-3]|[237][1-6]|[16][1-8]|5[1-7]|4[1-4])|1(?:6[1-6]|2[1-5]|4[1-3]|[0135][1-7])|2(?:3[1-7]|[045][1-4]|[12][1-8]))|1(?:4(?:[3-5][1-6]|0\d|7[1-8]|1[1-7]|[268][1-9])|2(?:3[12]|4[1-8])|8(?:1[1-5]|0[1-4])|6(?:00|3[1-6])|3(?:21|0[1-4])|10[1-8]|72[1-4]|501)|2(?:1(?:5[1-8]|0[12])|2(?:51|6[1-3]))))',
    '961' => '(?:(?:0(?:0(?:3[1-9]|[59][1-4]|[1248][1-7]|7[1-8]|0[0-5]|6[1-6])|9(?:0[1-8]|[13-5][1-7]|[67][1-5]|[289][1-6])|8(?:2[1-9]|[156][1-7]|[38][1-8]|4[1-6]|[07][1-5])|4(?:1[1-6]|0[1-9])|30[1-9]|10[0-6])|80(?:[1-36-9]1|4[1-7]|0[12]|5[1-6])))',
    '962' => '(?:0(?:8(?:[35][1-9]|[02][1-7]|[146][1-8])|0(?:2[1-8]|5[1-9]|[14][1-7]|6[1-3]|0[0-7]|3[1-6])|7(?:2[1-8]|1[1-4])|5(?:0[0-4]|1[1-6])|3(?:[01][1-5])|2(?:11|0[1-5])|12[1-6]|40[1-6]|62[1-3]))',
    '963' => '(?:(?:8(?:8(?:5[12]|[137][1-8]|2[1-9]|[06][1-7]|4[1-6])|0(?:[67]1|[01][1-8]|4[1-7]|3[1-9]|5[1-3]|2[1-6])|1(?:00|1[1-6])|30[0-8]|40[0-8]|20[1-7])|7(?:8(?:[78][1-6]|0[0-8]|[1-3][1-8]|6[1-7]|[45][1-9])|7(?:0\d|[14-6][1-9]|[37][1-3]|[28][1-6]))|0(?:1(?:1[1-5]|[02][1-9])|2(?:21|3[12]|0[1-9]|1[1-6])|7(?:[01][1-4]|2[1-6])|9(?:2[1-5]|[01][1-4])|5(?:51|4[1-7]|3[1-4])|6(?:7[1-3]|6[1-7])|83[1-7]|000)|5(?:6(?:6[1-4]|7[12]|8[1-5])|5(?:05|3[1-9]|2[12])|1(?:00|1[1-9])|4(?:11|0[0-8])|3(?:4[1-4]|2[1-3])|20[1-3])|6(?:1(?:31|1[1-5]|0[0-6]|[25][1-3]|4[1-7])|2(?:1[1-8]|0[0-8])|3(?:0[0-6]|1[1-6]))|4(?:3(?:00|1[1-8]|2[1-4])|6(?:0[1-6]|1[1-4])|43[1-6]|11[1-5]|20[1-5]|54[1-5]|70[12])|1(?:1(?:5[1-6]|6[1-5])|30[1-9]|24[1-8]|41[1-4]|63[1-3]|52[12])|3(?:40[0-6]|31[1-6]|52[1-5]|60[1-3])))',
    '964' => '(?:0(?:8(?:[0139][1-8]|[24-6][1-9]|8[1-7]|7[1-6])|9(?:[67][1-6]|[35][1-8]|[0189][1-7]|[24][1-9])|0(?:91|6[1-6]|[17][1-7]|[2-4][1-9]|0[0-8]|[58][1-8])|3(?:21|0[1-4]|1[1-6])|20[1-3]|43[1-3]|111))',
    '965' => '(?:0(?:8(?:6[1-7]|[045][1-9]|3\d|[127][1-8])|0(?:[34][1-8]|[068]\d|2[1-7]|[57][1-9]|1[1-6])|1(?:0[1-37]|1[0-8]|3[1-6]|2[146-9])|20[1-5]))',
    '966' => '(?:0(?:0(?:[27][1-4]|[346][1-9]|[189][1-7]|5[1-8]|0[0-7])|8(?:[1346][1-9]|2[1-7]|7[1-57]|5\d|0[1-6]|9[1-689]|8[1247])|9(?:1[1-5]|3[1-3]|[02][1-4])|10[1-8]|40[0-5]|501))',
    '967' => '(?:0(?:3(?:1[1-57-9]|3[1-6]|2[1-4]|[04][1-7])|5(?:2[1-8]|3[12]|1[1-5]|0[0-7])|0(?:0[0-7]|[12][1-6])|6(?:11|[24][12]|3[1-4]|0[1-5])))',
    '968' => '(?:0(?:4(?:00|[14][1-5]|2[1-3]|3[1-4])|0(?:0[0-6]|1[1-6])|60[1-7]|32[1-6]|10[0-4]|21[1-5]))',
    '969' => '(?:(?:6(?:0(?:[48][1-7]|[25-7][1-9]|[03][1-8]|1[1-35])|5(?:2[1-8]|[568][1-7]|[134][1-9]|0[0-7]|7[1-6])|1(?:8[02-689]|3[1-5]|[46][1-6]|7[1-7]|[0-2][1-9]|5[124-9])|2(?:[25][1-6]|[14][1-5]|0[0-7]|7[1-4]|3[12]|6[1-8])|3(?:4[1-3]|5[1-6]|[1-3][1-8]|0[1-7])|4(?:11|0[1-9]))|1(?:1(?:7[1-6]|0[013-9]|[1-6][1-9])|6(?:[46][1-3]|3[1-5]|0[0-8]|5[1-4]|[12][1-9])|7(?:[3-7]1|1[1-4]|8\d|2[12]|0[01])|20[1-6]|40[1-5]|30[0-2]|51[1-3])|3(?:5(?:1[1-5]|[45][1-6]|0[0-6]|2[1-7]|3[1-9])|4(?:[3-57]1|[0-28][12]|6[1-4])|1(?:41|0[0-3]|[1-3][1-3])|28[1-8]|30[0-4])|4(?:1(?:4\d|[013][1-9]|[256][1-7])|3(?:0[1-4]|1[1-6])|40[0-6]|73[1-7]|51[1-5]|62[1-4])|0(?:2(?:1[1-3]|0[0-6]|7[12]|[3-68][1-8]|2[1-7])|30[1-9]|10[0-6]|40[0-4])|5(?:3(?:00|1[1-8]|2[1-6]|[34][1-5])|1(?:[23][1-3]|4[1-7]|1[1-4])|20[1-8])|7(?:3(?:2[1-6]|1[1-5])|5(?:00|1[1-9])|4(?:13|0[1-7])|20\d)|2(?:7(?:01|5[12])|27[1-5]|66[1-3])))',
    '970' => '(?:(?:80(?:5[1-4]|4[1-7]|[0-2][1-8]|3[1-6])|0(?:1(?:1[1-6]|0[1-7])|22[1-8]|31[1-7]|000)|1(?:1(?:4[1-7]|5[1-3])|3(?:61|7[1-7])|26[1-4])))',
    '971' => '(?:81(?:[0157][12]|8[1-8]|[36][1-9]|2[1-7]|4[1-6]))',
    '972' => '(?:(?:83(?:01|2[1-6]|[13][1-8])|0(?:16[1-4]|25[1-3])))',
    '973' => '(?:84(?:0[1-9]|1[12]))',
    '974' => '(?:(?:82(?:61|0[1-4]|[45][12]|[1-3][1-3])|0(?:2(?:52|4[1-3])|15[1-3])))',
    '975' => '(?:00(?:0[0-8]|1[1-8]|2[1-7]|6[1-4]|[3-57][1-9]))',
    '976' => '(?:0(?:0(?:3[1-7]|4[12]|[12][1-6]|0[0-7]|5[1-3])|15[1-4]))',
    '979' => '(?:(?:1(?:4(?:0[0-2]|[2356][1-3]|[147][12])|5(?:4[1-5]|[23][1-6]|0[0-6]|1[1-3])|1(?:[47]1|[1-356][12]|0[01])|7(?:06|5[1-7])|30[0-8]|60[0-4]|20[0-2])|2(?:1(?:[167][1-5]|[023][1-4]|[45][1-7])|3(?:[12][1-4]|3[1-6]|0[1-5])|5(?:01|3[1-3]|[124][12])|4(?:[4-6][1-4])|70[0-8]|611)|0(?:2(?:1[1-6]|[02][1-7])|1(?:4[1-7]|5[1-5])|6(?:22|0[0-6])|40[0-8]|33[1-8]|51[1-5])|3(?:1(?:[12][1-5]|3[12])|20[1-4])))',
    '980' => '(?:(?:0(?:8(?:45|[01][1-5]|5[1-6]|6[1-7]|[27][1-4])|0(?:65|2[1-3]|1[1-4]|0[0-5]))|6(?:1(?:90|0[1-9]|[12]\d|3[01])|0(?:[39]0|[12]\d|0[1-9]))))',
    '981' => '(?:(?:4(?:3(?:7[1-5]|5[1-6]|6[1-8]|[0134][1-7]|2[1-9])|2(?:1[1-3]|5[1-6]|[36][1-5]|4[12]|0[0-3]|2[1-9]|7[1-7])|1(?:[3-5]1|0[0-5]|[12][12])|4(?:0[1-3]|1[1-9]))|3(?:3(?:41|[135][12]|2[1-9]|6[1-3]|0[0-6])|1(?:2[1-6]|0\d|[13][1-7])|2(?:71|1[1-7]|[02][1-6])|4(?:[01][1-9])|5(?:1[1-5]|0[0-3]|2[1-4])|6(?:11|2[1-9]|0\d))|0(?:9(?:4[1-5]|3[1-6]|[16][1-7]|[25][1-4]|0[1-8])|1(?:3[1-6]|1[1-3]|2[1-4]|0[0-5])|2(?:0[0-5]|1[1-5])|30[1-9]|50[0-6]|41[1-6])|2(?:1(?:0[0-6]|[45][1-6]|6[1-8]|[37][1-4]|[128][1-7])|30[1-3]|40[12]|[25]01)|1(?:2(?:51|4[0-8]|1[1-8]|3\d|2[1-7]|0[01])|5(?:1[1-8]|0[0-5]|3[1-4]|2[1-6])|10[1-7])|800[1-7]))',
    '982' => '(?:0(?:8(?:[14][1-8]|[03][1-7]|2[1-6])|0(?:2[1-7]|3[1-6]|1[1-5]|0[0-7])|2(?:31|[25][12]|6[1-3]|[14][1-5])))',
    '983' => '(?:0(?:8(?:03|5[1-3]|4[1-5]|2[1-68]|1[1-7]|[36][1-9])|0(?:0[0-7]|4[1-7]|3[1-9]|1[1-4]|2[13-6])))',
    '984' => '(?:0(?:0(?:22|3\d|0[0-4]|[45][1-8]|[67][1-5]|1[1-6])|8(?:4[1-5]|[23][1-8]|[01][1-7])))',
    '985' => '(?:0(?:0(?:0[0-6]|[1-4][1-6]|8[1-8]|[5-7][1-7])|8(?:[257][1-4]|[036][1-5]|4[1-6]|1[1-3])|19[1-5]|901))',
    '986' => '(?:(?:0(?:8(?:0[1-356]|[237][1-8]|[4-6][1-9]|1[1-5])|7(?:0\d|8[12]|[16][1-8]|[27][1-9]|5[1-4]|[34][1-3])|0(?:2[1-8]|1[135-7]|0[0-6]|[34][1-3])|1(?:2[1-4]|3[12]|1[1-5]|0[1-6])|3(?:0[1-5]|[12][1-4])|20[1-4]|40[12])|2(?:2(?:[5-7]1|2[1-6]|4[1-5]|[138][12]|0[0-5])|1(?:3[1-7]|0[1-5]|1[1-6]|2[1-3])|3(?:5[1-5]|4[1-7])|4(?:1[1-5]|0[1-6])|52[1-7])|1(?:3(?:1[1-3]|3[1-6]|2[12]|0[1-4])|111)))',
    '987' => '(?:(?:2(?:3(?:[0-6][1-9]|7[1-4])|1(?:3[1-3]|1[1-6]|2[1-8]|6[1-4]|[58][1-9]|[47][1-7])|2(?:2[1-9]|4[1-7]|0[0-5]|[13][1-6]|[67][1-5]|5[1-3])|0(?:[12][1-8]|[045][1-5]|3[1-6])|51[12])|0(?:0(?:[56][1-9]|3[1-8]|1[1-5]|4[1-6]|2[124-6]|0[0-6])|3(?:[1-3]1|4[1-6]|8[1-5]|6[1-8]|[057][1-9])|1(?:[25]1|0[0-7]|[16][1-5]|7[12]|[34]\d)|4(?:2[1-6]|[01][1-5]|3[1-3]|4[1-7])|6(?:11|0[12]|2[1-3])|5(?:00|1[1-3])|28[1-6]|70[1-4]|90[1-3])|1(?:30[1-6]|10[1-3]|22[12])))',
    '988' => '(?:0(?:3(?:[124][1-8]|6[1-7]|[0358][1-9]|7[1-5])|2(?:1[1-5]|5[1-6]|3[1-8]|[0248][1-7]|[67][1-9])|0(?:[78][1-7]|3[1-467]|[15][1-8]|0[0-8]|[246][1-6])|4(?:6[1-7]|[47][1-8]|[0235][1-6]|1[1-5])|1(?:6[1-9]|[1-47][1-4]|5[1-7]|[08][1-5])|8(?:5[1-5]|2[1-9]|[034][1-7]|[16][1-8])|5(?:[145][1-4]|2[1-7]|[78][12]|0[1-6]|3[1-5]|6[1-3])|6(?:[12][1-3]|3[1-4]|0[1-7])|927))',
    '989' => '(?:(?:6(?:1(?:[156][1-7]|2[1-8]|3[1-6]|[47][1-5]|0[0-6])|2(?:5[1-5]|[36][1-6]|[02][1-8]|1[1-7]|4[1-4])|4(?:71|[26][1-6]|[01][1-5]|[34][1-7])|8(?:11|3[1-8]|[02][1-7])|3(?:1[1-7]|2[12]|0[1-6])|7(?:01|1[12])|941)|0(?:2(?:3[1-3]|[1467][1-8]|0[0-8]|2\d|5[1-9])|5(?:61|[124][1-9]|[35][1-7]|0[0-8])|6(?:3[1-6]|[16][1-7]|4[1-4]|0[12]|[25][1-8])|9(?:21|1[1-6]|0[18])|8(?:[235]1|00|4[1-3])|7(?:01|3[1-4])|11[1-3])|1(?:2(?:[13][1-7]|7[1-4]|[45][1-9]|0[0-7]|2[1-5]|6[13467])|7(?:31|5[1-8]|6[1-5]|4[1-6])|6(?:31|0[0-8]|[12][1-3])|3(?:11|0[0-5]|2[1-3])|5(?:11|0[0-7])|10[1-4])|5(?:1(?:7[1-3]|5[1-5]|[46][1-6]|3\d|2[1-8]|8[13-5]|1[1-9])|3(?:[04-6]1|[178][12]|2[1-4]|3[1-5])|6(?:1\d|0[1-9]|2[1-7])|50[1-9]|40[1-3])|2(?:4(?:0[01]|6[1-5]|5[1-9]|3[1-7]|1[12]|[47][1-8]|2\d)|3(?:[1346]1|8[1-5]|2[1-4]|0[0-3]|[57][12])|20[0-8]|11[12])|4(?:5(?:0[3-9]|[23][1-9]|5[1-7]|[146-8]\d)|20[1-9]|41[1-9]|30[1-8]|10[1-6]|80[235-8]|70[1-3]|601)|3(?:2(?:1[1-6]|0[1-7])|12[1-8]|43[1-4])))',
    '990' => '(?:(?:0(?:8(?:7[0-24-9]|[38][1-6]|1[0-57-9]|[0249][1-9]|[56]\d)|0(?:[16][1-8]|0[0-8]|3[1-9]|[457][1-7]|2[1-5])|3(?:61|[23][1-3]|[145][12]|0[0-3])|7(?:21|0[0-3]|1[1-4]|3[1-5]|4[1-3])|5(?:61|[02][1-5]|1[1-3])|4(?:11|0\d))|2(?:3(?:[16][1-7]|2[1-4]|[07][1-8]|3[1-57-9]|5[1-5]|[48][1-6])|4(?:[47][1-7]|[18][1-4]|5[135]|[369][1-5]|0[1-6]|2[1-3])|2(?:51|3[1-5]|1[1-6]|4[12]|2[1-7])|1(?:6[1-4]|7[1-5]))|1(?:1(?:[135][1-4]|2[12]|4[1-6]|0[01]|6[1-5])|4(?:00|3[1-3]|[24][1-4]|1[12])|5(?:7[1-4]|[56][1-3])|27[1-6]|30[1-6])))',
    '991' => '(?:0(?:0(?:3[1-5]|6[1-6]|1[1-3]|5[1-7]|4[1-9]|0[0-8]|2[1-8])|801))',
    '992' => '(?:(?:0(?:0(?:0[0-5]|[35][1-9]|[12478][1-7]|[69][1-6])|3(?:[1-3][1-5]|0[0-2]|4[1-4]|5[12])|8(?:[24]1|0[0-2]|6[1-4]|[135][12])|11[1-9]|47[1-9]|77[1-9]|26[1-5]|58[1-4]|60[1-3])|1(?:4(?:06|6[12]|7[1-4]|4[1-6]|5[1-5])|12[1-8]|20[1-6]|3(?:03|31)|58[1-3])))',
    '993' => '(?:00(?:4[12]|[18][1-7]|[256][1-4]|0[0-7]|[37][1-5]))',
    '994' => '(?:0(?:0(?:81|5[1-7]|3[1-4]|[467][1-9]|2[1-8]|1[1-6]|0[0-7])|10[1-4]))',
    '995' => '(?:0(?:0(?:5[1-6]|2[1-5]|0[0-6]|4[12]|[13][1-8])|20[1-9]|11[1-3]))',
    '996' => '(?:0(?:0(?:[1469]1|[28][1-8]|7[1-9]|5[1-4]|0[0-2]|3[1-5])|2(?:1[1-3]|0[01])|11[12]|301))',
    '997' => '(?:(?:0(?:8(?:6[12]|4[1-8]|[25][1-7]|[013][1-9])|1(?:17|31|4[1-3]|[26][1-7]|[05][1-8])|0(?:[01]\d|5[1-8]|[24][1-9]|3[1-7])|3(?:[15]1|6[1-9]|3[1-4]|4[1-6]|[02][1-3])|4(?:[01][1-5])|75[1-8]|62[1-6]|53[12]|211)|1(?:3(?:0[01]|2[12]|3[1-9]|1[1-7])|1(?:56|[23][1-5]|1[1-7])|20[1-6])))',
    '998' => '(?:0(?:8(?:[15][1-9]|[37][1-8]|0[1-6]|6[1-5]|4[1-3]|2[1-46-9])|0(?:0[0-6]|4[1-6]|[57][1-5]|1[1-8]|2[1-9]|6[1-4]|3[1-7])|1(?:25|1[1-4]|0[1-5])|281))',
    '999' => '(?:(?:3(?:1(?:0[0-7]|[13][1-5]|[24][1-6]|7[12]|5[1-8]|6[1-7])|7(?:6[1-6]|[0-27]\d|3[0-8]|[58][1-7]|4[1-9])|2(?:[13][1-7]|0[1-4]|[24][1-6])|5(?:2[12]|0[0-3]|3[1-3]|1[1-5])|301)|7(?:7(?:0[0-7]|1[1-5]|8[12]|6[1-8]|4[1-9]|[2357][1-7])|6(?:11|6[1-4]|7[1-7]|0[124]|2[12]|3[1-8]|4[1-6]|8[1-5]|5[1-3])|54[1-8]|20[1-7]|12[1-6]|31[1-6]|46[1-4])|1(?:3(?:6[1-3]|[45][1-6]|0[0-3]|[12][1-4]|3[1-9])|4(?:[025][12]|1[1-4]|4[1-3]|3[1-6])|5(?:0[1-7]|1[1-4]|2[12])|2(?:0[1-3]|1[1-6])|11[1-3])|6(?:8(?:01|3[1-9]|2[1-7]|6[12]|4[1-8]|1[1-6]|5[1-3])|7(?:41|1[12]|0[1-8]|2[1-7]|3[1-5])|6(?:52|0[1-9])|10[0-7]|21[1-5]|31[1-5]|40[0-3])|8(?:2(?:[13][1-5]|4[1-6]|[02][1-7])|1(?:4[1-5]|[56][1-8]|3[1-4])|3(?:1[1-7]|0[0-4])|4(?:3[1-8]|2[1-3])|5(?:31|2[1-5]))|4(?:2(?:2[1-9]|1[1-4]|3[12]|0[0-8])|1(?:41|1[1-6]|2[12]|3[1-4]|0[0-3])|3(?:04|3[1-7])|55[1-7]|60[0-5]|44[1-5])|0(?:1(?:00|4[1-5]|5[1-3]|3[1-4]|2[12])|4(?:3[1-6]|2[1-7])|60[0-6]|21[1-4]|361)|5(?:4(?:0[0-6]|1[1-5])|3(?:0[01]|1[1-4])|1(?:91|0[1-3])|20[0-8]|60[1-4]|52[12])|2(?:2(?:5[1-6]|1[1-3]|[2-4][1-4]|6[1-7]|0[0-5])|17[1-9])))',
);

1;
__END__
