#pragma once
#include <stdint.h>
#include <stddef.h>

namespace panda { namespace lib {

uint64_t hash_murmur64a             (const char* str, size_t len);
uint32_t hash_jenkins_one_at_a_time (const char* str, size_t len);

inline uint64_t hash64 (const char* str, size_t len) { return hash_murmur64a(str, len); }
inline uint32_t hash32 (const char* str, size_t len) { return hash_jenkins_one_at_a_time(str, len); }

template <typename T> inline T        hashXX (const char* str, size_t len, T type);
template <>           inline uint32_t hashXX (const char* str, size_t len, uint32_t type) { return hash32(str, len); }
template <>           inline uint64_t hashXX (const char* str, size_t len, uint64_t type) { return hash64(str, len); }

}}
