package WWW::ManageWP::Simple;
use strict;
use warnings;
use base 'WWW::ManageWP';
use Want;

##########
## Core ##
##########

sub DELETE {
	my $self   = shift;
	my $params = $self->_prep_args([], @_);
	my $method = join('/', @{$self->{chain}});
	if (!$method) {
		die "ERROR! you can't call [get] on nothing\n";
	}
	return $self->remote->get(method => $method, request_params => $params);
}

sub GET {
	my $self   = shift;
	my $params = $self->_prep_args([], @_);
	my $method = join('/', @{$self->{chain}});
	if (!$method) {
		die "ERROR! you can't call [get] on nothing\n";
	}
	return $self->remote->get(method => $method, request_params => $params);
}

sub POST {
	my $self   = shift;
	my $params = $self->_prep_args([], @_);
	my $method = join('/', @{$self->{chain}});
	if (!$method) {
		die "ERROR! you can't call [get] on nothing\n";
	}
	return $self->remote->post(method => $method, request_params => $params);
}

##############
## AUTOLOAD ##
##############

sub AUTOLOAD {
	my $self = shift;
	our $AUTOLOAD;
	my ($key) = $AUTOLOAD =~ /.*::([\w_]+)/o;
	return if ($key eq 'DESTROY');
	push(@{$self->{chain}}, $key);
	if (want('OBJECT') or want('VOID')) {
		return $self;
	}
	my $params = $self->_prep_args([], @_);
	return $self->remote->get(
		method         => join('/', @{$self->{chain}}),
		request_params => $params,
	);
}

1;

__END__

=head1 NAME

WWW::ManageWP::Simple;

=head1 DESCRIPTION

A simple wrapper around WWW::ManageWP::Remote methods.

=cut

