package Google::Ads::AdWords::v201605::RealTimeBiddingSetting;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201605' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(Google::Ads::AdWords::v201605::Setting);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %Setting__Type_of :ATTR(:get<Setting__Type>);
my %optIn_of :ATTR(:get<optIn>);

__PACKAGE__->_factory(
    [ qw(        Setting__Type
        optIn

    ) ],
    {
        'Setting__Type' => \%Setting__Type_of,
        'optIn' => \%optIn_of,
    },
    {
        'Setting__Type' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'optIn' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
    },
    {

        'Setting__Type' => 'Setting.Type',
        'optIn' => 'optIn',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201605::RealTimeBiddingSetting

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
RealTimeBiddingSetting from the namespace https://adwords.google.com/api/adwords/cm/v201605.

Settings for Real-Time Bidding, a feature only available for campaigns targeting the Ad Exchange network. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * optIn




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

