use strict;
use warnings;

use Test::More tests => 5;
#use lib 'lib';

use_ok('Math::Symbolic');
use Math::Symbolic::ExportConstants qw/:all/;

my $x = Math::Symbolic::parse_from_string(
	'1+2'
);
ok(
	$x->apply_constant_fold()->to_string() eq '3',
	'apply_constant_fold() working for simple case'
);

$x = Math::Symbolic::parse_from_string(
	'a'
);
ok(
	$x->apply_constant_fold()->to_string() eq 'a',
	'apply_constant_fold() working for simple case'
);

$x = Math::Symbolic::parse_from_string(
	'a / (2 * 5)'
);
ok(
	$x->apply_constant_fold()->to_string() eq 'a / 10',
	'apply_constant_fold() working for simple case'
);

$x = Math::Symbolic::parse_from_string(
	'd*acos(cos(1))'
);

ok(
	$x->apply_constant_fold()->to_string() eq 'd * 1',
	'apply_constant_fold() working for simple case'
);


