# ************************************************************************* 
# Copyright (c) 2014, SUSE LLC
# 
# All rights reserved.
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
# 
# 1. Redistributions of source code must retain the above copyright notice,
# this list of conditions and the following disclaimer.
# 
# 2. Redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in the
# documentation and/or other materials provided with the distribution.
# 
# 3. Neither the name of SUSE LLC nor the names of its contributors may be
# used to endorse or promote products derived from this software without
# specific prior written permission.
# 
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
# ************************************************************************* 
#
# "CLI Guide" module
#
package App::Dochazka::CLI::Guide;

=head1 NAME

App::Dochazka::CLI::Guide - Dochazka CLI Guide



=head1 VERSION

Version 0.151

=cut

our $VERSION = '0.151';



=head1 CLI COMMANDS


=head2 Introduction

The CLI commands can be divided into four categories:

=over

=item Commands for generating HTTP requests

=item Commands for Dochazka administrators

=item Commands for Dochazka supervisors

=item Commands for Dochazka users

=back


=head2 Commands for generating HTTP requests

The CLI enables the user to generate HTTP requests to an L<App::Dochazka::REST>
server and view the server's responses. Commands in this category -- also known
as "REST test" commands -- have a direct correlation with the REST server
resources, always starting with one of the four basic HTTP methods supported by
the REST server: C<GET>, C<PUT>, C<POST>, C<DELETE>. These commands
are useful mainly for Dochazka developers, but may also be used by
administrators and normal users -- e.g., for troubleshooting and ad hoc
testing, or for doing things that the "normal" commands do not support. A "best
effort" has been made to support all the REST resources.

Commands in this category start with the HTTP method and continue 
with the resource (except it is written with spaces instead of forward
slashes) and concludes with the request entity, if any.

All CLI commands must be written on a single line of input, and
commands in this category are no exception.

Examples:

=over

=item DELETE INTERVAL IID 24

The equivalent of C<< DELETE interval/iid/24 >>

=item POST DOCU TEXT "employee/eid/:eid"

The equivalent of C<< POST docu/text >> with the request entity shown.

=item POST EMPLOYEE EID { "eid" : 15, "sec_id" : 340 }

Update the secondary ID of the employee with EID 15.

=back

A full list of REST test commands can be found in the source code of the
L<App::Dochazka::CLI::CommandMap> module.


=head2 Commands for Dochazka administrators

Dochazka administrators have access to all of Dochazka's resources and can
call them directly by generating appropriate HTTP requests. This can be a bit
tedious, however, so "real" CLI commands have been implemented for the more
commonly used administrative procedures, like changing an employee's privilege
level or schedule, removing locks, viewing attendance data entered by
employees, etc.

These commands are detailed in the L<"ADMINISTRATOR WORKFLOWS"> section.


=head2 Commands for Dochazka supervisors

Supervisors are Dochazka users who, in "real life", are in charge of a group of
employees who report to them. The idea here is that the supervisor can view and
modify the attendance data and other records of their reports (i.e. of the
employees in their team or department). The commands used for this purpose are
a subset of the administrator commands.

These commands are detailed in the L<"SUPERVISOR WORKFLOWS"> section.


=head2 Commands for Dochazka users

Finally there are the core, day-to-day commands used by Dochazka users
(employees of the organization) to enter attendance data, generate reports,
etc.

These commands are detailed in the L<"USER WORKFLOWS"> section.



=head1 ADMINISTRATOR WORKFLOWS


=head2 Activities


=head3 View all activities, including disabled

    ACTIVITY ALL DISABLED

Displays a list of B<all> activities, including disabled activities.


=head3 Add a new activity

From time to time, new activities will need to be added:

    PUT activity code $CODE { "long_desc" : "activity description here" }

Optionally, a "remark" property can be included as well.


=head3 Disable an activity

To accomplish this, we can use a REST test command:

    POST activity aid $AID { "disabled" : "t" }
    POST activity code $CODE { "disabled" : "t" }

=head3 Re-enable an activity

To accomplish this, we can use a REST test command:

    POST activity aid $AID { "disabled" : "f" }
    POST activity code $CODE { "disabled" : "f" }

=head3 Delete an activity

Assuming nothing points to it, an activity can be deleted:

    DELETE activity aid $AID
    DELETE activity code $CODE


=head1 SUPERVISOR WORKFLOWS




=head1 USER WORKFLOWS


=head2 Activities


=head3 View a list of all activities

To view a list of all activities, do:

    ACTIVITIES
    ACTIVITIES ALL


=head2 Employees


=head3 View own employee profile

Each Dochazka employee has a "profile" with some basic information. One's own
profile can be viewed by doing any of the following:

    EMPLOYEE
    EMPLOYEE PROFILE
    EMPLOYEE SHOW


=cut

1;
