use strict;
use warnings;
use ExtUtils::MakeMaker;

WriteMakefile(
    NAME                => 'AsyncLogWatcher',
    AUTHOR              => 'pannakoota@gmail.com',
    VERSION_FROM        => 'lib/AsyncLogWatcher.pm',
    ABSTRACT_FROM       => 'lib/AsyncLogWatcher.pm',
    LICENSE             => 'artistic_2',
    MAN3PODS            => {
        'man/AsyncLogWatcher.3' => '$(INST_MAN3DIR)/AsyncLogWatcher.3'
    },
    PREREQ_PM           => {
        'perl'                => '5.026',
        'File::Tail' => 0,
    },
    ($ExtUtils::MakeMaker::VERSION >= 6.3002
     ? ('LICENSE'=> 'perl')
     : ()
    ),
    META_MERGE => {
        'meta-spec' => { version => 2 },
        resources => {
            repository => {
                type => 'git',
                url  => 'https://github.com/kawamurashingo/AsyncLogWatcher.git',
                web  => 'https://github.com/kawamurashingo/AsyncLogWatcher.git',
            },
        },
    },
);
