package Acme::CPANAuthors::French;
use utf8;
use strict;
use warnings;

{
    no strict "vars";
    $VERSION = "0.08";
}

use Acme::CPANAuthors::Register (
    AASSAD      => "Arnaud Assad (Arhuman)",
    ALAMAZ      => "Joseph Benzakoun",
    BOOK        => "Philippe Bruhat (BooK)",
    BOUBAKER    => "Heddy Boubaker",
    BRIAC       => "Briac Pilpré",
    CASTOR      => "Raphaël Roulet",
    CBOUVI      => "Cédric Bouvier",
    CFILIPPE    => "Christophe Filippelli",     # has nothing on the CPAN
    CGUINE      => "Christian Guine",
    CHOLET      => "Éric Cholet",
    CMAUSSAN    => "Camille Maussang",          # has nothing on the CPAN
    CMERTZ      => "Christophe Mertz",
    CYK         => "Philippe Chane You Kaye",
    CYPLP       => "Cyprien Le Pannérer",
    DAMI        => "Laurent Dami",
    DAMS        => "Damien Krotkine",
    DAUNAY      => "David Aunay",
    DBARTH      => "David Barth",
    DDUMONT     => "Dominique Dumont",
    DLAND       => "David Landgren",
    DMOR        => "David Morel",
    DOMQ        => "Dominique Quatravaux",
    DOLMEN      => "Olivier Mengué (dolmen)",
    DOUMBZH     => "Dominique Launay",
    DRAUONER    => "Jean-Marie Renouard",
    DUPUISARN   => "Arnaud Dupuis",
    ECOCODE     => "Erik Colson",
    EDIPRETO    => "Emmanuel Di Pretoro",
    EGERMAN     => "Éric German",
    ELLIPSE     => "Grégory Vanuxem",
    ERIAM       => "Eriam Schaffter",
    FBRIERE     => "Frédéric Brière",
    FDESAR      => "François Désarmenien",
    FIGANIM     => "Frédéric Perrin",
    FMC         => "Frédéric Chauveau",
    FPORCHER    => "Franck Porcher",
    FRACOLO     => "François Colombier",
    FRANCKC     => "Franck Cuny",
    FRETT       => "Patrice Freydiere",
    GERBERRI    => "Richard Gerber",            # has nothing on the CPAN
    GUIMARD     => "Xavier Guimard",
    GOMOR       => "Patrice Auffret",
    GROMMIER    => "Sébastien Grommier",
    GROUSSE     => "Guillaume Rousse",
    GUYDX       => "Guy Decoux",
    JACQUELIN   => "Jacquelin Charbonnel",
    JBNIVOIT    => "Jean-Baptiste Nivoit",
    JETEVE      => "Jérôme Eteve",
    JFENAL      => "Jérôme Fenal",
    JFORGET     => "Jean Forget",
    JGL         => "Jean Galineau",
    JHIVER      => "Jean-Michel Hiver",
    JMFAYARD    => "Jean-Michel Fayard",
    JLMOREL     => "Jean-Louis Morel",
    JMGDOC      => "Jean-Marie Gouarné",
    JMPENNEL    => "Jean-Marc Pennel",          # has nothing on the CPAN
    JMVILOMET   => "Jean-Michel Vilomet",
    JPDURRIOS   => "Jean-Philippe Durrios",
    JPVIDAL     => "Jean-Pierre Vidal",
    JQUELIN     => "Jérôme Quelin",
    JUCROUZET   => "Julien Crouzet",            # has nothing on the CPAN
    KAFKA       => "Nicolas Herry",             # has nothing on the CPAN
    KERMAGO     => "Jean-Christophe Kermagoret",
    KORSANI     => "Korsani",
    KRISSG      => "Christophe Grosjean",
    LEUCOS      => "Michel Blanc",              # has nothing on the CPAN
    LGAUTROT    => "Laurent Gautrot",
    LSIM        => "Laurent Simonneau",
    LWA         => "Laurent Wacrenier",
    MAT         => "Mathieu Arnold",
    MHALLGREN   => "Michael Hallgren",          # has nothing on the CPAN
    MIROD       => "Michel Rodriguez",
    MISC        => "Michael Scherer",
    MJONDET     => "Mathieu Jondet",
    MOUNS       => "Samuel Mouniée",
    NANARDON    => "Olivier Thauvin",
    NBAREIL     => "Nicolas Bareil",
    NCHUCHE     => "Nicolas Chuche",
    NMONNET     => "Nicolas Monnet",            # has nothing on the CPAN
    NRINEAU     => "Nicolas Rineau",            # has nothing on the CPAN
    NTHIERY     => "Nicolas Thiéry",            # has nothing on the CPAN
    NTHIERYA    => "Nicolas Thiéry", #==NTHIERY # has nothing on the CPAN
    OARCHER     => "Olivier Archer",
    OLIBOU      => "Olivier Bouteille",
    ORTALO      => "Rodolphe Ortalo",
    OSALAUN     => "Olivier Salaün",
    PDENIS      => "Pierre Denis",
    PERRAD      => "Francois Perrad",
    PIXEL       => "Pascal Rigaux",
    PLEGALL     => "Pierrick Le Gall",
    PMEVZEK     => "Patrick Mevzek",
    POLGAB      => "Paul Gaborit",
    PVERD       => "Philippe Verdret",
    RAF         => "Raphaël Gommeaux",
    RAFAEL      => "Franck Dubois",
    RBERJON     => "Robin Berjon",
    RCHIBOIS    => "Remy Chibois",
    RECKON      => "Franck Latrémolière",
    RENNERT     => "Nicolas Rennert",           # has nothing on the CPAN
    RGARCIA     => "Rafaël Garcia-Suarez",
    ROSSI       => "Christian Rossi",
    ROUGE       => "Jean-Francois Paris",       # has nothing on the CPAN
    SAPER       => "Sébastien Aperghis-Tramoni (Maddingue)",
    SBZ         => "Sofian Brabez",             # has nothing on the CPAN
    SCOLINET    => "Sylvain Colinet (Skarsnik)",
    SDP         => "Sébastien Darribere-Pleyt",
    SEBDIAZ     => "Sebastien Diaz",
    SMAXIME     => "Soulé Maxime",              # has nothing on the CPAN
    SMILLET     => "Sébastien Millet",          # has nothing on the CPAN
    SNCK        => "Stephane Chmielewski",
    SNIPER      => "David Rigaudiere (Sniper)", # has nothing on the CPAN
    STEF        => "Stéphane Payrard",          # has nothing on the CPAN
    STHEBERT    => "Sébastien Thebert",         # has nothing on the CPAN
    STOUGARD    => "Stéphane Tougard",
    SUKRIA      => "Alexis Sukrieh",
    TCHINCHOW   => "Lionel Victor",
    TDRUGEON    => "Thomas Drugeon",
    THHAMON     => "Thierry Hamon",
    VPIT        => "Vincent Pit",
    XAV         => "Xavier Caron",              # has nothing on the CPAN
    YANN        => "Yannick Le Saint",          # has nothing on the CPAN
    YBLUSSEAU   => "Yves Blusseau",
    YVESAGO     => "Yves Agostini",
    ZERODEUX    => "Vincent Caron",             # has nothing on the CPAN
);


q<
    listen to 「陽の当たる月曜日」 by サエキけんぞう
    » http://www.myspace.com/cloclomadeinjapan
>


__END__

=encoding UTF-8

=head1 NAME

Acme::CPANAuthors::French - We are French-speaking CPAN authors

Acme::CPANAuthors::French - Nous sommes des auteurs CPAN francophones


=head1 VERSION

Version 0.07


=head1 SYNOPSIS

   use Acme::CPANAuthors;

   my $authors  = Acme::CPANAuthors->new("French");

   my $number   = $authors->count;
   my @ids      = $authors->id;
   my @distros  = $authors->distributions("SAPER");
   my $url      = $authors->avatar_url("VPIT");
   my $kwalitee = $authors->kwalitee("BOOK");
   my $name     = $authors->name("RGARCIA");


=head1 DESCRIPTION

This class provides a hash of French CPAN authors' PAUSE ID and name to 
the C<Acme::CPANAuthors> module.


=head1 MAINTENANCE

If you are a French CPAN author not listed here, please send me your ID/name 
via email or RT so we can always keep this module up to date. If there's a 
mistake and you're listed here but are not French (or just don't want to be 
listed), sorry for the inconvenience: please contact me and I'll remove the 
entry right away.


=head1 SEE ALSO

L<Acme::CPANAuthors> - Main class to manipulate this one

L<Acme::CPANAuthors::Austrian> - Austrian CPAN authors

L<Acme::CPANAuthors::Brazilian> - Brazilian CPAN authors

L<Acme::CPANAuthors::Chinese> - Chinese CPAN authors

L<Acme::CPANAuthors::Japanese> - Japanese CPAN authors


=head1 AUTHOR

Sébastien Aperghis-Tramoni C<< <sebastien at aperghis.net> >>


=head1 BUGS

Please report any bugs or feature requests to 
C<bug-acme-cpanauthors-french at rt.cpan.org>, or through the web interface at
L<http://rt.cpan.org/Dist/Display.html?Queue=Acme-CPANAuthors-French>.
I will be notified, and then you'll automatically be notified of 
progress on your bug as I make changes.


=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Acme::CPANAuthors::French

You can also look for information at:

=over 4

=item * RT: CPAN's request tracker

L<http://rt.cpan.org/Dist/Display.html?Queue=Acme-CPANAuthors-French>

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/Acme-CPANAuthors-French>

=item * CPAN Ratings

L<http://cpanratings.perl.org/d/Acme-CPANAuthors-French>

=item * Search CPAN

L<http://search.cpan.org/dist/Acme-CPANAuthors-French>

=back


=head1 ACKNOWLEDGEMENTS

Thanks to Kenichi Ishigaki for writing C<Acme::CPANAuthors>.


=head1 COPYRIGHT & LICENSE

Copyright 2008 Sébastien Aperghis-Tramoni, all rights reserved.

This program is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut
