use Test::More;
BEGIN {
    eval { require XML::Twig };
    if ( $@ ) {
        plan 'skip_all' => 'XML::Twig not installed';
    }
    else {
        plan 'tests' => 2;
    }
}

use strict;
use Bio::Phylo::IO qw'parse unparse';
use Bio::Phylo::Util::Logger;
use Bio::Phylo::Util::CONSTANT qw':objecttypes looks_like_object';

my $project = parse(
	'-format' => 'phyloxml',
	'-string' => tree1(),
	'-as_project' => 1,
);
ok( looks_like_object $project, _PROJECT_ );

my $string = unparse(
	'-format' => 'phyloxml',
	'-phylo'  => $project,
);
ok( $string );


sub tree1 {
return <<'TREE1';
<?xml version="1.0" encoding="UTF-8"?>
<phyloxml xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
   xsi:schemaLocation="http://www.phyloxml.org http://www.phyloxml.org/1.10/phyloxml.xsd"
   xmlns="http://www.phyloxml.org">
   <phylogeny rooted="true">
      <name>Bcl-2</name>
      <clade>
         <events>
            <duplications>1</duplications>
         </events>
         <clade>
            <branch_length>0.21409500000000004</branch_length>
            <confidence type="bootstrap">33.0</confidence>
            <events>
               <duplications>1</duplications>
            </events>
            <clade>
               <branch_length>0.22234</branch_length>
               <confidence type="bootstrap">58.0</confidence>
               <events>
                  <duplications>1</duplications>
               </events>
               <clade>
                  <branch_length>0.68133</branch_length>
                  <confidence type="bootstrap">99.0</confidence>
                  <events>
                     <duplications>1</duplications>
                  </events>
                  <clade>
                     <branch_length>0.0946</branch_length>
                     <confidence type="bootstrap">72.0</confidence>
                     <events>
                        <duplications>1</duplications>
                     </events>
                     <clade>
                        <branch_length>0.24716</branch_length>
                        <confidence type="bootstrap">35.0</confidence>
                        <events>
                           <speciations>1</speciations>
                        </events>
                        <clade>
                           <branch_length>0.18828</branch_length>
                           <confidence type="bootstrap">33.0</confidence>
                           <events>
                              <duplications>1</duplications>
                           </events>
                           <clade>
                              <branch_length>0.10487</branch_length>
                              <confidence type="bootstrap">37.0</confidence>
                              <events>
                                 <speciations>1</speciations>
                              </events>
                              <clade>
                                 <name>51_CHICK</name>
                                 <branch_length>0.28045</branch_length>
                                 <taxonomy>
                                    <code>CHICK</code>
                                 </taxonomy>
                              </clade>
                              <clade>
                                 <name>145_XENLA</name>
                                 <branch_length>0.59876</branch_length>
                                 <taxonomy>
                                    <code>XENLA</code>
                                 </taxonomy>
                              </clade>
                           </clade>
                           <clade>
                              <branch_length>0.38418</branch_length>
                              <confidence type="bootstrap">100.0</confidence>
                              <events>
                                 <duplications>1</duplications>
                              </events>
                              <clade>
                                 <branch_length>0.0267</branch_length>
                                 <confidence type="bootstrap">39.0</confidence>
                                 <events>
                                    <speciations>1</speciations>
                                 </events>
                                 <clade>
                                    <name>88_CANFA</name>
                                    <branch_length>0.08127</branch_length>
                                    <taxonomy>
                                       <code>CANFA</code>
                                    </taxonomy>
                                 </clade>
                                 <clade>
                                    <name>115_MOUSE</name>
                                    <branch_length>0.14168</branch_length>
                                    <taxonomy>
                                       <code>MOUSE</code>
                                    </taxonomy>
                                 </clade>
                              </clade>
                              <clade>
                                 <branch_length>1.0E-5</branch_length>
                                 <confidence type="bootstrap">55.0</confidence>
                                 <events>
                                    <speciations>1</speciations>
                                 </events>
                                 <clade>
                                    <name>74_BOVIN</name>
                                    <branch_length>0.09416</branch_length>
                                    <taxonomy>
                                       <code>BOVIN</code>
                                    </taxonomy>
                                 </clade>
                                 <clade>
                                    <name>9_HUMAN</name>
                                    <branch_length>0.06828</branch_length>
                                    <taxonomy>
                                       <code>HUMAN</code>
                                    </taxonomy>
                                 </clade>
                              </clade>
                           </clade>
                        </clade>
                        <clade>
                           <branch_length>0.35342</branch_length>
                           <confidence type="bootstrap">100.0</confidence>
                           <events>
                              <duplications>1</duplications>
                           </events>
                           <clade>
                              <name>159_BRARE</name>
                              <branch_length>0.01275</branch_length>
                              <taxonomy>
                                 <code>BRARE</code>
                              </taxonomy>
                           </clade>
                           <clade>
                              <name>166_BRARE</name>
                              <branch_length>0.02259</branch_length>
                              <taxonomy>
                                 <code>BRARE</code>
                              </taxonomy>
                           </clade>
                        </clade>
                     </clade>
                     <clade>
                        <branch_length>0.39739</branch_length>
                        <confidence type="bootstrap">99.0</confidence>
                        <events>
                           <speciations>1</speciations>
                        </events>
                        <clade>
                           <name>52_CHICK</name>
                           <branch_length>0.27747</branch_length>
                           <taxonomy>
                              <code>CHICK</code>
                           </taxonomy>
                        </clade>
                        <clade>
                           <name>144_XENLA</name>
                           <branch_length>0.34644</branch_length>
                           <taxonomy>
                              <code>XENLA</code>
                           </taxonomy>
                        </clade>
                     </clade>
                  </clade>
                  <clade>
                     <branch_length>0.51997</branch_length>
                     <confidence type="bootstrap">100.0</confidence>
                     <events>
                        <speciations>1</speciations>
                     </events>
                     <clade>
                        <branch_length>0.0983</branch_length>
                        <confidence type="bootstrap">56.0</confidence>
                        <events>
                           <speciations>1</speciations>
                        </events>
                        <clade>
                           <branch_length>0.5126</branch_length>
                           <confidence type="bootstrap">100.0</confidence>
                           <events>
                              <duplications>1</duplications>
                           </events>
                           <clade>
                              <branch_length>1.0E-5</branch_length>
                              <confidence type="bootstrap">46.0</confidence>
                              <events>
                                 <speciations>1</speciations>
                              </events>
                              <clade>
                                 <name>90_CANFA</name>
                                 <branch_length>0.03744</branch_length>
                                 <taxonomy>
                                    <code>CANFA</code>
                                 </taxonomy>
                              </clade>
                              <clade>
                                 <name>12_HUMAN</name>
                                 <branch_length>0.07368</branch_length>
                                 <taxonomy>
                                    <code>HUMAN</code>
                                 </taxonomy>
                              </clade>
                           </clade>
                           <clade>
                              <name>64_BOVIN</name>
                              <branch_length>0.05675</branch_length>
                              <taxonomy>
                                 <code>BOVIN</code>
                              </taxonomy>
                           </clade>
                        </clade>
                        <clade>
                           <name>142_XENLA</name>
                           <branch_length>0.26292</branch_length>
                           <taxonomy>
                              <code>XENLA</code>
                           </taxonomy>
                        </clade>
                     </clade>
                     <clade>
                        <branch_length>0.34592</branch_length>
                        <confidence type="bootstrap">99.0</confidence>
                        <events>
                           <duplications>1</duplications>
                        </events>
                        <clade>
                           <name>155_BRARE</name>
                           <branch_length>1.0E-5</branch_length>
                           <taxonomy>
                              <code>BRARE</code>
                           </taxonomy>
                        </clade>
                        <clade>
                           <name>154_BRARE</name>
                           <branch_length>1.0E-5</branch_length>
                           <taxonomy>
                              <code>BRARE</code>
                           </taxonomy>
                        </clade>
                     </clade>
                  </clade>
               </clade>
               <clade>
                  <branch_length>1.25362</branch_length>
                  <confidence type="bootstrap">100.0</confidence>
                  <events>
                     <duplications>1</duplications>
                  </events>
                  <clade>
                     <name>125_MOUSE</name>
                     <branch_length>0.04425</branch_length>
                     <taxonomy>
                        <code>MOUSE</code>
                     </taxonomy>
                  </clade>
                  <clade>
                     <branch_length>0.14928</branch_length>
                     <confidence type="bootstrap">40.0</confidence>
                     <events>
                        <speciations>1</speciations>
                     </events>
                     <clade>
                        <name>95_CANFA</name>
                        <branch_length>0.09977</branch_length>
                        <taxonomy>
                           <code>CANFA</code>
                        </taxonomy>
                     </clade>
                     <clade>
                        <name>13_HUMAN</name>
                        <branch_length>0.07433</branch_length>
                        <taxonomy>
                           <code>HUMAN</code>
                        </taxonomy>
                     </clade>
                  </clade>
               </clade>
            </clade>
            <clade>
               <branch_length>0.57089</branch_length>
               <confidence type="bootstrap">66.0</confidence>
               <events>
                  <speciations>1</speciations>
               </events>
               <clade>
                  <branch_length>0.53798</branch_length>
                  <confidence type="bootstrap">100.0</confidence>
                  <events>
                     <duplications>1</duplications>
                  </events>
                  <clade>
                     <name>16_SPHGR</name>
                     <branch_length>1.0E-5</branch_length>
                     <taxonomy>
                        <code>SPHGR</code>
                     </taxonomy>
                  </clade>
                  <clade>
                     <name>17_SPHGR</name>
                     <branch_length>1.0E-5</branch_length>
                     <taxonomy>
                        <code>SPHGR</code>
                     </taxonomy>
                  </clade>
               </clade>
               <clade>
                  <branch_length>0.69471</branch_length>
                  <confidence type="bootstrap">89.0</confidence>
                  <events>
                     <speciations>1</speciations>
                  </events>
                  <clade>
                     <branch_length>0.15935</branch_length>
                     <confidence type="bootstrap">83.0</confidence>
                     <events>
                        <speciations>1</speciations>
                     </events>
                     <clade>
                        <branch_length>0.24123</branch_length>
                        <confidence type="bootstrap">100.0</confidence>
                        <events>
                           <duplications>1</duplications>
                        </events>
                        <clade>
                           <name>158_BRARE</name>
                           <branch_length>1.0E-5</branch_length>
                           <taxonomy>
                              <code>BRARE</code>
                           </taxonomy>
                        </clade>
                        <clade>
                           <name>169_BRARE</name>
                           <branch_length>1.0E-5</branch_length>
                           <taxonomy>
                              <code>BRARE</code>
                           </taxonomy>
                        </clade>
                     </clade>
                     <clade>
                        <name>130_TETNG</name>
                        <branch_length>0.37777</branch_length>
                        <taxonomy>
                           <code>TETNG</code>
                        </taxonomy>
                     </clade>
                  </clade>
                  <clade>
                     <branch_length>0.13835</branch_length>
                     <confidence type="bootstrap">44.0</confidence>
                     <events>
                        <speciations>1</speciations>
                     </events>
                     <clade>
                        <branch_length>0.1765</branch_length>
                        <confidence type="bootstrap">73.0</confidence>
                        <events>
                           <duplications>1</duplications>
                        </events>
                        <clade>
                           <name>122_MOUSE</name>
                           <branch_length>0.10759</branch_length>
                           <taxonomy>
                              <code>MOUSE</code>
                           </taxonomy>
                        </clade>
                        <clade>
                           <branch_length>0.09256</branch_length>
                           <confidence type="bootstrap">44.0</confidence>
                           <events>
                              <speciations>1</speciations>
                           </events>
                           <clade>
                              <branch_length>0.01016</branch_length>
                              <confidence type="bootstrap">40.0</confidence>
                              <events>
                                 <duplications>1</duplications>
                              </events>
                              <clade>
                                 <branch_length>0.0243</branch_length>
                                 <confidence type="bootstrap">32.0</confidence>
                                 <events>
                                    <speciations>1</speciations>
                                 </events>
                                 <clade>
                                    <name>11_HUMAN</name>
                                    <branch_length>0.02336</branch_length>
                                    <taxonomy>
                                       <code>HUMAN</code>
                                    </taxonomy>
                                 </clade>
                                 <clade>
                                    <name>68_BOVIN</name>
                                    <branch_length>0.24624</branch_length>
                                    <taxonomy>
                                       <code>BOVIN</code>
                                    </taxonomy>
                                 </clade>
                              </clade>
                              <clade>
                                 <name>92_CANFA</name>
                                 <branch_length>1.0E-5</branch_length>
                                 <taxonomy>
                                    <code>CANFA</code>
                                 </taxonomy>
                              </clade>
                           </clade>
                           <clade>
                              <name>46_CHICK</name>
                              <branch_length>1.06707</branch_length>
                              <taxonomy>
                                 <code>CHICK</code>
                              </taxonomy>
                           </clade>
                        </clade>
                     </clade>
                     <clade>
                        <name>147_XENLA</name>
                        <branch_length>0.43513</branch_length>
                        <taxonomy>
                           <code>XENLA</code>
                        </taxonomy>
                     </clade>
                  </clade>
               </clade>
            </clade>
         </clade>
         <clade>
            <branch_length>0.21984499999999996</branch_length>
            <confidence type="bootstrap">33.0</confidence>
            <events>
               <duplications>1</duplications>
            </events>
            <clade>
               <branch_length>0.13885</branch_length>
               <confidence type="bootstrap">14.0</confidence>
               <events>
                  <duplications>1</duplications>
               </events>
               <clade>
                  <branch_length>0.07066</branch_length>
                  <confidence type="bootstrap">2.0</confidence>
                  <events>
                     <duplications>1</duplications>
                  </events>
                  <clade>
                     <branch_length>0.0137</branch_length>
                     <confidence type="bootstrap">3.0</confidence>
                     <events>
                        <speciations>1</speciations>
                     </events>
                     <clade>
                        <branch_length>0.10632</branch_length>
                        <confidence type="bootstrap">4.0</confidence>
                        <events>
                           <duplications>1</duplications>
                        </events>
                        <clade>
                           <branch_length>0.09782</branch_length>
                           <confidence type="bootstrap">15.0</confidence>
                           <events>
                              <speciations>1</speciations>
                           </events>
                           <clade>
                              <branch_length>0.08093</branch_length>
                              <confidence type="bootstrap">32.0</confidence>
                              <events>
                                 <speciations>1</speciations>
                              </events>
                              <clade>
                                 <branch_length>0.17228</branch_length>
                                 <confidence type="bootstrap">52.0</confidence>
                                 <events>
                                    <duplications>1</duplications>
                                 </events>
                                 <clade>
                                    <branch_length>0.22305</branch_length>
                                    <confidence type="bootstrap">76.0</confidence>
                                    <events>
                                       <duplications>1</duplications>
                                    </events>
                                    <clade>
                                       <branch_length>0.00625</branch_length>
                                       <confidence type="bootstrap">55.0</confidence>
                                       <events>
                                          <speciations>1</speciations>
                                       </events>
                                       <clade>
                                          <name>140_TETNG</name>
                                          <branch_length>0.92309</branch_length>
                                          <taxonomy>
                                             <code>TETNG</code>
                                          </taxonomy>
                                       </clade>
                                       <clade>
                                          <branch_length>0.07662</branch_length>
                                          <confidence type="bootstrap">43.0</confidence>
                                          <events>
                                             <speciations>1</speciations>
                                          </events>
                                          <clade>
                                             <name>152_XENLA</name>
                                             <branch_length>0.19286</branch_length>
                                             <taxonomy>
                                                <code>XENLA</code>
                                             </taxonomy>
                                          </clade>
                                          <clade>
                                             <branch_length>0.0429</branch_length>
                                             <confidence type="bootstrap">35.0</confidence>
                                             <events>
                                                <speciations>1</speciations>
                                             </events>
                                             <clade>
                                                <branch_length>0.06125</branch_length>
                                                <confidence type="bootstrap">68.0</confidence>
                                                <events>
                                                   <duplications>1</duplications>
                                                </events>
                                                <clade>
                                                   <branch_length>1.0E-5</branch_length>
                                                   <confidence type="bootstrap">93.0</confidence>
                                                   <events>
                                                      <duplications>1</duplications>
                                                   </events>
                                                   <clade>
                                                      <branch_length>1.0E-5</branch_length>
                                                      <confidence type="bootstrap">75.0</confidence>
                                                      <events>
                                                         <speciations>1</speciations>
                                                      </events>
                                                      <clade>
                                                         <name>0_HUMAN</name>
                                                         <branch_length>1.0E-5</branch_length>
                                                         <taxonomy>
                                                            <code>HUMAN</code>
                                                         </taxonomy>
                                                      </clade>
                                                      <clade>
                                                         <name>72_BOVIN</name>
                                                         <branch_length>0.0105</branch_length>
                                                         <taxonomy>
                                                            <code>BOVIN</code>
                                                         </taxonomy>
                                                      </clade>
                                                   </clade>
                                                   <clade>
                                                      <name>123_MOUSE</name>
                                                      <branch_length>0.01053</branch_length>
                                                      <taxonomy>
                                                         <code>MOUSE</code>
                                                      </taxonomy>
                                                   </clade>
                                                </clade>
                                                <clade>
                                                   <name>97_CANFA</name>
                                                   <branch_length>1.0E-5</branch_length>
                                                   <taxonomy>
                                                      <code>CANFA</code>
                                                   </taxonomy>
                                                </clade>
                                             </clade>
                                             <clade>
                                                <name>41_CHICK</name>
                                                <branch_length>0.03818</branch_length>
                                                <taxonomy>
                                                   <code>CHICK</code>
                                                </taxonomy>
                                             </clade>
                                          </clade>
                                       </clade>
                                    </clade>
                                    <clade>
                                       <branch_length>0.07344</branch_length>
                                       <confidence type="bootstrap">38.0</confidence>
                                       <events>
                                          <speciations>1</speciations>
                                       </events>
                                       <clade>
                                          <branch_length>0.18878</branch_length>
                                          <confidence type="bootstrap">96.0</confidence>
                                          <events>
                                             <speciations>1</speciations>
                                          </events>
                                          <clade>
                                             <branch_length>0.02241</branch_length>
                                             <confidence type="bootstrap">81.0</confidence>
                                             <events>
                                                <duplications>1</duplications>
                                             </events>
                                             <clade>
                                                <name>132_TETNG</name>
                                                <branch_length>1.0E-5</branch_length>
                                                <taxonomy>
                                                   <code>TETNG</code>
                                                </taxonomy>
                                             </clade>
                                             <clade>
                                                <name>135_TETNG</name>
                                                <branch_length>1.0E-5</branch_length>
                                                <taxonomy>
                                                   <code>TETNG</code>
                                                </taxonomy>
                                             </clade>
                                          </clade>
                                          <clade>
                                             <name>102_FUGRU</name>
                                             <branch_length>0.00904</branch_length>
                                             <taxonomy>
                                                <code>FUGRU</code>
                                             </taxonomy>
                                          </clade>
                                       </clade>
                                       <clade>
                                          <name>167_BRARE</name>
                                          <branch_length>0.26949</branch_length>
                                          <taxonomy>
                                             <code>BRARE</code>
                                          </taxonomy>
                                       </clade>
                                    </clade>
                                 </clade>
                                 <clade>
                                    <branch_length>0.0375</branch_length>
                                    <confidence type="bootstrap">23.0</confidence>
                                    <events>
                                       <duplications>1</duplications>
                                    </events>
                                    <clade>
                                       <branch_length>0.23552</branch_length>
                                       <confidence type="bootstrap">99.0</confidence>
                                       <events>
                                          <speciations>1</speciations>
                                       </events>
                                       <clade>
                                          <name>151_XENLA</name>
                                          <branch_length>0.12315</branch_length>
                                          <taxonomy>
                                             <code>XENLA</code>
                                          </taxonomy>
                                       </clade>
                                       <clade>
                                          <branch_length>0.22499</branch_length>
                                          <confidence type="bootstrap">100.0</confidence>
                                          <events>
                                             <duplications>1</duplications>
                                          </events>
                                          <clade>
                                             <name>126_MOUSE</name>
                                             <branch_length>1.0E-5</branch_length>
                                             <taxonomy>
                                                <code>MOUSE</code>
                                             </taxonomy>
                                          </clade>
                                          <clade>
                                             <branch_length>0.01047</branch_length>
                                             <confidence type="bootstrap">100.0</confidence>
                                             <events>
                                                <duplications>1</duplications>
                                             </events>
                                             <clade>
                                                <name>96_CANFA</name>
                                                <branch_length>1.0E-5</branch_length>
                                                <taxonomy>
                                                   <code>CANFA</code>
                                                </taxonomy>
                                             </clade>
                                             <clade>
                                                <branch_length>1.0E-5</branch_length>
                                                <confidence type="bootstrap">100.0</confidence>
                                                <events>
                                                   <speciations>1</speciations>
                                                </events>
                                                <clade>
                                                   <name>8_HUMAN</name>
                                                   <branch_length>1.0E-5</branch_length>
                                                   <taxonomy>
                                                      <code>HUMAN</code>
                                                   </taxonomy>
                                                </clade>
                                                <clade>
                                                   <name>79_BOVIN</name>
                                                   <branch_length>1.0E-5</branch_length>
                                                   <taxonomy>
                                                      <code>BOVIN</code>
                                                   </taxonomy>
                                                </clade>
                                             </clade>
                                          </clade>
                                       </clade>
                                    </clade>
                                    <clade>
                                       <branch_length>0.04974</branch_length>
                                       <confidence type="bootstrap">25.0</confidence>
                                       <events>
                                          <speciations>1</speciations>
                                       </events>
                                       <clade>
                                          <branch_length>0.20281</branch_length>
                                          <confidence type="bootstrap">86.0</confidence>
                                          <events>
                                             <duplications>1</duplications>
                                          </events>
                                          <clade>
                                             <branch_length>1.0E-5</branch_length>
                                             <confidence type="bootstrap">92.0</confidence>
                                             <events>
                                                <speciations>1</speciations>
                                             </events>
                                             <clade>
                                                <name>164_BRARE</name>
                                                <branch_length>0.02901</branch_length>
                                                <taxonomy>
                                                   <code>BRARE</code>
                                                </taxonomy>
                                             </clade>
                                             <clade>
                                                <branch_length>0.06877</branch_length>
                                                <confidence type="bootstrap">100.0</confidence>
                                                <events>
                                                   <speciations>1</speciations>
                                                </events>
                                                <clade>
                                                   <name>136_TETNG</name>
                                                   <branch_length>0.01045</branch_length>
                                                   <taxonomy>
                                                      <code>TETNG</code>
                                                   </taxonomy>
                                                </clade>
                                                <clade>
                                                   <name>100_FUGRU</name>
                                                   <branch_length>1.0E-5</branch_length>
                                                   <taxonomy>
                                                      <code>FUGRU</code>
                                                   </taxonomy>
                                                </clade>
                                             </clade>
                                          </clade>
                                          <clade>
                                             <branch_length>0.17649</branch_length>
                                             <confidence type="bootstrap">84.0</confidence>
                                             <events>
                                                <duplications>1</duplications>
                                             </events>
                                             <clade>
                                                <branch_length>0.05352</branch_length>
                                                <confidence type="bootstrap">97.0</confidence>
                                                <events>
                                                   <speciations>1</speciations>
                                                </events>
                                                <clade>
                                                   <name>129_TETNG</name>
                                                   <branch_length>6.9E-4</branch_length>
                                                   <taxonomy>
                                                      <code>TETNG</code>
                                                   </taxonomy>
                                                </clade>
                                                <clade>
                                                   <name>104_FUGRU</name>
                                                   <branch_length>0.03078</branch_length>
                                                   <taxonomy>
                                                      <code>FUGRU</code>
                                                   </taxonomy>
                                                </clade>
                                             </clade>
                                             <clade>
                                                <branch_length>0.23291</branch_length>
                                                <confidence type="bootstrap">95.0</confidence>
                                                <events>
                                                   <speciations>1</speciations>
                                                </events>
                                                <clade>
                                                   <name>128_TETNG</name>
                                                   <branch_length>0.36032</branch_length>
                                                   <taxonomy>
                                                      <code>TETNG</code>
                                                   </taxonomy>
                                                </clade>
                                                <clade>
                                                   <branch_length>0.24906</branch_length>
                                                   <confidence type="bootstrap">100.0</confidence>
                                                   <events>
                                                      <duplications>1</duplications>
                                                   </events>
                                                   <clade>
                                                      <name>103_FUGRU</name>
                                                      <branch_length>0.24206</branch_length>
                                                      <taxonomy>
                                                         <code>FUGRU</code>
                                                      </taxonomy>
                                                   </clade>
                                                   <clade>
                                                      <branch_length>0.09945</branch_length>
                                                      <confidence type="bootstrap">65.0</confidence>
                                                      <events>
                                                         <duplications>1</duplications>
                                                      </events>
                                                      <clade>
                                                         <name>106_FUGRU</name>
                                                         <branch_length>0.04182</branch_length>
                                                         <taxonomy>
                                                            <code>FUGRU</code>
                                                         </taxonomy>
                                                      </clade>
                                                      <clade>
                                                         <branch_length>1.0E-5</branch_length>
                                                         <confidence type="bootstrap">77.0</confidence>
                                                         <events>
                                                            <duplications>1</duplications>
                                                         </events>
                                                         <clade>
                                                            <branch_length>0.0141</branch_length>
                                                            <confidence type="bootstrap">71.0</confidence>
                                                            <events>
                                                            <duplications>1</duplications>
                                                            </events>
                                                            <clade>
                                                            <name>112_FUGRU</name>
                                                            <branch_length>0.03123</branch_length>
                                                            <taxonomy>
                                                            <code>FUGRU</code>
                                                            </taxonomy>
                                                            </clade>
                                                            <clade>
                                                            <name>113_FUGRU</name>
                                                            <branch_length>0.09693</branch_length>
                                                            <taxonomy>
                                                            <code>FUGRU</code>
                                                            </taxonomy>
                                                            </clade>
                                                         </clade>
                                                         <clade>
                                                            <branch_length>0.195</branch_length>
                                                            <confidence type="bootstrap">100.0</confidence>
                                                            <events>
                                                            <duplications>1</duplications>
                                                            </events>
                                                            <clade>
                                                            <name>108_FUGRU</name>
                                                            <branch_length>0.01027</branch_length>
                                                            <taxonomy>
                                                            <code>FUGRU</code>
                                                            </taxonomy>
                                                            </clade>
                                                            <clade>
                                                            <name>111_FUGRU</name>
                                                            <branch_length>0.01081</branch_length>
                                                            <taxonomy>
                                                            <code>FUGRU</code>
                                                            </taxonomy>
                                                            </clade>
                                                         </clade>
                                                      </clade>
                                                   </clade>
                                                </clade>
                                             </clade>
                                          </clade>
                                       </clade>
                                       <clade>
                                          <branch_length>0.03668</branch_length>
                                          <confidence type="bootstrap">58.0</confidence>
                                          <events>
                                             <speciations>1</speciations>
                                          </events>
                                          <clade>
                                             <name>149_XENLA</name>
                                             <branch_length>0.32167</branch_length>
                                             <taxonomy>
                                                <code>XENLA</code>
                                             </taxonomy>
                                          </clade>
                                          <clade>
                                             <branch_length>0.07846</branch_length>
                                             <confidence type="bootstrap">90.0</confidence>
                                             <events>
                                                <speciations>1</speciations>
                                             </events>
                                             <clade>
                                                <name>49_CHICK</name>
                                                <branch_length>0.05537</branch_length>
                                                <taxonomy>
                                                   <code>CHICK</code>
                                                </taxonomy>
                                             </clade>
                                             <clade>
                                                <branch_length>0.03275</branch_length>
                                                <confidence type="bootstrap">83.0</confidence>
                                                <events>
                                                   <duplications>1</duplications>
                                                </events>
                                                <clade>
                                                   <branch_length>0.192</branch_length>
                                                   <confidence type="bootstrap">99.0</confidence>
                                                   <events>
                                                      <duplications>1</duplications>
                                                   </events>
                                                   <clade>
                                                      <name>63_BOVIN</name>
                                                      <branch_length>0.1324</branch_length>
                                                      <taxonomy>
                                                         <code>BOVIN</code>
                                                      </taxonomy>
                                                   </clade>
                                                   <clade>
                                                      <name>80_BOVIN</name>
                                                      <branch_length>0.13424</branch_length>
                                                      <taxonomy>
                                                         <code>BOVIN</code>
                                                      </taxonomy>
                                                   </clade>
                                                </clade>
                                                <clade>
                                                   <branch_length>1.0E-5</branch_length>
                                                   <confidence type="bootstrap">51.0</confidence>
                                                   <events>
                                                      <duplications>1</duplications>
                                                   </events>
                                                   <clade>
                                                      <name>57_BOVIN</name>
                                                      <branch_length>0.01041</branch_length>
                                                      <taxonomy>
                                                         <code>BOVIN</code>
                                                      </taxonomy>
                                                   </clade>
                                                   <clade>
                                                      <branch_length>1.0E-5</branch_length>
                                                      <confidence type="bootstrap">20.0</confidence>
                                                      <events>
                                                         <duplications>1</duplications>
                                                      </events>
                                                      <clade>
                                                         <name>117_MOUSE</name>
                                                         <branch_length>1.0E-5</branch_length>
                                                         <taxonomy>
                                                            <code>MOUSE</code>
                                                         </taxonomy>
                                                      </clade>
                                                      <clade>
                                                         <branch_length>0.01043</branch_length>
                                                         <confidence type="bootstrap">66.0</confidence>
                                                         <events>
                                                            <speciations>1</speciations>
                                                         </events>
                                                         <clade>
                                                            <name>87_CANFA</name>
                                                            <branch_length>1.0E-5</branch_length>
                                                            <taxonomy>
                                                            <code>CANFA</code>
                                                            </taxonomy>
                                                         </clade>
                                                         <clade>
                                                            <name>1_HUMAN</name>
                                                            <branch_length>1.0E-5</branch_length>
                                                            <taxonomy>
                                                            <code>HUMAN</code>
                                                            </taxonomy>
                                                         </clade>
                                                      </clade>
                                                   </clade>
                                                </clade>
                                             </clade>
                                          </clade>
                                       </clade>
                                    </clade>
                                 </clade>
                              </clade>
                              <clade>
                                 <name>25_BRAFL</name>
                                 <branch_length>0.4534</branch_length>
                                 <taxonomy>
                                    <code>BRAFL</code>
                                 </taxonomy>
                              </clade>
                           </clade>
                           <clade>
                              <name>15_SPHGR</name>
                              <branch_length>0.68488</branch_length>
                              <taxonomy>
                                 <code>SPHGR</code>
                              </taxonomy>
                           </clade>
                        </clade>
                        <clade>
                           <name>21_SPHGR</name>
                           <branch_length>1.05022</branch_length>
                           <taxonomy>
                              <code>SPHGR</code>
                           </taxonomy>
                        </clade>
                     </clade>
                     <clade>
                        <branch_length>0.08808</branch_length>
                        <confidence type="bootstrap">22.0</confidence>
                        <events>
                           <duplications>1</duplications>
                        </events>
                        <clade>
                           <name>33_NEMVE</name>
                           <branch_length>0.482</branch_length>
                           <taxonomy>
                              <code>NEMVE</code>
                           </taxonomy>
                        </clade>
                        <clade>
                           <name>30_NEMVE</name>
                           <branch_length>0.47217</branch_length>
                           <taxonomy>
                              <code>NEMVE</code>
                           </taxonomy>
                        </clade>
                     </clade>
                  </clade>
                  <clade>
                     <branch_length>0.28685</branch_length>
                     <confidence type="bootstrap">9.0</confidence>
                     <events>
                        <duplications>1</duplications>
                     </events>
                     <clade>
                        <branch_length>0.17977</branch_length>
                        <confidence type="bootstrap">14.0</confidence>
                        <events>
                           <duplications>1</duplications>
                        </events>
                        <clade>
                           <branch_length>0.4495</branch_length>
                           <confidence type="bootstrap">92.0</confidence>
                           <events>
                              <speciations>1</speciations>
                           </events>
                           <clade>
                              <branch_length>0.33029</branch_length>
                              <confidence type="bootstrap">89.0</confidence>
                              <events>
                                 <speciations>1</speciations>
                              </events>
                              <clade>
                                 <branch_length>0.13116</branch_length>
                                 <confidence type="bootstrap">61.0</confidence>
                                 <events>
                                    <duplications>1</duplications>
                                 </events>
                                 <clade>
                                    <name>165_BRARE</name>
                                    <branch_length>0.30255</branch_length>
                                    <taxonomy>
                                       <code>BRARE</code>
                                    </taxonomy>
                                 </clade>
                                 <clade>
                                    <name>162_BRARE</name>
                                    <branch_length>0.62996</branch_length>
                                    <taxonomy>
                                       <code>BRARE</code>
                                    </taxonomy>
                                 </clade>
                              </clade>
                              <clade>
                                 <branch_length>0.22822</branch_length>
                                 <confidence type="bootstrap">100.0</confidence>
                                 <events>
                                    <speciations>1</speciations>
                                 </events>
                                 <clade>
                                    <name>137_TETNG</name>
                                    <branch_length>0.24501</branch_length>
                                    <taxonomy>
                                       <code>TETNG</code>
                                    </taxonomy>
                                 </clade>
                                 <clade>
                                    <name>107_FUGRU</name>
                                    <branch_length>0.04204</branch_length>
                                    <taxonomy>
                                       <code>FUGRU</code>
                                    </taxonomy>
                                 </clade>
                              </clade>
                           </clade>
                           <clade>
                              <branch_length>0.25726</branch_length>
                              <confidence type="bootstrap">94.0</confidence>
                              <events>
                                 <duplications>1</duplications>
                              </events>
                              <clade>
                                 <branch_length>0.15529</branch_length>
                                 <confidence type="bootstrap">59.0</confidence>
                                 <events>
                                    <speciations>1</speciations>
                                 </events>
                                 <clade>
                                    <name>42_CHICK</name>
                                    <branch_length>0.29479</branch_length>
                                    <taxonomy>
                                       <code>CHICK</code>
                                    </taxonomy>
                                 </clade>
                                 <clade>
                                    <name>143_XENLA</name>
                                    <branch_length>0.60398</branch_length>
                                    <taxonomy>
                                       <code>XENLA</code>
                                    </taxonomy>
                                 </clade>
                              </clade>
                              <clade>
                                 <branch_length>0.13595</branch_length>
                                 <confidence type="bootstrap">100.0</confidence>
                                 <events>
                                    <duplications>1</duplications>
                                 </events>
                                 <clade>
                                    <name>58_BOVIN</name>
                                    <branch_length>0.05604</branch_length>
                                    <taxonomy>
                                       <code>BOVIN</code>
                                    </taxonomy>
                                 </clade>
                                 <clade>
                                    <branch_length>1.0E-5</branch_length>
                                    <confidence type="bootstrap">60.0</confidence>
                                    <events>
                                       <duplications>1</duplications>
                                    </events>
                                    <clade>
                                       <branch_length>0.02217</branch_length>
                                       <confidence type="bootstrap">78.0</confidence>
                                       <events>
                                          <duplications>1</duplications>
                                       </events>
                                       <clade>
                                          <branch_length>1.0E-5</branch_length>
                                          <confidence type="bootstrap">42.0</confidence>
                                          <events>
                                             <speciations>1</speciations>
                                          </events>
                                          <clade>
                                             <name>85_CANFA</name>
                                             <branch_length>0.01109</branch_length>
                                             <taxonomy>
                                                <code>CANFA</code>
                                             </taxonomy>
                                          </clade>
                                          <clade>
                                             <name>2_HUMAN</name>
                                             <branch_length>0.01103</branch_length>
                                             <taxonomy>
                                                <code>HUMAN</code>
                                             </taxonomy>
                                          </clade>
                                       </clade>
                                       <clade>
                                          <name>124_MOUSE</name>
                                          <branch_length>0.04504</branch_length>
                                          <taxonomy>
                                             <code>MOUSE</code>
                                          </taxonomy>
                                       </clade>
                                    </clade>
                                    <clade>
                                       <name>73_BOVIN</name>
                                       <branch_length>1.0E-5</branch_length>
                                       <taxonomy>
                                          <code>BOVIN</code>
                                       </taxonomy>
                                    </clade>
                                 </clade>
                              </clade>
                           </clade>
                        </clade>
                        <clade>
                           <branch_length>0.53052</branch_length>
                           <confidence type="bootstrap">100.0</confidence>
                           <events>
                              <speciations>1</speciations>
                           </events>
                           <clade>
                              <name>45_CHICK</name>
                              <branch_length>0.17601</branch_length>
                              <taxonomy>
                                 <code>CHICK</code>
                              </taxonomy>
                           </clade>
                           <clade>
                              <branch_length>0.40974</branch_length>
                              <confidence type="bootstrap">98.0</confidence>
                              <events>
                                 <duplications>1</duplications>
                              </events>
                              <clade>
                                 <branch_length>0.05702</branch_length>
                                 <confidence type="bootstrap">52.0</confidence>
                                 <events>
                                    <speciations>1</speciations>
                                 </events>
                                 <clade>
                                    <name>91_CANFA</name>
                                    <branch_length>0.10905</branch_length>
                                    <taxonomy>
                                       <code>CANFA</code>
                                    </taxonomy>
                                 </clade>
                                 <clade>
                                    <branch_length>0.06948</branch_length>
                                    <confidence type="bootstrap">63.0</confidence>
                                    <events>
                                       <speciations>1</speciations>
                                    </events>
                                    <clade>
                                       <branch_length>0.18193</branch_length>
                                       <confidence type="bootstrap">100.0</confidence>
                                       <events>
                                          <duplications>1</duplications>
                                       </events>
                                       <clade>
                                          <name>118_MOUSE</name>
                                          <branch_length>0.18633</branch_length>
                                          <taxonomy>
                                             <code>MOUSE</code>
                                          </taxonomy>
                                       </clade>
                                       <clade>
                                          <name>127_MOUSE</name>
                                          <branch_length>1.0E-5</branch_length>
                                          <taxonomy>
                                             <code>MOUSE</code>
                                          </taxonomy>
                                       </clade>
                                    </clade>
                                    <clade>
                                       <name>3_HUMAN</name>
                                       <branch_length>0.04341</branch_length>
                                       <taxonomy>
                                          <code>HUMAN</code>
                                       </taxonomy>
                                    </clade>
                                 </clade>
                              </clade>
                              <clade>
                                 <branch_length>0.09486</branch_length>
                                 <confidence type="bootstrap">100.0</confidence>
                                 <events>
                                    <duplications>1</duplications>
                                 </events>
                                 <clade>
                                    <name>76_BOVIN</name>
                                    <branch_length>1.0E-5</branch_length>
                                    <taxonomy>
                                       <code>BOVIN</code>
                                    </taxonomy>
                                 </clade>
                                 <clade>
                                    <name>71_BOVIN</name>
                                    <branch_length>1.0E-5</branch_length>
                                    <taxonomy>
                                       <code>BOVIN</code>
                                    </taxonomy>
                                 </clade>
                              </clade>
                           </clade>
                        </clade>
                     </clade>
                     <clade>
                        <branch_length>0.13006</branch_length>
                        <confidence type="bootstrap">23.0</confidence>
                        <events>
                           <speciations>1</speciations>
                        </events>
                        <clade>
                           <branch_length>0.40777</branch_length>
                           <confidence type="bootstrap">73.0</confidence>
                           <events>
                              <speciations>1</speciations>
                           </events>
                           <clade>
                              <branch_length>0.33571</branch_length>
                              <confidence type="bootstrap">100.0</confidence>
                              <events>
                                 <speciations>1</speciations>
                              </events>
                              <clade>
                                 <name>157_BRARE</name>
                                 <branch_length>0.2958</branch_length>
                                 <taxonomy>
                                    <code>BRARE</code>
                                 </taxonomy>
                              </clade>
                              <clade>
                                 <name>109_FUGRU</name>
                                 <branch_length>0.19527</branch_length>
                                 <taxonomy>
                                    <code>FUGRU</code>
                                 </taxonomy>
                              </clade>
                           </clade>
                           <clade>
                              <branch_length>0.1832</branch_length>
                              <confidence type="bootstrap">68.0</confidence>
                              <events>
                                 <duplications>1</duplications>
                              </events>
                              <clade>
                                 <branch_length>0.78705</branch_length>
                                 <confidence type="bootstrap">100.0</confidence>
                                 <events>
                                    <speciations>1</speciations>
                                 </events>
                                 <clade>
                                    <name>55_BOVIN</name>
                                    <branch_length>0.43001</branch_length>
                                    <taxonomy>
                                       <code>BOVIN</code>
                                    </taxonomy>
                                 </clade>
                                 <clade>
                                    <branch_length>0.08251</branch_length>
                                    <confidence type="bootstrap">65.0</confidence>
                                    <events>
                                       <speciations>1</speciations>
                                    </events>
                                    <clade>
                                       <name>119_MOUSE</name>
                                       <branch_length>0.64738</branch_length>
                                       <taxonomy>
                                          <code>MOUSE</code>
                                       </taxonomy>
                                    </clade>
                                    <clade>
                                       <name>10_HUMAN</name>
                                       <branch_length>0.18995</branch_length>
                                       <taxonomy>
                                          <code>HUMAN</code>
                                       </taxonomy>
                                    </clade>
                                 </clade>
                              </clade>
                              <clade>
                                 <branch_length>0.09353</branch_length>
                                 <confidence type="bootstrap">48.0</confidence>
                                 <events>
                                    <speciations>1</speciations>
                                 </events>
                                 <clade>
                                    <name>171_CHICK</name>
                                    <branch_length>0.56823</branch_length>
                                    <taxonomy>
                                       <code>CHICK</code>
                                    </taxonomy>
                                 </clade>
                                 <clade>
                                    <name>141_XENLA</name>
                                    <branch_length>0.57176</branch_length>
                                    <taxonomy>
                                       <code>XENLA</code>
                                    </taxonomy>
                                 </clade>
                              </clade>
                           </clade>
                        </clade>
                        <clade>
                           <name>40_CAEEL</name>
                           <branch_length>1.20795</branch_length>
                           <taxonomy>
                              <code>CAEEL</code>
                           </taxonomy>
                        </clade>
                     </clade>
                  </clade>
               </clade>
               <clade>
                  <branch_length>0.09583</branch_length>
                  <confidence type="bootstrap">8.0</confidence>
                  <events>
                     <duplications>1</duplications>
                  </events>
                  <clade>
                     <branch_length>0.03647</branch_length>
                     <confidence type="bootstrap">6.0</confidence>
                     <events>
                        <speciations>1</speciations>
                     </events>
                     <clade>
                        <branch_length>0.15942</branch_length>
                        <confidence type="bootstrap">15.0</confidence>
                        <events>
                           <duplications>1</duplications>
                        </events>
                        <clade>
                           <branch_length>0.37935</branch_length>
                           <confidence type="bootstrap">100.0</confidence>
                           <events>
                              <duplications>1</duplications>
                           </events>
                           <clade>
                              <branch_length>1.0E-5</branch_length>
                              <confidence type="bootstrap">65.0</confidence>
                              <events>
                                 <duplications>1</duplications>
                              </events>
                              <clade>
                                 <name>23_BRAFL</name>
                                 <branch_length>1.0E-5</branch_length>
                                 <taxonomy>
                                    <code>BRAFL</code>
                                 </taxonomy>
                              </clade>
                              <clade>
                                 <name>24_BRAFL</name>
                                 <branch_length>0.08958</branch_length>
                                 <taxonomy>
                                    <code>BRAFL</code>
                                 </taxonomy>
                              </clade>
                           </clade>
                           <clade>
                              <name>26_BRAFL</name>
                              <branch_length>1.0E-5</branch_length>
                              <taxonomy>
                                 <code>BRAFL</code>
                              </taxonomy>
                           </clade>
                        </clade>
                        <clade>
                           <branch_length>0.07297</branch_length>
                           <confidence type="bootstrap">24.0</confidence>
                           <events>
                              <speciations>1</speciations>
                           </events>
                           <clade>
                              <branch_length>0.74877</branch_length>
                              <confidence type="bootstrap">100.0</confidence>
                              <events>
                                 <speciations>1</speciations>
                              </events>
                              <clade>
                                 <branch_length>0.22523</branch_length>
                                 <confidence type="bootstrap">100.0</confidence>
                                 <events>
                                    <speciations>1</speciations>
                                 </events>
                                 <clade>
                                    <name>168_BRARE</name>
                                    <branch_length>0.13915</branch_length>
                                    <taxonomy>
                                       <code>BRARE</code>
                                    </taxonomy>
                                 </clade>
                                 <clade>
                                    <name>131_TETNG</name>
                                    <branch_length>0.07883</branch_length>
                                    <taxonomy>
                                       <code>TETNG</code>
                                    </taxonomy>
                                 </clade>
                              </clade>
                              <clade>
                                 <name>146_XENLA</name>
                                 <branch_length>0.27947</branch_length>
                                 <taxonomy>
                                    <code>XENLA</code>
                                 </taxonomy>
                              </clade>
                           </clade>
                           <clade>
                              <name>14_SPHGR</name>
                              <branch_length>0.61862</branch_length>
                              <taxonomy>
                                 <code>SPHGR</code>
                              </taxonomy>
                           </clade>
                        </clade>
                     </clade>
                     <clade>
                        <branch_length>0.145</branch_length>
                        <confidence type="bootstrap">29.0</confidence>
                        <events>
                           <duplications>1</duplications>
                        </events>
                        <clade>
                           <branch_length>0.14662</branch_length>
                           <confidence type="bootstrap">25.0</confidence>
                           <events>
                              <duplications>1</duplications>
                           </events>
                           <clade>
                              <name>35_NEMVE</name>
                              <branch_length>0.49481</branch_length>
                              <taxonomy>
                                 <code>NEMVE</code>
                              </taxonomy>
                           </clade>
                           <clade>
                              <name>38_NEMVE</name>
                              <branch_length>0.35293</branch_length>
                              <taxonomy>
                                 <code>NEMVE</code>
                              </taxonomy>
                           </clade>
                        </clade>
                        <clade>
                           <name>34_NEMVE</name>
                           <branch_length>0.32221</branch_length>
                           <taxonomy>
                              <code>NEMVE</code>
                           </taxonomy>
                        </clade>
                     </clade>
                  </clade>
                  <clade>
                     <branch_length>0.40409</branch_length>
                     <confidence type="bootstrap">89.0</confidence>
                     <events>
                        <speciations>1</speciations>
                     </events>
                     <clade>
                        <branch_length>0.10452</branch_length>
                        <confidence type="bootstrap">28.0</confidence>
                        <events>
                           <duplications>1</duplications>
                        </events>
                        <clade>
                           <branch_length>0.1139</branch_length>
                           <confidence type="bootstrap">41.0</confidence>
                           <events>
                              <duplications>1</duplications>
                           </events>
                           <clade>
                              <branch_length>0.18551</branch_length>
                              <confidence type="bootstrap">35.0</confidence>
                              <events>
                                 <speciations>1</speciations>
                              </events>
                              <clade>
                                 <branch_length>0.13606</branch_length>
                                 <confidence type="bootstrap">92.0</confidence>
                                 <events>
                                    <duplications>1</duplications>
                                 </events>
                                 <clade>
                                    <branch_length>0.05378</branch_length>
                                    <confidence type="bootstrap">57.0</confidence>
                                    <events>
                                       <speciations>1</speciations>
                                    </events>
                                    <clade>
                                       <branch_length>0.11874</branch_length>
                                       <confidence type="bootstrap">90.0</confidence>
                                       <events>
                                          <speciations>1</speciations>
                                       </events>
                                       <clade>
                                          <name>110_FUGRU</name>
                                          <branch_length>0.56162</branch_length>
                                          <taxonomy>
                                             <code>FUGRU</code>
                                          </taxonomy>
                                       </clade>
                                       <clade>
                                          <name>134_TETNG</name>
                                          <branch_length>0.03296</branch_length>
                                          <taxonomy>
                                             <code>TETNG</code>
                                          </taxonomy>
                                       </clade>
                                    </clade>
                                    <clade>
                                       <branch_length>0.091</branch_length>
                                       <confidence type="bootstrap">66.0</confidence>
                                       <events>
                                          <speciations>1</speciations>
                                       </events>
                                       <clade>
                                          <branch_length>0.04421</branch_length>
                                          <confidence type="bootstrap">62.0</confidence>
                                          <events>
                                             <speciations>1</speciations>
                                          </events>
                                          <clade>
                                             <branch_length>0.13167</branch_length>
                                             <confidence type="bootstrap">94.0</confidence>
                                             <events>
                                                <duplications>1</duplications>
                                             </events>
                                             <clade>
                                                <name>7_HUMAN</name>
                                                <branch_length>1.0E-5</branch_length>
                                                <taxonomy>
                                                   <code>HUMAN</code>
                                                </taxonomy>
                                             </clade>
                                             <clade>
                                                <branch_length>0.01865</branch_length>
                                                <confidence type="bootstrap">61.0</confidence>
                                                <events>
                                                   <speciations>1</speciations>
                                                </events>
                                                <clade>
                                                   <branch_length>0.51198</branch_length>
                                                   <confidence type="bootstrap">100.0</confidence>
                                                   <events>
                                                      <speciations>1</speciations>
                                                   </events>
                                                   <clade>
                                                      <name>89_CANFA</name>
                                                      <branch_length>0.01988</branch_length>
                                                      <taxonomy>
                                                         <code>CANFA</code>
                                                      </taxonomy>
                                                   </clade>
                                                   <clade>
                                                      <name>62_BOVIN</name>
                                                      <branch_length>1.0E-5</branch_length>
                                                      <taxonomy>
                                                         <code>BOVIN</code>
                                                      </taxonomy>
                                                   </clade>
                                                </clade>
                                                <clade>
                                                   <name>114_MOUSE</name>
                                                   <branch_length>0.01315</branch_length>
                                                   <taxonomy>
                                                      <code>MOUSE</code>
                                                   </taxonomy>
                                                </clade>
                                             </clade>
                                          </clade>
                                          <clade>
                                             <name>48_CHICK</name>
                                             <branch_length>1.0E-5</branch_length>
                                             <taxonomy>
                                                <code>CHICK</code>
                                             </taxonomy>
                                          </clade>
                                       </clade>
                                       <clade>
                                          <name>150_XENLA</name>
                                          <branch_length>0.0853</branch_length>
                                          <taxonomy>
                                             <code>XENLA</code>
                                          </taxonomy>
                                       </clade>
                                    </clade>
                                 </clade>
                                 <clade>
                                    <branch_length>1.0E-5</branch_length>
                                    <confidence type="bootstrap">38.0</confidence>
                                    <events>
                                       <speciations>1</speciations>
                                    </events>
                                    <clade>
                                       <branch_length>0.19569</branch_length>
                                       <confidence type="bootstrap">100.0</confidence>
                                       <events>
                                          <speciations>1</speciations>
                                       </events>
                                       <clade>
                                          <name>101_FUGRU</name>
                                          <branch_length>0.02185</branch_length>
                                          <taxonomy>
                                             <code>FUGRU</code>
                                          </taxonomy>
                                       </clade>
                                       <clade>
                                          <name>133_TETNG</name>
                                          <branch_length>0.00907</branch_length>
                                          <taxonomy>
                                             <code>TETNG</code>
                                          </taxonomy>
                                       </clade>
                                    </clade>
                                    <clade>
                                       <branch_length>0.1765</branch_length>
                                       <confidence type="bootstrap">100.0</confidence>
                                       <events>
                                          <duplications>1</duplications>
                                       </events>
                                       <clade>
                                          <name>160_BRARE</name>
                                          <branch_length>1.0E-5</branch_length>
                                          <taxonomy>
                                             <code>BRARE</code>
                                          </taxonomy>
                                       </clade>
                                       <clade>
                                          <name>161_BRARE</name>
                                          <branch_length>1.0E-5</branch_length>
                                          <taxonomy>
                                             <code>BRARE</code>
                                          </taxonomy>
                                       </clade>
                                    </clade>
                                 </clade>
                              </clade>
                              <clade>
                                 <branch_length>0.43964</branch_length>
                                 <confidence type="bootstrap">100.0</confidence>
                                 <events>
                                    <duplications>1</duplications>
                                 </events>
                                 <clade>
                                    <name>98_DROME</name>
                                    <branch_length>0.38195</branch_length>
                                    <taxonomy>
                                       <code>DROME</code>
                                    </taxonomy>
                                 </clade>
                                 <clade>
                                    <name>99_DROME</name>
                                    <branch_length>0.30802</branch_length>
                                    <taxonomy>
                                       <code>DROME</code>
                                    </taxonomy>
                                 </clade>
                              </clade>
                           </clade>
                           <clade>
                              <branch_length>0.18404</branch_length>
                              <confidence type="bootstrap">45.0</confidence>
                              <events>
                                 <speciations>1</speciations>
                              </events>
                              <clade>
                                 <name>22_BRAFL</name>
                                 <branch_length>0.39195</branch_length>
                                 <taxonomy>
                                    <code>BRAFL</code>
                                 </taxonomy>
                              </clade>
                              <clade>
                                 <name>18_SPHGR</name>
                                 <branch_length>0.4734</branch_length>
                                 <taxonomy>
                                    <code>SPHGR</code>
                                 </taxonomy>
                              </clade>
                           </clade>
                        </clade>
                        <clade>
                           <name>20_SPHGR</name>
                           <branch_length>0.64378</branch_length>
                           <taxonomy>
                              <code>SPHGR</code>
                           </taxonomy>
                        </clade>
                     </clade>
                     <clade>
                        <branch_length>0.06108</branch_length>
                        <confidence type="bootstrap">45.0</confidence>
                        <events>
                           <duplications>1</duplications>
                        </events>
                        <clade>
                           <name>39_NEMVE</name>
                           <branch_length>0.56478</branch_length>
                           <taxonomy>
                              <code>NEMVE</code>
                           </taxonomy>
                        </clade>
                        <clade>
                           <branch_length>0.12162</branch_length>
                           <confidence type="bootstrap">57.0</confidence>
                           <events>
                              <duplications>1</duplications>
                           </events>
                           <clade>
                              <branch_length>0.46294</branch_length>
                              <confidence type="bootstrap">100.0</confidence>
                              <events>
                                 <duplications>1</duplications>
                              </events>
                              <clade>
                                 <name>37_NEMVE</name>
                                 <branch_length>1.0E-5</branch_length>
                                 <taxonomy>
                                    <code>NEMVE</code>
                                 </taxonomy>
                              </clade>
                              <clade>
                                 <name>29_NEMVE</name>
                                 <branch_length>1.0E-5</branch_length>
                                 <taxonomy>
                                    <code>NEMVE</code>
                                 </taxonomy>
                              </clade>
                           </clade>
                           <clade>
                              <name>31_NEMVE</name>
                              <branch_length>0.56073</branch_length>
                              <taxonomy>
                                 <code>NEMVE</code>
                              </taxonomy>
                           </clade>
                        </clade>
                     </clade>
                  </clade>
               </clade>
            </clade>
            <clade>
               <branch_length>0.11059</branch_length>
               <confidence type="bootstrap">29.0</confidence>
               <events>
                  <duplications>1</duplications>
               </events>
               <clade>
                  <branch_length>0.24695</branch_length>
                  <confidence type="bootstrap">52.0</confidence>
                  <events>
                     <duplications>1</duplications>
                  </events>
                  <clade>
                     <name>172_XENLA</name>
                     <branch_length>0.53649</branch_length>
                     <taxonomy>
                        <code>XENLA</code>
                     </taxonomy>
                  </clade>
                  <clade>
                     <branch_length>0.09295</branch_length>
                     <confidence type="bootstrap">50.0</confidence>
                     <events>
                        <duplications>1</duplications>
                     </events>
                     <clade>
                        <branch_length>0.14603</branch_length>
                        <confidence type="bootstrap">87.0</confidence>
                        <events>
                           <speciations>1</speciations>
                        </events>
                        <clade>
                           <branch_length>0.09214</branch_length>
                           <confidence type="bootstrap">65.0</confidence>
                           <events>
                              <speciations>1</speciations>
                           </events>
                           <clade>
                              <name>19_SPHGR</name>
                              <branch_length>0.37571</branch_length>
                              <taxonomy>
                                 <code>SPHGR</code>
                              </taxonomy>
                           </clade>
                           <clade>
                              <branch_length>0.09991</branch_length>
                              <confidence type="bootstrap">100.0</confidence>
                              <events>
                                 <duplications>1</duplications>
                              </events>
                              <clade>
                                 <name>28_BRAFL</name>
                                 <branch_length>1.0E-5</branch_length>
                                 <taxonomy>
                                    <code>BRAFL</code>
                                 </taxonomy>
                              </clade>
                              <clade>
                                 <name>27_BRAFL</name>
                                 <branch_length>1.0E-5</branch_length>
                                 <taxonomy>
                                    <code>BRAFL</code>
                                 </taxonomy>
                              </clade>
                           </clade>
                        </clade>
                        <clade>
                           <name>36_NEMVE</name>
                           <branch_length>0.36151</branch_length>
                           <taxonomy>
                              <code>NEMVE</code>
                           </taxonomy>
                        </clade>
                     </clade>
                     <clade>
                        <branch_length>0.34289</branch_length>
                        <confidence type="bootstrap">100.0</confidence>
                        <events>
                           <speciations>1</speciations>
                        </events>
                        <clade>
                           <name>50_CHICK</name>
                           <branch_length>0.05827</branch_length>
                           <taxonomy>
                              <code>CHICK</code>
                           </taxonomy>
                        </clade>
                        <clade>
                           <branch_length>0.22124</branch_length>
                           <confidence type="bootstrap">92.0</confidence>
                           <events>
                              <duplications>1</duplications>
                           </events>
                           <clade>
                              <name>170_MOUSE</name>
                              <branch_length>0.17237</branch_length>
                              <taxonomy>
                                 <code>MOUSE</code>
                              </taxonomy>
                           </clade>
                           <clade>
                              <branch_length>1.0E-5</branch_length>
                              <confidence type="bootstrap">59.0</confidence>
                              <events>
                                 <duplications>1</duplications>
                              </events>
                              <clade>
                                 <name>67_BOVIN</name>
                                 <branch_length>0.05006</branch_length>
                                 <taxonomy>
                                    <code>BOVIN</code>
                                 </taxonomy>
                              </clade>
                              <clade>
                                 <branch_length>0.00337</branch_length>
                                 <confidence type="bootstrap">81.0</confidence>
                                 <events>
                                    <speciations>1</speciations>
                                 </events>
                                 <clade>
                                    <name>84_CANFA</name>
                                    <branch_length>0.01072</branch_length>
                                    <taxonomy>
                                       <code>CANFA</code>
                                    </taxonomy>
                                 </clade>
                                 <clade>
                                    <branch_length>0.02097</branch_length>
                                    <confidence type="bootstrap">98.0</confidence>
                                    <events>
                                       <duplications>1</duplications>
                                    </events>
                                    <clade>
                                       <name>6_HUMAN</name>
                                       <branch_length>0.02091</branch_length>
                                       <taxonomy>
                                          <code>HUMAN</code>
                                       </taxonomy>
                                    </clade>
                                    <clade>
                                       <name>5_HUMAN</name>
                                       <branch_length>0.01043</branch_length>
                                       <taxonomy>
                                          <code>HUMAN</code>
                                       </taxonomy>
                                    </clade>
                                 </clade>
                              </clade>
                           </clade>
                        </clade>
                     </clade>
                  </clade>
               </clade>
               <clade>
                  <branch_length>0.20775</branch_length>
                  <confidence type="bootstrap">73.0</confidence>
                  <events>
                     <speciations>1</speciations>
                  </events>
                  <clade>
                     <name>32_NEMVE</name>
                     <branch_length>0.30744</branch_length>
                     <taxonomy>
                        <code>NEMVE</code>
                     </taxonomy>
                  </clade>
                  <clade>
                     <branch_length>0.27579</branch_length>
                     <confidence type="bootstrap">64.0</confidence>
                     <events>
                        <speciations>1</speciations>
                     </events>
                     <clade>
                        <name>53_CIOIN</name>
                        <branch_length>0.40206</branch_length>
                        <taxonomy>
                           <code>CIOIN</code>
                        </taxonomy>
                     </clade>
                     <clade>
                        <branch_length>0.28261</branch_length>
                        <confidence type="bootstrap">92.0</confidence>
                        <events>
                           <speciations>1</speciations>
                        </events>
                        <clade>
                           <branch_length>0.05338</branch_length>
                           <confidence type="bootstrap">67.0</confidence>
                           <events>
                              <duplications>1</duplications>
                           </events>
                           <clade>
                              <name>156_BRAREb</name>
                              <branch_length>0.64914</branch_length>
                              <taxonomy>
                                 <code>BRARE</code>
                              </taxonomy>
                           </clade>
                           <clade>
                              <branch_length>0.0829</branch_length>
                              <confidence type="bootstrap">70.0</confidence>
                              <events>
                                 <speciations>1</speciations>
                              </events>
                              <clade>
                                 <name>156_BRAREa</name>
                                 <branch_length>0.18704</branch_length>
                                 <taxonomy>
                                    <code>BRARE</code>
                                 </taxonomy>
                              </clade>
                              <clade>
                                 <branch_length>0.03919</branch_length>
                                 <confidence type="bootstrap">100.0</confidence>
                                 <events>
                                    <speciations>1</speciations>
                                 </events>
                                 <clade>
                                    <name>138_TETNG</name>
                                    <branch_length>0.03397</branch_length>
                                    <taxonomy>
                                       <code>TETNG</code>
                                    </taxonomy>
                                 </clade>
                                 <clade>
                                    <name>173_FUGRU</name>
                                    <branch_length>1.0E-5</branch_length>
                                    <taxonomy>
                                       <code>FUGRU</code>
                                    </taxonomy>
                                 </clade>
                              </clade>
                           </clade>
                        </clade>
                        <clade>
                           <branch_length>0.15101</branch_length>
                           <confidence type="bootstrap">78.0</confidence>
                           <events>
                              <speciations>1</speciations>
                           </events>
                           <clade>
                              <name>153_XENLA</name>
                              <branch_length>0.15191</branch_length>
                              <taxonomy>
                                 <code>XENLA</code>
                              </taxonomy>
                           </clade>
                           <clade>
                              <branch_length>0.24267</branch_length>
                              <confidence type="bootstrap">100.0</confidence>
                              <events>
                                 <duplications>1</duplications>
                              </events>
                              <clade>
                                 <name>116_MOUSE</name>
                                 <branch_length>1.0E-5</branch_length>
                                 <taxonomy>
                                    <code>MOUSE</code>
                                 </taxonomy>
                              </clade>
                              <clade>
                                 <branch_length>0.04527</branch_length>
                                 <confidence type="bootstrap">49.0</confidence>
                                 <events>
                                    <speciations>1</speciations>
                                 </events>
                                 <clade>
                                    <name>4_HUMAN</name>
                                    <branch_length>1.0E-5</branch_length>
                                    <taxonomy>
                                       <code>HUMAN</code>
                                    </taxonomy>
                                 </clade>
                                 <clade>
                                    <branch_length>0.011</branch_length>
                                    <confidence type="bootstrap">37.0</confidence>
                                    <events>
                                       <speciations>1</speciations>
                                    </events>
                                    <clade>
                                       <name>94_CANFA</name>
                                       <branch_length>1.0E-5</branch_length>
                                       <taxonomy>
                                          <code>CANFA</code>
                                       </taxonomy>
                                    </clade>
                                    <clade>
                                       <name>82_BOVIN</name>
                                       <branch_length>1.0E-5</branch_length>
                                       <taxonomy>
                                          <code>BOVIN</code>
                                       </taxonomy>
                                    </clade>
                                 </clade>
                              </clade>
                           </clade>
                        </clade>
                     </clade>
                  </clade>
               </clade>
            </clade>
         </clade>
      </clade>
   </phylogeny>
</phyloxml>
TREE1
}
