#!/usr/bin/env perl

use strict;
use warnings;

use IO::File;

use List::Cycle;

use Text::CSV_XS;
use Text::Xslate 'mark_raw';

# -----------------------------------------------

sub get_colors
{
	my(@color) = split(/\n/, load_colors() );

	# Discard dark colors.

	shift @color for 1 .. 220;

	return List::Cycle -> new({values => \@color});

} # End of get_colors.

# -----------------------------------------------

sub load_colors
{
	return <<EOS;
000000
000080
00008B
0000CD
0000EE
0000FF
006400
00688B
008000
008080
00868B
008B00
008B45
008B8B
009ACD
00B2EE
00BFFF
00C5CD
00CD00
00CD66
00CDCD
00CED1
00E5EE
00EE00
00EE76
00EEEE
00F5FF
00FA9A
00FF00
00FF7F
00FFFF
030303
050505
080808
0A0A0A
0D0D0D
0F0F0F
104E8B
121212
141414
171717
1874CD
191970
1A1A1A
1C1C1C
1C86EE
1E90FF
1F1F1F
20B2AA
212121
228B22
242424
262626
27408B
292929
2B2B2B
2E2E2E
2E8B57
2F4F4F
303030
32814B
32CD32
333333
363636
36648B
383838
3A5FCD
3B3B3B
3CB371
3D3D3D
404040
40E0D0
4169E1
424242
436EEE
43CD80
454545
458B00
458B74
4682B4
473C8B
474747
483D8B
4876FF
48D1CC
4A4A4A
4A708B
4B0082
4D4D4D
4EEE94
4F4F4F
4F94CD
525252
528B8B
53868B
545454
548B54
54FF9F
551A8B
556B2F
575757
595959
5C5C5C
5CACEE
5D478B
5E5E5E
5F9EA0
607B8B
616161
636363
63B8FF
6495ED
666666
668B8B
66CD00
66CDAA
68228B
68838B
6959CD
696969
698B22
698B69
6A5ACD
6B6B6B
6B8E23
6C7B8B
6CA6CD
6E6E6E
6E7B8B
6E8B3D
707070
708090
737373
757575
76EE00
76EEC6
778899
787878
79CDCD
7A378B
7A67EE
7A7A7A
7A8B8B
7AC5CD
7B68EE
7CCD7C
7CFC00
7D26CD
7D7D7D
7E7E7E
7EC0EE
7F7F7F
7FFF00
7FFFD4
800000
800080
808000
808080
828282
836FFF
838B83
838B8B
8470FF
858585
878787
87CEEB
87CEFA
87CEFF
8968CD
8A2BE2
8A8A8A
8B0000
8B008B
8B0A50
8B1A1A
8B1C62
8B2252
8B2323
8B2500
8B3626
8B3A3A
8B3A62
8B3E2F
8B4500
8B4513
8B4726
8B475D
8B4789
8B4C39
8B5742
8B5A00
8B5A2B
8B5F65
8B636C
8B6508
8B668B
8B6914
8B6969
8B7355
8B7500
8B7765
8B795E
8B7B8B
8B7D6B
8B7D7B
8B7E66
8B814C
8B8378
8B8386
8B864E
8B8682
8B8878
8B8970
8B8989
8B8B00
8B8B7A
8B8B83
8C8C8C
8DB6CD
8DEEEE
8EE5EE
8F8F8F
8FBC8F
90EE90
912CEE
919191
9370DB
9400D3
949494
969696
96CDCD
97FFFF
98F5FF
98FB98
9932CC
999999
9A32CD
9AC0CD
9ACD32
9AFF9A
9B30FF
9BCD9B
9C9C9C
9E9E9E
9F79EE
9FB6CD
A020F0
A0522D
A1A1A1
A2B5CD
A2CD5A
A3A3A3
A4D3EE
A52A2A
A6A6A6
A8A8A8
A9A9A9
AB82FF
ABABAB
ADADAD
ADD8E6
ADFF2F
AEEEEE
AFEEEE
B03060
B0B0B0
B0C4DE
B0E0E6
B0E2FF
B22222
B23AEE
B2DFEE
B3B3B3
B3EE3A
B452CD
B4CDCD
B4EEB4
B5B5B5
B8860B
B8B8B8
B9D3EE
BA55D3
BABABA
BBFFFF
BC8F8F
BCD2EE
BCEE68
BDB76B
BDBDBD
BEBEBE
BF3EFF
BFBFBF
BFEFFF
C0C0C0
C0FF3E
C1CDC1
C1CDCD
C1FFC1
C2C2C2
C4C4C4
C6E2FF
C71585
C7C7C7
C9C9C9
CAE1FF
CAFF70
CCCCCC
CD0000
CD00CD
CD1076
CD2626
CD2990
CD3278
CD3333
CD3700
CD4F39
CD5555
CD5B45
CD5C5C
CD6090
CD6600
CD661D
CD6839
CD6889
CD69C9
CD7054
CD8162
CD8500
CD853F
CD8C95
CD919E
CD950C
CD96CD
CD9B1D
CD9B9B
CDAA7D
CDAD00
CDAF95
CDB38B
CDB5CD
CDB79E
CDB7B5
CDBA96
CDBE70
CDC0B0
CDC1C5
CDC5BF
CDC673
CDC8B1
CDC9A5
CDC9C9
CDCD00
CDCDB4
CDCDC1
CFCFCF
D02090
D15FEE
D1C166
D1D1D1
D1EEEE
D2691E
D2B48C
D3D3D3
D4D4D4
D6D6D6
D8BFD8
D9D9D9
DA70D6
DAA520
DB7093
DBDBDB
DC143C
DCDCDC
DDA0DD
DEB887
DEDEDE
E066FF
E0E0E0
E0EEE0
E0EEEE
E0FFFF
E3E3E3
E5E5E5
E6E6FA
E8E8E8
E9967A
EBEBEB
EDEDED
EE0000
EE00EE
EE1289
EE2C2C
EE30A7
EE3A8C
EE3B3B
EE4000
EE5C42
EE6363
EE6A50
EE6AA7
EE7600
EE7621
EE7942
EE799F
EE7AE9
EE8262
EE82EE
EE9572
EE9A00
EE9A49
EEA2AD
EEA9B8
EEAD0E
EEAEEE
EEB422
EEB4B4
EEC591
EEC900
EECBAD
EECFA1
EED2EE
EED5B7
EED5D2
EED8AE
EEDC82
EEDD82
EEDFCC
EEE0E5
EEE5DE
EEE685
EEE8AA
EEE8CD
EEE9BF
EEE9E9
EEEE00
EEEED1
EEEEE0
F08080
F0E68C
F0F0F0
F0F8FF
F0FFF0
F0FFFF
F2F2F2
F4A460
F5DEB3
F5F5DC
F5F5F5
F5FFFA
F7F7F7
F8F8FF
FA8072
FAEBD7
FAF0E6
FAFAD2
FAFAFA
FCFCFC
FDF5E6
FF0000
FF00FF
FF1493
FF3030
FF34B3
FF3E96
FF4040
FF4500
FF6347
FF69B4
FF6A6A
FF6EB4
FF7256
FF7F00
FF7F24
FF7F50
FF8247
FF82AB
FF83FA
FF8C00
FF8C69
FFA07A
FFA500
FFA54F
FFAEB9
FFB5C5
FFB6C1
FFB90F
FFBBFF
FFC0CB
FFC125
FFC1C1
FFD39B
FFD700
FFDAB9
FFDEAD
FFE1FF
FFE4B5
FFE4C4
FFE4E1
FFE7BA
FFEBCD
FFEC8B
FFEFD5
FFEFDB
FFF0F5
FFF5EE
FFF68F
FFF8DC
FFFACD
FFFAF0
FFFAFA
FFFF00
FFFFE0
FFFFF0
FFFFFF
EOS

} # End of load_colors.

# -----------------------------------------------

sub read_csv_file
{
	my($file_name) = @_;
	my($csv) = Text::CSV_XS -> new({allow_whitespace => 1});
	my($io)  = IO::File -> new($file_name, 'r');

	$csv -> column_names($csv -> getline($io) );

	return $csv -> getline_hr_all($io);

} # End of read_csv_file.

# -----------------------------------------------

my($cycle)         = get_colors;
my(@heading)       = qw/Start Accept State Event Next Entry Exit Regexp Interpretation/;
my($stt_file_name) = './data/default.stt.csv';
my($stt)           = read_csv_file($stt_file_name);
my($templater)     = Text::Xslate -> new
(
 input_layer => '',
 path        => 'htdocs/assets/templates/graph/easy/marpa',
);

my($column, @column);
my(@row);

for $column (@heading)
{
	push @column, {td => $column};
}

push @row, [@column];

for my $item (@$stt)
{
	@column = ();

	for $column (@heading)
	{
		push @column, {td => mark_raw($$item{$column} || '.')};
	}

	push @row, [@column];
}

@column = ();

for $column (@heading)
{
	push @column, {td => $column};
}

push @row, [@column];

my($table) =
{
	border  => 0,
	row     => [@row],
	size    => $#row + 1,
	summary => 'STT',
};

print $templater -> render
(
 'rainbow.page.tx',
 {
	 title => 'State Transition Table for Graph::Easy::Marpa::Lexer',
	 table => $table,
 },
);
