#!/usr/bin/perl

# This is used as a diagnostic to send to the module author

use strict;

use Data::Dumper;
use Inline Config => force_build => 1,
  print_info      => 1;
use Graphics::Framebuffer;
$Data::Dumper::Sortkeys = 1;
my $dev = 0;
$dev = $ARGV[0] if (scalar(@ARGV));
print "Using /dev/fb$dev\n";
sleep 1;
my $fb = Graphics::Framebuffer->new('SHOW_ERRORS' => 1, 'FB_DEVICE' => "/dev/fb$dev");
$fb->cls();

my $copy = $fb;

delete($copy->{'SCREEN'});

foreach my $name (sort(keys %{$copy})) {
    unless (ref($copy->{$name}) =~ /Imager|threads|GLOB|ARRAY|HASH|SUB/i) {
        print STDERR "$name = " . $copy->{$name} . "\n";
    }
}
print STDERR '=' x 79 . "\n";
print STDERR Dumper($copy);

=head1 NAME

Framebuffer Information Dump

=head1 DESCRIPTION

This script is used to help the author diagnose (and fix) any problems you may be having with the Graphics::Framebuffer module

=head1 SYNOPSIS

 perl dump.pl [frambuffer_number] 2> gfb_dump.txt

=cut
