#!/usr/bin/perl

use 5.010;
use strict;
use warnings FATAL => 'all';
use Config;
use ExtUtils::MakeMaker;

eval {
    use Term::ANSIColor;

    if (defined($ENV{'DISPLAY'})) {
        print "\n\n",colored(['red'],qq(****************************************************************************
* Graphics::Framebuffer should not be installed from within X-Windows!     *
*                                                                          *
* You should install it from the console itself, and not a console window. *
****************************************************************************
)),colored(['yellow'],qq(
If you insist on installing from within X-Windows, please keep in mind that
the tests will show nothing, as they will be unable to draw to the screen,
since X-Windows is using it.  Thus the tests will run in emulation mode only.
));
    }

    print "\nChecking for 'fgconsole' binary... ";
    my $fg = `fgconsole 2>&1`;

    if ($fg =~ /\d+/ || -e '/bin/fgconsole') {
        print colored(['green'],"FOUND\n\n");
    } else {
        print colored(['yellow'],'NOT FOUND'), "\n\nWhile 'fgconsole' is not required, it is needed for the 'which_console' method to function.\n\n";
    }

    print 'Checking for threaded Perl... ';
    if ($Config{'useithreads'}) {
        print colored(['green'],'Threaded Perl detected'),"\n\n";
    } else {
        print colored(['yellow'],'Not a threaded Perl.'),"  Making adjustments...\n";
        my $MOD = slurp_file('lib/Graphics/Framebuffer.pm');
        # We have to remove any references to shared variables
        $MOD =~ s/use threads/\# use threads/sg;
        $MOD =~ s/: shared//sg;
        my $change_from = 'NO_THREADS = FALSE';
        my $change_to   = 'NO_THREADS = TRUE';
        $MOD =~ s/$change_from/$change_to/sg;
        open(my $OUT,'>','lib/Graphics/Framebuffer.pm');
        print $OUT "$MOD\n";
        close($OUT);
        print colored(['bold'],'Changes complete'),"\n\n";
    }

    if (WriteMakefile(
        NAME               => 'Graphics::Framebuffer',
        AUTHOR             => q{Richard Kelsch <rich@rk-internet.com>},
        VERSION_FROM       => 'lib/Graphics/Framebuffer.pm',
        ABSTRACT_FROM      => 'lib/Graphics/Framebuffer.pm',
        LICENSE            => 'Artistic_2_0',
        PL_FILES           => {},
        MIN_PERL_VERSION   => 5.010,
        CONFIGURE_REQUIRES => {
            'Inline::MakeMaker' => 0.45,
            'ExtUtils::MakeMaker' => 6.52,
        },
        BUILD_REQUIRES => {
            'Test::Most' => '0.30',
            'List::Util' => '1.20',
        },
        PREREQ_PM      => {
            'Math::Bezier'   => '0.01',
            'Math::Trig'     => '1.10',
            'Math::Gradient' => '0.03',
            'List::Util'     => '1.20',
            'Sys::Mmap'      => '0.16',
            'Imager'         => '0.91',
        },
#    RECOMMENDS => {
#        'Inline'         => '0.70',
#        'Inline::C'      => '0.75',
#    },
        dist  => {COMPRESS => 'gzip -9f', SUFFIX => 'gz',},
        clean => {FILES    => 'Graphics-Framebuffer-* _Inline* examples/_Inline*'},
    )) {

        print "\nNow run:\n\n\t",colored(['bold'],'make'),"\n";
        print "\nUse to test:\n\n\t",colored(['bold'],'make test'),"\n\nUse to install (you may need to do it as root with sudo):\n\n\tsudo ",colored(['bold'],'make install'),"\n\n";
        print qq{The "examples" directory (in this package) has some handy scripts to help get\nyou started, and show you how to use the module.  Just 'perldoc' each to see\nhow to use them:\n\n};

        print "\t",colored(['bold'],'primitives.pl'),"\t- This script will pretty much demonstrate all of the\n\t\t\t  capabilities of this module.\n\n";
        print "\t",colored(['bold'],'threadstest.pl'),"\t- This script demonstrates how to use the module in a\n\t\t\t  threading environment.\n\n";
        print "\t",colored(['bold'],'slideshow.pl'),"\t- This script shows all of the images in a specific path.\n\t\t\t  It automatically detects all of your framebuffer\n\t\t\t  devices, and dedicates a thread to each.\n\n";
        print "\t",colored(['bold'],'viewpic.pl'),"\t- This script shows one specific image (or animation).\n\n";
        print "\t",colored(['bold'],'dump.pl'),"\t\t- This script does a diagnostic variable dump to STDERR\n\t\t\t  for the author to help you with troubleshooting.\n\n";
        print "\t",colored(['bold'],'fonts.pl'),"\t- This script prints installed font names.\n\n";
    }
};
if ($@) {
    if (defined($ENV{'DISPLAY'})) {
        print qq(

****************************************************************************
* Graphics::Framebuffer should not be installed from within X-Windows!     *
*                                                                          *
* You should install it from the console itself, and not a console window. *
****************************************************************************

If you insist on installing from within X-Windows, please keep in mind that
the tests will show nothing, as they will be unable to draw to the screen,
since X-Windows is using it.  Thus the tests will run in emulation mode only.
);
    }

    print "\nChecking for 'fgconsole' binary... ";
    my $fg = `fgconsole 2>&1`;

    if ($fg =~ /\d+/ || -e '/bin/fgconsole') {
        print "FOUND\n\n";
    } else {
        print "NOT FOUND\n\nWhile 'fgconsole' is not required, it is needed for the 'which_console' method to function.\n\n";
    }

    print 'Checking for threaded Perl... ';
    if ($Config{'useithreads'}) {
        print "Threaded Perl detected\n\n";
    } else {
        print "Not a threaded Perl.  Making adjustments...\n";
        my $MOD = slurp_file('lib/Graphics/Framebuffer.pm');
        # We have to remove any references to shared variables
        $MOD =~ s/use threads/\# use threads/sg;
        $MOD =~ s/: shared//sg;
        my $change_from = 'NO_THREADS = FALSE';
        my $change_to   = 'NO_THREADS = TRUE';
        $MOD =~ s/$change_from/$change_to/sg;
        open(my $OUT,'>','lib/Graphics/Framebuffer.pm');
        print $OUT "$MOD\n";
        close($OUT);
        print "Changes complete\n\n";
    }

    if (WriteMakefile(
        NAME               => 'Graphics::Framebuffer',
        AUTHOR             => q{Richard Kelsch <rich@rk-internet.com>},
        VERSION_FROM       => 'lib/Graphics/Framebuffer.pm',
        ABSTRACT_FROM      => 'lib/Graphics/Framebuffer.pm',
        LICENSE            => 'Artistic_2_0',
        PL_FILES           => {},
        MIN_PERL_VERSION   => 5.010,
        CONFIGURE_REQUIRES => {
            'Inline::MakeMaker' => 0.45,
            'ExtUtils::MakeMaker' => 6.52,
        },
        BUILD_REQUIRES => {
            'Test::Most' => '0.30',
            'List::Util' => '1.20',
        },
        PREREQ_PM      => {
            'Math::Bezier'   => '0.01',
            'Math::Trig'     => '1.10',
            'Math::Gradient' => '0.03',
            'List::Util'     => '1.20',
            'Sys::Mmap'      => '0.16',
            'Imager'         => '0.91',
        },
#    RECOMMENDS => {
#        'Inline'         => '0.70',
#        'Inline::C'      => '0.75',
#    },
        dist  => {COMPRESS => 'gzip -9f', SUFFIX => 'gz',},
        clean => {FILES    => 'Graphics-Framebuffer-* _Inline* examples/_Inline*'},
    )) {

        print "\nNow run:\n\n\tmake\n";
        print "\nUse to test:\n\n\tmake test\n\nUse to install (you may need to do it as root with sudo):\n\n\tsudo make install\n\n";
        print qq{The "examples" directory (in this package) has some handy scripts to help get\nyou started, and show you how to use the module.  Just 'perldoc' each to see\nhow to use them:\n\n};

        print "\tprimitives.pl\t- This script will pretty much demonstrate all of the\n\t\t\t  capabilities of this module.\n\n";
        print "\tthreadstest.pl\t- This script demonstrates how to use the module in a\n\t\t\t  threading environment.\n\n";
        print "\tslideshow.pl\t- This script shows all of the images in a specific path.\n\t\t\t  It automatically detects all of your framebuffer\n\t\t\t  devices, and dedicates a thread to each.\n\n";
        print "\tviewpic.pl\t- This script shows one specific image (or animation).\n\n";
        print "\tdump.pl\t\t- This script does a diagnostic variable dump to STDERR\n\t\t\t  for the author to help you with troubleshooting.\n\n";
        print "\tfonts.pl\t- This script prints installed font names.\n\n";
    }
}

sub slurp_file {
    my $file = shift;

    # Read in a text file without using open
    return (
        do { local (@ARGV, $/) = $file; <> }
    );
}
