use 5.014;
use strict;
use warnings FATAL => 'all';
use ExtUtils::MakeMaker;


if (defined($ENV{'DISPLAY'})) {
    print qq(

****************************************************************************
* Graphics::Framebuffer should not be installed from within X-Windows!     *
*                                                                          *
* You should install it from the console itself, and not a console window. *
****************************************************************************

If you insist on installing from within X-Windows, please keep in mind that
the tests will show nothing, as they will be unable to draw to the screen,
since X-Windows is using it.  Thus the tests will run in emulation mode only.

);
}

print "\nChecking for 'fbset' binary... ";
my $fbset = `fbset -i 2>&1`;

if ($fbset =~ /mode/) {
    print "FOUND\n\n";
} else {
    print "NOT FOUND\n\nWhile 'fbset' is not required, it is, nevertheless, recommended.\nIt is used as a last resort to get infomration about the framebuffer\nfor the module to render properly.\n\nIf your display is scrambled or skewed, then installing this should fix it.\n\n";
}

WriteMakefile(
    NAME               => 'Graphics::Framebuffer',
    AUTHOR             => q{Richard Kelsch <rich@rk-internet.com>},
    VERSION_FROM       => 'lib/Graphics/Framebuffer.pm',
    ABSTRACT_FROM      => 'lib/Graphics/Framebuffer.pm',
    LICENSE            => 'Artistic_2_0',
    PL_FILES           => {},
    MIN_PERL_VERSION   => 5.014,
    CONFIGURE_REQUIRES => {
        'ExtUtils::MakeMaker' => 0,
    },
    BUILD_REQUIRES => {
        'Test::More' => 0,
        'List::Util' => 0,
    },
    PREREQ_PM      => {
        'Math::Bezier'   => 0,
        'Math::Trig'     => 0,
        'Math::Gradient' => 0,
        'List::Util'     => 0,
        'Sys::Mmap'      => 0,
        'Imager'         => 0,
    },
    dist  => {COMPRESS => 'gzip -9f', SUFFIX => 'gz',},
    clean => {FILES    => 'Graphics-Framebuffer-*'},
);
