#!/usr/bin/perl -w
# This tests the various methods of the Graphics::Framebuffer module
# and shows the only way threads will work with it.

use strict;
use Switch;

use threads;
use Graphics::Framebuffer;
use Sys::CPU;
use Data::Dumper::Simple;

my $Threads = $ARGV[0] || Sys::CPU::cpu_count();
print "\nRunning on a ",Sys::CPU::cpu_type(), " with $Threads threads\n";
sleep 3;
my @framebuffer;
foreach my $thr (0..$Threads) {
    $framebuffer[$thr] = Graphics::Framebuffer->new('FB_DEVICE' => '/dev/fb0');
}
my $screen_width  = $framebuffer[0]->{'XRES'};
my $screen_height = $framebuffer[0]->{'YRES'};
my $cols = $Threads / 2;


$framebuffer[0]->cls();
my $cls = int(rand($screen_width));
foreach my $page (1..$Threads) {
    threads->create(
        sub {
            my $Page = shift;
            my $Cols = shift;
            if (defined($framebuffer[$Page]->{'ERROR'})) {
                print STDERR "Thread $Page, $framebuffer[$Page]->{'ERROR'}\n";
            }
            while(1) {
                attract($Page,$Cols);
            }
        },
        $page,$cols
    );
}
while(1) {
    threads->yield();
    sleep 1;
}


##############################################################################
##                             ATTRACT MODE                                 ##
##############################################################################
# Remeniscent of the "Atract Mode" of the old Atari 8 bit computers, this    #
# mode merely puts random patterns on the screen.                            #
##############################################################################

sub attract {
    my $page = shift;
    my $cols = shift;
    my $red  = int(rand(256));
    my $grn  = int(rand(256));
    my $blu  = int(rand(256));
    my $x    = int(rand($screen_width));
    my $y    = int(rand($screen_height));
    my $w    = int(rand($screen_width/$cols));
    my $h    = int(rand($screen_height/$cols));
    my $rx   = int(rand($screen_width/$cols));
    my $ry   = int(rand($screen_height/$cols));
    my $sd   = int(rand(360));
    my $ed   = int(rand(360));
    my $gr   = (rand(100)/100);
    my $mode = int(rand(5));
    my $type = int(rand(7));
    my $size = int(rand(7)) - 3;
    $framebuffer[$page]->cls() if ($x >= ($cls - 4) && $x <= ($cls + 4));

    $framebuffer[$page]->set_color({'red' => $red,'green' => $grn,'blue' => $blu});
    $framebuffer[$page]->draw_mode($mode);
    switch ($type) {
        case 0 {
            $framebuffer[$page]->plot({'x' => $x,'y' => $y,'pixel_size' => $size});
        }
        case 1 {
            $framebuffer[$page]->plot({'x' => $x,'y' => $y,'pixel_size' => $size});
            $framebuffer[$page]->drawto({'x' => $w,'y' => $h,'pixel_size' => $size});
        }
        case 2 {
            $framebuffer[$page]->circle({'x' => $x,'y' => $y,'radius' => $rx,'filled' => int(rand(2)),'pixel_size' => $size});
        }
        case 3 {
            $framebuffer[$page]->ellipse({'x' => $x,'y' => $y,'xradius' => $rx,'yradius' => $ry,'filled' => int(rand(2)),'factor' => 1,'pixel_size' => $size});
        }
        case 4 {
            $framebuffer[$page]->rbox({'x' => $x,'y' => $y,'width' => $w,'height' => $h,'filled' => (int(rand(2))),'pixel_size' => $size});
        }
        case 5 {
            $framebuffer[$page]->draw_arc({'x' => $x,'y' => $y,'radius' => $ry,'start_degrees' => $sd,'end_degrees' => $ed,'granularity' => $gr,'mode' => (int(rand(3))),'pixel_size' => $size});
        }
        case 6 {
            my @poly;
            foreach my $count (0..int(rand(10))) {
                push(@poly,int(rand($screen_width)));
                push(@poly,int(rand($screen_height)));
            }
            $framebuffer[$page]->polygon({'pixel_size' => $size,'coordinates' => \@poly, 'filled' => (int(rand(2)))});
        }
        else { # This can be a large memory hog.  Disabled (random number doesn't go this high) for the moment.
#            $framebuffer[$Page]->clip_set({'x' => $x-50,'y' => $y-50,'xx' => $x+50,'yy' => $y+50});
            $framebuffer[$page]->fill({'x' => $x,'y' => $y});
        }
    }
}

__END__

__C__

