use 5.005;

use strict;
use ExtUtils::MakeMaker;
use File::Spec;
use IO::File;

my $revision = q($Id: Makefile.PL,v 1.4 2000/07/17 07:31:45 rjray Exp $);

sub create_excludes { join(':', grep($_ ne '.', @INC)) }

sub write_config
{
    my $cfg_file = File::Spec->catfile(qw(Coverage prefs.pm));
    my $debugging = 0;

    if (-e "$cfg_file")
    {
        print STDERR "Copying old $cfg_file to $cfg_file.old\n";
        rename "$cfg_file", "$cfg_file.old";
    }
    if (grep(/DEBUGGING/, @ARGV))
    {
        @ARGV = grep(! /DEBUGGING/, @ARGV);
        $debugging = 1;
    }

    my $excludes = create_excludes;
    my $prefs_file =
        ($^O =~ /MacOS|MSWin32|os2|VMS/) ? 'perlcov.txt' : '.coverperl';
    my $date = scalar localtime;
    my $fh = new IO::File "> $cfg_file";
    die "Error opening $cfg_file to write: $!" unless (defined $fh);

    print $fh <<"END_CONFIG";
# $revision
# $date
#
# Config file $cfg_file auto-generated by MakeMaker. Do not
# edit this file, edit $0 instead. Changes made here will
# be lost.

package Devel::Coverage::prefs;

use strict;
use vars qw(\@EXPORT \@EXPORT_OK \@ISA \%preferences);

require Exporter;

\@ISA = qw(Exporter);
\@EXPORT = qw(%preferences);
\@EXPORT_OK = qw(%preferences);

\$preferences{exclude} = '$excludes';
\$preferences{prefs_file} = '$prefs_file';
\$preferences{debugging} = $debugging;

1;
END_CONFIG

    close $fh;
    1;
}

write_config;

WriteMakefile(
              NAME           => 'Devel::Coverage',
              VERSION_FROM   => 'Coverage.pm',
              EXE_FILES      => [qw(coverperl)],
              dist           => { COMPRESS => 'gzip -9f', SUFFIX => 'gz' },
              clean          => { FILES => 'coverperl' },
              realclean      => { FILES =>
                                  'Coverage/prefs.pm ' .
                                  'Coverage/prefs.pm.old' },
             );
