use strict;
use warnings;
package Text::SlackEmoji;
# ABSTRACT: data for mapping Slack :emoji_strings: into Unicode text
$Text::SlackEmoji::VERSION = '0.001';
#pod =head1 SYNOPSIS
#pod
#pod   use Text::SlackEmoji;
#pod
#pod   my $emoji = Text::SlackEmoji->emoji_map;
#pod
#pod   $slack_message =~ s!:([-+a-z0-9_]+):!$emoji->{$1} // ":$1:"!ge;
#pod
#pod =head1 DESCRIPTION
#pod
#pod This library is basically just a container around a hash mapping strings like
#pod "disappointed_relieved" to Unicode text like 😥 .
#pod
#pod =head1 SECRET ORIGINS
#pod
#pod I made the first version of this lookup to power a little C<irssi> plugin so
#pod that when using the Slack IRC gateway, I'd see the same emoji as the people
#pod using the Slack app, at least when possible.
#pod
#pod =cut

our %Emoji = (
  '+1' => "\N{THUMBS UP SIGN}",
  '-1' => "\N{THUMBS DOWN SIGN}",

  'angry'                 => "\N{ANGRY FACE}",
  'anguished'             => "\N{ANGUISHED FACE}",
  'blush'                 => "\N{SMILING FACE WITH SMILING EYES}",
  'coffee'                => "\N{HOT BEVERAGE}",
  'confounded'            => "\N{CONFOUNDED FACE}",
  'confused'              => "\N{CONFUSED FACE}",
  'cry'                   => "\N{CRYING FACE}",
  'disappointed'          => "\N{DISAPPOINTED FACE}",
  'disappointed_relieved' => "\N{DISAPPOINTED BUT RELIEVED FACE}",
  'expressionless'        => "\N{EXPRESSIONLESS FACE}",
  'facepunch'             => "\N{FISTED HAND SIGN}",
  'fearful'               => "\N{FEARFUL FACE}",
  'fist'                  => "\N{RAISED FIST}",
  'frowning'              => "\N{FROWNING FACE WITH OPEN MOUTH}",
  'grin'                  => "\N{GRINNING FACE WITH SMILING EYES}",
  'grinning'              => "\N{GRINNING FACE}",
  'heart'                 => "\N{BLACK HEART SUIT}\x{FE0F}",
  'heart_eyes'            => "\N{SMILING FACE WITH HEART-SHAPED EYES}",
  'imp'                   => "\N{IMP}",
  'innocent'              => "\N{SMILING FACE WITH HALO}",
  'joy'                   => "\N{FACE WITH TEARS OF JOY}",
  'kissing'               => "\N{KISSING FACE}",
  'kissing_closed_eyes'   => "\N{KISSING FACE WITH CLOSED EYES}",
  'kissing_heart'         => "\N{FACE THROWING A KISS}",
  'kissing_smiling_eyes'  => "\N{KISSING FACE WITH SMILING EYES}",
  'neutral_face'          => "\N{NEUTRAL FACE}",
  'ok'                    => "\N{SQUARED OK}",
  'ok_hand'               => "\N{OK HAND SIGN}",
  'pensive'               => "\N{PENSIVE FACE}",
  'persevere'             => "\N{PERSEVERING FACE}",
  'poop'                  => "\N{PILE OF POO}",
  'pouting_cat'           => "\N{POUTING CAT FACE}",
  'rage'                  => "\N{POUTING FACE}",
  'rage'                  => "\N{POUTING FACE}",
  'relaxed'               => "\N{WHITE SMILING FACE}",
  'relieved'              => "\N{RELIEVED FACE}",
  'satisfied'   => "\N{SMILING FACE WITH OPEN MOUTH AND TIGHTLY-CLOSED EYES}",
  'smile'       => "\N{SMILING FACE WITH OPEN MOUTH AND SMILING EYES}",
  'smiley'      => "\N{SMILING FACE WITH OPEN MOUTH}",
  'smiling_imp' => "\N{SMILING FACE WITH HORNS}",
  'smirk'       => "\N{SMIRKING FACE}",
  'snowman'     => "\N{SNOWMAN}",
  'sunglasses'  => "\N{SMILING FACE WITH SUNGLASSES}",
  'sweat'       => "\N{FACE WITH COLD SWEAT}",
  'sweat_smile' => "\N{SMILING FACE WITH OPEN MOUTH AND COLD SWEAT}",
  'triumph'     => "\N{FACE WITH LOOK OF TRIUMPH}",
  'unamused'    => "\N{UNAMUSED FACE}",
  'wave'        => "\N{WAVING HAND SIGN}",
  'weary'       => "\N{WEARY FACE}",
  'wink'        => "\N{WINKING FACE}",
  'worried'     => "\N{WORRIED FACE}",
  'yum'         => "\N{FACE SAVOURING DELICIOUS FOOD}",

  'stuck_out_tongue' => "\N{FACE WITH STUCK-OUT TONGUE}",
  'stuck_out_tongue_closed_eyes' => "\N{FACE WITH STUCK-OUT TONGUE AND TIGHTLY-CLOSED EYES}",
  'stuck_out_tongue_winking_eyes' => "\N{FACE WITH STUCK-OUT TONGUE AND WINKING EYE}",
);

#pod =method emoji_map
#pod
#pod This method takes no arguments and returns a hashref mapping Slack emoji names
#pod to Unicode strings.  The strings may be more than one character long.
#pod
#pod =cut

sub emoji_map {
  my ($self) = @_;
  return { %Emoji };
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Text::SlackEmoji - data for mapping Slack :emoji_strings: into Unicode text

=head1 VERSION

version 0.001

=head1 SYNOPSIS

  use Text::SlackEmoji;

  my $emoji = Text::SlackEmoji->emoji_map;

  $slack_message =~ s!:([-+a-z0-9_]+):!$emoji->{$1} // ":$1:"!ge;

=head1 DESCRIPTION

This library is basically just a container around a hash mapping strings like
"disappointed_relieved" to Unicode text like 😥 .

=head1 METHODS

=head2 emoji_map

This method takes no arguments and returns a hashref mapping Slack emoji names
to Unicode strings.  The strings may be more than one character long.

=head1 SECRET ORIGINS

I made the first version of this lookup to power a little C<irssi> plugin so
that when using the Slack IRC gateway, I'd see the same emoji as the people
using the Slack app, at least when possible.

=head1 AUTHOR

Ricardo Signes <rjbs@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Ricardo Signes.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
