#! perl
# Copyright (C) 2001-2003, The Perl Foundation.
# $Id: vtable_h.pl 24056 2007-12-19 03:27:11Z coke $

=head1 NAME

tools/build/vtable_h.pl - Create the vtable header

=head1 SYNOPSIS

 % perl tools/build/vtable_h.pl

=head1 DESCRIPTION

This script creates F<include/parrot/vtable.h> from F<src/vtable.tbl>. It
uses C<Parrot::Vtable>.

=head1 SEE ALSO

=over 4

=item C<Parrot::Vtable>

=back

=cut

use strict;
use warnings;

use lib 'lib';
use Parrot::Vtable;

my $vtable = parse_vtable();

open my $OUT, '>', 'include/parrot/vtable.h' or die $!;

print $OUT <<'EOF';
/* ex: set ro:
** !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
**
** This file is generated automatically from 'src/vtable.tbl' by vtable_h.pl
*/

#ifndef PARROT_VTABLE_H_GUARD
#define PARROT_VTABLE_H_GUARD

#include "parrot/parrot.h"

#define VTABLE_SIZE 512

EOF

print $OUT vtbl_defs($vtable);

print $OUT "\n";

print $OUT vtbl_struct($vtable);

print $OUT vtbl_macros($vtable);

# append the guard suffix and C code coda
print $OUT <<"EOC";

#endif /* PARROT_VTABLE_H_GUARD */

/*
 * Local variables:
 *   c-file-style: "parrot"
 * End:
 * vim: expandtab shiftwidth=4:
 */
EOC

# Local Variables:
#   mode: cperl
#   cperl-indent-level: 4
#   fill-column: 100
# End:
# vim: expandtab shiftwidth=4:
